/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NELoginMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.QxNEConnectInfo;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import gnu.trove.TIntArrayList;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TEIntegrationStartSevlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String NEID_PARAM = "neid";
    private static final String PHYNEID_PARAM = "nePhyID";
    private static final String START_STOP_FLAG = "flag";
    private static final String NM_USER_ATTR = "nmUser";
    private static final String LANG = "lang";
    private static final int STOP_FLAG = 0;
    private static final int COMM_TCP = 1;
    private static final int COMM_SSL = 4;
    private static final byte[] KEY = new byte[]{89, 69, 75, 48, 48, 48, 50, 84};
    private static final byte[] ADD_ENCRPT_STR = new byte[]{68, 50, 67, 56, 49, 50, 55, 56, 68, 70, 53, 65, 65, 67, 53, 53};
    private static final int TL1NEID_MASK = 0x4000000;

    public void init() throws ServletException {
        super.init();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int flag;
        int nePhyID;
        int neid;
        TELogFactory.getNormalLogger().info("enter into TEIntegrationStartSevlet!");
        Datainterface ouputData = new Datainterface();
        try {
            String neidstr = request.getParameter(NEID_PARAM);
            String nephyidstr = request.getParameter(PHYNEID_PARAM);
            String flagstr = request.getParameter(START_STOP_FLAG);
            TELogFactory.getNormalLogger().info("neidstr---->" + neidstr);
            TELogFactory.getNormalLogger().info("nephyidstr---->" + nephyidstr);
            TELogFactory.getNormalLogger().info("flagstr---->" + flagstr);
            neid = Integer.parseInt(neidstr);
            nePhyID = Integer.parseInt(nephyidstr);
            flag = Integer.parseInt(flagstr);
        }
        catch (NumberFormatException e) {
            TELogFactory.getNormalLogger().error("neID Parameter error,return errorCode is 1090646019!");
            ouputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
            this.printMessage(ouputData, response.getWriter());
            return;
        }
        if (flag == 0) {
            return;
        }
        String nmUser = request.getParameter(NM_USER_ATTR);
        String t2000Lang = request.getParameter(LANG);
        request.getSession().setAttribute(NM_USER_ATTR, (Object)nmUser);
        String commStr = request.getParameter("commStr");
        int sbiSoketType = 1;
        String gneAdd = request.getParameter("gneAdd");
        String gnePort = request.getParameter("gnePort");
        String devType = request.getParameter("devType");
        String hostVersion = request.getParameter("devVersion");
        int serverSSLMode = TESysManagerBean.getInstance().getServerSSLMode();
        if ("".equals(commStr)) {
            ouputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
            this.printMessage(ouputData, response.getWriter());
            return;
        }
        sbiSoketType = 0 == serverSSLMode ? 1 : 4;
        TELogFactory.getNormalLogger().info("devType = " + devType + "  hostVersion = " + hostVersion);
        TELogFactory.getNormalLogger().info("t2000Lang = " + t2000Lang);
        TELogFactory.getNormalLogger().info("sbiSoketType = " + sbiSoketType + "  gneAdd = " + gneAdd + "  gnePort = " + gnePort);
        String userName = "";
        byte[] userPassword = null;
        String sbiAdd = "";
        String sbiPort = "0";
        try {
            t2000Lang = t2000Lang != null && (t2000Lang.equals("zh_CN") || t2000Lang.equals("zh")) ? "zh" : "en";
            String[] obc = commStr.split(":");
            byte[] user = this.decryptPwd(new String(KEY), IOStreamConvertor.getByteArrayFromString(obc[0] + new String(ADD_ENCRPT_STR)));
            byte[] sbiads = this.decryptPwd(new String(KEY), IOStreamConvertor.getByteArrayFromString(obc[2] + new String(ADD_ENCRPT_STR)));
            byte[] sbiport = this.decryptPwd(new String(KEY), IOStreamConvertor.getByteArrayFromString(obc[3] + new String(ADD_ENCRPT_STR)));
            userName = IOStreamConvertor.replaceSpecialStr(new String(user));
            char[] charPwd = EncryptUtils.decryptAESStr2Char(obc[1]);
            userPassword = EncryptUtils.decodePlainText(charPwd);
            userPassword = IOStreamConvertor.removeByteZero(userPassword);
            EncryptUtils.clearChar(charPwd);
            sbiAdd = IOStreamConvertor.replaceSpecialStr(new String(sbiads));
            if ("0.0.0.0".equals(sbiAdd)) {
                sbiAdd = "127.0.0.1";
            }
            sbiPort = IOStreamConvertor.replaceSpecialStr(new String(sbiport));
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("decrypt commStr is Fail!", (Throwable)e);
            ouputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
            this.printMessage(ouputData, response.getWriter());
            return;
        }
        try {
            int result = 0;
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            if (null == ne) {
                TIntArrayList nes = TENEListMgr.getInstance().getNEIDList();
                TELogFactory.getNormalLogger().error("can't find ne, neid->" + neid);
                TELogFactory.getNormalLogger().error("tenelistmgr neids -> " + nes);
                return;
            }
            boolean isQx = this.getTL1OrQx(nePhyID) == 0;
            TELogFactory.getNormalLogger().info("begin to create connect,neid->" + ne.getNEID());
            if (ne.getLogStatus() != 1) {
                if (isQx) {
                    QxNEConnectInfo neCon = new QxNEConnectInfo();
                    neCon.setLogicNeID((long)neid);
                    neCon.setPort(Integer.parseInt(sbiPort));
                    neCon.setIpAddress(sbiAdd);
                    neCon.setCommType(sbiSoketType);
                    neCon.setNeVersion(ne.getNEVersion());
                    result = TENECommMgr.getInstance().createConect(neCon);
                } else {
                    result = TETL1NECommMgr.getInstance().createConect((long)neid, Integer.parseInt(sbiPort), sbiAdd, sbiSoketType);
                }
            } else {
                TELogFactory.getNormalLogger().info("Ne has createConect, ne.getLogStatus()=" + ne.getLogStatus());
            }
            TELogFactory.getNormalLogger().info("end to create connect,neid->" + ne.getNEID() + "result->" + result);
            if (0 != result && result != 1090781210) {
                TELogFactory.getNormalLogger().info("Connect to SBI Fail!");
                ouputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(result));
                this.printMessage(ouputData, response.getWriter());
                return;
            }
            byte[] curPassword = ne.getCurUserPassword();
            if (userName.equals(ne.getCurUser()) && Arrays.equals(userPassword, curPassword) && ne.getLogStatus() == 1) {
                EncryptUtils.clearByte(curPassword);
                ne.initInterNEDataAfterLogin();
                ouputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
                this.printMessage(ouputData, response.getWriter());
                return;
            }
            TELogFactory.getNormalLogger().info("begin to login ne,neid->" + ne.getNEID());
            if (!isQx) {
                TETL1NELoginMgr.Fault fault = TETL1NELoginMgr.getInstance().sendLoginCmd(ne.getNEID(), userName, userPassword);
                result = fault.getRetCode();
                if (result == 0) {
                    ne.setLogStatus(1);
                }
            } else {
                result = ne.login(userName, userPassword, 1);
            }
            TELogFactory.getNormalLogger().info("end to login ne,neid->" + ne.getNEID() + "result->" + result);
            EncryptUtils.clearByte(userPassword);
            EncryptUtils.clearByte(curPassword);
            if (0 == result) {
                TELogFactory.getNormalLogger().info("begin to initInterNEDataAfterLogin,neid->" + ne.getNEID());
                ne.initInterNEDataAfterLogin();
                TELogFactory.getNormalLogger().info("end to initInterNEDataAfterLogin,neid->" + ne.getNEID());
                ouputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
                this.printMessage(ouputData, response.getWriter());
                return;
            }
            TELogFactory.getNormalLogger().error("Login ne Fail!");
            ouputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(result));
            this.printMessage(ouputData, response.getWriter());
            return;
        }
        catch (Throwable e) {
            TELogFactory.getNormalLogger().error("Intergation Fail!!", e);
            ouputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
            this.printMessage(ouputData, response.getWriter());
            TELogFactory.getNormalLogger().info("leave out TEIntegrationStartSevlet!");
            return;
        }
    }

    private int getTL1OrQx(int phyNEID) {
        if (0 != (phyNEID & 0x4000000)) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printMessage(Datainterface output, PrintWriter print) {
        StringWriter out = new StringWriter();
        try {
            output.marshal(out);
            print.println(((Object)out).toString());
            TELogFactory.getInterfaceLogger().info("The return T2000 XML Data\u00a3\u00ba" + ((Object)out).toString());
            ((Writer)out).close();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Output Data Marshal Fail!", (Throwable)e);
        }
        finally {
            try {
                if (null != out) {
                    ((Writer)out).close();
                }
                if (null != print) {
                    print.close();
                }
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("Close Stream error!", (Throwable)e);
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void destroy() {
        super.destroy();
    }

    public byte[] decryptPwd(String key, byte[] encrptbyte) throws Exception {
        String arithmetic = "DES";
        byte[] b_key = key.getBytes();
        SecretKeySpec deskey = new SecretKeySpec(b_key, arithmetic);
        Cipher c1 = Cipher.getInstance(arithmetic);
        c1.init(2, deskey);
        return c1.doFinal(encrptbyte);
    }
}

