/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.security.TETokenCheckMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.system.TESystemUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.appmanager.api.DeploymentMode;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEE2EServlet
extends HttpServlet {
    private static final String NEID_PARAM = "neid";
    private static final String NM_USER_ATTR = "nmUser";
    private static final String IS_T2000_FLAG = "t2000Flag";
    private static final String NM_USER_NAME_ATTR = "nmUserName";
    private static final String IS_SOLARIS = "isSolaris";
    private static final String E2EPARAM = "params";
    private static final String FUNCTION_ITEM_TAG = "functionItem";
    private static final String E2EFunctionID = "e2efunid";
    private DeploymentMode sysStatus = null;
    private String isT2000Flag = null;
    private static final String NE_E2EFUNC_FILE = TEResourceManager.getPath() + "conf/e2econf/e2efunction.xml";
    private static boolean isInited = false;
    private Map<KeyObject, String> e2eFunMap = null;

    public void init() throws ServletException {
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object key;
        if (!isInited) {
            this.sysStatus = TESysManagerBean.getInstance().getSysStauts();
            this.readFile();
            isInited = true;
        }
        String neVersion = "";
        String urlPrefix = request.getRequestURL().toString();
        urlPrefix = urlPrefix.substring(0, urlPrefix.lastIndexOf(47) + 1);
        int neid = Integer.parseInt(request.getParameter(NEID_PARAM));
        String nmUser = request.getParameter(NM_USER_ATTR);
        String nmUserName = request.getParameter(NM_USER_NAME_ATTR);
        this.isT2000Flag = request.getParameter(IS_T2000_FLAG);
        String isSolarisParam = request.getParameter(IS_SOLARIS);
        String e2eFunID = request.getParameter(E2EFunctionID);
        String e2eParam = request.getParameter(E2EPARAM);
        String token = TETokenCheckMgr.getTokenFromHeadOrURL(request);
        StringBuffer parsedParam = new StringBuffer();
        if (e2eParam != null) {
            String[] sParams = !e2eParam.contains(",") ? new String[]{e2eParam} : e2eParam.split(",");
            int size = sParams.length;
            for (int index = 0; index < size; ++index) {
                String[] entryParam = sParams[index].split(":");
                key = entryParam[0];
                String value = entryParam[1];
                parsedParam.append("&").append((String)key).append("=").append(value);
            }
        }
        if (null == nmUser) {
            nmUser = TESysManagerBean.getInstance().getSysUser();
        }
        if (null == nmUserName) {
            nmUserName = TESysManagerBean.getInstance().getSysUser();
        }
        String redirectParam = "?neid=" + neid + "&nmUser=" + nmUser + "&t2000Flag=" + this.isT2000Flag + "&nmUserName=" + nmUserName + "&isSolaris=" + isSolarisParam + "&isE2E=true" + parsedParam + "&token=" + token;
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter print = response.getWriter();
        try {
            this.sysStatus = TESysManagerConstants.SYS_INTEGRATION_STATUS;
            if (null != this.isT2000Flag && this.sysStatus == TESysManagerConstants.SYS_SINGLE_STATUS) {
                this.handleException(1090650128, print);
                return;
            }
            neVersion = TENEListMgr.getInstance().getNE(neid).getHostVersion();
            key = new KeyObject(e2eFunID, new VersionObj(neVersion));
            String forwardURL = this.e2eFunMap.get(key);
            if (forwardURL != null && !forwardURL.equals("")) {
                String fullURL = forwardURL + redirectParam;
                TESystemUtil.sendRedirect(fullURL, request, response);
                TELogFactory.getNormalLogger().debug("Forward to E2E function page:" + fullURL);
            } else {
                print.println(TEErrorResourceUtil.getErrorMessage(1090605066).getErrorinfo());
            }
        }
        catch (Exception e) {
            this.handleException(1090646019, print);
            TELogFactory.getNormalLogger().error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != print) {
                print.close();
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void handleException(int code, PrintWriter print) {
        ErrorMessage error = TEErrorResourceUtil.getErrorMessage(code);
        StringWriter stringout = null;
        try {
            stringout = new StringWriter();
            error.marshal(stringout);
        }
        catch (Exception marshalException) {
            TELogFactory.getNormalLogger().error(marshalException.getMessage(), (Throwable)marshalException);
        }
        print.println(stringout.toString());
    }

    private void readFile() {
        this.e2eFunMap = new HashMap<KeyObject, String>();
        File file = null;
        try {
            file = new File(TEResourceManager.getFileRealPath(null, NE_E2EFUNC_FILE));
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEE2EServlet.readFile() fail!", (Throwable)e);
        }
        Document doc = TEParseXMLFile.parseFile(file);
        NodeList funNodeList = doc.getElementsByTagName(FUNCTION_ITEM_TAG);
        Element node = null;
        KeyObject entry = null;
        int size = funNodeList.getLength();
        for (int iNode = 0; iNode < size; ++iNode) {
            node = (Element)funNodeList.item(iNode);
            entry = new KeyObject(node.getAttribute("funID"), new VersionObj(node.getAttribute("version")));
            this.e2eFunMap.put(entry, node.getAttribute("link"));
        }
    }

    private class VersionObj {
        private String verStr;

        public VersionObj(String verstr) {
            this.verStr = verstr;
        }

        public boolean equals(Object otherObj) {
            if (!(otherObj instanceof VersionObj)) {
                return false;
            }
            VersionObj otherVerObj = (VersionObj)otherObj;
            String oVerStr = otherVerObj.verStr;
            if (oVerStr != null) {
                String[] oVerStrs = oVerStr.split(",");
                String oEntry = null;
                String ostartVer = null;
                String oendVer = null;
                int osplitIndex = 0;
                String[] verStrs = this.verStr.split(",");
                String entry = null;
                String startVer = null;
                String endVer = null;
                int splitIndex = 0;
                boolean isMatch = false;
                int size = verStrs.length;
                for (int index = 0; index < size; ++index) {
                    startVer = entry = verStrs[index];
                    endVer = entry;
                    splitIndex = entry.indexOf(45);
                    if (splitIndex != -1) {
                        startVer = entry.substring(0, splitIndex);
                        endVer = entry.substring(splitIndex + 1, entry.length());
                    }
                    int osize = oVerStrs.length;
                    for (int oindex = 0; oindex < osize; ++oindex) {
                        ostartVer = oEntry = oVerStrs[oindex];
                        oendVer = oEntry;
                        osplitIndex = oEntry.indexOf(45);
                        if (osplitIndex != -1) {
                            ostartVer = oEntry.substring(0, osplitIndex);
                            oendVer = oEntry.substring(osplitIndex + 1, oEntry.length());
                        }
                        if (startVer.compareTo(ostartVer) < 0 || startVer.compareTo(oendVer) > 0 || endVer.compareTo(ostartVer) < 0 || endVer.compareTo(oendVer) > 0) continue;
                        isMatch = true;
                        break;
                    }
                    if (isMatch) continue;
                    return isMatch;
                }
                return isMatch;
            }
            return true;
        }

        public int hashCode() {
            return this.verStr.hashCode();
        }
    }

    private class KeyObject {
        private String funID;
        private VersionObj verObj;
        private int hashCode;

        public KeyObject(String funcID, VersionObj vo) {
            this.funID = funcID;
            this.verObj = vo;
            this.hashCode = funcID.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object ko) {
            if (!(ko instanceof KeyObject)) {
                return false;
            }
            KeyObject koo = (KeyObject)ko;
            return this.funID.equals(koo.funID) && this.verObj.equals(koo.verObj);
        }
    }
}

