/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.handler.TENEHandlerMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public class TEDelBoardAction
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String BASE_PATH = "res" + File.separator + "funcdesres_" + LANGUAGE + ".ini";
    private TEResourceUtil res = TEResourceUtil.getInstance(BASE_PATH);
    private static final String SLOT_ID_PARAM = "slotID";
    private static final int BOARD_NO_EXIST_ERROR = 38666;
    private int slotid;

    @Override
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        Operation delBoardOperation = (Operation)operationList.get(0);
        Operation verfityOperation = (Operation)operationList.get(1);
        Part part = Definitions.getParam((Part[])delBoardOperation.getInput().getPart(), (String)SLOT_ID_PARAM);
        this.slotid = Integer.parseInt(part.getValue());
        if (!verfityOperation.getOutput(0).getFault(0).getCode().equals("0")) {
            verfityOperation.setInput((Input)delBoardOperation.getInput().clone());
            operationList.remove(0);
        } else {
            operationList.remove(1);
        }
        this.outputData = TEDataConverter.convertToDatainterface(neid, subfunc, operationList);
        if (this.outputData.getErrorMessage().getErrorcode().equals(String.valueOf(0))) {
            this.removeBoard();
        } else {
            RowParams rowparams = null;
            if (null != this.outputData.getBussinessParams() && this.outputData.getBussinessParams().getRowParamsCount() > 0 && (rowparams = this.outputData.getBussinessParams().getRowParams(0)).getRowErrorsCount() > 0 && rowparams.getRowErrors(0).getErrorMessage().getErrorcode().equals(String.valueOf(38666))) {
                this.removeBoard();
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
            }
        }
    }

    private void removeBoard() {
        try {
            TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
            Vector boardList = neObj.getClonedBoardList();
            Operation operation = null;
            TEBoard board = null;
            int boradType = -1;
            int size = this.operationList.size();
            for (int i = 0; i < size; ++i) {
                operation = (Operation)this.operationList.get(i);
                Part part = Definitions.getParam((Part[])operation.getInput().getPart(), (String)SLOT_ID_PARAM);
                this.slotid = Integer.parseInt(part.getValue());
                board = neObj.getBoard(this.slotid);
                if (null == board) continue;
                boradType = board.getBoardType();
                TENEHandlerMgr.getInstance().doBoardDeleteHandle(this.neid, this.slotid, boradType);
                boardList.remove(board);
            }
            neObj.removeAlarm(this.slotid, 0);
            neObj.removeLogicPortBySlot(this.neid, this.slotid, boradType);
            neObj.setLastBoardModifyTime();
            neObj.setBoardList(boardList);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Delete memery Board Fault!", (Throwable)e);
            return;
        }
    }

    @Override
    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(subfunc.getCode());
            this.slotid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam(SLOT_ID_PARAM).getValue());
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode != 0) {
                loginfo.setResult(2);
            } else {
                loginfo.setResult(0);
            }
            if (errorCode == 2) {
                for (int i = outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
                    if (outputData.getBussinessParams().getRowParams(i).getRowErrorsCount() <= 0) continue;
                    errorCode = Integer.parseInt(outputData.getBussinessParams().getRowParams(i).getRowErrors(0).getErrorMessage().getErrorcode());
                    break;
                }
            }
            loginfo.setErrCode(errorCode);
            loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(errorCode));
            loginfo.setLocation(ipAddress);
            String subrackName = TEBoardUtil.getSubrackNameFromSlot(neid, this.slotid);
            if (!"".equals(subrackName)) {
                subrackName = subrackName + "-";
            }
            loginfo.setOperateDesc(this.res.getString("SLOT_ID") + ":" + subrackName + TEBoardUtil.getSlotIDFromSlot(neid, this.slotid));
            loginfo.setOperateName(subfunc.getSubFuncDes(neid));
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            loginfo.setOperateObject(operObj);
            loginfo.setUserID(0);
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            TELogMgr.writeLog(loginfo);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Write Log Fail!", (Throwable)e);
        }
    }
}

