/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.bscfg.installcp.TECPOccupySlot;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.TESplitPageBean;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallSubCPRecord;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class TECalculateBoard
implements TENEMgrInterface {
    private Datainterface output = null;
    private int neType;
    private int slotid;
    private int shelf;
    private int subrackId;
    private int neid = 0;

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.output = new Datainterface();
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        this.neType = ne.getNEType();
        int neVersion = TEConvertUtil.convertVerStrToInt(ne.getHostVersion());
        int devType = TEGetNEDomainVersion.getInstance().getDevType(this.neType);
        Vector subrackList = ne.getClonedSubrackList();
        this.output.setBussinessParams(new BussinessParams());
        RowParams inputRowParams = inputData.getBussinessParams().getRowParams(0);
        Param tmpParam = null;
        for (int i = inputRowParams.getParamCount() - 1; i >= 0; --i) {
            tmpParam = inputRowParams.getParam(i);
            if (tmpParam.getName().equals("slotID")) {
                this.slotid = Integer.parseInt(tmpParam.getValue());
                continue;
            }
            if (!tmpParam.getName().equals("shelfType")) continue;
            this.shelf = Integer.parseInt(tmpParam.getValue());
        }
        this.subrackId = TEBoardUtil.getSubrackIDFromSlot(neid, this.slotid);
        this.slotid = TEBoardUtil.getSlotIDFromSlot(neid, this.slotid);
        TESubrack subrack = null;
        if (subrackList != null) {
            int n = subrackList.size();
            for (int j = 0; j < n; ++j) {
                subrack = (TESubrack)subrackList.get(j);
                if (Integer.valueOf(subrack.getSubrackID()) != this.subrackId) continue;
                if (ne.getIsTL1OrQX() == 0) {
                    devType = TEGetNEDomainVersion.getInstance().getDevType(Integer.valueOf(subrack.getNeType()));
                    break;
                }
                devType = TEGetNEDomainVersion.getInstance().getDevType(Integer.valueOf(subrack.getTl1NeType()));
                break;
            }
        }
        int cpType = 0;
        String boardName = null;
        String slotList = null;
        TECPOccupySlot occupySlot = null;
        int mSlotId = 0;
        int occupySlotNumber = 1;
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        TIntObjectHashMap<TECPOccupySlot> occupyCps = TEEquipmentDescription.getInstance().getInstallCPsBySlot(devType, this.shelf, this.slotid, neVersion);
        TIntObjectIterator iter = occupyCps.iterator();
        while (iter.hasNext()) {
            iter.advance();
            cpType = iter.key();
            boardName = cpDesc.getTypeName(cpType);
            occupySlot = (TECPOccupySlot)iter.value();
            if (occupySlot.getM_OccupySlotList() != null) {
                slotList = occupySlot.getM_OccupySlotList().toString();
                slotList = slotList.substring(1, slotList.length() - 1);
                slotList = slotList.replaceAll(" ", "");
            } else {
                mSlotId = occupySlot.getM_SlotID();
                slotList = String.valueOf(mSlotId);
                StringBuffer slotListSB = new StringBuffer(slotList);
                occupySlotNumber = cpDesc.getOccupySlotNumber(cpType);
                if (occupySlotNumber > 0) {
                    for (int i = 1; i < occupySlotNumber; ++i) {
                        slotListSB.append(",").append(this.slotid + i);
                    }
                } else if (occupySlotNumber < 0) {
                    for (int i = 1; i < Math.abs(occupySlotNumber); ++i) {
                        slotListSB.append(",").append(this.slotid - i);
                    }
                }
                slotList = slotListSB.toString();
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            String[] slotArray = slotList.split(",");
            int size = slotArray.length;
            for (int j = 0; j < size; ++j) {
                list.add(Integer.parseInt(slotArray[j]));
            }
            if (!this.isShouldShowMultiSlotBoard(list)) continue;
            this.addParamToOutput(cpType, boardName, slotList);
        }
        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        ArrayList<String> sortParamList = new ArrayList<String>();
        sortParamList.add("boardName");
        TESplitPageBean.sortDatainterface(this.output, subFunc, sortParamList, "asc");
        return this.output;
    }

    private void addParamToOutput(int boardType, String boardName, String slot_list) {
        RowParams rowparam = new RowParams();
        Param param = null;
        param = new Param("boardType", String.valueOf(boardType));
        rowparam.addParam(param);
        param = new Param("boardName", boardName);
        rowparam.addParam(param);
        StringBuffer sb = new StringBuffer();
        String[] slotArray = slot_list.split(",");
        int length = slotArray.length;
        for (int i = 0; i < length; ++i) {
            sb.append(TEBoardUtil.getSlotIDFromSlot(this.neid, Integer.parseInt(slotArray[i]))).append(",");
        }
        String tmp = sb.toString();
        slot_list = tmp.substring(0, tmp.length() - 1);
        param = new Param("slotList", slot_list);
        rowparam.addParam(param);
        boolean isSupportSubCard = TEBoardUtil.isSupportSubCard(boardType);
        param = new Param("issupportsubcard", String.valueOf(isSupportSubCard));
        rowparam.addParam(param);
        ArrayList<Integer> oldBds = new ArrayList<Integer>();
        oldBds.add(2427);
        oldBds.add(2428);
        if (oldBds.contains(boardType)) {
            param = new Param("supportsubtypes", TEBoardUtil.getSupportSubCardTypes(this.neid, boardType));
            rowparam.addParam(param);
        } else {
            String supportsTypes = "";
            if (isSupportSubCard) {
                supportsTypes = this.getSupportSubCardStr(this.neid, boardType);
            }
            param = new Param("supportsubtypes", supportsTypes);
            rowparam.addParam(param);
        }
        this.output.getBussinessParams().addRowParams(rowparam);
    }

    private String getSupportSubCardStr(int neID, int boardType) {
        StringBuilder supportsTypes = new StringBuilder();
        List<Integer> subSlots = TECircuitPackDescription.getInstance().getInstallSubSlots(boardType);
        for (Integer subSlot : subSlots) {
            TEInstallSubCPRecord cpRed = TECircuitPackDescription.getInstance().getInstallSubCPType(boardType, subSlot);
            ArrayList bds = cpRed.subCPTypeList;
            String seq = "";
            for (Integer bd : bds) {
                supportsTypes.append(seq).append(bd).append('-').append(TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, bd));
                seq = ",";
            }
            supportsTypes.append(';');
        }
        return supportsTypes.substring(0, supportsTypes.length() - 1);
    }

    private boolean isShouldShowMultiSlotBoard(List<Integer> slotList) {
        TEBoard board = null;
        int size = slotList.size();
        for (int i = 0; i < size; ++i) {
            board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, TEBoardUtil.neToSlotIDNM(this.subrackId, slotList.get(i)));
            if (null == board) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNeedOperationlog() {
        return false;
    }
}

