/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallSubCPRecord;
import com.huawei.nglct.nelist.model.cpnerelate.TEBoardSlotInfo;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;

public class TEBoardGraphNew
implements TENEMgrInterface {
    private static final String NE_NAME_PARAM = "neName";
    private static final String BOARD_UPDATE_FLAG = "boardupgateflag";
    private static final String SLOT_ID_PARAM = "slotID";
    private static final String BOARD_TYPE_PARAM = "boardType";
    private static final String BOARD_NAME_PARAM = "boardName";
    private static final String BOARD_LOOP_PARAM = "boardLoop";
    private static final String BOARD_PG_PARAM = "boardPG";
    private static final String BOARD_STATE_PARAM = "boardState";
    private static final String TOP_ALARM_LEVEL = "topAlmLevel";
    private static final String SUB_CARD_SUPPORT = "issupportsubcard";
    private static final String SUPPORT_CARD_TYPES = "supportsubtypes";
    private static final String SUB_CARD_ID_PARAM = "subcardid";
    private static final String SUB_CARD_TYPE_PARAM = "subcardtype";
    private static final String SUB_CARD_NAME_PARAM = "subcardname";
    private static final String SUB_CARD_STATE_PARAM = "subcardstate";
    private static final int BOARD_OUT_LOGIC = 1;
    private static final int BOARD_IN_RUN = 3;
    private static final int BOARD_IN_PHY = 2;
    private ArrayList usedSlotList = new ArrayList();
    private static final String BOARD_SLOT_LIST_PARAM = "slotList";
    private Datainterface outputData = null;
    private Logger log = TELogFactory.getNormalLogger();
    private boolean isFirstQuery = true;
    private boolean bCorrect = true;
    private static HashMap<String, String> convertBoardMap = new HashMap();

    public Datainterface initParam(int neid, Datainterface inputData) {
        RowParams rowparams = null;
        Datainterface outputDataResult = new Datainterface();
        outputDataResult.setBussinessParams(new BussinessParams());
        RowParams inputRowParams = inputData.getBussinessParams().getRowParams(0);
        Param tmpParam = inputRowParams.getParam("correct");
        if (tmpParam != null && ("0".equals(tmpParam.getValue()) || "false".equals(tmpParam.getValue()))) {
            this.bCorrect = false;
        }
        if ((tmpParam = inputRowParams.getParam("isFirstQuery")) != null && ("0".equals(tmpParam.getValue()) || "false".equals(tmpParam.getValue()))) {
            this.isFirstQuery = false;
        }
        TENE currentNE = TENEListMgr.getInstance().getNE(neid);
        String neName = currentNE.getNEName();
        boolean boardupdateflag = TENEListMgr.getInstance().getNE(neid).getBoardUpdateFlag();
        rowparams = new RowParams();
        rowparams.addParam(NE_NAME_PARAM, neName);
        rowparams.addParam(BOARD_UPDATE_FLAG, String.valueOf(boardupdateflag));
        rowparams.addParam("boardChange", "false");
        outputDataResult.getBussinessParams().addRowParams(rowparams);
        return outputDataResult;
    }

    public Vector dealBoardList(int neid) {
        TENE currentNE = TENEListMgr.getInstance().getNE(neid);
        Vector boardList = null;
        Vector phyBoardList = null;
        Vector<Object> oldBoardList = new Vector<Object>();
        TESubBoard subboard = null;
        try {
            boardList = currentNE.getClonedBoardList();
            phyBoardList = currentNE.getClonedPhyBoardList();
            if (null != boardList || null != phyBoardList) {
                int i;
                TEBoard logicboard = null;
                TEBoard phyboard = null;
                int slotid = -1;
                int physlotid = -1;
                int physize = 0;
                int j = 0;
                boolean ifinputrow = false;
                if (null != boardList) {
                    Collections.sort(boardList);
                    for (i = 0; i < boardList.size(); ++i) {
                        logicboard = (TEBoard)boardList.get(i);
                        TEBoardGraphNew.addUsedSlotList(neid, logicboard, this.bCorrect, this.usedSlotList);
                    }
                }
                if (null != phyBoardList) {
                    physize = phyBoardList.size();
                    Collections.sort(phyBoardList);
                }
                if (null != boardList) {
                    for (i = 0; i < boardList.size(); ++i) {
                        logicboard = (TEBoard)boardList.get(i);
                        slotid = logicboard.getSlotID();
                        ifinputrow = false;
                        int level = currentNE.getCurTopLevelAlm(slotid);
                        if (0 == slotid) continue;
                        while (j < physize) {
                            phyboard = (TEBoard)phyBoardList.get(j);
                            physlotid = phyboard.getSlotID();
                            if (slotid > physlotid) {
                                if (TEBoardGraphNew.checkSlotIdle(neid, phyboard, this.bCorrect, this.usedSlotList)) {
                                    phyboard.setState(2);
                                    phyboard.setTopAlmLevel(level);
                                    oldBoardList.add(phyboard.clone());
                                }
                                ++j;
                                continue;
                            }
                            if (slotid == physlotid) {
                                if (logicboard.compareTo(phyboard) == 0) {
                                    if (!phyboard.getSubBoardList().isEmpty()) {
                                        if (!logicboard.getSubBoardList().isEmpty()) {
                                            subboard = (TESubBoard)logicboard.getSubBoardList().get(0);
                                            subboard.setState(3);
                                        } else {
                                            subboard = (TESubBoard)phyboard.getSubBoardList().get(0);
                                            subboard.setState(2);
                                            logicboard.getSubBoardList().add(subboard.clone());
                                        }
                                    }
                                    logicboard.setState(3);
                                    logicboard.setTopAlmLevel(level);
                                    oldBoardList.add(logicboard.clone());
                                } else {
                                    logicboard.setState(1);
                                    logicboard.setTopAlmLevel(level);
                                    oldBoardList.add(logicboard.clone());
                                }
                                ifinputrow = true;
                                ++j;
                                break;
                            }
                            if (slotid >= physlotid) continue;
                            logicboard.setState(1);
                            logicboard.setTopAlmLevel(level);
                            oldBoardList.add(logicboard.clone());
                            ifinputrow = true;
                            break;
                        }
                        if (j < physize || ifinputrow) continue;
                        logicboard.setState(1);
                        logicboard.setTopAlmLevel(level);
                        oldBoardList.add(logicboard.clone());
                    }
                }
                while (j < physize) {
                    phyboard = (TEBoard)phyBoardList.get(j);
                    if (TEBoardGraphNew.checkSlotIdle(neid, phyboard, this.bCorrect, this.usedSlotList)) {
                        int level = currentNE.getCurTopLevelAlm(phyboard.getSlotID());
                        phyboard.setState(2);
                        phyboard.setTopAlmLevel(level);
                        if (!phyboard.getSubBoardList().isEmpty()) {
                            subboard = (TESubBoard)phyboard.getSubBoardList().get(0);
                            subboard.setState(2);
                        }
                        oldBoardList.add(phyboard.clone());
                    }
                    ++j;
                }
            }
            Collections.sort(oldBoardList);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        }
        catch (Exception e) {
            this.log.error("Get boart error\u00a3\u00ba", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
        }
        ArrayList<TEBoard> phyBds = new ArrayList<TEBoard>();
        Iterator dataBds = oldBoardList.iterator();
        while (dataBds.hasNext()) {
            TEBoard tebd = (TEBoard)dataBds.next();
            if (tebd.getState() != 2) continue;
            phyBds.add(tebd);
            dataBds.remove();
        }
        if (!phyBds.isEmpty()) {
            oldBoardList.addAll(0, phyBds);
        }
        return oldBoardList;
    }

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        TENE currentNE = TENEListMgr.getInstance().getNE(neid);
        this.outputData = this.initParam(neid, inputData);
        Vector boardList = this.dealBoardList(neid);
        TEBoard board = null;
        TEBoard boardTmp = null;
        if (this.isFirstQuery) {
            currentNE.setOldBoardList(boardList);
            for (int i = 0; i < boardList.size(); ++i) {
                board = (TEBoard)boardList.get(i);
                this.createOutputData(neid, board, this.bCorrect, true);
            }
        } else {
            int i;
            Vector oldBoardList = currentNE.getOldBoardList();
            boolean isUpdate = false;
            for (i = 0; i < boardList.size(); ++i) {
                board = (TEBoard)boardList.get(i);
                int index = oldBoardList.indexOf(board);
                if (index >= 0) {
                    boardTmp = (TEBoard)oldBoardList.get(index);
                    if (boardTmp.getTopAlmLevel() != board.getTopAlmLevel() || boardTmp.getState() != board.getState() || boardTmp.getBoardLoop() != board.getBoardLoop() || boardTmp.getBoardPG() != board.getBoardPG()) {
                        isUpdate = true;
                        break;
                    }
                } else {
                    isUpdate = true;
                    break;
                }
                oldBoardList.remove(board);
            }
            if (!oldBoardList.isEmpty()) {
                isUpdate = true;
            }
            if (isUpdate) {
                for (i = 0; i < boardList.size(); ++i) {
                    board = (TEBoard)boardList.get(i);
                    this.createOutputData(neid, board, this.bCorrect, true);
                }
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090605056));
            }
            currentNE.setOldBoardList(boardList);
        }
        return this.outputData;
    }

    @Override
    public boolean isNeedOperationlog() {
        return false;
    }

    private void createOutputData(int neid, TEBoard board, boolean bCorrect, boolean isAdd) {
        TEBoardSlotInfo slotInfo;
        if (null == board) {
            return;
        }
        Param slotidparam = null;
        Param boardtypeparam = null;
        Param boardnameparam = null;
        Param boardloopparam = null;
        Param boardpgparam = null;
        Param boardstateparam = null;
        Param boardslotlist = null;
        String slotList = "";
        int slotid = -1;
        int boardtype = -1;
        RowParams rowparams = null;
        rowparams = new RowParams();
        slotid = board.getSlotID();
        boardtype = board.getBoardType();
        slotidparam = new Param(SLOT_ID_PARAM, String.valueOf(slotid));
        rowparams.addParam(slotidparam);
        boardtypeparam = new Param(BOARD_TYPE_PARAM, String.valueOf(boardtype));
        rowparams.addParam(boardtypeparam);
        String boardName = board.getBoardTypeName();
        boardnameparam = new Param(BOARD_NAME_PARAM, boardName);
        rowparams.addParam(boardnameparam);
        boardloopparam = new Param(BOARD_LOOP_PARAM, String.valueOf(board.getBoardLoop()));
        rowparams.addParam(boardloopparam);
        boardpgparam = new Param(BOARD_PG_PARAM, String.valueOf(board.getBoardPG()));
        rowparams.addParam(boardpgparam);
        boardstateparam = new Param(BOARD_STATE_PARAM, String.valueOf(board.getState()));
        rowparams.addParam(boardstateparam);
        boardstateparam = new Param(TOP_ALARM_LEVEL, String.valueOf(board.getTopAlmLevel()));
        rowparams.addParam(boardstateparam);
        boardstateparam = new Param("isadd", String.valueOf(isAdd));
        rowparams.addParam(boardstateparam);
        boolean isSupport = TEBoardUtil.isSupportSubCard(boardtype);
        Param isSupportSubcard = new Param(SUB_CARD_SUPPORT, String.valueOf(isSupport));
        rowparams.addParam(isSupportSubcard);
        ArrayList<Integer> oldBds = new ArrayList<Integer>();
        oldBds.add(2427);
        oldBds.add(2428);
        if (oldBds.contains(boardtype)) {
            Param supportCardTypes = new Param(SUPPORT_CARD_TYPES, TEBoardUtil.getSupportSubCardTypes(neid, boardtype));
            rowparams.addParam(supportCardTypes);
            if (!board.getSubBoardList().isEmpty()) {
                TESubBoard subboard = (TESubBoard)board.getSubBoardList().get(0);
                Param subcardid = new Param(SUB_CARD_ID_PARAM, String.valueOf(subboard.getSubSlotID()));
                rowparams.addParam(subcardid);
                Param subcardtype = new Param(SUB_CARD_TYPE_PARAM, String.valueOf(subboard.getSubBoardType()));
                rowparams.addParam(subcardtype);
                Param subcardname = new Param(SUB_CARD_NAME_PARAM, TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, subboard.getSubBoardType()));
                rowparams.addParam(subcardname);
                Param subcardstate = new Param(SUB_CARD_STATE_PARAM, String.valueOf(subboard.getState()));
                rowparams.addParam(subcardstate);
            }
        } else {
            this.addSubBoardParams(neid, board, rowparams);
        }
        int subrackId = 0;
        if (bCorrect) {
            subrackId = TEBoardUtil.getSubrackIDFromSlot(neid, slotid);
            slotid = TEBoardUtil.getSlotIDFromSlot(neid, slotid);
        }
        slotList = null != (slotInfo = TEConfigurationDataMgr.getInstance().getBoardSlotInfo(neid, subrackId, boardtype, slotid)) ? slotInfo.toString() : slotid + "";
        String[] slotArr = slotList.split(",");
        StringBuffer slotListStr = new StringBuffer();
        for (int i = 0; i < slotArr.length; ++i) {
            slotListStr.append(",").append(Integer.parseInt(slotArr[i]));
        }
        boardslotlist = new Param(BOARD_SLOT_LIST_PARAM, slotListStr.toString().substring(1));
        rowparams.addParam(boardslotlist);
        this.outputData.getBussinessParams().addRowParams(rowparams);
    }

    public static void addUsedSlotList(int neid, TEBoard board, boolean bCorrect, ArrayList usedSlotList1) {
        TEBoardSlotInfo slotInfo;
        if (null == board) {
            return;
        }
        int boardtype = -1;
        int slotid = -1;
        boardtype = board.getBoardType();
        slotid = board.getSlotID();
        int subrackId = 0;
        int offset = 0;
        if (bCorrect) {
            subrackId = TEBoardUtil.getSubrackIDFromSlot(neid, slotid);
            offset = subrackId * 65536;
            slotid -= offset;
        }
        if (null != (slotInfo = TEConfigurationDataMgr.getInstance().getBoardSlotInfo(neid, subrackId, boardtype, slotid))) {
            ArrayList tempusedList = null;
            tempusedList = slotInfo.getStandbySlotList();
            usedSlotList1.add(slotInfo.getDirectSlotid() + offset);
            int size = tempusedList.size();
            for (int i = 0; i < size; ++i) {
                usedSlotList1.add((Integer)tempusedList.get(i) + offset);
            }
        } else {
            usedSlotList1.add(slotid + offset);
        }
    }

    public static boolean checkSlotIdle(int neid, TEBoard board, boolean bCorrect, ArrayList usedSlotList1) {
        TEBoardSlotInfo slotInfo;
        if (null == board) {
            return true;
        }
        int boardtype = -1;
        int slotid = -1;
        boardtype = board.getBoardType();
        slotid = board.getSlotID();
        int size = usedSlotList1.size();
        for (int i = 0; i < size; ++i) {
            if (slotid != (Integer)usedSlotList1.get(i)) continue;
            return false;
        }
        int subrackId = 0;
        int offset = 0;
        if (bCorrect) {
            subrackId = TEBoardUtil.getSubrackIDFromSlot(neid, slotid);
            offset = subrackId * 65536;
            slotid -= offset;
        }
        if (null == (slotInfo = TEConfigurationDataMgr.getInstance().getBoardSlotInfo(neid, subrackId, boardtype, slotid))) {
            return true;
        }
        ArrayList tempusedList = slotInfo.getStandbySlotList();
        int tempsize = tempusedList.size();
        for (int i = 0; i < tempsize; ++i) {
            int tempSlot = (Integer)tempusedList.get(i) + offset;
            int usedsize = usedSlotList1.size();
            for (int j = 0; j < usedsize; ++j) {
                if (!usedSlotList1.get(j).equals(tempSlot)) continue;
                return false;
            }
        }
        return true;
    }

    private void addSubBoardParams(int neid, TEBoard board, RowParams rowParams) {
        Param supportCardTypes;
        List subBds = board.getSubBoardList();
        StringBuilder subSlot = new StringBuilder();
        StringBuilder subBdType = new StringBuilder();
        StringBuilder subBdName = new StringBuilder();
        StringBuilder subBdStat = new StringBuilder();
        StringBuilder supSubCps = new StringBuilder();
        ArrayList<Integer> subSlots = new ArrayList<Integer>();
        if (TEBoardUtil.isSupportSubCard(board.getBoardType())) {
            subSlots.addAll(TECircuitPackDescription.getInstance().getInstallSubSlots(board.getBoardType()));
        }
        Collections.sort(subSlots);
        TESubBoard tempSubBd = null;
        for (Integer tempSubSlot : subSlots) {
            TESubBoard subBd;
            Iterator i$ = subBds.iterator();
            while (i$.hasNext() && (tempSubBd = (subBd = (TESubBoard)i$.next()).getSubSlotID() == tempSubSlot.intValue() ? subBd : null) == null) {
            }
            if (tempSubBd != null) {
                subSlot.append(tempSubBd.getSubSlotID()).append(",");
                subBdType.append(tempSubBd.getSubBoardType()).append(",");
                subBdName.append(TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, tempSubBd.getSubBoardType())).append(",");
                subBdStat.append(tempSubBd.getState()).append(",");
            } else {
                subSlot.append(tempSubSlot).append(",");
                subBdType.append("").append(",");
                subBdName.append("").append(",");
                subBdStat.append("0").append(",");
            }
            TEInstallSubCPRecord cpRed = TECircuitPackDescription.getInstance().getInstallSubCPType(board.getBoardType(), tempSubSlot);
            ArrayList bds = cpRed.subCPTypeList;
            for (Integer bd : bds) {
                supSubCps.append(bd).append("-").append(TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, bd)).append(",");
            }
            String tempStr = supSubCps.toString();
            if (tempStr.endsWith(",")) {
                tempStr = tempStr.substring(0, tempStr.length() - 1);
                supSubCps = new StringBuilder();
                supSubCps.append(tempStr);
            }
            supSubCps.append(";");
            tempSubBd = null;
        }
        if (!subSlots.isEmpty()) {
            supportCardTypes = new Param(SUPPORT_CARD_TYPES, supSubCps.toString().substring(0, supSubCps.toString().length() - 1));
            rowParams.addParam(supportCardTypes);
            Param subcardid = new Param(SUB_CARD_ID_PARAM, subSlot.toString().substring(0, subSlot.toString().length() - 1));
            rowParams.addParam(subcardid);
            Param subcardtype = new Param(SUB_CARD_TYPE_PARAM, subBdType.toString().substring(0, subBdType.toString().length() - 1));
            rowParams.addParam(subcardtype);
            Param subcardname = new Param(SUB_CARD_NAME_PARAM, subBdName.toString().substring(0, subBdName.toString().length() - 1));
            rowParams.addParam(subcardname);
            Param subcardstate = new Param(SUB_CARD_STATE_PARAM, subBdStat.toString().substring(0, subBdStat.toString().length() - 1));
            rowParams.addParam(subcardstate);
        } else {
            supportCardTypes = new Param(SUPPORT_CARD_TYPES, TEBoardUtil.getSupportSubCardTypes(neid, board.getBoardType()));
            rowParams.addParam(supportCardTypes);
        }
    }

    static {
        convertBoardMap.put("53NQ2(COMP)", "53NQ2");
        convertBoardMap.put("53ND2(COMP)", "53ND2");
        convertBoardMap.put("53NS2(COMP)", "53NS2");
        convertBoardMap.put("55NPO2(STND)", "55NPO2");
        convertBoardMap.put("54ENQ2(STND)", "54ENQ2");
    }
}

