/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer;

import com.huawei.nglct.cbb.log.LCTDebugTracer;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.gencfg.TEGenCfgWaveConvertBean;
import com.huawei.nglct.util.io.TEFileUtil;
import com.huawei.nglct.util.xml.TERWCfgFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class TEAppServletListener
extends HttpServlet
implements ServletContextListener,
HttpSessionListener {
    private static String appFilePath = null;
    private static String reportDir = null;
    private static final String PATH_LOG4J = File.separator + "conf" + File.separator + "log4j.properties";

    public static String getReportOutputDir() {
        return reportDir;
    }

    public static String getAppPath() {
        return appFilePath;
    }

    public void contextInitialized(ServletContextEvent sce) {
        appFilePath = sce.getServletContext().getRealPath("/");
        this.sysInit(appFilePath);
        reportDir = TERWCfgFile.getBundleRWCfgFilePath(TEResourceManager.class, "report");
        TELogFactory.getStartupLogger().info("File Path: " + appFilePath);
        File dir = new File(reportDir);
        if (!dir.exists()) {
            dir.mkdirs();
            TELogFactory.getNormalLogger().info("create report directory:" + reportDir);
        }
        TEGenCfgWaveConvertBean waveInfoConvert = new TEGenCfgWaveConvertBean();
        waveInfoConvert.getWaveDataBuss();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        TEFileUtil.deleteDir(new File(reportDir));
    }

    public void sessionCreated(HttpSessionEvent se) {
        this.deleteTempSessionDir(se);
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        this.deleteTempSessionDir(se);
    }

    private void deleteTempSessionDir(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        if (session != null) {
            String id = session.getId();
            if (appFilePath != null) {
                String sessionDir = reportDir + File.separator + id;
                TEFileUtil.deleteDir(new File(sessionDir));
            }
        }
    }

    private void sysInit(String appFilePath) {
        System.out.println("NGLCT System WebAppPath: " + appFilePath);
        LCTDebugTracer.redirectSystemErrToFile(appFilePath + File.separator + "log" + File.separator + "systemerr.log");
        if (null == appFilePath || "".equals(appFilePath)) {
            TELogFactory.getStartupLogger().error("Can't find NGLCT System WebAppPath!");
        }
        TEResourceManager.setPath(appFilePath);
        TELogFactory.removeDefaultLogFile();
    }
}

