/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEQueryLogicPort;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Vector;

public class TEAddBoardAction
extends TENEExplorerBean {
    private static final int TIME_OUT = 20;
    private static final String SLOT_ID_PARAM = "slotID";
    private static final String BOARD_TYPE_PARAM = "boardType";

    @Override
    public int getTimeOut() {
        return 20;
    }

    @Override
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        Operation addBoardOperation = (Operation)operationList.get(0);
        Operation verfityOperation = (Operation)operationList.get(1);
        Part part = Definitions.getParam((Part[])addBoardOperation.getInput().getPart(), (String)SLOT_ID_PARAM);
        int slotid = Integer.parseInt(part.getValue());
        part = Definitions.getParam((Part[])addBoardOperation.getInput().getPart(), (String)BOARD_TYPE_PARAM);
        int boardType = Integer.parseInt(part.getValue());
        if (!verfityOperation.getOutput(0).getFault(0).getCode().equals("0")) {
            verfityOperation.setInput((Input)addBoardOperation.getInput().clone());
            operationList.remove(0);
        } else {
            operationList.remove(1);
        }
        this.outputData = TEDataConverter.convertToDatainterface(neid, subfunc, operationList);
        if (this.outputData.getErrorMessage().getErrorcode().equals(String.valueOf(0))) {
            this.addBoard(slotid, boardType);
        }
    }

    private void addBoard(int slotid, int boardType) {
        try {
            TENE neObj;
            Vector<TEBoard> boardList = TENEListMgr.getInstance().getNE(this.neid).getClonedBoardList();
            if (null == boardList) {
                boardList = new Vector<TEBoard>();
            }
            if (null != (neObj = TENEListMgr.getInstance().getNE(this.neid))) {
                boardList.remove(neObj.getBoard(slotid));
            }
            boardList.add(new TEBoard(this.neid, slotid, boardType));
            TENEListMgr.getInstance().getNE(this.neid).setLastBoardModifyTime();
            TENEListMgr.getInstance().getNE(this.neid).setBoardList(boardList);
            TEQueryLogicPort.queryExistLogicPort(this.neid, slotid, boardType);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Add memery Board Fault!", (Throwable)e);
            return;
        }
    }

    @Override
    public String getDetailStr(RowParams rowparams) {
        int slotid = Integer.parseInt(rowparams.getParam(SLOT_ID_PARAM).getValue());
        int boardType = Integer.parseInt(rowparams.getParam(BOARD_TYPE_PARAM).getValue());
        String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardType);
        String subrackName = TEBoardUtil.getSubrackNameFromSlot(this.neid, slotid);
        if (!"".equals(subrackName)) {
            subrackName = subrackName + "-";
        }
        return subrackName + TEBoardUtil.getSlotIDFromSlot(this.neid, slotid) + "-" + boardName;
    }
}

