/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.explorer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENELdDevPkgNoticeReceiver;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.tl1.TETL1NECommMgr;

public class NEConnectRunnable
implements Runnable {
    private TENE neObj;
    private int oldPort;
    private int oldNEGWType;
    private String oldGwAddress;

    public NEConnectRunnable(TENE neObj, int oldPort, String oldGwAddress, int oldNEGWType) {
        this.neObj = neObj;
        this.oldGwAddress = oldGwAddress;
        this.oldPort = oldPort;
        this.oldNEGWType = oldNEGWType;
    }

    @Override
    public void run() {
        int neid = this.neObj.getNEID();
        int result = 0;
        int neConnectType = this.neObj.getIsTL1OrQX();
        if (neConnectType == 1) {
            TETL1NECommMgr.getInstance().closeConnect((long)neid, this.oldPort, this.oldGwAddress, this.oldNEGWType);
            TELogFactory.getNormalLogger().info("Begin to connect tl1ne,NE: " + this.neObj.getNEName() + ", time:" + System.currentTimeMillis());
            result = TETL1NECommMgr.getInstance().createConect((long)neid, Integer.parseInt(this.neObj.getPort()), this.neObj.getNEGWAddress(), this.neObj.getNEGWType());
            TELogFactory.getNormalLogger().info("End to connect tl1ne,NE: " + this.neObj.getNEName() + ", time:" + System.currentTimeMillis());
        } else {
            TENECommMgr.getInstance().closeConnect((long)neid, this.oldPort, this.oldGwAddress, this.oldNEGWType);
            TELogFactory.getNormalLogger().info("Begin to connect ne,NE: " + neid + ", time:" + System.currentTimeMillis());
            result = TENECommMgr.getInstance().createConect((long)neid, Integer.parseInt(this.neObj.getPort()), this.neObj.getNEGWAddress(), this.neObj.getNEGWType());
            TELogFactory.getNormalLogger().info("End to connect ne,NE: " + neid + ", time:" + System.currentTimeMillis());
        }
        if (result != 0) {
            TELogFactory.getNormalLogger().info("Connect Fault!");
            this.neObj.setComStatus(0);
            this.neObj.setLogStatus(0);
        } else {
            TELogFactory.getNormalLogger().info("Connect Success!");
            this.neObj.setComStatus(1);
            result = this.neObj.login(this.neObj.getCurUser(), this.neObj.getCurUserPassword(), 0);
            if (result != 0) {
                TELogFactory.getNormalLogger().info("Login Fault!");
                this.neObj.setLogStatus(0);
            } else {
                TELogFactory.getNormalLogger().info("Login Success!");
                TENELdDevPkgNoticeReceiver receiver = new TENELdDevPkgNoticeReceiver();
                receiver.handleNotice(neid);
            }
        }
    }
}

