/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.devicesearch;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TESplitPageBean;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.PageParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.devicesearch.TEDeviceSearchBean;
import com.huawei.nglct.neinterface.devicesearch.IPSearchDomain;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TEDeviceSearchServlet
extends HttpServlet {
    private static final long serialVersionUID = 8949582250778475944L;
    private static final String SEARCH_AREA_PARAM_NAME = "searchArea";
    private static final String SFID_PARAM = "sfid";
    private static final String INPUTDATA_PARAM = "inputdata";
    private static final int GET_SEARCH_AREA_CMD = 24603;
    private static final int START_SEARCH_DEVICE_CMD = 24600;
    private static final int STOP_SEARCH_DEVICE_CMD = 24601;
    private static final int GET_SEARCH_DEVICE_CMD = 24602;
    private static final int CMD_ADD_SEARCH_AREA = 24604;
    private static final int CMD_DEL_SEARCH_AREA = 24605;
    private static final int CMD_MODIFY_SEARCH_AREA = 24606;
    private static final int ADD_NE_CMD = 12288;
    private static final int TYPE_GNE_IPADDRESS = 2;
    private static final int TYPE_GNE_MCAST = 3;
    private static final int CMD_RAPID_SEARCH_INIT = 24607;
    private static final int CMD_RAPID_SEARCH = 24608;

    public void init() throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/xml;charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        int sfid = Integer.parseInt(request.getParameter(SFID_PARAM));
        String inputDataStr = request.getParameter(INPUTDATA_PARAM);
        Datainterface inputData = null;
        Datainterface outputData = null;
        SubFunc subFunc = null;
        TEDeviceSearchBean deviceSearchBean = null;
        StringWriter out = new StringWriter();
        PrintWriter print = response.getWriter();
        TELogInfo loginfo = new TELogInfo();
        try {
            TELogFactory.getInterfaceLogger().info("The sfid is :" + sfid + "The page reuqest XML is:\n" + inputDataStr);
            if (null != inputDataStr && !inputDataStr.equals("")) {
                inputData = TECreateObjectFactory.parseInputData(inputDataStr);
            }
            if (null == (subFunc = TECreateObjectFactory.getSubFunc(sfid))) {
                throw new FileNotFoundException();
            }
            deviceSearchBean = new TEDeviceSearchBean();
            String searchArea = null;
            String searchAreaType = null;
            String connectType = "normal";
            if (inputData != null && inputData.getBussinessParams().getRowParams(0).getParam("connectType") != null) {
                connectType = inputData.getBussinessParams().getRowParams(0).getParam("connectType").getValue();
            }
            switch (sfid) {
                case 24603: {
                    outputData = deviceSearchBean.getSearchArea();
                    break;
                }
                case 24607: {
                    outputData = deviceSearchBean.initRapidSearch(connectType);
                    break;
                }
                case 24608: {
                    RowParams row = inputData.getBussinessParams().getRowParams(0);
                    byte[] password = EncryptUtils.decrypt(row.getParam("password").getValue());
                    outputData = deviceSearchBean.rapidSearch(row.getParam("localip").getValue(), connectType, row.getParam("username").getValue(), EncryptUtils.encryptAESByte2Str(password));
                    EncryptUtils.clearByte(password);
                    break;
                }
                case 24600: {
                    String userName = null;
                    byte[] password = null;
                    if (null != inputData && null != inputData.getBussinessParams()) {
                        int len = inputData.getBussinessParams().getRowParamsCount();
                        for (int row = 0; row < len; ++row) {
                            RowParams rowparams = inputData.getBussinessParams().getRowParams(row);
                            searchArea = rowparams.getParam(SEARCH_AREA_PARAM_NAME).getValue();
                            searchAreaType = rowparams.getParam("domainType").getValue();
                            userName = rowparams.getParam("username").getValue();
                            password = EncryptUtils.decrypt(rowparams.getParam("password").getValue());
                        }
                    }
                    loginfo.setOperateDesc("ip:" + searchArea);
                    int castType = 1;
                    if (searchAreaType == null || searchArea == null) {
                        TELogFactory.getInterfaceLogger().error("searchAreaType is null");
                        return;
                    }
                    switch (Integer.parseInt(searchAreaType)) {
                        case 2: {
                            castType = 0;
                            break;
                        }
                        case 3: {
                            castType = 2;
                        }
                    }
                    if (connectType.equals("service port")) {
                        castType = 3;
                    }
                    outputData = deviceSearchBean.startSearchDevice(searchArea, castType, userName, EncryptUtils.encryptAESByte2Str(password));
                    EncryptUtils.clearByte(password);
                    break;
                }
                case 24601: {
                    outputData = deviceSearchBean.stopSearchDevice();
                    break;
                }
                case 24602: {
                    outputData = deviceSearchBean.getSearchDevice(searchArea, searchAreaType);
                    break;
                }
                case 12288: {
                    outputData = deviceSearchBean.addNE(subFunc, inputData);
                    break;
                }
                case 24604: {
                    IPSearchDomain searchDomain = null;
                    if (null != inputData && null != inputData.getBussinessParams()) {
                        RowParams rowparams = inputData.getBussinessParams().getRowParams(0);
                        int domainType = Integer.parseInt(rowparams.getParam("domainType").getValue());
                        String domainAddress = rowparams.getParam("domainAddress").getValue();
                        searchDomain = new IPSearchDomain(domainAddress, domainType);
                    }
                    outputData = deviceSearchBean.addSearchArea(searchDomain);
                    break;
                }
                case 24605: {
                    outputData = deviceSearchBean.delSearchArea(inputData);
                    break;
                }
                case 24606: {
                    IPSearchDomain newSearchDomain = null;
                    String oldSearchDomain = "";
                    if (null != inputData && null != inputData.getBussinessParams()) {
                        RowParams rowparams = inputData.getBussinessParams().getRowParams(0);
                        int domainType = Integer.parseInt(rowparams.getParam("domainType").getValue());
                        String domainAddress = rowparams.getParam("domainAddress").getValue();
                        oldSearchDomain = rowparams.getParam("oldDomainAddress").getValue();
                        newSearchDomain = new IPSearchDomain(domainAddress, domainType);
                    }
                    outputData = deviceSearchBean.modifySearchArea(newSearchDomain, oldSearchDomain);
                    break;
                }
                default: {
                    TELogFactory.getInterfaceLogger().error("sfid is default!");
                    return;
                }
            }
            if ((sfid == 24602 || sfid == 24600 || sfid == 24601) && inputData.getPageParams() != null && outputData.getBussinessParams() != null) {
                int rowlen = outputData.getBussinessParams().getRowParamsCount();
                for (int row = 0; row < rowlen; ++row) {
                    RowParams rowParams = outputData.getBussinessParams().getRowParams(row);
                    String neidStr = rowParams.getParam("neid").getValue();
                    int neidInt = Integer.parseInt(neidStr) % 65536;
                    Param param = new Param();
                    param.setName("idName");
                    param.setValue(String.valueOf(neidInt));
                    rowParams.addParam(param);
                }
                PageParams pageParams = inputData.getPageParams();
                ArrayList<String> sortParamList = new ArrayList<String>();
                String sortby = "asc";
                int size = pageParams.getParamCount();
                for (int i = 0; i < size; ++i) {
                    if (pageParams.getParam(i).getName().equals("sortParam")) {
                        sortParamList.add(pageParams.getParam(i).getValue());
                        continue;
                    }
                    if (!pageParams.getParam(i).getName().equals("sortby")) continue;
                    sortby = pageParams.getParam(i).getValue();
                }
                TESplitPageBean.sortDatainterface(outputData, subFunc, sortParamList, sortby);
            }
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setUserID(0);
            loginfo.setCmdID(sfid);
            loginfo.setLocation(request.getRemoteAddr());
            loginfo.setOperateObject("");
            loginfo.setOperateName(subFunc.getSubFuncDes());
            loginfo.setErrCode(Integer.parseInt(outputData.getErrorMessage().getErrorcode()));
            loginfo.setErrInfo(outputData.getErrorMessage().getErrorinfo());
            loginfo.setResult(Integer.parseInt(outputData.getErrorMessage().getErrorcode()));
            loginfo.setOperateDesc(subFunc.getSubFuncDes());
            TELogMgr.writeLog(loginfo);
            outputData.marshal(out);
            TELogFactory.getInterfaceLogger().info("The sfid is :" + sfid + "\nThe return page XML Data is:\n" + ((Object)out).toString());
            print.println(((Object)out).toString());
        }
        catch (FileNotFoundException e) {
            TELogFactory.getNormalLogger().error("File not found error:", (Throwable)e);
            return;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Program inner error:", (Throwable)e);
            outputData = new Datainterface();
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
            try {
                outputData.marshal(out);
                TELogFactory.getInterfaceLogger().info("The return page XML Data is:\n" + ((Object)out).toString());
            }
            catch (Exception ex) {
                TELogFactory.getNormalLogger().error("Parse error:", (Throwable)ex);
                return;
            }
            print.println(((Object)out).toString());
            return;
        }
        finally {
            if (null != out) {
                ((Writer)out).close();
            }
            if (null != print) {
                print.close();
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void destroy() {
    }

    public String calcMaskByPrefixLength(int length) {
        int mask = -1 << 32 - length;
        int partsNum = 4;
        int bitsOfPart = 8;
        int[] maskParts = new int[partsNum];
        int selector = 255;
        for (int i = 0; i < maskParts.length; ++i) {
            int pos = maskParts.length - 1 - i;
            maskParts[pos] = mask >> i * bitsOfPart & selector;
        }
        StringBuilder result = new StringBuilder();
        result.append(maskParts[0]);
        for (int i = 1; i < maskParts.length; ++i) {
            result.append(".").append(maskParts[i]);
        }
        return result.toString();
    }
}

