/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.devicesearch;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.devicesearch.TESubnetAddress;
import com.huawei.nglct.neinterface.devicesearch.IPSearchDomain;
import com.huawei.nglct.neinterface.devicesearch.TEAddressStruct;
import com.huawei.nglct.neinterface.devicesearch.TENESearchMgr;
import com.huawei.nglct.neinterface.devicesearch.TESearchedNE;
import com.huawei.nglct.nelist.TEAddNEBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import gnu.trove.TIntArrayList;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

public class TEDeviceSearchBean {
    private static final int NO_CREATE_STATUS = 0;
    private static final int CREATED_STATUS = 1;
    private static final int IP_PROTOCOL = 1;
    private static final int SERIAL_PROTOCOL = 3;
    private static final String DEFAULT_IP_PORT = "1400";
    private static final String TL1_IP_PORT = "3081";
    private static final String DEFAULT_SERIAL_PORT = "COM1";
    public String filePath = TEPathManager.RESOURCE_PROFILE_PATH + "res_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    public TEResourceUtil res = TEResourceUtil.getInstance(this.filePath);
    private static final String TYPE_GNE_DOMAIN = "1";
    private static final String IS_DEFAULT_SEARCHDOMAIN = "1";
    private static final String ISNOT_DEFAULT_SEARCHDOMAIN = "0";
    private static final String GNE = "1";
    private static final String NON_GNE = "2";

    public Datainterface rapidSearch(String localip, String connectType, String username, String password) throws SocketException {
        TELogFactory.getNormalLogger().info("====localip is : " + localip + "====connectType is : " + connectType);
        Datainterface output = new Datainterface();
        output.setBussinessParams(new BussinessParams());
        Enumeration<NetworkInterface> eni = NetworkInterface.getNetworkInterfaces();
        while (eni.hasMoreElements()) {
            NetworkInterface networkCard = eni.nextElement();
            List<InterfaceAddress> ncAddrList = networkCard.getInterfaceAddresses();
            for (InterfaceAddress networkCardAddress : ncAddrList) {
                int result;
                String hostAddress;
                if (networkCardAddress == null) continue;
                InetAddress address = networkCardAddress.getAddress();
                TELogFactory.getNormalLogger().info("====address is : " + address.getHostAddress());
                TELogFactory.getNormalLogger().info("====isLoopbackAddress : " + address.isLoopbackAddress());
                if (address.isLoopbackAddress() || !(hostAddress = address.getHostAddress()).equals(localip)) continue;
                TELogFactory.getNormalLogger().info("====Broadcast address is : " + networkCardAddress.getBroadcast().getHostAddress());
                int castType = 1;
                if (connectType.equals("service port")) {
                    castType = 3;
                }
                if ((result = TENESearchMgr.getInstance().searchNE(this.getSearchField(networkCardAddress), castType, username, password)) != 0) continue;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    TELogFactory.getNormalLogger().error(e.getMessage());
                }
                List searchedList = TENESearchMgr.getInstance().getAllSearchedNEList();
                TENESearchMgr.getInstance().receiveEndSearchRequest();
                TELogFactory.getNormalLogger().info("====searchedList size is : " + searchedList.size());
                int iLength = searchedList.size();
                for (int i = 0; i < iLength; ++i) {
                    TESearchedNE searchedNEData = (TESearchedNE)searchedList.get(i);
                    TELogFactory.getNormalLogger().info(searchedNEData.getNeID() + " isIsGNE: " + searchedNEData.isIsGNE());
                    if (!searchedNEData.isIsGNE()) continue;
                    RowParams rowparams = new RowParams();
                    for (TEAddressStruct struct : searchedNEData.getCommendGNEAddressList()) {
                        TELogFactory.getNormalLogger().info("====== getCommendGNEAddressList : " + struct.getAddress() + ":" + searchedNEData.getNeID());
                    }
                    TEAddressStruct struct = (TEAddressStruct)searchedNEData.getCommendGNEAddressList().get(0);
                    rowparams.addParam("searchedip", struct.getAddress());
                    rowparams.addParam("searchedneid", searchedNEData.getNeID());
                    output.getBussinessParams().addRowParams(rowparams);
                }
            }
        }
        output.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        return output;
    }

    private String getSearchField(InterfaceAddress networkCardAddress) {
        String osName = System.getProperties().getProperty("os.name");
        if ("Windows Vista".equals(osName) || "Windows 7".equals(osName) || "Windows 8".equals(osName)) {
            Map<String, String> broadCastMap = new TESubnetAddress().getBroadCastAddressMap();
            return broadCastMap.get(networkCardAddress.getAddress().getHostAddress());
        }
        return networkCardAddress.getBroadcast().getHostAddress();
    }

    public Datainterface initRapidSearch(String connectType) throws SocketException {
        Datainterface output = new Datainterface();
        output.setBussinessParams(new BussinessParams());
        RowParams firstrowparams = new RowParams();
        output.getBussinessParams().addRowParams(firstrowparams);
        Enumeration<NetworkInterface> eni = NetworkInterface.getNetworkInterfaces();
        while (eni.hasMoreElements()) {
            NetworkInterface networkCard = eni.nextElement();
            List<InterfaceAddress> ncAddrList = networkCard.getInterfaceAddresses();
            for (InterfaceAddress networkCardAddress : ncAddrList) {
                String hostAddress;
                InetAddress address;
                if (networkCardAddress == null || (address = networkCardAddress.getAddress()).isLoopbackAddress() || (hostAddress = address.getHostAddress()).indexOf(":") > 0) continue;
                firstrowparams.addParam("localip" + hostAddress, hostAddress);
            }
        }
        output.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        return output;
    }

    public Datainterface getSearchArea() {
        Datainterface output = new Datainterface();
        RowParams rowparams = null;
        Param param = null;
        List localAddress = null;
        localAddress = TENESearchMgr.getInstance().getLocalIPList();
        ArrayList ipAddress = TENESearchMgr.getInstance().getSearchDomains();
        boolean isLocalAddress = false;
        boolean isAddAddress = false;
        ArrayList<String> localIPField = new ArrayList<String>();
        output.setBussinessParams(new BussinessParams());
        if (null != localAddress && localAddress.size() > 0) {
            for (int i = localAddress.size() - 1; i >= 0; --i) {
                rowparams = new RowParams();
                if (!IPAddressUtil.isValidIP(localAddress.get(i).toString())) continue;
                String ipField = TENESearchMgr.getInstance().getSearchField(localAddress.get(i).toString());
                if (localIPField.size() > 0 && localIPField.contains(ipField)) continue;
                localIPField.add(ipField);
                param = new Param("domainAddress", ipField);
                rowparams.addParam(param);
                param = new Param("domainType", "1");
                rowparams.addParam(param);
                param = new Param("isDefaultFlag", "1");
                rowparams.addParam(param);
                output.getBussinessParams().addRowParams(rowparams);
            }
            isLocalAddress = true;
        }
        if (null != ipAddress && ipAddress.size() > 0) {
            IPSearchDomain searchDomain = null;
            int len = ipAddress.size();
            for (int i = 0; i < len; ++i) {
                searchDomain = (IPSearchDomain)ipAddress.get(i);
                rowparams = new RowParams();
                param = new Param("domainType", String.valueOf(searchDomain.getDomainType()));
                rowparams.addParam(param);
                param = new Param("domainAddress", searchDomain.getDomainAddress());
                rowparams.addParam(param);
                param = new Param("isDefaultFlag", ISNOT_DEFAULT_SEARCHDOMAIN);
                rowparams.addParam(param);
                output.getBussinessParams().addRowParams(rowparams);
            }
            isAddAddress = true;
        }
        if (isAddAddress || isLocalAddress) {
            output.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        } else {
            output.setErrorMessage(TEErrorResourceUtil.getErrorMessage(2));
        }
        return output;
    }

    public Datainterface startSearchDevice(String searchArea, int castType, String userName, String password) {
        Datainterface output = new Datainterface();
        int result = TENESearchMgr.getInstance().searchNE(searchArea, castType, userName, password);
        output.setErrorMessage(TEErrorResourceUtil.getErrorMessage(result));
        return output;
    }

    public Datainterface stopSearchDevice() {
        Datainterface output = new Datainterface();
        int result = TENESearchMgr.getInstance().receiveEndSearchRequest();
        output.setErrorMessage(TEErrorResourceUtil.getErrorMessage(result));
        return output;
    }

    public Datainterface getSearchDevice(String searchArea, String searchAreaType) {
        Datainterface output = new Datainterface();
        List searchNEList = TENESearchMgr.getInstance().getAllSearchedNEList();
        this.handleSearchResult(searchArea, searchNEList, output);
        output.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        return output;
    }

    public Datainterface addNE(SubFunc subfunc, Datainterface inputData) {
        TEAddNEBean addNEBean = new TEAddNEBean();
        Datainterface output = addNEBean.subFuncProcessed(subfunc, inputData, "");
        return output;
    }

    private void handleSearchResult(String searchArea, List searchedNEList, Datainterface output) {
        TESearchedNE searchedNEData = null;
        RowParams rowparams = null;
        Param neid_param = null;
        Param ne_status_param = null;
        Param gne_type_param = null;
        Param gne_address_param = null;
        Param gne_port_param = null;
        Param is_gne_param = null;
        Param neconnecttype_param = null;
        Option gne_type_option = null;
        Option gne_address_option = null;
        Option gne_port_option = null;
        ArrayList gneInfoList = null;
        TEAddressStruct struct = null;
        int neStatus = 0;
        if (null != searchedNEList && !searchedNEList.isEmpty()) {
            output.setBussinessParams(new BussinessParams());
            int neNo = 0;
            for (int searchedNEIndex = searchedNEList.size() - 1; searchedNEIndex >= 0; --searchedNEIndex) {
                searchedNEData = (TESearchedNE)searchedNEList.get(searchedNEIndex);
                TIntArrayList neIDList = TENEListMgr.getInstance().getNEIDList();
                TENE neObj = null;
                TENE neInMemory = null;
                int neListSize = neIDList.size();
                for (int neListIndex = 0; neListIndex < neListSize; ++neListIndex) {
                    int neIDInMemory = neIDList.get(neListIndex);
                    neInMemory = TENEListMgr.getInstance().getNE(neIDInMemory);
                    if (!neInMemory.getNEName().equals(searchedNEData.getNeID())) continue;
                    neObj = neInMemory;
                }
                neStatus = null != neObj ? 1 : 0;
                rowparams = new RowParams();
                neid_param = new Param("neid", searchedNEData.getNeID());
                ne_status_param = new Param("neStatus", String.valueOf(neStatus));
                is_gne_param = new Param("neGateWay", searchedNEData.isIsGNE() ? "1" : NON_GNE);
                gneInfoList = searchedNEData.getCommendGNEAddressList();
                struct = (TEAddressStruct)gneInfoList.get(0);
                gne_type_param = new Param("gneType", String.valueOf(struct.getProtocolType()));
                gne_address_param = new Param("gneAddress", struct.getAddress());
                int neConnectType = struct.getInterfType();
                neconnecttype_param = new Param("neConnectType", String.valueOf(neConnectType));
                gne_port_param = struct.getProtocolType() == 1 ? (neConnectType == 1 ? new Param("port", DEFAULT_IP_PORT) : new Param("port", TL1_IP_PORT)) : (struct.getProtocolType() == 3 ? new Param("port", DEFAULT_SERIAL_PORT) : new Param("port", ""));
                int len = gneInfoList.size();
                for (int j = 0; j < len; ++j) {
                    struct = (TEAddressStruct)gneInfoList.get(j);
                    gne_type_option = new Option();
                    gne_type_option.setValue(String.valueOf(struct.getProtocolType()));
                    gne_type_param.addOption(gne_type_option);
                    gne_address_option = new Option();
                    gne_address_option.setValue(struct.getAddress());
                    gne_address_param.addOption(gne_address_option);
                    gne_port_option = new Option();
                    if (struct.getProtocolType() == 1) {
                        if (struct.getInterfType() == 1) {
                            gne_port_option.setValue(DEFAULT_IP_PORT);
                        } else {
                            gne_port_option.setValue(TL1_IP_PORT);
                        }
                    } else if (struct.getProtocolType() == 3) {
                        gne_port_option.setValue(DEFAULT_SERIAL_PORT);
                    } else {
                        gne_port_option.setValue("");
                    }
                    gne_port_param.addOption(gne_port_option);
                }
                rowparams.addParam(neid_param);
                rowparams.addParam(gne_type_param);
                rowparams.addParam(gne_address_param);
                rowparams.addParam(gne_port_param);
                rowparams.addParam(ne_status_param);
                rowparams.addParam(neconnecttype_param);
                rowparams.addParam(is_gne_param);
                rowparams.addParam("neno", String.valueOf(neNo++));
                output.getBussinessParams().addRowParams(rowparams);
            }
        }
    }

    public Datainterface addSearchArea(IPSearchDomain searchDomain) {
        Datainterface output = new Datainterface();
        boolean succ = TENESearchMgr.getInstance().addSearchArea(searchDomain);
        if (succ) {
            output.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        } else {
            output.setErrorMessage(TEErrorResourceUtil.getErrorMessage(2));
        }
        return output;
    }

    public Datainterface modifySearchArea(IPSearchDomain searchDomain, String oldSearchDomain) {
        Datainterface output = new Datainterface();
        boolean succ = TENESearchMgr.getInstance().modifySearchArea(searchDomain, oldSearchDomain);
        if (succ) {
            output.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        } else {
            output.setErrorMessage(TEErrorResourceUtil.getErrorMessage(2));
        }
        return output;
    }

    public Datainterface delSearchArea(Datainterface inputData) {
        Datainterface outputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        int succCount = 0;
        if (null != inputData && null != inputData.getBussinessParams()) {
            int len = inputData.getBussinessParams().getRowParamsCount();
            for (int row = 0; row < len; ++row) {
                RowParams rowparams = inputData.getBussinessParams().getRowParams(row);
                String domainAddress = rowparams.getParam("domainAddress").getValue();
                if (TENESearchMgr.getInstance().delSearchArea(domainAddress)) continue;
                ++succCount;
                RowParams rowParam = new RowParams();
                RowErrors rowErr = new RowErrors();
                Param errParam = new Param();
                errParam.setName("domainAddress");
                errParam.setValue(domainAddress);
                rowErr.addParam(errParam);
                rowErr.setErrorMessage(TEErrorResourceUtil.getErrorMessage(2));
                rowParam.addRowErrors(rowErr);
                bussiness.addRowParams(rowParam);
            }
            outputData.setBussinessParams(bussiness);
            if (succCount == inputData.getBussinessParams().getRowParamsCount()) {
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(2));
            } else if (succCount == 0) {
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
            } else {
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1));
            }
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
        }
        return outputData;
    }
}

