/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.db.jni.hbnconfiguration;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.jni.hbnconfiguration.CompositePOKey;
import com.huawei.nglct.db.jni.hbnconfiguration.DTDEntityResolver;
import com.huawei.nglct.db.jni.hbnconfiguration.ErrorLogger;
import com.huawei.nglct.db.jni.hbnconfiguration.IPOClass;
import com.huawei.nglct.db.jni.hbnconfiguration.IPOCollection;
import com.huawei.nglct.db.jni.hbnconfiguration.IPOKey;
import com.huawei.nglct.db.jni.hbnconfiguration.IPOKeyProperty;
import com.huawei.nglct.db.jni.hbnconfiguration.IPOMemberProperty;
import com.huawei.nglct.db.jni.hbnconfiguration.POCollectionImpl;
import com.huawei.nglct.db.jni.hbnconfiguration.PODefinitionContainer;
import com.huawei.nglct.db.jni.hbnconfiguration.PODefinitionParser;
import com.huawei.nglct.db.jni.hbnconfiguration.POKeyPropertyImpl;
import com.huawei.nglct.db.jni.hbnconfiguration.PORootClass;
import com.huawei.nglct.db.jni.hbnconfiguration.POSubClass;
import com.huawei.nglct.db.jni.hbnconfiguration.SimplePOKey;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

class SaxPODefinitionParser
implements PODefinitionParser {
    private static Logger embededWnemgrlog = TELogFactory.getembededWnemgrLogger();
    private SAXReader saxReader = new SAXReader();

    SaxPODefinitionParser() {
    }

    @Override
    public void parseFile(File f, PODefinitionContainer con) throws Exception {
        ArrayList errors = new ArrayList();
        DTDEntityResolver DEFAULT_DTD_RESOLVER = new DTDEntityResolver();
        this.saxReader.setEntityResolver((EntityResolver)DEFAULT_DTD_RESOLVER);
        this.saxReader.setErrorHandler((ErrorHandler)new ErrorLogger(f.toString(), errors));
        this.saxReader.setMergeAdjacentText(true);
        this.saxReader.setValidation(false);
        Document doc = this.saxReader.read(f);
        if (!errors.isEmpty()) {
            throw new Exception(f + "  " + errors.get(0));
        }
        this.add(doc, con);
    }

    private void add(Document doc, PODefinitionContainer con) throws Exception {
        Element hmNode = doc.getRootElement();
        Iterator rootChildren = hmNode.elementIterator();
        while (rootChildren.hasNext()) {
            IPOClass c;
            Element element = (Element)rootChildren.next();
            String nodeName = element.getName();
            Attribute clzNameAttr = element.attribute("name");
            String clzName = clzNameAttr.getValue();
            if (con.containsPO(clzName)) {
                return;
            }
            if ("subclass".equals(nodeName) || "joined-subclass".equals(nodeName) || "union-subclass".equals(nodeName)) {
                c = this.createSubClass(element, con);
                con.addPO(c);
                continue;
            }
            if (!"class".equals(nodeName)) continue;
            c = this.createPORootClass(element, con);
            con.addPO(c);
        }
    }

    private IPOClass createPORootClass(Element root, PODefinitionContainer con) throws Exception {
        PORootClass cls = new PORootClass();
        String classname = root.attributeValue("name");
        cls.setName(classname);
        ArrayList<String> clzcollections = new ArrayList<String>();
        cls.setCollections(clzcollections);
        HashMap<String, IPOMemberProperty> properties = new HashMap<String, IPOMemberProperty>();
        cls.setProperties(properties);
        Iterator subnodes = root.elementIterator();
        ArrayList<Element> innerSubClassList = new ArrayList<Element>();
        while (subnodes.hasNext()) {
            IPOKey key;
            Element subnode = (Element)subnodes.next();
            String name = subnode.getName();
            if ("id".equals(name)) {
                key = this.processSimpleIDElement(subnode);
                cls.setKey(key);
                continue;
            }
            if ("composite-id".equals(name)) {
                key = this.processCompositeidElement(subnode);
                cls.setKey(key);
                continue;
            }
            if (!"subclass".equals(name) && !"joined-subclass".equals(name) && !"union-subclass".equals(name)) continue;
            innerSubClassList.add(subnode);
        }
        for (Element subele : innerSubClassList) {
            IPOClass cc = this.createInnerSubClass(subele, con, cls);
            if (null == cc) {
                throw new Exception("\u00b3\u00f5\u00ca\u00bc\u00bb\u00af\u00ca\u00a7\u00b0\u00dc->");
            }
            con.addPO(cc);
        }
        return cls;
    }

    private IPOKey processCompositeidElement(Element compositeidElement) {
        ArrayList<IPOKeyProperty> keys = new ArrayList<IPOKeyProperty>();
        Iterator keyproIter = compositeidElement.elementIterator("key-property");
        while (keyproIter.hasNext()) {
            Element keyEle = (Element)keyproIter.next();
            String keyName = keyEle.attributeValue("name");
            String keyCol = keyEle.attributeValue("column");
            String keyType = keyEle.attributeValue("type");
            POKeyPropertyImpl keyproperty = new POKeyPropertyImpl(keyName, keyType, keyCol);
            keys.add(keyproperty);
        }
        CompositePOKey key = new CompositePOKey(keys);
        return key;
    }

    private IPOKey processSimpleIDElement(Element simpleIDElement) {
        String ename = simpleIDElement.attributeValue("name");
        String type = simpleIDElement.attributeValue("type");
        String colname = null;
        Iterator colIter = simpleIDElement.elementIterator("column");
        while (colIter.hasNext()) {
            Element colEle = (Element)colIter.next();
            if (!"column".equals(colEle.getName())) continue;
            colname = colEle.attributeValue("name");
            break;
        }
        POKeyPropertyImpl keyproperty = new POKeyPropertyImpl(ename, type, colname);
        SimplePOKey key = new SimplePOKey(keyproperty);
        return key;
    }

    private IPOClass createInnerSubClass(Element root, PODefinitionContainer con, IPOClass parent) throws Exception {
        IPOClass pclz = parent;
        String extendz = parent.getName();
        String classname = root.attributeValue("name");
        POSubClass clz = new POSubClass();
        clz.setName(classname);
        clz.setParent(pclz);
        ArrayList<String> clzcollections = new ArrayList<String>();
        clz.setCollections(clzcollections);
        HashMap<String, IPOMemberProperty> properties = new HashMap<String, IPOMemberProperty>();
        properties.putAll(pclz.getProperties());
        clz.setProperties(properties);
        Exception exception = null;
        List<String> pclzcollections = pclz.getCollections();
        if (null != pclzcollections && !pclzcollections.isEmpty()) {
            for (String pcname : pclzcollections) {
                IPOCollection ic = con.findCollection(pcname);
                if (null == ic) {
                    exception = new Exception("\u00d5\u00d2\u00b2\u00bb\u00b5\u00bd\u00b6\u00d4\u00d3\u00a6\u00b5\u00c4\u00c8\u00dd\u00c6\u00f7\u00b6\u00a8\u00d2\u00e5->" + pcname);
                    embededWnemgrlog.error("\u00d5\u00d2\u00b2\u00bb\u00b5\u00bd\u00b6\u00d4\u00d3\u00a6\u00b5\u00c4\u00c8\u00dd\u00c6\u00f7\u00b6\u00a8\u00d2\u00e5->" + pcname, (Throwable)exception);
                    throw exception;
                }
                String newName = pcname.replace(extendz, classname);
                clzcollections.add(newName);
                POCollectionImpl sic = new POCollectionImpl(newName, ic.getElementType(), ic.getKey());
                con.addCollection(sic);
            }
        }
        return clz;
    }

    private IPOClass createSubClass(Element root, PODefinitionContainer con) throws Exception {
        String extendz = root.attributeValue("extends");
        if (null == extendz) {
            throw new Exception("\u00c8\u00b1\u00c9\u00d9 extends \u00ca\u00f4\u00d0\u00d4");
        }
        IPOClass pclz = con.findPO(extendz);
        if (null == pclz) {
            throw new Exception("\u00ce\u00b4\u00d5\u00d2\u00b5\u00bd\u00b8\u00b8\u00c0\u00e0\u00b6\u00a8\u00d2\u00e5->" + extendz);
        }
        String classname = root.attributeValue("name");
        POSubClass clz = new POSubClass();
        clz.setName(classname);
        clz.setParent(pclz);
        ArrayList<String> clzcollections = new ArrayList<String>();
        clz.setCollections(clzcollections);
        HashMap<String, IPOMemberProperty> properties = new HashMap<String, IPOMemberProperty>();
        properties.putAll(pclz.getProperties());
        clz.setProperties(properties);
        List<String> pclzcollections = pclz.getCollections();
        if (null != pclzcollections && !pclzcollections.isEmpty()) {
            for (String pcname : pclzcollections) {
                IPOCollection ic = con.findCollection(pcname);
                if (null == ic) {
                    throw new Exception("\u00d5\u00d2\u00b2\u00bb\u00b5\u00bd\u00b6\u00d4\u00d3\u00a6\u00b5\u00c4\u00c8\u00dd\u00c6\u00f7\u00b6\u00a8\u00d2\u00e5->" + pcname);
                }
                String newName = pcname.replace(extendz, classname);
                clzcollections.add(newName);
                POCollectionImpl sic = new POCollectionImpl(newName, ic.getElementType(), ic.getKey());
                con.addCollection(sic);
            }
        }
        return clz;
    }
}

