/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.db.jni.hbnconfiguration;

import com.huawei.nglct.db.jni.hbnconfiguration.IPOClass;
import com.huawei.nglct.db.jni.hbnconfiguration.IPOCollection;
import com.huawei.nglct.db.jni.hbnconfiguration.PODefinitionContainer;
import com.huawei.nglct.db.jni.hbnconfiguration.PODefinitionParser;
import com.huawei.nglct.db.jni.hbnconfiguration.SaxPODefinitionParser;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class POConfiguration
implements PODefinitionContainer {
    private static final String HBNCFG_SUFFIX = ".hbm.xml";
    private static POConfiguration instance = new POConfiguration();
    private Map<String, File> fileMap = new HashMap<String, File>();
    private PODefinitionParser parser = new SaxPODefinitionParser();
    private Map<String, IPOClass> classes = new HashMap<String, IPOClass>();
    private Map<String, IPOCollection> collections = new HashMap<String, IPOCollection>();

    static POConfiguration getInstance() {
        return instance;
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> l = new ArrayList<String>();
        l.add("g:/dtd");
        instance.parseHbnFile(l);
        System.out.println("classes===============");
        for (IPOClass c : POConfiguration.instance.classes.values()) {
            System.out.println(c.toString());
        }
        System.out.println();
        System.out.println("collections===============");
        Iterator<IPOCollection> iter2 = POConfiguration.instance.collections.values().iterator();
        while (iter2.hasNext()) {
            System.out.println(iter2.next());
        }
    }

    private POConfiguration() {
    }

    void parseHbnFile(List<String> dirs) throws Exception {
        if (null == dirs || dirs.isEmpty()) {
            return;
        }
        File[] fs = new File[dirs.size()];
        int findex = 0;
        for (String dir : dirs) {
            File f = new File(dir);
            if (!f.isDirectory()) continue;
            this.ListFile(f);
            fs[findex++] = f;
        }
    }

    public void parseHbnFile(File[] fs) throws Exception {
        if (null == fs || fs.length == 0) {
            return;
        }
        for (File f : fs) {
            this.addDirectory(f);
        }
    }

    private void addDirectory(File dir) throws Exception {
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.addDirectory(files[i]);
                continue;
            }
            if (!files[i].getName().endsWith(HBNCFG_SUFFIX)) continue;
            this.parseHbnCfgFile(files[i]);
        }
    }

    private void ListFile(File dir) {
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (null == files) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.ListFile(files[i]);
                continue;
            }
            if (!files[i].getName().endsWith(HBNCFG_SUFFIX)) continue;
            this.fileMap.put(files[i].getName(), files[i]);
        }
    }

    private void parseHbnCfgFile(File file) throws Exception {
        this.parseHbnCfgFile_Sax(file);
    }

    private void parseHbnCfgFile_Sax(File file) throws Exception {
        this.parser.parseFile(file, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPOClass getPOClass(String clsname) throws Exception {
        Map<String, IPOClass> map = this.classes;
        synchronized (map) {
            IPOClass cls = this.classes.get(clsname);
            if (null == cls) {
                String newname = clsname;
                File f = null;
                String shortName = this.clsName2HbnFileName(clsname);
                f = this.fileMap.get(shortName);
                while (f == null) {
                    Class<?> c = Class.forName(newname);
                    Class<?> s = c.getSuperclass();
                    if (s != null && s != Object.class) {
                        newname = s.getName();
                        shortName = this.clsName2HbnFileName(newname);
                        f = this.fileMap.get(shortName);
                        continue;
                    }
                    throw new Exception("\u00c7\u00eb\u00bc\u00ec\u00b2\u00e9\u00ca\u00c7\u00b7\u00f1\u00d3\u00d0\u00b4\u00cbPO\u00b5\u00c4\u00c5\u00e4\u00d6\u00c3\u00ce\u00c4\u00bc\u00fe\u00a3\u00ba->" + newname);
                }
                if (f.exists()) {
                    this.parseHbnCfgFile(f);
                }
            }
            cls = this.classes.get(clsname);
            return cls;
        }
    }

    private String clsName2HbnFileName(String clsname) {
        String shortName = clsname.substring(clsname.lastIndexOf(".") + 1);
        shortName = shortName + HBNCFG_SUFFIX;
        shortName = shortName.toLowerCase();
        return shortName;
    }

    @Override
    public void addCollection(IPOCollection collection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPO(IPOClass c) {
        Map<String, IPOClass> map = this.classes;
        synchronized (map) {
            this.classes.put(c.getName(), c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsPO(String clzName) {
        Map<String, IPOClass> map = this.classes;
        synchronized (map) {
            return this.classes.containsKey(clzName);
        }
    }

    @Override
    public IPOCollection findCollection(String pcname) {
        return this.collections.get(pcname);
    }

    @Override
    public IPOClass findPO(String poName) throws Exception {
        return this.getPOClass(poName);
    }
}

