/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.db.jni.hbnconfiguration;

import com.huawei.nglct.core.startup.TEWNEMgrJniLogFactory;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

class DTDEntityResolver
implements EntityResolver,
Serializable {
    private static final long serialVersionUID = -2521799303339047667L;
    private static final String HIBERNATE_MAPPING_3_0_DTD = "hibernate-mapping-3.0.dtd";
    private static final String JNI_DIR_NAME = "jni";
    private Logger log = TEWNEMgrJniLogFactory.getLogger(DTDEntityResolver.class.getName());

    DTDEntityResolver() {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        StringBuffer filePath = new StringBuffer(TEResourceManager.getPath()).append(File.separator).append(TEPathManager.CONFIG_PROFILE_PATH).append(JNI_DIR_NAME).append(File.separator).append(HIBERNATE_MAPPING_3_0_DTD);
        File f = TEResourceManager.getFileByName(filePath.toString());
        if (null == f || !f.exists()) {
            this.log.info("dtd file not exists....");
            return null;
        }
        try {
            InputStream in = f.toURI().toURL().openStream();
            InputSource source = new InputSource(in);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
        catch (MalformedURLException e) {
            this.log.info(e.getLocalizedMessage());
        }
        catch (IOException e) {
            this.log.info(e.getLocalizedMessage());
        }
        return null;
    }

    protected InputStream resolveInHibernateNamespace(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }
}

