/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.db.jni.dbservice;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.startup.TEWNEMgrJniDllLoader;
import com.huawei.nglct.core.startup.TEWNEMgrJniLogFactory;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.xml.TEResourceManager;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class TEMitDataMgr {
    private static Logger embededWnemgrlog = TEWNEMgrJniLogFactory.getLogger(TEMitDataMgr.class.getName());
    private static final String PO2MOMAPPING_FILENAME = "po2momapping.xml";
    private static final String ROOTNAMEATTR = "rootname";
    private static final String MONAMEATTR = "moname";
    private static final String NAMEATTR = "name";
    private static final String JNI_DIR_NAME = "jni";
    private static final String SEPARATER = "/";
    private static final String DOTSTRING = ".";
    private Map<String, String> class2RootName = new HashMap<String, String>();
    private TObjectIntHashMap<String> rootName2RootValue = new TObjectIntHashMap();
    private Map<String, String> po2MOName = new HashMap<String, String>();
    private static final int INVALID = -1;
    private static TEMitDataMgr instance;

    static TEMitDataMgr getInstance() {
        return instance;
    }

    private TEMitDataMgr() {
    }

    private void initData() {
        embededWnemgrlog.info("begin to init mit data");
        this.initPO2CMONameData();
        this.initRootInMitData();
        this.reg2Cmgr();
        embededWnemgrlog.info("end to init mit data");
    }

    public static void init() {
        instance.initData();
    }

    private void reg2Cmgr() {
        ArrayList<TEDaoNameValuePair> moName2POName = new ArrayList<TEDaoNameValuePair>();
        Set<Map.Entry<String, String>> entrySet = this.po2MOName.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String poname = entry.getKey();
            poname = poname.replace(DOTSTRING, SEPARATER);
            TEDaoNameValuePair pair = new TEDaoNameValuePair(entry.getValue(), poname);
            moName2POName.add(pair);
        }
        embededWnemgrlog.info("******************* begin to register po name ***********************");
        embededWnemgrlog.info(((Object)moName2POName).toString());
        try {
            TEMitDataMgr.regMO2POName(moName2POName);
        }
        catch (Throwable e) {
            embededWnemgrlog.info("", e);
        }
        embededWnemgrlog.info("**********************end to register po name **********************");
    }

    private static native void regMO2POName(List<TEDaoNameValuePair> var0);

    private static native void getRootInMitData(List<TEDaoNameValuePair> var0);

    public static void main(String[] args) {
    }

    private void initPO2CMONameData() {
        embededWnemgrlog.info("begin to load po 2 mo name data");
        StringBuffer filePath = new StringBuffer(TEResourceManager.getPath()).append(File.separator).append(TEPathManager.CONFIG_PROFILE_PATH).append(JNI_DIR_NAME).append(File.separator).append(PO2MOMAPPING_FILENAME);
        File file = TEResourceManager.getFileByName(filePath.toString());
        embededWnemgrlog.info("po 2 mo file path is ->" + filePath);
        if (null == file || !file.exists()) {
            embededWnemgrlog.info("mit conf file not exists->" + filePath);
            return;
        }
        embededWnemgrlog.info("file is ->" + file.getAbsolutePath());
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder db = factory.newDocumentBuilder();
            doc = db.parse(file);
        }
        catch (ParserConfigurationException e) {
            embededWnemgrlog.info(e.getMessage());
            TELogFactory.getNormalLogger().error("TEMitDataMgr.initPO2CMONameData() fail!", (Throwable)e);
        }
        catch (SAXException e) {
            embededWnemgrlog.info(e.getMessage());
            TELogFactory.getNormalLogger().error("TEMitDataMgr.initPO2CMONameData() fail!", (Throwable)e);
        }
        catch (IOException e) {
            embededWnemgrlog.info(e.getMessage());
            TELogFactory.getNormalLogger().error("TEMitDataMgr.initPO2CMONameData() fail!", (Throwable)e);
        }
        if (null == doc) {
            embededWnemgrlog.info("PARSE PO 2 MO NAME FAILED");
            return;
        }
        Element root = doc.getDocumentElement();
        NodeList children = root.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = children.item(i);
            if (1 != node.getNodeType()) continue;
            Element nodeElement = (Element)node;
            String clzname = nodeElement.getAttribute(NAMEATTR);
            String moname = nodeElement.getAttribute(MONAMEATTR);
            String rootname = nodeElement.getAttribute(ROOTNAMEATTR);
            this.class2RootName.put(clzname, rootname);
            this.po2MOName.put(clzname, moname);
        }
        embededWnemgrlog.info("class 2 root name is ->" + this.class2RootName);
        embededWnemgrlog.info("po 2 mo name is ->" + this.po2MOName);
        embededWnemgrlog.info("end to load po 2 mo name data");
    }

    private void initRootInMitData() {
        ArrayList<TEDaoNameValuePair> rootList = new ArrayList<TEDaoNameValuePair>();
        embededWnemgrlog.info("******************* begin to get root in mit ***********************");
        try {
            TEMitDataMgr.getRootInMitData(rootList);
        }
        catch (Throwable e) {
            embededWnemgrlog.info("", e);
        }
        embededWnemgrlog.info("root in mit ->" + rootList);
        for (TEDaoNameValuePair pair : rootList) {
            this.rootName2RootValue.put((Object)pair.getName(), Integer.parseInt(pair.getValue()));
        }
        if (!this.rootName2RootValue.containsKey((Object)"TEiMAPRoot")) {
            this.rootName2RootValue.put((Object)"TEiMAPRoot", 4);
        }
        embededWnemgrlog.info("root name 2 root value->" + this.rootName2RootValue);
        embededWnemgrlog.info("******************* end to get root in mit ***********************");
    }

    int getRootInmit(Class poClass) {
        int rootInMit = -1;
        String rootName = this.class2RootName.get(poClass.getName());
        if (null != rootName) {
            rootInMit = this.rootName2RootValue.get((Object)rootName);
        }
        return rootInMit;
    }

    String getCMONameByClassName(Class poClass) {
        String moName = this.po2MOName.get(poClass.getName());
        if (null == moName) {
            embededWnemgrlog.info("*************** class po not defined ****************  " + poClass);
            moName = TEMitDataMgr.getDefaultMONameByClass(poClass);
        }
        return moName;
    }

    private static String getDefaultMONameByClass(Class poClass) {
        String clsName = poClass.getName();
        String moName = clsName.substring(clsName.lastIndexOf(DOTSTRING) + 1);
        return moName;
    }

    static {
        TEWNEMgrJniDllLoader.loadWNEMgrDll();
        instance = new TEMitDataMgr();
    }
}

