/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.db.jni.dbservice;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.startup.TEWNEMgrJniLogFactory;
import com.huawei.nglct.db.IDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationConstants;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.db.gencfg.TEGeneralKeyValueObj;
import com.huawei.nglct.db.gencfg.TEGeneralValueObj;
import com.huawei.nglct.db.gencfg.TEGnlValueElementObj;
import com.huawei.nglct.db.jni.dbservice.DECommonData;
import com.huawei.nglct.db.jni.dbservice.JniCreateSubMOReq;
import com.huawei.nglct.db.jni.dbservice.JniCreateSubMORsp;
import com.huawei.nglct.db.jni.dbservice.JniDeleteSubMOReq;
import com.huawei.nglct.db.jni.dbservice.JniDeleteSubMORsp;
import com.huawei.nglct.db.jni.dbservice.JniGetCurrentMOReq;
import com.huawei.nglct.db.jni.dbservice.JniGetCurrentMORsp;
import com.huawei.nglct.db.jni.dbservice.JniGetSubMOReq;
import com.huawei.nglct.db.jni.dbservice.JniGetSubMORsp;
import com.huawei.nglct.db.jni.dbservice.JniModifySubMOReq;
import com.huawei.nglct.db.jni.dbservice.JniModifySubMORsp;
import com.huawei.nglct.db.jni.dbservice.JniSaveGnlValueReq;
import com.huawei.nglct.db.jni.dbservice.JniSaveGnlValueRsp;
import com.huawei.nglct.db.jni.dbservice.MetaElementIndex;
import com.huawei.nglct.db.jni.dbservice.MetaLength;
import com.huawei.nglct.db.jni.dbservice.OperationObjectType;
import com.huawei.nglct.db.jni.dbservice.TEGeneralKeyValue;
import com.huawei.nglct.db.jni.dbservice.TEGeneralValue;
import com.huawei.nglct.db.jni.dbservice.TEGnlValueElement;
import com.huawei.nglct.db.jni.dbservice.TEJniDaoServiceUtil;
import com.huawei.nglct.db.jni.dbservice.TEMitDataMgr;
import com.huawei.nglct.db.jni.hbnconfiguration.IPOClass;
import com.huawei.nglct.db.jni.hbnconfiguration.IPOKey;
import com.huawei.nglct.db.jni.hbnconfiguration.IProperty;
import com.huawei.nglct.db.jni.hbnconfiguration.IPropertyIterator;
import com.huawei.nglct.db.jni.hbnconfiguration.TEHibernateConfigurationMgr;
import com.huawei.nglct.jni.TEJNIFacadeUtil;
import com.huawei.nglct.jni.struct.TEGetGnlValueReqData;
import com.huawei.nglct.jni.struct.TEGetGnlValueRspData;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import gnu.trove.TIntIntHashMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

final class TEJniDaoService
implements IDaoService {
    private static Logger embededWnemgrlog = TEWNEMgrJniLogFactory.getLogger(TEJniDaoService.class.getName());
    private static final int INVALID = -1;
    private static final int EMPTYARRAY_LEN = 0;
    private static final int MAXMETALEN = 3;
    private TIntIntHashMap matalen2ObjType = new TIntIntHashMap(){
        private final int DEFAULTVALUE = OperationObjectType.ROOTINMITTYPE;
        {
            this.put(MetaLength.NETYPE, OperationObjectType.NETYPE);
            this.put(MetaLength.BOARDTYPE, OperationObjectType.BOARDTYPE);
            this.put(MetaLength.PORTTYPE, OperationObjectType.PORTTYPE);
        }

        public int get(int k) {
            return this.online(k) ? this.wow(k) : this.kof();
        }

        private boolean online(int key) {
            return super.contains(key);
        }

        private int wow(int k) {
            return super.get(k);
        }

        private int kof() {
            return this.DEFAULTVALUE;
        }
    };

    TEJniDaoService() {
    }

    private boolean isIntArrayNULLOrEmpty(int[] metadata) {
        return null == metadata || 0 == metadata.length;
    }

    private TEDaoOperationResult delete(int objType, int[] metadata, Object obj, byte mitLockType, short mitLockTime) throws Exception {
        embededWnemgrlog.info("********************delete*********************");
        embededWnemgrlog.info("objType->" + objType);
        if (this.isIntArrayNULLOrEmpty(metadata)) {
            embededWnemgrlog.info("metadata is null or length is 0");
            return TEDaoOperationConstants.EXCEPTIONRESULT;
        }
        TEDaoOperationResult result = new TEDaoOperationResult();
        Class<?> cls = obj.getClass();
        String clsName = cls.getName();
        IPOClass pocls = null;
        pocls = TEHibernateConfigurationMgr.findPO(clsName);
        if (null == pocls) {
            embededWnemgrlog.info("can't find class definition.->" + clsName);
            return TEDaoOperationConstants.EXCEPTIONRESULT;
        }
        JniDeleteSubMOReq req = new JniDeleteSubMOReq();
        DECommonData commonData = req.commonData;
        req.moObj = obj;
        commonData.objtype = objType;
        commonData.refreshMetaData(objType, metadata);
        commonData.moName = this.getCMONameByClassName(cls);
        commonData.needLock = mitLockType != 0;
        commonData.lockType = mitLockType;
        commonData.lockTime = mitLockTime;
        this.processPOClassKey(cls, pocls, commonData, obj);
        JniDeleteSubMORsp rsp = new JniDeleteSubMORsp();
        TEJniDaoServiceUtil.deleteSubMOWrapper(req, rsp);
        result.setResult(rsp.result);
        return result;
    }

    private TEDaoOperationResult findAll(int objType, int[] metadata, Class po, byte mitLockType, short mitLockTime) throws Exception {
        if (this.isIntArrayNULLOrEmpty(metadata)) {
            embededWnemgrlog.info("metadata is null or length is 0");
            return TEDaoOperationConstants.EXCEPTIONRESULT;
        }
        TEDaoOperationResult result = new TEDaoOperationResult();
        Class cls = po;
        String clsName = cls.getName();
        IPOClass pocls = null;
        pocls = TEHibernateConfigurationMgr.findPO(clsName);
        if (null == pocls) {
            embededWnemgrlog.info("can't find class definition.->" + clsName);
            return TEDaoOperationConstants.EXCEPTIONRESULT;
        }
        JniGetSubMOReq req = new JniGetSubMOReq();
        req.getAll = true;
        DECommonData commonData = req.commonData;
        commonData.objtype = objType;
        commonData.refreshMetaData(objType, metadata);
        commonData.needLock = mitLockType != 0;
        commonData.lockType = mitLockType;
        commonData.lockTime = mitLockTime;
        commonData.moName = this.getCMONameByClassName(cls);
        JniGetSubMORsp rsp = new JniGetSubMORsp();
        TEJniDaoServiceUtil.getSubMOWrapper(req, rsp);
        result.setResult(rsp.result);
        result.addData(rsp.moList);
        return result;
    }

    private TEDaoOperationResult update(int objType, int[] metadata, Object obj, byte mitLockType, short mitLockTime) throws Exception {
        if (this.isIntArrayNULLOrEmpty(metadata)) {
            return TEDaoOperationConstants.EXCEPTIONRESULT;
        }
        TEDaoOperationResult result = new TEDaoOperationResult();
        Class<?> cls = obj.getClass();
        String clsName = cls.getName();
        IPOClass pocls = null;
        pocls = TEHibernateConfigurationMgr.findPO(clsName);
        if (null == pocls) {
            return TEDaoOperationConstants.EXCEPTIONRESULT;
        }
        JniModifySubMOReq req = new JniModifySubMOReq();
        req.moObj = obj;
        DECommonData commonData = req.commonData;
        commonData.objtype = objType;
        commonData.refreshMetaData(objType, metadata);
        commonData.moName = this.getCMONameByClassName(cls);
        commonData.needLock = mitLockType != 0;
        commonData.lockType = mitLockType;
        commonData.lockTime = mitLockTime;
        this.processPOClassKey(cls, pocls, commonData, obj);
        JniModifySubMORsp rsp = new JniModifySubMORsp();
        TEJniDaoServiceUtil.modifySubMOWrapper(req, rsp);
        result.setResult(rsp.result);
        return result;
    }

    private TEDaoOperationResult create(int objType, int[] metadata, Object obj, byte mitLockType, short mitLockTime) throws Exception {
        TEDaoOperationResult result = new TEDaoOperationResult();
        Class<?> cls = obj.getClass();
        String clsName = cls.getName();
        IPOClass pocls = null;
        pocls = TEHibernateConfigurationMgr.findPO(clsName);
        if (null == pocls) {
            return result;
        }
        JniCreateSubMOReq req = new JniCreateSubMOReq();
        req.moObj = obj;
        DECommonData commonData = req.commonData;
        commonData.objtype = objType;
        commonData.refreshMetaData(objType, metadata);
        commonData.moName = this.getCMONameByClassName(cls);
        commonData.needLock = mitLockType != 0;
        commonData.lockType = mitLockType;
        commonData.lockTime = mitLockTime;
        this.processPOClassKey(cls, pocls, commonData, obj);
        JniCreateSubMORsp rsp = new JniCreateSubMORsp();
        TEJniDaoServiceUtil.createSubMOWrapper(req, rsp);
        result.setResult(rsp.result);
        return result;
    }

    private void processPOClassKey(Class cls, IPOClass pocls, DECommonData commonData, Object obj) throws Exception {
        List<TEDaoNameValuePair> mokey = commonData.mokey;
        IPOKey poKey = pocls.getKey();
        if (null == poKey) {
            return;
        }
        IPropertyIterator iter = poKey.iterator();
        while (iter.hasNext()) {
            IProperty keyproperty = iter.next();
            String name = keyproperty.getName();
            Field field = cls.getDeclaredField(name);
            if (null == field) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (null == field.get(obj)) continue;
            String value = field.get(obj).toString();
            TEDaoNameValuePair pair = new TEDaoNameValuePair(name, value);
            mokey.add(pair);
        }
    }

    private String getCMONameByClassName(Class poClass) {
        return TEMitDataMgr.getInstance().getCMONameByClassName(poClass);
    }

    private TEDaoOperationResult findMO(int objType, int[] metadata, boolean getAll, byte mitLockType, short mitLockTime) {
        JniGetCurrentMOReq req = new JniGetCurrentMOReq();
        DECommonData commonData = req.commonData;
        commonData.objtype = objType;
        req.getAll = getAll;
        commonData.neID = metadata[MetaElementIndex.NE];
        commonData.slotID = metadata[MetaElementIndex.BOARD];
        commonData.portID = metadata[MetaElementIndex.PORT];
        commonData.needLock = mitLockType != 0;
        commonData.lockType = mitLockType;
        commonData.lockTime = mitLockTime;
        int idStartIndex = 3;
        int idLen = metadata.length - idStartIndex;
        int[] ids = new int[idLen];
        System.arraycopy(metadata, idStartIndex, ids, 0, idLen);
        req.idList = ids;
        JniGetCurrentMORsp rsp = new JniGetCurrentMORsp();
        TEJniDaoServiceUtil.getCurrentMOWrapper(req, rsp);
        TEDaoOperationResult result = new TEDaoOperationResult();
        result.setResult(rsp.result);
        result.addData(rsp.data);
        return result;
    }

    @Override
    public TEDaoOperationResult create(int[] metadata, Object obj, byte mitLockType, short mitLockTime) throws Exception {
        if (this.isIntArrayNULLOrEmpty(metadata)) {
            return TEDaoOperationConstants.EXCEPTIONRESULT;
        }
        int len = metadata.length;
        int objType = this.matalen2ObjType.get(len);
        return this.create(objType, metadata, obj, mitLockType, mitLockTime);
    }

    @Override
    public TEDaoOperationResult create(Object obj, byte mitLockType, short mitLockTime) throws Exception {
        Class<?> cls = obj.getClass();
        int rootInMit = TEMitDataMgr.getInstance().getRootInmit(cls);
        int objType = OperationObjectType.ROOTINMITTYPE;
        int[] metadata = new int[]{rootInMit};
        return this.create(objType, metadata, obj, mitLockType, mitLockTime);
    }

    @Override
    public TEDaoOperationResult delete(int[] metadata, Object obj, byte mitLockType, short mitLockTime) throws Exception {
        if (this.isIntArrayNULLOrEmpty(metadata)) {
            return TEDaoOperationConstants.EXCEPTIONRESULT;
        }
        int len = metadata.length;
        int objType = this.matalen2ObjType.get(len);
        return this.delete(objType, metadata, obj, mitLockType, mitLockTime);
    }

    @Override
    public TEDaoOperationResult delete(Object obj, byte mitLockType, short mitLockTime) throws Exception {
        Class<?> cls = obj.getClass();
        int rootInMit = TEMitDataMgr.getInstance().getRootInmit(cls);
        int objType = OperationObjectType.ROOTINMITTYPE;
        int[] metadata = new int[]{rootInMit};
        return this.delete(objType, metadata, obj, mitLockType, mitLockTime);
    }

    @Override
    public TEDaoOperationResult deleteByID(int[] metadata, Class poClass, List<TEDaoNameValuePair> criterion, byte mitLockType, short mitLockTime) throws Exception {
        if (this.isIntArrayNULLOrEmpty(metadata)) {
            return TEDaoOperationConstants.EXCEPTIONRESULT;
        }
        int len = metadata.length;
        int objType = this.matalen2ObjType.get(len);
        return this.deleteByID(objType, metadata, poClass, criterion, mitLockType, mitLockTime);
    }

    private TEDaoOperationResult deleteByID(int objType, int[] metadata, Class poClass, List<TEDaoNameValuePair> criterion, byte mitLockType, short mitLockTime) {
        if (this.isIntArrayNULLOrEmpty(metadata)) {
            return TEDaoOperationConstants.EXCEPTIONRESULT;
        }
        TEDaoOperationResult result = new TEDaoOperationResult();
        Class cls = poClass;
        JniDeleteSubMOReq req = new JniDeleteSubMOReq();
        DECommonData commonData = req.commonData;
        commonData.objtype = objType;
        commonData.refreshMetaData(objType, metadata);
        commonData.moName = this.getCMONameByClassName(cls);
        if (null != criterion) {
            commonData.mokey.addAll(criterion);
        }
        commonData.needLock = mitLockType != 0;
        commonData.lockType = mitLockType;
        commonData.lockTime = mitLockTime;
        JniDeleteSubMORsp rsp = new JniDeleteSubMORsp();
        TEJniDaoServiceUtil.deleteSubMOWrapper(req, rsp);
        result.setResult(rsp.result);
        return result;
    }

    @Override
    public TEDaoOperationResult deleteByID(Class poClass, List<TEDaoNameValuePair> deleteCriterion, byte mitLockType, short mitLockTime) throws Exception {
        int rootInMit = TEMitDataMgr.getInstance().getRootInmit(poClass);
        int objType = OperationObjectType.ROOTINMITTYPE;
        int[] metadata = new int[]{rootInMit};
        return this.deleteByID(objType, metadata, poClass, deleteCriterion, mitLockType, mitLockTime);
    }

    @Override
    public TEDaoOperationResult findAll(int[] metadata, Class poClass, byte mitLockType, short mitLockTime) throws Exception {
        if (this.isIntArrayNULLOrEmpty(metadata)) {
            return TEDaoOperationConstants.EXCEPTIONRESULT;
        }
        int objType = this.matalen2ObjType.get(metadata.length);
        return this.findAll(objType, metadata, poClass, mitLockType, mitLockTime);
    }

    @Override
    public TEDaoOperationResult findAll(Class poClass, byte mitLockType, short mitLockTime) throws Exception {
        Class cls = poClass;
        int rootInMit = TEMitDataMgr.getInstance().getRootInmit(cls);
        int objType = OperationObjectType.ROOTINMITTYPE;
        int[] metadata = new int[]{rootInMit};
        return this.findAll(objType, metadata, poClass, mitLockType, mitLockTime);
    }

    @Override
    public TEDaoOperationResult findAllNE(byte mitLockType, short mitLockTime) throws Exception {
        int objType = OperationObjectType.NETYPE;
        int[] metadata = new int[]{-1, -1, -1};
        boolean findAll = true;
        return this.findMO(objType, metadata, findAll, mitLockType, mitLockTime);
    }

    @Override
    public TEDaoOperationResult findBoards(int neID, byte mitLockType, short mitLockTime) throws Exception {
        int objType = OperationObjectType.BOARDTYPE;
        int[] metadata = new int[]{neID, -1, -1};
        boolean findAll = true;
        return this.findMO(objType, metadata, findAll, mitLockType, mitLockTime);
    }

    @Override
    public TEDaoOperationResult findBoards(int neID, int[] slotIDs, byte mitLockType, short mitLockTime) throws Exception {
        if (this.isIntArrayNULLOrEmpty(slotIDs)) {
            return this.findBoards(neID, mitLockType, mitLockTime);
        }
        int objType = OperationObjectType.BOARDTYPE;
        int[] metadata = new int[3 + slotIDs.length];
        metadata[MetaElementIndex.NE] = neID;
        System.arraycopy(slotIDs, 0, metadata, 3, slotIDs.length);
        boolean findAll = false;
        return this.findMO(objType, metadata, findAll, mitLockType, mitLockTime);
    }

    @Override
    public TEDaoOperationResult findByID(int[] metadata, Class poClass, List<TEDaoNameValuePair> criteria, byte mitLockType, short mitLockTime) {
        if (this.isIntArrayNULLOrEmpty(metadata)) {
            return TEDaoOperationConstants.EXCEPTIONRESULT;
        }
        int objType = this.matalen2ObjType.get(metadata.length);
        return this.findByID(objType, metadata, poClass, criteria, mitLockType, mitLockTime);
    }

    private TEDaoOperationResult findByID(int objType, int[] metadata, Class poClass, List<TEDaoNameValuePair> criteria, byte mitLockType, short mitLockTime) {
        if (this.isIntArrayNULLOrEmpty(metadata)) {
            return TEDaoOperationConstants.EXCEPTIONRESULT;
        }
        TEDaoOperationResult result = new TEDaoOperationResult();
        Class cls = poClass;
        JniGetSubMOReq req = new JniGetSubMOReq();
        DECommonData commonData = req.commonData;
        commonData.objtype = objType;
        commonData.refreshMetaData(objType, metadata);
        commonData.moName = this.getCMONameByClassName(cls);
        if (null != criteria) {
            commonData.mokey.addAll(criteria);
        }
        commonData.needLock = mitLockType != 0;
        commonData.lockType = mitLockType;
        commonData.lockTime = mitLockTime;
        JniGetSubMORsp rsp = new JniGetSubMORsp();
        TEJniDaoServiceUtil.getSubMOWrapper(req, rsp);
        result.setResult(rsp.result);
        result.addData(rsp.moList);
        return result;
    }

    @Override
    public TEDaoOperationResult findByID(Class poClass, List<TEDaoNameValuePair> criteria, byte mitLockType, short mitLockTime) {
        Class cls = poClass;
        int rootInMit = TEMitDataMgr.getInstance().getRootInmit(cls);
        int objType = OperationObjectType.ROOTINMITTYPE;
        int[] metadata = new int[]{rootInMit};
        return this.findByID(objType, metadata, poClass, criteria, mitLockType, mitLockTime);
    }

    @Override
    public TEDaoOperationResult findNE(int[] neIDList, byte mitLockType, short mitLockTime) throws Exception {
        if (this.isIntArrayNULLOrEmpty(neIDList)) {
            return this.findAllNE(mitLockType, mitLockTime);
        }
        int objType = OperationObjectType.NETYPE;
        int[] metadata = new int[3 + neIDList.length];
        System.arraycopy(neIDList, 0, metadata, 3, neIDList.length);
        boolean findAll = false;
        return this.findMO(objType, metadata, findAll, mitLockType, mitLockTime);
    }

    @Override
    public TEDaoOperationResult findPorts(int neID, int slotID, byte mitLockType, short mitLockTime) throws Exception {
        int objType = OperationObjectType.PORTTYPE;
        int[] metadata = new int[]{neID, slotID, -1};
        boolean findAll = true;
        return this.findMO(objType, metadata, findAll, mitLockType, mitLockTime);
    }

    @Override
    public TEDaoOperationResult findPorts(int neID, int slotID, int[] portIDs, byte mitLockType, short mitLockTime) throws Exception {
        if (this.isIntArrayNULLOrEmpty(portIDs)) {
            return this.findPorts(neID, slotID, mitLockType, mitLockTime);
        }
        int objType = OperationObjectType.PORTTYPE;
        int[] metadata = new int[3 + portIDs.length];
        metadata[MetaElementIndex.NE] = neID;
        metadata[MetaElementIndex.BOARD] = slotID;
        System.arraycopy(portIDs, 0, metadata, 3, portIDs.length);
        boolean findAll = false;
        return this.findMO(objType, metadata, findAll, mitLockType, mitLockTime);
    }

    @Override
    public TEDaoOperationResult update(Object obj, byte mitLockType, short mitLockTime) throws Exception {
        Class<?> cls = obj.getClass();
        int rootInMit = TEMitDataMgr.getInstance().getRootInmit(cls);
        int objType = OperationObjectType.ROOTINMITTYPE;
        int[] metadata = new int[]{rootInMit};
        return this.update(objType, metadata, obj, mitLockType, mitLockTime);
    }

    @Override
    public TEDaoOperationResult update(int[] metadata, Object obj, byte mitLockType, short mitLockTime) throws Exception {
        if (this.isIntArrayNULLOrEmpty(metadata)) {
            return TEDaoOperationConstants.EXCEPTIONRESULT;
        }
        int objType = this.matalen2ObjType.get(metadata.length);
        return this.update(objType, metadata, obj, mitLockType, mitLockTime);
    }

    @Override
    public TEDaoOperationResult findGnlValue(List<TEGnlValueElement> elementList) {
        TEDaoOperationResult result = new TEDaoOperationResult();
        TEGetGnlValueReqData req = new TEGetGnlValueReqData();
        TEGetGnlValueRspData rsp = new TEGetGnlValueRspData();
        req.addGelVaule(elementList);
        int retCode = (int)TEJNIFacadeUtil.sendJNIMessage(2, req, rsp);
        result.setResult(retCode);
        if (0 == retCode) {
            List<TEGnlValueElement> rspEleList = rsp.getMoList();
            if (null != rspEleList && !rspEleList.isEmpty()) {
                for (TEGnlValueElement element : rspEleList) {
                    result.addData(element);
                }
            }
            result.setResult(rsp.getResult());
        }
        return result;
    }

    @Override
    public TEDaoOperationResult findGnlValue_NoLock(List<TEGnlValueElement> elementList) {
        TEDaoOperationResult result = new TEDaoOperationResult();
        TEGetGnlValueReqData req = new TEGetGnlValueReqData();
        TEGetGnlValueRspData rsp = new TEGetGnlValueRspData();
        req.addGelVaule(elementList);
        req.setMitLockType((byte)0);
        int retCode = (int)TEJNIFacadeUtil.sendJNIMessage(2, req, rsp);
        result.setResult(retCode);
        if (0 == retCode) {
            List<TEGnlValueElement> rspEleList = rsp.getMoList();
            if (null != rspEleList && !rspEleList.isEmpty()) {
                for (TEGnlValueElement element : rspEleList) {
                    result.addData(element);
                }
            }
            result.setResult(rsp.getResult());
        }
        return result;
    }

    private void fillKeyValueFromObj(TEGeneralKeyValueObj keyValueObj, TEGeneralKeyValue keyValue) {
        keyValue.setAttrID(keyValueObj.getAttrID());
        keyValue.setTEOBJECTID(keyValueObj.getTEOBJECTID());
    }

    @Override
    public TEDaoOperationResult saveGnlValue(List<TEGnlValueElementObj> gnlValueElementObjList) {
        JniSaveGnlValueReq req = new JniSaveGnlValueReq();
        JniSaveGnlValueRsp rsp = new JniSaveGnlValueRsp();
        req.gelVauleList.addAll(this.generateElementFromObj(gnlValueElementObjList));
        req.mitLockType = (byte)16;
        int retCode = TEJniDaoServiceUtil.saveGnlValueWrapper(req, rsp);
        TEDaoOperationResult result = new TEDaoOperationResult();
        result.setResult(retCode);
        return result;
    }

    private List<TEGnlValueElement> generateElementFromObj(List<TEGnlValueElementObj> gnlValueElementObjList) {
        ArrayList<TEGnlValueElement> elementList = new ArrayList<TEGnlValueElement>();
        for (TEGnlValueElementObj valueObj : gnlValueElementObjList) {
            elementList.add(this.generateElementFromObj(valueObj));
        }
        return elementList;
    }

    private TEGnlValueElement generateElementFromObj(TEGnlValueElementObj valueObj) {
        TEGnlValueElement element = new TEGnlValueElement();
        element.setGnlKeyValue(new TEGeneralKeyValue());
        element.setGnlValue(new TEGeneralValue());
        this.fillKeyValueFromObj(valueObj.getGnlKeyValue(), element.getGnlKeyValue());
        this.fillGenValueFromObj(valueObj.getGnlValue(), element.getGnlValue());
        return element;
    }

    private void fillGenValueFromObj(TEGeneralValueObj valueObj, TEGeneralValue value) {
        value.setAccess(valueObj.getAccess());
        value.setbValid(valueObj.isbValid());
        value.setErrCode(valueObj.getErrCode());
        value.setErrorInfo(valueObj.getErrorInfo());
        value.setiValue(valueObj.getiValue());
        value.setsValue(valueObj.getsValue());
    }

    @Override
    public TEDaoOperationResult saveGnlValueToDB(List<TEGnlValueElement> gnlValueElementList) {
        ArrayList<TEGnlValueElement> lockList = new ArrayList<TEGnlValueElement>();
        ArrayList<TEGnlValueElement> noLockList = new ArrayList<TEGnlValueElement>();
        int neID = -1;
        TENE ne = null;
        for (TEGnlValueElement ele : gnlValueElementList) {
            neID = ele.getGnlKeyValue().getTEOBJECTID()[1];
            ne = TENEListMgr.getInstance().getNE(neID);
            if (ne.isDataCfgStausNeedLock()) {
                lockList.add(ele);
                continue;
            }
            noLockList.add(ele);
        }
        TEDaoOperationResult lockResult = new TEDaoOperationResult();
        lockResult.setResult(0);
        TEDaoOperationResult noLockResult = new TEDaoOperationResult();
        noLockResult.setResult(0);
        if (!lockList.isEmpty()) {
            lockResult = this.saveGnlValueToDB(gnlValueElementList, (byte)16);
            TELogFactory.getembededWnemgrLogger().info("save gen value with write lock. result->" + lockResult.getResult());
        }
        if (!noLockList.isEmpty()) {
            noLockResult = this.saveGnlValueToDB(gnlValueElementList, (byte)0);
            TELogFactory.getembededWnemgrLogger().info("save gen value without lock. result->" + noLockResult.getResult());
        }
        if (0 != lockResult.getResult()) {
            return lockResult;
        }
        if (0 != noLockResult.getResult()) {
            return noLockResult;
        }
        TEDaoOperationResult result = new TEDaoOperationResult();
        result.setResult(0);
        return result;
    }

    private TEDaoOperationResult saveGnlValueToDB(List<TEGnlValueElement> gnlValueElementList, byte lockType) {
        JniSaveGnlValueReq req = new JniSaveGnlValueReq();
        JniSaveGnlValueRsp rsp = new JniSaveGnlValueRsp();
        req.gelVauleList.addAll(gnlValueElementList);
        req.mitLockType = lockType;
        int retCode = TEJniDaoServiceUtil.saveGnlValueWrapper(req, rsp);
        TEDaoOperationResult result = new TEDaoOperationResult();
        result.setResult(retCode);
        return result;
    }
}

