/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.db;

import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.hibernate.Dao;
import com.huawei.uflight.hibernate.DaoFactory;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class TEDaoHolder {
    private static final URL FAULT_CONFIG_URL = TEResourceManager.getURL("conf" + File.separator + "db" + File.separator + "hibernate.cfg.xml");
    private static final String FAULT_DBNAME = "securityDB";
    private static final Map<String, Dao> DAOMAP = new HashMap<String, Dao>();
    private static TEDaoHolder daoHolder;

    public static synchronized TEDaoHolder getInstance() {
        if (daoHolder == null) {
            daoHolder = new TEDaoHolder();
        }
        return daoHolder;
    }

    public Dao getDao() {
        Dao dao = DAOMAP.get(FAULT_CONFIG_URL.toString());
        if (dao == null) {
            dao = DaoFactory.getInstance().getDao(FAULT_CONFIG_URL, FAULT_DBNAME);
            DAOMAP.put(FAULT_CONFIG_URL.toString(), dao);
        }
        return dao;
    }

    public Dao getDao(String dbName) {
        Dao dao = DAOMAP.get(FAULT_CONFIG_URL.toString());
        if (dao == null) {
            dao = DaoFactory.getInstance().getDao(FAULT_CONFIG_URL, dbName);
            DAOMAP.put(FAULT_CONFIG_URL.toString(), dao);
        }
        return dao;
    }

    public Dao getDao(URL confFileURL, String dbName) {
        return this.getDao(confFileURL, null, dbName);
    }

    public Dao getDao(Properties properties, String dbName) {
        return this.getDao(FAULT_CONFIG_URL, properties, dbName);
    }

    public Dao getDao(URL confFileURL, Properties properties, String dbName) {
        Dao dao = DAOMAP.get(confFileURL.toString());
        if (dao == null) {
            dao = DaoFactory.getInstance().getDao(confFileURL, properties, dbName);
            DAOMAP.put(confFileURL.toString(), dao);
        }
        return dao;
    }

    private TEDaoHolder() {
    }

    public void closeDao() {
        DaoFactory.getInstance().closeDao(FAULT_CONFIG_URL);
        DAOMAP.remove(FAULT_CONFIG_URL.toString());
    }

    public void closeDao(URL confFileURL) {
        DaoFactory.getInstance().closeDao(confFileURL);
        DAOMAP.remove(confFileURL.toString());
    }
}

