/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.db;

import com.huawei.nglct.cbb.log.t2kinterface.TEDBConnMgr;
import com.huawei.nglct.db.IDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.db.gencfg.TEGeneralKeyValueObj;
import com.huawei.nglct.db.gencfg.TEGnlValueElementObj;
import com.huawei.nglct.db.jni.dbservice.TEEmbededWNEMgrDaoServiceAdapter;
import com.huawei.nglct.db.jni.dbservice.TEGeneralKeyValue;
import com.huawei.nglct.db.jni.dbservice.TEGnlValueElement;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public final class TECommonDaoService {
    private static IDaoService service = null;
    private static final short DEFAULT_LOCK_TIME = 60;
    public static final byte NEED_LOCK_TYPE = 1;
    public static final byte NON_LOCK_TYPE = 0;
    private static final int PATH_ID_POS = 4;
    private static final Map<Integer, String> ATTR_ID_TO_NAME = new Hashtable<Integer, String>();

    public static void intialIDaoService() {
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            service = TEEmbededWNEMgrDaoServiceAdapter.getInstance();
        }
        ATTR_ID_TO_NAME.put(10001012, "W32PORT_ATTR_LINE_CAPACITY");
        ATTR_ID_TO_NAME.put(271567, "W32PORT_ATTR_LINE_CAPACITY");
        ATTR_ID_TO_NAME.put(272275, "W32PORT_ATTR_FECTYPE");
        ATTR_ID_TO_NAME.put(270376, "W32PORT_ATTR_FECENABLE");
    }

    private TECommonDaoService() {
    }

    public static final Connection getDBConn(String dbName) {
        return TEDBConnMgr.getInstance().getDBConn(dbName);
    }

    public static final Connection getMCDBConn() {
        return TEDBConnMgr.getInstance().getMCDBConn();
    }

    public static final Connection getLogConn() {
        return TEDBConnMgr.getInstance().getLogConn();
    }

    public static final Connection getSecurityConn() {
        return TEDBConnMgr.getInstance().getSecurityConn();
    }

    public static final TEDaoOperationResult create(int[] metadata, Object obj) throws Exception {
        return TECommonDaoService.create(metadata, obj, (byte)1, (short)60);
    }

    public static final TEDaoOperationResult create_NonLock(int[] metadata, Object obj) throws Exception {
        return TECommonDaoService.create(metadata, obj, (byte)0, (short)60);
    }

    public static final TEDaoOperationResult create(int neID, int[] metadata, Object obj) throws Exception {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        TEDaoOperationResult result = null;
        if (ne == null) {
            result = new TEDaoOperationResult();
            result.setResult(1090613273);
            return result;
        }
        if (ne.isDataCfgStausNeedLock()) {
            return TECommonDaoService.create(metadata, obj);
        }
        return TECommonDaoService.create_NonLock(metadata, obj);
    }

    public static final TEDaoOperationResult create(Object obj) throws Exception {
        return TECommonDaoService.create(obj, (byte)1, (short)60);
    }

    public static final TEDaoOperationResult create_NonLock(Object obj) throws Exception {
        return TECommonDaoService.create(obj, (byte)0, (short)60);
    }

    public static final TEDaoOperationResult delete(int[] metadata, Object obj) throws Exception {
        return TECommonDaoService.delete(metadata, obj, (byte)1, (short)60);
    }

    public static final TEDaoOperationResult delete_NonLock(int[] metadata, Object obj) throws Exception {
        return TECommonDaoService.delete(metadata, obj, (byte)0, (short)60);
    }

    public static final TEDaoOperationResult delete(int neID, int[] metadata, Object obj) throws Exception {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        TEDaoOperationResult result = null;
        if (ne == null) {
            result = new TEDaoOperationResult();
            result.setResult(1090613273);
            return result;
        }
        if (ne.isDataCfgStausNeedLock()) {
            return TECommonDaoService.delete(metadata, obj);
        }
        return TECommonDaoService.delete_NonLock(metadata, obj);
    }

    public static final TEDaoOperationResult delete(Object obj) throws Exception {
        return TECommonDaoService.delete(obj, (byte)1, (short)60);
    }

    public static final TEDaoOperationResult delete_NonLock(Object obj) throws Exception {
        return TECommonDaoService.delete(obj, (byte)0, (short)60);
    }

    public static final TEDaoOperationResult deleteByID(Class poClass, List<TEDaoNameValuePair> deleteCriterion) throws Exception {
        return TECommonDaoService.deleteByID(poClass, deleteCriterion, (byte)1, (short)60);
    }

    public static final TEDaoOperationResult deleteByID_NonLock(Class poClass, List<TEDaoNameValuePair> deleteCriterion) throws Exception {
        return TECommonDaoService.deleteByID(poClass, deleteCriterion, (byte)0, (short)60);
    }

    public static final TEDaoOperationResult deleteByID(int[] metadata, Class poClass, List<TEDaoNameValuePair> criterion) throws Exception {
        return TECommonDaoService.deleteByID(metadata, poClass, criterion, (byte)1, (short)60);
    }

    public static final TEDaoOperationResult deleteByID_NonLock(int[] metadata, Class poClass, List<TEDaoNameValuePair> criterion) throws Exception {
        return TECommonDaoService.deleteByID(metadata, poClass, criterion, (byte)0, (short)60);
    }

    public static final TEDaoOperationResult deleteByID(int neID, int[] metadata, Class poClass, List<TEDaoNameValuePair> criterion) throws Exception {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        TEDaoOperationResult result = null;
        if (ne == null) {
            result = new TEDaoOperationResult();
            result.setResult(1090613273);
            return result;
        }
        if (ne.isDataCfgStausNeedLock()) {
            return TECommonDaoService.deleteByID(metadata, poClass, criterion);
        }
        return TECommonDaoService.deleteByID_NonLock(metadata, poClass, criterion);
    }

    public static final TEDaoOperationResult findAll(Class poClass) throws Exception {
        return TECommonDaoService.findAll(poClass, (byte)1, (short)60);
    }

    public static final TEDaoOperationResult findAll_NonLock(Class poClass) throws Exception {
        return TECommonDaoService.findAll(poClass, (byte)0, (short)60);
    }

    public static final TEDaoOperationResult findAll(int[] metadata, Class poClass) throws Exception {
        return TECommonDaoService.findAll(metadata, poClass, (byte)1, (short)60);
    }

    public static final TEDaoOperationResult findAll_NonLock(int[] metadata, Class poClass) throws Exception {
        return TECommonDaoService.findAll(metadata, poClass, (byte)0, (short)60);
    }

    public static final TEDaoOperationResult findAll(int neID, int[] metadata, Class poClass) throws Exception {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        TEDaoOperationResult result = null;
        if (ne == null) {
            result = new TEDaoOperationResult();
            result.setResult(1090613273);
            return result;
        }
        if (ne.isDataCfgStausNeedLock()) {
            return TECommonDaoService.findAll(metadata, poClass);
        }
        return TECommonDaoService.findAll_NonLock(metadata, poClass);
    }

    public static final TEDaoOperationResult findAllNE() throws Exception {
        return TECommonDaoService.findAllNE((byte)1, (short)60);
    }

    public static final TEDaoOperationResult findAllNE_NonLock() throws Exception {
        return TECommonDaoService.findAllNE((byte)0, (short)60);
    }

    public static final TEDaoOperationResult findBoards(int neID, int[] slotIDs) throws Exception {
        return TECommonDaoService.findBoards(neID, slotIDs, (byte)1, (short)60);
    }

    public static final TEDaoOperationResult findBoards_NonLock(int neID, int[] slotIDs) throws Exception {
        return TECommonDaoService.findBoards(neID, slotIDs, (byte)0, (short)60);
    }

    public static final TEDaoOperationResult findBoards(int neID) throws Exception {
        return TECommonDaoService.findBoards(neID, (byte)1, (short)60);
    }

    public static final TEDaoOperationResult findBoards_NonLock(int neID) throws Exception {
        return TECommonDaoService.findBoards(neID, (byte)0, (short)60);
    }

    public static final TEDaoOperationResult findByID(Class poClass, List<TEDaoNameValuePair> criteria) {
        return TECommonDaoService.findByID(poClass, criteria, (byte)1, (short)60);
    }

    public static final TEDaoOperationResult findByID_NonLock(Class poClass, List<TEDaoNameValuePair> criteria) {
        return TECommonDaoService.findByID(poClass, criteria, (byte)0, (short)60);
    }

    public static final TEDaoOperationResult findByID(int[] metadata, Class poClass, List<TEDaoNameValuePair> criteria) {
        return TECommonDaoService.findByID(metadata, poClass, criteria, (byte)1, (short)60);
    }

    public static final TEDaoOperationResult findByID_NonLock(int[] metadata, Class poClass, List<TEDaoNameValuePair> criteria) {
        return TECommonDaoService.findByID(metadata, poClass, criteria, (byte)0, (short)60);
    }

    public static final TEDaoOperationResult findByID(int neID, int[] metadata, Class poClass, List<TEDaoNameValuePair> criteria) throws Exception {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        TEDaoOperationResult result = null;
        if (ne == null) {
            result = new TEDaoOperationResult();
            result.setResult(1090613273);
            return result;
        }
        if (ne.isDataCfgStausNeedLock()) {
            return TECommonDaoService.findByID(metadata, poClass, criteria);
        }
        return TECommonDaoService.findByID_NonLock(metadata, poClass, criteria);
    }

    public static final TEDaoOperationResult findNE(int[] neIDList) throws Exception {
        return TECommonDaoService.findNE(neIDList, (byte)1, (short)60);
    }

    public static final TEDaoOperationResult findNE_NonLock(int[] neIDList) throws Exception {
        return TECommonDaoService.findNE(neIDList, (byte)0, (short)60);
    }

    public static final TEDaoOperationResult findPorts(int neID, int slotID, int[] portIDs) throws Exception {
        return TECommonDaoService.findPorts(neID, slotID, portIDs, (byte)1, (short)60);
    }

    public static final TEDaoOperationResult findPorts_NonLock(int neID, int slotID, int[] portIDs) throws Exception {
        return TECommonDaoService.findPorts(neID, slotID, portIDs, (byte)0, (short)60);
    }

    public static final TEDaoOperationResult findPorts(int neID, int slotID) throws Exception {
        return TECommonDaoService.findPorts(neID, slotID, (byte)1, (short)60);
    }

    public static final TEDaoOperationResult findPorts_NonLock(int neID, int slotID) throws Exception {
        return TECommonDaoService.findPorts(neID, slotID, (byte)0, (short)60);
    }

    public static final TEDaoOperationResult update(int[] metadata, Object obj) throws Exception {
        return TECommonDaoService.update(metadata, obj, (byte)1, (short)60);
    }

    public static final TEDaoOperationResult update_NonLock(int[] metadata, Object obj) throws Exception {
        return TECommonDaoService.update(metadata, obj, (byte)0, (short)60);
    }

    public static final TEDaoOperationResult update(int neID, int[] metadata, Object obj) throws Exception {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        TEDaoOperationResult result = null;
        if (ne == null) {
            result = new TEDaoOperationResult();
            result.setResult(1090613273);
            return result;
        }
        if (ne.isDataCfgStausNeedLock()) {
            return TECommonDaoService.update(metadata, obj);
        }
        return TECommonDaoService.update_NonLock(metadata, obj);
    }

    public static final TEDaoOperationResult update(Object obj) throws Exception {
        return TECommonDaoService.update(obj, (byte)1, (short)60);
    }

    public static final TEDaoOperationResult update_NonLock(Object obj) throws Exception {
        return TECommonDaoService.update(obj, (byte)0, (short)60);
    }

    private static final TEDaoOperationResult create(int[] metadata, Object obj, byte mitLockType, short mitLockTime) throws Exception {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        return service.create(metadata, obj, mitLockType, mitLockTime);
    }

    private static final TEDaoOperationResult create(Object obj, byte mitLockType, short mitLockTime) throws Exception {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        return service.create(obj, mitLockType, mitLockTime);
    }

    private static final TEDaoOperationResult delete(int[] metadata, Object obj, byte mitLockType, short mitLockTime) throws Exception {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        return service.delete(metadata, obj, mitLockType, mitLockTime);
    }

    private static final TEDaoOperationResult delete(Object obj, byte mitLockType, short mitLockTime) throws Exception {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        return service.delete(obj, mitLockType, mitLockTime);
    }

    private static final TEDaoOperationResult deleteByID(Class poClass, List<TEDaoNameValuePair> deleteCriterion, byte mitLockType, short mitLockTime) throws Exception {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        return service.deleteByID(poClass, deleteCriterion, mitLockType, mitLockTime);
    }

    private static final TEDaoOperationResult deleteByID(int[] metadata, Class poClass, List<TEDaoNameValuePair> criterion, byte mitLockType, short mitLockTime) throws Exception {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        return service.deleteByID(metadata, poClass, criterion, mitLockType, mitLockTime);
    }

    private static final TEDaoOperationResult findAll(Class poClass, byte mitLockType, short mitLockTime) throws Exception {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        return service.findAll(poClass, mitLockType, mitLockTime);
    }

    private static final TEDaoOperationResult findAll(int[] metadata, Class poClass, byte mitLockType, short mitLockTime) throws Exception {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        return service.findAll(metadata, poClass, mitLockType, mitLockTime);
    }

    private static final TEDaoOperationResult findAllNE(byte mitLockType, short mitLockTime) throws Exception {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        return service.findAllNE(mitLockType, mitLockTime);
    }

    private static final TEDaoOperationResult findBoards(int neID, byte mitLockType, short mitLockTime) throws Exception {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        return service.findBoards(neID, mitLockType, mitLockTime);
    }

    private static final TEDaoOperationResult findBoards(int neID, int[] slotIDs, byte mitLockType, short mitLockTime) throws Exception {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        return service.findBoards(neID, slotIDs, mitLockType, mitLockTime);
    }

    private static final TEDaoOperationResult findByID(Class poClass, List<TEDaoNameValuePair> criteria, byte mitLockType, short mitLockTime) {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        return service.findByID(poClass, criteria, mitLockType, mitLockTime);
    }

    private static final TEDaoOperationResult findByID(int[] metadata, Class poClass, List<TEDaoNameValuePair> criteria, byte mitLockType, short mitLockTime) {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        return service.findByID(metadata, poClass, criteria, mitLockType, mitLockTime);
    }

    private static final TEDaoOperationResult findNE(int[] neIDList, byte mitLockType, short mitLockTime) throws Exception {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        return service.findNE(neIDList, mitLockType, mitLockTime);
    }

    private static final TEDaoOperationResult findPorts(int neID, int slotID, byte mitLockType, short mitLockTime) throws Exception {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        return service.findPorts(neID, slotID, mitLockType, mitLockTime);
    }

    private static final TEDaoOperationResult findPorts(int neID, int slotID, int[] portIDs, byte mitLockType, short mitLockTime) throws Exception {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        return service.findPorts(neID, slotID, portIDs, mitLockType, mitLockTime);
    }

    private static final TEDaoOperationResult update(int[] metadata, Object obj, byte mitLockType, short mitLockTime) throws Exception {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        return service.update(metadata, obj, mitLockType, mitLockTime);
    }

    private static final TEDaoOperationResult update(Object obj, byte mitLockType, short mitLockTime) throws Exception {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        return service.update(obj, mitLockType, mitLockTime);
    }

    public static TEDaoOperationResult findGnlValue(List<TEGnlValueElement> elementList) {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        List<TEGnlValueElement> cloneList = TECommonDaoService.cloneTEGnlValueElement(elementList);
        TECommonDaoService.convertToNmPath(cloneList);
        TEDaoOperationResult result = service.findGnlValue(cloneList);
        TECommonDaoService.convertToNePath(result.getData());
        return result;
    }

    public static TEDaoOperationResult findGnlValue_NoLock(List<TEGnlValueElement> elementList) {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        List<TEGnlValueElement> cloneList = TECommonDaoService.cloneTEGnlValueElement(elementList);
        TECommonDaoService.convertToNmPath(cloneList);
        TEDaoOperationResult result = service.findGnlValue_NoLock(cloneList);
        TECommonDaoService.convertToNePath(result.getData());
        return result;
    }

    public static TEDaoOperationResult saveGnlValue(List<TEGnlValueElementObj> gnlValueElementObjList) {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        TECommonDaoService.convertObjToNmPath(gnlValueElementObjList);
        TEDaoOperationResult result = service.saveGnlValue(gnlValueElementObjList);
        TECommonDaoService.convertObjToNePath(gnlValueElementObjList);
        return result;
    }

    public static TEDaoOperationResult saveGnlValueToDB(List<TEGnlValueElement> gnlValueElementList) {
        if (service == null) {
            TECommonDaoService.intialIDaoService();
        }
        TECommonDaoService.convertToNmPath(gnlValueElementList);
        TEDaoOperationResult result = service.saveGnlValueToDB(gnlValueElementList);
        TECommonDaoService.convertElmToNePath(gnlValueElementList);
        return result;
    }

    private static void convertObjToNePath(List<TEGnlValueElementObj> gnlValueElementList) {
        for (TEGnlValueElementObj element : gnlValueElementList) {
            TEGeneralKeyValueObj gnlKeyValue = element.getGnlKeyValue();
            if (!ATTR_ID_TO_NAME.containsKey(gnlKeyValue.getAttrID())) continue;
            TECommonDaoService.resetObjPathID(gnlKeyValue, false);
        }
    }

    private static void convertObjToNmPath(List<TEGnlValueElementObj> gnlValueElementList) {
        for (TEGnlValueElementObj element : gnlValueElementList) {
            TEGeneralKeyValueObj gnlKeyValue = element.getGnlKeyValue();
            if (!ATTR_ID_TO_NAME.containsKey(gnlKeyValue.getAttrID())) continue;
            TECommonDaoService.resetObjPathID(gnlKeyValue, true);
        }
    }

    private static void convertElmToNePath(List<TEGnlValueElement> gnlValueElementList) {
        for (TEGnlValueElement element : gnlValueElementList) {
            TEGeneralKeyValue gnlKeyValue = element.getGnlKeyValue();
            if (!ATTR_ID_TO_NAME.containsKey(gnlKeyValue.getAttrID())) continue;
            TECommonDaoService.resetElnPathID(gnlKeyValue, false);
        }
    }

    private static void convertToNePath(List<Object> gnlValueElementList) {
        TEGnlValueElement element = null;
        for (Object obj : gnlValueElementList) {
            element = (TEGnlValueElement)obj;
            TEGeneralKeyValue gnlKeyValue = element.getGnlKeyValue();
            if (!ATTR_ID_TO_NAME.containsKey(gnlKeyValue.getAttrID())) continue;
            TECommonDaoService.resetElnPathID(gnlKeyValue, false);
        }
    }

    private static void convertToNmPath(List<TEGnlValueElement> gnlValueElementList) {
        for (TEGnlValueElement element : gnlValueElementList) {
            TEGeneralKeyValue gnlKeyValue = element.getGnlKeyValue();
            if (!ATTR_ID_TO_NAME.containsKey(gnlKeyValue.getAttrID())) continue;
            TECommonDaoService.resetElnPathID(gnlKeyValue, true);
        }
    }

    private static void resetObjPathID(TEGeneralKeyValueObj gnlKeyValue, boolean toNmFlag) {
        int[] objectID = gnlKeyValue.getTEOBJECTID();
        if (objectID.length > 4) {
            String attrName = ATTR_ID_TO_NAME.get(gnlKeyValue.getAttrID());
            int neID = objectID[1];
            int slotID = objectID[2];
            int portID = TEConfigurationDataMgr.getPortRelativeID(objectID[3]);
            int path = objectID[4];
            int tempPath = -1;
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
            tempPath = toNmFlag ? TEOTNModelDataMgr.getInstance().getAttrNmPath(portID, path, boardType, attrName) : TEOTNModelDataMgr.getInstance().getAttrNePath(portID, path, boardType, attrName);
            objectID[4] = tempPath;
            gnlKeyValue.setTEOBJECTID(objectID);
        }
    }

    private static void resetElnPathID(TEGeneralKeyValue gnlKeyValue, boolean toNmFlag) {
        int[] objectID = gnlKeyValue.getTEOBJECTID();
        if (objectID.length > 4) {
            String attrName = ATTR_ID_TO_NAME.get(gnlKeyValue.getAttrID());
            int neID = objectID[1];
            int slotID = objectID[2];
            int portID = TEConfigurationDataMgr.getPortRelativeID(objectID[3]);
            int path = objectID[4];
            int tempPath = -1;
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
            tempPath = toNmFlag ? TEOTNModelDataMgr.getInstance().getAttrNmPath(portID, path, boardType, attrName) : TEOTNModelDataMgr.getInstance().getAttrNePath(portID, path, boardType, attrName);
            objectID[4] = tempPath;
            gnlKeyValue.setTEOBJECTID(objectID);
        }
    }

    private static List<TEGnlValueElement> cloneTEGnlValueElement(List<TEGnlValueElement> elementList) {
        ArrayList<TEGnlValueElement> clonelist = new ArrayList<TEGnlValueElement>();
        try {
            for (TEGnlValueElement elem : elementList) {
                clonelist.add((TEGnlValueElement)elem.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clonelist;
    }
}

