/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.taskmgr.handler;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.commustru.fstru.FStruct;

public abstract class TEWNEMgrHandler {
    private static final int FRAME_DEFAULT_SHELFID = -1;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm) {
        int retCode = 0;
        this.logReq(req);
        this.applyCache();
        retCode = this.handleRequestImpl(req, rsp, tm);
        this.releaseCache();
        this.logRsp(rsp);
        return retCode;
    }

    protected void applyCache() {
    }

    protected void releaseCache() {
    }

    private void logRsp(FStruct rsp) {
        if (this.isLogRsp()) {
            TELogFactory.getE2ELogger().info(TEAsn1Util.getAsn1String(rsp));
        }
    }

    private void logReq(FStruct req) {
        if (this.isLogReq()) {
            TELogFactory.getE2ELogger().info(TEAsn1Util.getAsn1String(req));
        }
    }

    protected abstract int handleRequestImpl(FStruct var1, FStruct var2, TaskMgr var3);

    protected boolean isLogReq() {
        boolean isLog = true;
        return isLog;
    }

    protected boolean isLogRsp() {
        boolean isLog = true;
        return isLog;
    }

    public static void debug(String tipStr, long beginTime, long endTime) {
        boolean token = false;
        TEWNEMgrHandler.debug(tipStr, beginTime, endTime, token);
    }

    public static void debug(String tipStr, long beginTime, long endTime, boolean token) {
        if (token) {
            TELogFactory.getNormalLogger().info(tipStr + (double)(endTime - beginTime) / 1000.0 + " second.");
        }
    }

    public Map<Integer, Integer> handleLoginNE(List<Integer> neList) {
        HashMap<Integer, Integer> resultMap = new HashMap<Integer, Integer>();
        Iterator<Integer> iter = neList.iterator();
        int neID = -1;
        TENE ne = null;
        while (iter.hasNext()) {
            neID = iter.next();
            ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne || 1 == ne.getLogStatus()) continue;
            int errCode = TEHandleSbiInfo.getInstance().handleSBIConnect(neID);
            resultMap.put(neID, errCode);
        }
        return resultMap;
    }

    public Map<Integer, Integer> loginSinkNE(TENE sinkNe) {
        ArrayList<Integer> neList = new ArrayList<Integer>();
        neList.add(sinkNe.getNEID());
        Map<Integer, Integer> loginResult = this.handleLoginNE(neList);
        return loginResult;
    }

    public QAsnErrInfo constructErr(TEErrInfo teErrInfo) {
        String objName = null;
        String strOperDesc = null;
        QAsnErrInfo qErr = new QAsnErrInfo();
        qErr.errCode = teErrInfo.getErrorCode();
        qErr.objID = new QAsnTinyIntList();
        int[] objID = teErrInfo.getObjID();
        if (null != objID) {
            int len = objID.length;
            for (int i = 0; i < len; ++i) {
                qErr.objID.add((Object)objID[i]);
            }
        }
        if (null != (objName = teErrInfo.getObjName())) {
            qErr.objName = objName.getBytes();
        }
        if (null != (strOperDesc = teErrInfo.getStrOperDesc())) {
            qErr.strOperDesc = strOperDesc.getBytes();
        }
        return qErr;
    }

    public QAsnErrInfoList constructErrList(List<TEErrInfo> errList) {
        QAsnErrInfoList qErrList = new QAsnErrInfoList();
        if (null != errList) {
            for (TEErrInfo err : errList) {
                qErrList.add((Object)this.constructErr(err));
            }
        }
        return qErrList;
    }
}

