/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.taskmgr;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.util.asn.AsnCoder;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.core.taskmgr.TEWNEMgrTaskDescription;
import com.huawei.nglct.util.cache.TETimeStatMgr;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public final class TEWNEMgrTaskMgr
extends TaskMgr {
    private Map<Integer, Object> taskMap = new ConcurrentHashMap<Integer, Object>();

    public TEWNEMgrTaskMgr() {
        super(0, null, 0, null);
    }

    public FStruct dispatchMsg(TEWNEMgrTaskDescription des, MSGPacketExt msg) throws Exception {
        if (null == des) {
            return null;
        }
        TELogFactory.getNormalLogger().info("DES TASK CLASS IS:" + des.getTaskClass().getName());
        int cmdCode = des.getCmdCode();
        Object taskImpl = this.taskMap.get(cmdCode);
        if (null == taskImpl || !des.getTaskClass().getName().equals(taskImpl.getClass().getName())) {
            Class tskCls = des.getTaskClass();
            taskImpl = tskCls.newInstance();
            TELogFactory.getNormalLogger().info("CACHE DES TASK CLASS IS:" + tskCls.getName());
            this.taskMap.put(cmdCode, taskImpl);
        }
        Class reqClass = des.getReq();
        Class rspClass = des.getRsp();
        TETimeStatMgr timer = new TETimeStatMgr(TETimeStatMgr.FLAG_LOG);
        timer.startStat(reqClass.getSimpleName() + " time");
        Method taskMethod = des.getTaskMethod();
        FStruct req = null;
        req = (FStruct)reqClass.newInstance();
        AsnCoder.deserialize((MSGPacketExt)msg, (FStruct)req);
        FStruct rsp = null;
        if (0 == des.getDetailMsgFlag()) {
            if (null == rspClass) {
                rsp = null;
                taskMethod.invoke(taskImpl, new Object[]{req, this});
            } else {
                rsp = (FStruct)rspClass.newInstance();
                if (Task.class.isAssignableFrom(taskMethod.getParameterTypes()[2])) {
                    taskMethod.invoke(taskImpl, req, rsp, new Task(null, des.getTaskID(), des.getTaskClass()));
                } else {
                    taskMethod.invoke(taskImpl, new Object[]{req, rsp, this});
                }
            }
        } else {
            TETaskInfo taskInfo = new TETaskInfo(msg.mheader);
            if (null == rspClass) {
                rsp = null;
                taskMethod.invoke(taskImpl, new Object[]{req, this, taskInfo});
            } else {
                rsp = (FStruct)rspClass.newInstance();
                int METHOD_PARA_FULL_LEN = 4;
                if (4 == taskMethod.getParameterTypes().length) {
                    taskMethod.invoke(taskImpl, new Object[]{req, rsp, this, taskInfo});
                } else {
                    taskMethod.invoke(taskImpl, new Object[]{req, rsp, this});
                }
            }
        }
        ArrayList<Logger> loggerList = new ArrayList<Logger>();
        loggerList.add(TELogFactory.getembededWnemgrLogger());
        loggerList.add(TELogFactory.getE2ELogger());
        timer.stopStat(loggerList);
        return rsp;
    }

    public void close() {
        if (null != this.taskMap) {
            this.taskMap.clear();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.taskMap == null ? 0 : ((Object)this.taskMap).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TEWNEMgrTaskMgr other = (TEWNEMgrTaskMgr)((Object)obj);
        return !(this.taskMap == null ? other.taskMap != null : !((Object)this.taskMap).equals(other.taskMap));
    }
}

