/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.taskmgr;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.commextend.taskmgr.TaskDes;
import com.huawei.commextend.taskmgr.TaskDispatcherMgr;
import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.util.asn.AsnCoder;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.startup.TEWNEMgrJniLogFactory;
import com.huawei.nglct.core.taskmgr.TETaskDes;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.core.taskmgr.TEWNEMgrTaskDescription;
import com.huawei.nglct.core.taskmgr.TEWNEMgrTaskMgr;
import com.huawei.nglct.explorer.e2e.TEIParseNeIDFromReq;
import com.huawei.nglct.explorer.e2e.TEParseNeIDMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public final class TEWNEMgrTaskDispatcher {
    private static TEWNEMgrTaskDispatcher instance = new TEWNEMgrTaskDispatcher();
    private TEWNEMgrTaskMgr taskMgr = null;
    private static Logger log = TEWNEMgrJniLogFactory.getLogger(TEWNEMgrTaskDispatcher.class.getName());
    private Map<Integer, TEWNEMgrTaskDescription> cmdTaskDesMap = new ConcurrentHashMap<Integer, TEWNEMgrTaskDescription>();
    private Hashtable<Integer, List<TEWNEMgrTaskDescription>> multiTaskTable = new Hashtable();

    public static TEWNEMgrTaskDispatcher getInstance() {
        return instance;
    }

    private TEWNEMgrTaskDispatcher() {
        this.init();
    }

    private void init() {
        this.taskMgr = new TEWNEMgrTaskMgr();
    }

    public int registerTask(Class taskClass) {
        log.info("register task->" + taskClass);
        int result = 0;
        result = TEWNEMgrTaskDispatcher.checkIntStatus() ? this.registerTask_Jni(taskClass) : TaskDispatcherMgr.getInstance(null).registerTask(taskClass);
        return result;
    }

    private int registerTask_Jni(Class taskClass) {
        Method[] methodAry = taskClass.getMethods();
        Class<?> reqClass = null;
        Class<?> rspClass = null;
        for (Method method : methodAry) {
            int taskMsgFlag;
            int cmdCode;
            int taskID;
            int taskMgrID;
            TaskDes taskDes = method.getAnnotation(TaskDes.class);
            if (null != taskDes) {
                taskMgrID = taskDes.taskmgrID();
                taskID = taskDes.taskID();
                cmdCode = taskDes.cmdCode();
                taskMsgFlag = 0;
                TELogFactory.getNormalLogger().info(method.getName() + " of method is annotated");
            } else {
                TETaskDes teTaskDes = method.getAnnotation(TETaskDes.class);
                if (null == teTaskDes) continue;
                taskMgrID = teTaskDes.taskmgrID();
                taskID = teTaskDes.taskID();
                cmdCode = teTaskDes.cmdCode();
                taskMsgFlag = teTaskDes.detailMsgFlag();
            }
            if (!this.isValidateMethod(method)) {
                TELogFactory.getNormalLogger().info("method is invalid");
                continue;
            }
            try {
                Class<?>[] paramTypes = method.getParameterTypes();
                reqClass = paramTypes[0];
                rspClass = null;
                if (paramTypes.length >= 3) {
                    rspClass = paramTypes[1];
                }
                TEWNEMgrTaskDescription taskDesObj = new TEWNEMgrTaskDescription(taskClass, taskMgrID, taskID, cmdCode, reqClass, rspClass, method, taskMsgFlag);
                if (this.cmdTaskDesMap.get(cmdCode) != null) {
                    List<TEWNEMgrTaskDescription> taskDeses = this.multiTaskTable.get(cmdCode);
                    if (taskDeses == null) {
                        taskDeses = new ArrayList<TEWNEMgrTaskDescription>();
                        taskDeses.add(this.cmdTaskDesMap.get(cmdCode));
                        this.multiTaskTable.put(cmdCode, taskDeses);
                    }
                    taskDeses.add(taskDesObj);
                }
                this.cmdTaskDesMap.put(cmdCode, taskDesObj);
                TELogFactory.getNormalLogger().info("regist task successful, (" + taskID + ", " + cmdCode + ")");
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("regist failed!", (Throwable)e);
            }
        }
        return 0;
    }

    public static boolean isStaticTask(int taskID) {
        return taskID >= 1 && taskID <= 20;
    }

    private boolean isValidateMethod(Method method) {
        boolean result = false;
        Class<?>[] paramTypes = method.getParameterTypes();
        switch (paramTypes.length) {
            case 2: {
                result = !FStruct.class.isAssignableFrom(paramTypes[0]) || !Task.class.isAssignableFrom(paramTypes[1]);
                break;
            }
            case 3: {
                result = !FStruct.class.isAssignableFrom(paramTypes[0]) || !FStruct.class.isAssignableFrom(paramTypes[1]) || !Task.class.isAssignableFrom(paramTypes[2]) || Task.class.isAssignableFrom(paramTypes[2]) && !TaskMgr.class.isAssignableFrom(paramTypes[2]);
                break;
            }
            case 4: {
                result = !FStruct.class.isAssignableFrom(paramTypes[0]) || !FStruct.class.isAssignableFrom(paramTypes[1]) || !Task.class.isAssignableFrom(paramTypes[2]) || !TETaskInfo.class.isAssignableFrom(paramTypes[3]);
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private static boolean checkIntStatus() {
        return true;
    }

    public FStruct receiveMessage(MSGPacketExt msg) {
        return this.dispatchMsg(msg);
    }

    private FStruct dispatchMsg(MSGPacketExt msg) {
        FStruct rsp = null;
        int cmd = msg.getCmdCode();
        log.info("taskdispatcher receive msg, cmd->" + cmd);
        TEWNEMgrTaskDescription des = this.getTaskDes(cmd, msg);
        if (null == des) {
            log.info("taskdispatcher, can't find task des, cmd->" + cmd);
            rsp = null;
        } else {
            log.info("taskdispatcher, des class ->" + des.getTaskClass());
            try {
                rsp = this.taskMgr.dispatchMsg(des, msg);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEWNEMgrTaskDispatcher.dispatchMsg() fail!", (Throwable)e);
                rsp = null;
            }
        }
        if (null == rsp) {
            log.info("response is NULL");
        } else {
            log.info("response is NOT NULL");
        }
        return rsp;
    }

    public void close() {
        if (null != this.cmdTaskDesMap) {
            this.cmdTaskDesMap.clear();
        }
        this.taskMgr.close();
    }

    private TEWNEMgrTaskDescription getTaskDes(int cmd, MSGPacketExt msg) {
        if (this.multiTaskTable.get(cmd) == null) {
            return this.cmdTaskDesMap.get(cmd);
        }
        TELogFactory.getNormalLogger().info("start multi task process!");
        TEWNEMgrTaskDescription resTaskDes = this.cmdTaskDesMap.get(cmd);
        try {
            List<TEWNEMgrTaskDescription> taskDesList = this.multiTaskTable.get(cmd);
            Class reqClass = resTaskDes.getReq();
            FStruct req = (FStruct)reqClass.newInstance();
            AsnCoder.deserialize((MSGPacketExt)msg, (FStruct)req);
            TEIParseNeIDFromReq parser = (TEIParseNeIDFromReq)Class.forName(TEParseNeIDMgr.getInstance().getParserMap().get(cmd)).newInstance();
            String taskName = TESpecialAttrMgr.getInstance().getNEAttrValue(parser.getNeID(req), "TE_FUNC_CFG_NE_ATTRIBUTE", "NE_ATTR_SUPPORT_E2ETASK_SPECIFIED");
            TELogFactory.getNormalLogger().info("the dest task name is " + taskName);
            for (TEWNEMgrTaskDescription tempTaskDes : taskDesList) {
                if (!tempTaskDes.getTaskClass().getName().equals(taskName)) continue;
                resTaskDes = tempTaskDes;
                break;
            }
        }
        catch (Exception e) {
            log.info("get task des failed!, can't find task des, cmd->", (Throwable)e);
        }
        return resTaskDes;
    }
}

