/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.taskmgr;

import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TEAppMgr;
import com.huawei.nglct.core.taskmgr.TEITaskMgrConts;
import com.huawei.nglct.core.taskmgr.TERecoverThread;
import com.huawei.nglct.core.taskmgr.TERecoverThreadGroup;
import com.huawei.nglct.core.taskmgr.TETask;
import com.huawei.nglct.core.taskmgr.TETaskIDMgr;
import com.huawei.nglct.core.taskmgr.TEThreadToTask;
import com.huawei.nglct.core.taskmgr.TETimer;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class TETaskMgr {
    public static boolean enableAutoTaskThread = false;
    public TEAppMgr appMgr;
    public int taskMgrID;
    public float thrWaitVThrTotalOnDec = 0.8f;
    public float tskReadyVThrTotalOnDec = 0.2f;
    protected int readyTaskNum;
    protected int waitingThreadNum;
    protected int taskCount;
    protected int threadNum;
    protected int releaseThreadNum;
    protected Lock mtxThrdCtrl = new ReentrantLock(true);
    protected int maxThreadNum;
    protected int minThreadNum;
    protected boolean autoCtrlThread;
    protected TETimer autoCtrlTimer;
    protected TETaskIDMgr taskIDMgr;
    protected int timerID;
    protected int[] staticTaskID = new int[31];
    protected List<TETask> tasks = new ArrayList<TETask>();
    protected Lock tasksMutex = new ReentrantLock(true);
    protected Semaphore waitThreadEnterCond = new Semaphore(1, true);
    protected boolean isOpen;
    protected List<TEThreadToTask> threadToTasks = new ArrayList<TEThreadToTask>();
    protected Lock threadToTasksMutex = new ReentrantLock();
    protected TERecoverThread[] threads;

    public TETaskMgr(TEAppMgr appMgr, int id, int minThreadNum, int maxThreadNum, boolean autoCtrlThread) {
        this.appMgr = appMgr;
        TETaskMgr taskMgr = appMgr.findTaskMgrByID(id);
        if (null != taskMgr) {
            TELogFactory.getNormalLogger().error(TEStringUtils.snprintf(128, "iMapTaskMgr::iMapTaskMgr fail, Can't create a taskmgr(%d) existed!\n", id));
            return;
        }
        try {
            this.waitThreadEnterCond.acquire();
        }
        catch (InterruptedException e) {
            TELogFactory.getNormalLogger().error("TETaskMgr.TETaskMgr() fail!", (Throwable)e);
        }
        this.taskMgrID = id;
        this.waitingThreadNum = 0;
        this.readyTaskNum = 0;
        this.taskCount = 0;
        int n = this.threadNum = minThreadNum > 0 ? minThreadNum : 1;
        if (minThreadNum < 0 || minThreadNum > 5) {
            minThreadNum = 5;
        } else {
            this.minThreadNum = minThreadNum;
        }
        if (maxThreadNum < 0 || maxThreadNum > 50) {
            maxThreadNum = 50;
        } else {
            this.maxThreadNum = maxThreadNum;
        }
        autoCtrlThread = enableAutoTaskThread && autoCtrlThread;
        this.autoCtrlTimer = null;
        this.releaseThreadNum = 0;
        this.taskIDMgr = new TETaskIDMgr();
        this.timerID = appMgr.reactor.schedule_timer(this, null, 5, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.tasks.clear();
        this.tasksMutex.lock();
        try {
            if (this.autoCtrlThread) {
                this.unRegAutoCtrlTimer();
            }
            this.appMgr.reactor.cancel_timer(this.timerID);
        }
        finally {
            this.tasksMutex.unlock();
        }
    }

    public int open() {
        if (!this.isOpen()) {
            this.isOpen = true;
            this.activate(this.threadNum);
            if (this.autoCtrlThread) {
                this.regAutoCtrlTimer();
            }
        }
        return 0;
    }

    public int svc() {
        return 0;
    }

    public int dispatch(MSGPacketExt msg) {
        return -1;
    }

    public int enqueueMsg(MSGPacketExt msg) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWaitingThread(int threadNum) {
        this.tasksMutex.lock();
        try {
            this.releaseWaitingThread_i(threadNum);
        }
        finally {
            this.tasksMutex.unlock();
        }
    }

    public int regAutoCtrlTimer() {
        if (null != this.autoCtrlTimer) {
            String str = TEStringUtils.snprintf(256, "RegAutoCtrlTimer fail, TaskMgr %d already registered an auto threads controlling timer!\n", this.taskMgrID);
            TELogFactory.getNormalLogger().error(str);
            return -1;
        }
        this.autoCtrlTimer = new TETimer();
        this.autoCtrlTimer.taskID = 0;
        this.autoCtrlTimer.type = TEITaskMgrConts.TIMER_TYPE.TIMER_INTERVAL;
        this.autoCtrlTimer.callBackProc = null;
        this.autoCtrlTimer.scheduleID = this.appMgr.reactor.schedule_timer(this, this.autoCtrlTimer, 30, 30);
        if (-1 == this.autoCtrlTimer.scheduleID) {
            String str = TEStringUtils.snprintf(256, "TaskMgr %d register an auto threads controlling timer failed!\n", this.taskMgrID);
            TELogFactory.getNormalLogger().error(str);
            this.autoCtrlTimer = null;
            return -1;
        }
        String str = TEStringUtils.snprintf(256, "TaskMgr %d register an auto threads controlling timer succeed!\n", this.taskMgrID);
        TELogFactory.getNormalLogger().info(str);
        return 0;
    }

    public int unRegAutoCtrlTimer() {
        if (this.autoCtrlTimer != null) {
            this.appMgr.reactor.cancel_timer(this.autoCtrlTimer.scheduleID);
            String str = TEStringUtils.snprintf(256, "TaskMgr %d unregister an auto threads controlling timer succeed!\n", this.taskMgrID);
            TELogFactory.getNormalLogger().info(str);
            this.autoCtrlTimer = null;
        }
        return 0;
    }

    public void insertCurThreadTask(TETask task) {
    }

    public void tmInitInsertTask(TETask task) {
        if (null == task) {
            String str = TEStringUtils.snprintf(128, "taskmgr(%d), TMInitInsertTask fail, input para task=NULL\n", this.taskMgrID);
            TELogFactory.getNormalLogger().error(str);
            return;
        }
        task.outInit = true;
        this.tmInsertTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tmInsertTask(TETask task) {
        if (null == task) {
            String str = TEStringUtils.snprintf(128, "taskmgr(%d), TMInsertTask fail, input para task=NULL\n", this.taskMgrID);
            TELogFactory.getNormalLogger().error(str);
            return;
        }
        if (null == this.taskIDMgr) {
            String str = TEStringUtils.snprintf(128, "taskmgr(%d), TMInsertTask fail, m_pTaskIDMgr=NULL\n", this.taskMgrID);
            TELogFactory.getNormalLogger().error(str);
            return;
        }
        List<TETask> list = this.tasks;
        synchronized (list) {
            if (this.autoCtrlThread && 0 == this.waitingThreadNum && this.threadNum < this.maxThreadNum) {
                int iThreadNum = 1;
                int ret = this.activate(iThreadNum);
                if (-1 == ret) {
                    TELogFactory.getNormalLogger().error(TEStringUtils.snprintf(256, "TaskMgr(%d) auto increase threads failed!\n", this.taskMgrID));
                } else {
                    TELogFactory.getNormalLogger().info(TEStringUtils.snprintf(256, "TaskMgr(%d) increase %d threads.\n", this.taskMgrID, this.threadNum));
                    this.threadNum += iThreadNum;
                }
            }
            if (0 == task.taskID) {
                task.taskID = this.taskIDMgr.allocID();
            }
            if (0 == task.taskID) {
                if (task.taskName != null) {
                    TELogFactory.getNormalLogger().info(TEStringUtils.snprintf(256, "iMapTaskMgr::TMInsertTask(),alloc task ID failed, delete task,taskmgr=%d,taskname=%s\n", this.taskMgrID, task.taskName));
                } else {
                    TELogFactory.getNormalLogger().info(TEStringUtils.snprintf(256, "iMapTaskMgr::TMInsertTask(),alloc task ID failed. delete task create by taskmgr=%d\n", this.taskMgrID));
                }
                return;
            }
            task.freshTaskIDForTimer();
            if (0 == this.tasks.size()) {
                this.tasks.add(task);
            } else {
                for (int i = this.tasks.size() - 1; i >= 0; --i) {
                    TETask one = this.tasks.get(i);
                    if (one.taskID > 30) {
                        this.tasks.add(i, task);
                        break;
                    }
                    if (i != 0) continue;
                    this.tasks.add(task);
                    break;
                }
            }
            ++this.taskCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tmInsertStaticTask(TETask task, int id) {
        if (null == task || id > 30) {
            String str = TEStringUtils.snprintf(128, "taskmgr(%d), TMInsertStaticTask fail, invalid input para. iID=%d\n", this.taskMgrID, id);
            TELogFactory.getNormalLogger().error(str);
            return false;
        }
        Object str = this.tasks;
        synchronized (str) {
            if (1 == this.staticTaskID[id]) {
                String str2 = TEStringUtils.snprintf(128, "taskmgr(%d), TMInsertStaticTask fail, static task id(%d) is already used\n", this.taskMgrID, id);
                TELogFactory.getNormalLogger().error(str2);
                return false;
            }
            this.staticTaskID[id] = 1;
            task.taskID = id;
            task.setTaskState_i(TEITaskMgrConts.TASK_EXEC_STAT.TASK_STATE_IDLE);
            this.tasks.add(task);
            ++this.taskCount;
            task.freshTaskIDForTimer();
        }
        str = TEStringUtils.snprintf(128, "iMapTaskMgr(%d) Insert a Statictask(%d).\n", this.taskMgrID, id);
        TELogFactory.getNormalLogger().info((String)str);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int handle_timeout(long time, TETimer timer) {
        if (null != timer) {
            if (this.autoCtrlThread && null != this.autoCtrlTimer && this.autoCtrlTimer.scheduleID == timer.scheduleID) {
                this.threadsAutoCtrl();
                return 0;
            }
            if (0 == timer.taskID) {
                return 0;
            }
            MSGPacketExt msg = new MSGPacketExt();
            msg.mheader.msgType = (byte)TEITaskMgrConts.MSG_TYPE.MSG_TIMER.getValue();
            msg.mheader.cmdHandle = (char)timer.taskID;
            this.enqueueMsg(msg);
        } else {
            List<TETask> list = this.tasks;
            synchronized (list) {
                TETask task = null;
                for (int i = this.tasks.size() - 1; i >= 0; --i) {
                    task = this.tasks.get(i);
                    if (null == task || !task.finished || !task.msgQueue.realQueue.isEmpty() || !task.outInit) continue;
                    this.removeTask_i(task);
                }
            }
        }
        return 0;
    }

    public int threadsAutoCtrl() {
        return 0;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TETask findTaskByID(int taskID) {
        TETask task;
        this.tasksMutex.lock();
        try {
            task = this.findTaskByID_i(taskID);
        }
        finally {
            this.tasksMutex.unlock();
        }
        return task;
    }

    public void removeTask(TETask task) {
    }

    public int allocReqID(TETask task) {
        int ret;
        if (null == task || null == this.taskIDMgr) {
            String str = TEStringUtils.snprintf(128, "iMapTaskMgr::AllocReqID fail, something invalid. ", new Object[0]);
            TELogFactory.getNormalLogger().error(str);
            return 0;
        }
        task.taskID = ret = task.taskID != 0 ? task.taskID : this.taskIDMgr.allocID();
        return ret;
    }

    public TEITaskMgrConts.TM_COMM_STAT tmMsgCenterConnStat() {
        if (this.appMgr.handler.getConnCloseFlag()) {
            return TEITaskMgrConts.TM_COMM_STAT.TMMsgCenterConnOpen;
        }
        return TEITaskMgrConts.TM_COMM_STAT.TMMsgCenterConnClose;
    }

    public TEITaskMgrConts.CONN_STAT_TYPE getConnState() {
        return this.appMgr.handler.getConnCloseFlag() ? TEITaskMgrConts.CONN_STAT_TYPE.CONNECT_ERROR : TEITaskMgrConts.CONN_STAT_TYPE.CONNECT_OK;
    }

    public int getFreeTaskIDNum() {
        return this.taskIDMgr.getFreeTaskIDNum();
    }

    public int getIdleThreadNum() {
        return this.waitingThreadNum;
    }

    public TETask getCurrentTask() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TETask findTaskByName(String taskName) {
        TETask task2 = null;
        this.tasksMutex.lock();
        try {
            for (TETask task2 : this.tasks) {
                if (null == task2 || !taskName.equals(task2.taskName)) continue;
                TETask tETask = task2;
                return tETask;
            }
        }
        finally {
            this.tasksMutex.unlock();
        }
        return null;
    }

    public int getTaskMgrID() {
        return this.taskMgrID;
    }

    public TERecoverThread[] getThreads() {
        return this.threads;
    }

    public abstract boolean initEnv();

    public abstract int close(int var1);

    public abstract TETask imapCreateTask(MSGPacketExt var1);

    protected int activate(int threadNum) {
        this.threads = new TERecoverThread[threadNum];
        TERecoverThreadGroup threadGroup = new TERecoverThreadGroup("TaskMgr_ThreadGroup_" + this.taskMgrID);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TETaskMgr.this.svc();
            }
        };
        for (int i = 0; i < threadNum; ++i) {
            this.threads[i] = new TERecoverThread((ThreadGroup)threadGroup, this, runnable, "TaskThread_" + i);
            this.threads[i].start();
        }
        return 0;
    }

    protected TETask acquireIdleTask() {
        return null;
    }

    protected void releaseWaitingThread_i(int threadNum) {
        this.readyTaskNum += threadNum;
        this.waitThreadEnterCond.release(threadNum);
    }

    protected void removeTask_i(TETask task) {
        if (null == task || null == this.taskIDMgr) {
            TELogFactory.getNormalLogger().error("RemoveTask_i fail, something invalid.");
            return;
        }
        int taskID = task.taskID;
        this.tasks.remove(task);
        --this.taskCount;
        if (taskID > 0 && taskID <= 30) {
            this.staticTaskID[taskID] = 0;
        } else if (taskID > 30) {
            this.taskIDMgr.revokeID(taskID);
        }
    }

    protected TETask findTaskByID_i(int taskID) {
        TETask task2 = null;
        for (TETask task2 : this.tasks) {
            if (task2 != null && taskID == task2.taskID) break;
        }
        return task2;
    }

    protected int releaseTask(TETask task) {
        return 0;
    }

    protected int waitThreadEnterCond(long timeout) {
        return 0;
    }
}

