/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.taskmgr;

import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.core.taskmgr.TEAppMgr;
import com.huawei.nglct.core.taskmgr.TEGnlTask;
import com.huawei.nglct.core.taskmgr.TEHandleMsgBefDisp;
import com.huawei.nglct.core.taskmgr.TETaskCreator;
import com.huawei.nglct.core.taskmgr.TETaskHandler;
import com.huawei.nglct.core.taskmgr.TETaskMgr;
import java.util.Iterator;
import java.util.List;

public class TETaskCreatorImpl
extends TETaskCreator {
    protected static TEHandleMsgBefDisp befDisp;

    protected TETaskCreatorImpl(TEAppMgr appMgr) {
    }

    public int forwardCommand(MSGPacketExt msg) {
        if (null == msg) {
            TELogFactory.getNormalLogger().error("iMapTaskCreatorImpl::ForwardCommand pMsg is null.");
            return 0;
        }
        if (0 != msg.mheader.receiverModule) {
            return 1;
        }
        this.mutex.readLock().lock();
        if (this.table.get(msg.mheader.cmdCode) != null) {
            TETaskHandler handler = (TETaskHandler)this.table.get(msg.mheader.cmdCode);
            msg.mheader.receiverModule = (byte)handler.taskMgrID;
        }
        this.mutex.readLock().unlock();
        return 1;
    }

    @Override
    public TEGnlTask createTask(int taskMgrID, int cmdCode, TETaskMgr taskMgr) {
        if (null == taskMgr) {
            String str = String.format("CreateTask fail, input para pTaskMgr=NULL! TaskMgrID=%d, Cmd=%d\n", taskMgrID, cmdCode);
            TELogFactory.getNormalLogger().error(str);
            return null;
        }
        this.mutex.readLock().lock();
        TETaskHandler stru = (TETaskHandler)this.table.get(cmdCode);
        if (stru != null && null != stru.createTaskFunc) {
            this.mutex.readLock().unlock();
            return stru.createTaskFunc.createTask(taskMgr);
        }
        this.mutex.readLock().unlock();
        if (cmdCode != 49153 && cmdCode != 49154) {
            String str = String.format("TaskMgr(%d), CmdCode(%d): No CreateTaskFunc Registered!\n", taskMgrID, cmdCode);
            TELogFactory.getNormalLogger().info(str);
        }
        return null;
    }

    @Override
    public void getAllRegisteredHandler(List<TETaskHandler> buf) {
        buf.clear();
        this.mutex.readLock().lock();
        Iterator it = this.table.entrySet().iterator();
        while (it.hasNext()) {
            buf.add((TETaskHandler)it.next().getValue());
        }
        this.mutex.readLock().unlock();
    }

    @Override
    public boolean getTaskHandler(int taskMgrID, int cmdCode, TETaskHandler[] handler) {
        if (null == handler) {
            String str = String.format("GetTaskHandler fail, input para pHandler=NULL! TaskMgrID=%d, Cmd=%d\n", taskMgrID, cmdCode);
            TELogFactory.getNormalLogger().error(str);
            return false;
        }
        this.mutex.readLock().lock();
        TETaskHandler stru = (TETaskHandler)this.table.get(cmdCode);
        if (stru != null) {
            handler[0] = stru;
            this.mutex.readLock().unlock();
            return true;
        }
        this.mutex.readLock().unlock();
        return false;
    }

    @Override
    public void registerTask(TETaskHandler handler) {
        if (null == handler.createTaskFunc) {
            TELogFactory.getNormalLogger().error("RegisterTask fail, input para m_pCreateTaskFunc=null!\n");
            return;
        }
        this.mutex.writeLock().lock();
        TETaskHandler stru = (TETaskHandler)this.table.get(handler.cmdCode);
        if (stru == null) {
            this.table.put(handler.cmdCode, handler);
            TEASN1CommMgr.addMessageListener(handler.cmdCode, TEAppMgr.instance().handler);
        } else {
            String str = String.format("RegisterTask1 error, for the cmdcode 0x%x registered again!\n", handler.cmdCode);
            TELogFactory.getNormalLogger().error(str);
        }
        this.mutex.writeLock().unlock();
    }

    @Override
    public void registerTask(List<TETaskHandler> handlers) {
        if (null == handlers) {
            TELogFactory.getNormalLogger().error("RegisterTask fail, input para pHandlerList=NULL!\n");
            return;
        }
        this.mutex.writeLock().lock();
        int size = handlers.size();
        for (int i = 0; i < size; ++i) {
            TETaskHandler handler = handlers.get(i);
            int cmdCode = handler.cmdCode;
            TETaskHandler stru = (TETaskHandler)this.table.get(cmdCode);
            if (stru == null) {
                this.table.put(cmdCode, handler);
                TEASN1CommMgr.addMessageListener(handler.cmdCode, TEAppMgr.instance().handler);
                continue;
            }
            TELogFactory.getNormalLogger().error(String.format("RegisterTask2 error, for the cmdcode 0x%x registered again!\n", cmdCode));
        }
        this.mutex.writeLock().unlock();
    }

    @Override
    public void unregisterTask(TETaskHandler handler) {
        this.mutex.writeLock().lock();
        this.table.remove(handler.cmdCode);
        this.mutex.writeLock().unlock();
    }

    @Override
    public void unregisterTask(List<TETaskHandler> handlers) {
        if (null == handlers) {
            TELogFactory.getNormalLogger().error("UnregisterTask fail, input para pHandlerList=NULL!\n");
            return;
        }
        this.mutex.writeLock().lock();
        int size = handlers.size();
        for (int i = 0; i < size; ++i) {
            this.table.remove(handlers.get((int)i).cmdCode);
        }
        this.mutex.writeLock().unlock();
    }
}

