/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.taskmgr;

import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.startup.SystemConfiguration;
import com.huawei.nglct.core.taskmgr.TEAppMgr;
import com.huawei.nglct.core.taskmgr.TEITaskMgrConts;
import com.huawei.nglct.core.taskmgr.TEMessageBlock;
import com.huawei.nglct.core.taskmgr.TEMessageQueue;
import com.huawei.nglct.core.taskmgr.TESystypes;
import com.huawei.nglct.core.taskmgr.TETaskContext;
import com.huawei.nglct.core.taskmgr.TETaskMgr;
import com.huawei.nglct.core.taskmgr.TETaskTimeOutCBFP;
import com.huawei.nglct.core.taskmgr.TETimer;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class TETask {
    public TEITaskMgrConts.TASK_EXEC_STAT taskState;
    public boolean finished;
    public String taskName;
    public int taskID;
    public TEMessageQueue msgQueue;
    public boolean outInit;
    public Lock stateMutex = new ReentrantLock(true);
    public TETaskMgr taskMgrInst;
    protected int curSyncMsgSn;
    protected Set<Integer> syncMsgSnSet = new HashSet<Integer>();
    protected Lock syncMsgSnSetMutex = new ReentrantLock(true);
    protected long msgArriveTime;
    protected Lock mutexMsgArriveTime = new ReentrantLock();
    protected List<TETimer> timers = new ArrayList<TETimer>(2);
    protected Lock mutexTimers = new ReentrantLock(true);
    protected TETaskContext context;

    public TETask(TETaskMgr taskMgr, String taskName) {
        this.taskState = TEITaskMgrConts.TASK_EXEC_STAT.TASK_STATE_IDLE;
        this.taskMgrInst = taskMgr;
        this.taskName = taskName;
        this.taskID = 0;
        this.msgQueue = new TEMessageQueue();
        this.msgQueue.setHighWaterMark(102400000);
        this.msgQueue.setLowWaterMark(102400000);
    }

    public void release() {
        this.cancelAllTimerByType(TEITaskMgrConts.TIMER_TYPE.TIMER_TIMEOUT);
        this.cancelAllTimerByType(TEITaskMgrConts.TIMER_TYPE.TIMER_INTERVAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllTimerByType(TEITaskMgrConts.TIMER_TYPE type) {
        TETimer timer2 = null;
        this.mutexTimers.lock();
        try {
            for (TETimer timer2 : this.timers) {
                if (timer2.type != type) continue;
                this.taskMgrInst.appMgr.reactor.cancel_timer(timer2.scheduleID);
            }
        }
        finally {
            this.mutexTimers.unlock();
        }
    }

    public void recvMsg(MSGPacketExt cmdMsg) {
        if (null == cmdMsg) {
            TELogFactory.getNormalLogger().error("iMapTask::RecvMsg fail, input para pCmdMsg=NULL\n");
            return;
        }
        if (TEITaskMgrConts.MSG_TYPE.MSG_TIMER.getValue() == cmdMsg.mheader.msgType) {
            this.recvTimerMsg(cmdMsg);
        } else if (TEITaskMgrConts.MSG_TYPE.MSG_REQUEST_BC.getValue() == cmdMsg.mheader.msgType || TEITaskMgrConts.MSG_TYPE.MSG_REQUEST_NBC.getValue() == cmdMsg.mheader.msgType || TEITaskMgrConts.MSG_TYPE.MSG_GET_TASKMGR_STATE.getValue() == cmdMsg.mheader.msgType) {
            if (cmdMsg.mheader.cmdHandle > '\u001e' || '\u0000' == cmdMsg.mheader.cmdHandle || TEITaskMgrConts.MSG_TYPE.MSG_GET_TASKMGR_STATE.getValue() == cmdMsg.mheader.msgType) {
                this.recvRequMsg(cmdMsg);
            } else {
                this.recvRespMsg(cmdMsg);
            }
        } else if (TEITaskMgrConts.MSG_TYPE.MSG_RESPONSE_BC.getValue() == cmdMsg.mheader.msgType || TEITaskMgrConts.MSG_TYPE.MSG_RESPONSE_NBC.getValue() == cmdMsg.mheader.msgType) {
            this.recvRespMsg(cmdMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recvTimerMsg(MSGPacketExt cmdMsg) {
        int timerID;
        TETimer timer;
        block14: {
            if (null == cmdMsg) {
                TELogFactory.getNormalLogger().error("iMapTask::RecvTimerMsg fail, input para pCmdMsg=NULL\n");
                return;
            }
            timer = new TETimer(cmdMsg);
            timerID = 0;
            this.mutexTimers.lock();
            try {
                if (this.timers.contains(timer)) {
                    timerID = timer.scheduleID;
                    break block14;
                }
                TELogFactory.getNormalLogger().error(String.format("Receive a invalid Timer(%d).", timer.scheduleID));
                return;
            }
            finally {
                this.mutexTimers.unlock();
            }
        }
        if (TEITaskMgrConts.TIMER_TYPE.TIMER_INTERVAL == timer.type) {
            this.imapTaskTimeInterval(timerID);
        } else if (TEITaskMgrConts.TIMER_TYPE.TIMER_TIMEOUT == timer.type) {
            if (null != timer.callBackProc) {
                String temp = String.format("iMapTask::RecvTimerMsg() TaskID %d timeout,callback %s\n", this.taskID, timer.callBackProc.getClass().getName());
                TELogFactory.getNormalLogger().debug(temp);
                timer.callBackProc.onTime();
            }
            this.mutexTimers.lock();
            try {
                TETimer realTimer = this.findTimerByID_i(timerID);
                if (realTimer != null) {
                    this.timers.remove(realTimer);
                }
                TELogFactory.getNormalLogger().error("Find the timeout timer failed, so can't delete it.\n");
            }
            finally {
                this.mutexTimers.unlock();
            }
        } else {
            TELogFactory.getNormalLogger().error("Receive a invalid Timer.\n");
        }
    }

    public void recvRequMsg(MSGPacketExt cmdMsg) {
        this.imapTaskCmdRecv(cmdMsg);
    }

    public void recvRespMsg(MSGPacketExt cmdMsg) {
        this.cancelAllTimerByType(TEITaskMgrConts.TIMER_TYPE.TIMER_TIMEOUT);
        this.imapTaskCmdResp(cmdMsg.mheader.errCode, cmdMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean imapSetTaskStateInterior(TEITaskMgrConts.TASK_EXEC_STAT state) {
        boolean ret;
        this.stateMutex.lock();
        try {
            ret = false;
            ret = this.setTaskState_i(state);
        }
        finally {
            this.stateMutex.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean imapSetTaskState(TEITaskMgrConts.TASK_EXEC_STAT state) {
        boolean ret;
        if (TEITaskMgrConts.TASK_EXEC_STAT.TASK_STATE_IDLE == state) {
            TELogFactory.getNormalLogger().info("The state of task can't be set with TASK_STATE_IDLE!!\n");
            return false;
        }
        this.stateMutex.lock();
        try {
            ret = this.setTaskState_i(state);
        }
        finally {
            this.stateMutex.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TEITaskMgrConts.TASK_EXEC_STAT getTaskState() {
        TEITaskMgrConts.TASK_EXEC_STAT ret;
        this.stateMutex.lock();
        try {
            ret = this.getTaskState_i();
        }
        finally {
            this.stateMutex.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TETimer findTimerByID(int scheDuleID) {
        TETimer timer;
        this.mutexTimers.lock();
        try {
            timer = this.findTimerByID_i(scheDuleID);
        }
        finally {
            this.mutexTimers.unlock();
        }
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TETimer findTimerByType(TEITaskMgrConts.TIMER_TYPE type) {
        TETimer timer;
        this.mutexTimers.lock();
        try {
            timer = this.findTimerByType_i(type);
        }
        finally {
            this.mutexTimers.unlock();
        }
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freshTaskIDForTimer() {
        this.mutexTimers.lock();
        try {
            TETimer timer2 = null;
            for (TETimer timer2 : this.timers) {
                if (timer2 == null) continue;
                timer2.taskID = this.taskID;
            }
        }
        finally {
            this.mutexTimers.unlock();
        }
    }

    public void imapTaskTimeOut() {
        this.imapSetTaskStateInterior(TEITaskMgrConts.TASK_EXEC_STAT.TASK_STATE_TIMEEXIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setTaskTimeOut(int timeOutCount, TETaskTimeOutCBFP proc) {
        if (0 == timeOutCount || null == proc) {
            return -1;
        }
        TETimer timer = new TETimer();
        timer.taskID = this.taskID;
        timer.type = TEITaskMgrConts.TIMER_TYPE.TIMER_TIMEOUT;
        timer.callBackProc = proc;
        timer.scheduleID = 0;
        this.mutexTimers.lock();
        try {
            timer.scheduleID = this.taskMgrInst.appMgr.reactor.schedule_timer(this.taskMgrInst, timer, timeOutCount);
            this.timers.add(timer);
        }
        finally {
            this.mutexTimers.unlock();
        }
        String info = TEStringUtils.snprintf(1024, "iMapTaskMgr(%d)-iMapTask(%d)::SetTaskTimeOut() schedule_timer %d\n", this.taskMgrInst.taskMgrID, this.taskID, timer.scheduleID);
        TELogFactory.getNormalLogger().debug(info);
        return timer.scheduleID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTaskTimeOut(int timerID) {
        this.mutexTimers.lock();
        try {
            TETimer timer = this.findTimerByID_i(timerID);
            if (null != timer) {
                this.taskMgrInst.appMgr.reactor.cancel_timer(timer.scheduleID);
                this.timers.remove(timer);
            }
        }
        finally {
            this.mutexTimers.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setTaskTimeInterval(int timeIntervalCount) {
        if (0 == timeIntervalCount) {
            return -1;
        }
        TETimer timer = new TETimer();
        timer.taskID = this.taskID;
        timer.type = TEITaskMgrConts.TIMER_TYPE.TIMER_INTERVAL;
        timer.callBackProc = null;
        timer.scheduleID = 0;
        this.mutexTimers.lock();
        try {
            timer.scheduleID = this.taskMgrInst.appMgr.reactor.schedule_timer(this.taskMgrInst, timer, timeIntervalCount, timeIntervalCount);
            this.timers.add(timer);
        }
        finally {
            this.mutexTimers.unlock();
        }
        return timer.scheduleID;
    }

    public void delTaskTimeInterval(int scheduleID) {
        this.cancelTaskTimeOut(scheduleID);
    }

    public void fillCmdMsgHead(MSGPacketExt msg) {
        if (null == msg) {
            TELogFactory.getNormalLogger().error("iMapTask::FillCmdMsgHead fail, input para pMsg=NULL!\n");
            return;
        }
        msg.mheader.protocolVer = (byte)10;
        msg.mheader.senderProcIP = 2130706433;
        msg.mheader.senderDeskID = (char)SystemConfiguration.getAppInstDeskID();
        msg.mheader.senderProcHandle = SystemConfiguration.getProcHandler();
        msg.mheader.senderProcID = SystemConfiguration.getProcID();
        msg.mheader.senderCmdHandle = (char)this.taskID;
    }

    public int imapSendCmdMsg(MSGPacketExt cmdMsg, int len) {
        if (null == cmdMsg) {
            TELogFactory.getNormalLogger().error("iMapTask::iMapSendCmdMsg fail, input para pCmdMsg=NULL\n");
            return -1;
        }
        if (cmdMsg.length() > 65535) {
            String error = TEStringUtils.snprintf(1024, "iMapTask::iMapSendCmdMsg fail, invalid length! ", new Object[0]);
            TELogFactory.getNormalLogger().error(error);
            return -1;
        }
        if (!TEAppMgr.instance().sendOneMsg_i(cmdMsg)) {
            return -1;
        }
        return 0;
    }

    public static void imapCmdSendAnsFrameCB(MSGPacketExt cmdMsg) {
        TEAppMgr.instance().sendOneMsg_i(cmdMsg);
    }

    public void imapCmdSendFrameCB(MSGPacketExt cmdMsg, int timeOut, TETaskTimeOutCBFP timeOutProc) {
        if (timeOut < 0) {
            TELogFactory.getNormalLogger().error("iMapTask::iMapCmdSendFrameCB iTimeOut < 0.");
            return;
        }
        if (!TEAppMgr.instance().sendOneMsg_i(cmdMsg)) {
            TELogFactory.getNormalLogger().error("iMapTask::iMapCmdSendFrameCB send msg fail.\n\n");
        } else {
            this.setTaskTimeOut(timeOut, timeOutProc);
        }
    }

    public boolean imapCmdSynSendCB(MSGPacketExt inCmdMsg, MSGPacketExt[] outCmdMsg, int timeOut) {
        int[] retCode = new int[]{0};
        return this.imapCmdSynSendCB(inCmdMsg, outCmdMsg, timeOut, retCode);
    }

    public boolean imapCmdSynSendCB(MSGPacketExt inCmdMsg, MSGPacketExt[] outCmdMsg, int timeOut, int[] retCode) {
        if (timeOut < 0) {
            TELogFactory.getNormalLogger().error("iMapTask::iMapCmdSynSendCB iTimeOut < 0.");
            return false;
        }
        if (!TEAppMgr.instance().sendOneMsg_i(inCmdMsg)) {
            TELogFactory.getNormalLogger().error("iMapTask::iMapCmdSynSendCB send msg fail.\n\n");
            return false;
        }
        return this.imapSynRecv(outCmdMsg, timeOut, retCode, 0, 0);
    }

    public boolean imapSynRecv(MSGPacketExt[] msg, int timeOut, int[] retCode, int cmdCode, int msgSN) {
        if (null == this.msgQueue) {
            this.imapSetTaskStateInterior(TEITaskMgrConts.TASK_EXEC_STAT.TASK_STATE_EXEC);
            if (retCode != null && retCode.length > 0) {
                retCode[0] = 1;
            }
            this.setMsgTimeFlag(0L);
            return false;
        }
        if (timeOut <= 0) {
            this.imapSetTaskStateInterior(TEITaskMgrConts.TASK_EXEC_STAT.TASK_STATE_EXEC);
            if (retCode != null && retCode.length > 0) {
                retCode[0] = 1;
            }
            this.setMsgTimeFlag(0L);
            return false;
        }
        return this.imapSynRecvBySn(cmdCode, msg, msgSN, timeOut, retCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMsgTimeFlag(long time) {
        this.mutexMsgArriveTime.lock();
        try {
            this.msgArriveTime = time;
        }
        finally {
            this.mutexMsgArriveTime.unlock();
        }
    }

    public boolean imapSynRecvBySn(int cmdCode, MSGPacketExt[] cmdMsg, int msgSn, long timeOut, int[] retCode) {
        this.imapSetTaskStateInterior(TEITaskMgrConts.TASK_EXEC_STAT.TASK_STATE_EXEC);
        if (retCode != null && retCode.length > 0) {
            retCode[0] = 0;
        }
        TEMessageQueue tempQueue = new TEMessageQueue();
        tempQueue.setHighWaterMark(102400000);
        tempQueue.setLowWaterMark(102400000);
        long toBeTimeout = System.currentTimeMillis() + timeOut * 1000L;
        MSGPacketExt tmpMsg = null;
        TEMessageBlock[] mb = new TEMessageBlock[1];
        boolean recvResult = false;
        while (true) {
            if (-1 == this.msgQueue.dequeue(mb, toBeTimeout)) {
                TELogFactory.getNormalLogger().error("iMapTask::iMapSynRecvBySn synrecv Timeout Exit!\n");
                if (retCode == null || retCode.length <= 0) break;
                retCode[0] = 2;
                break;
            }
            tmpMsg = mb[0].getBase();
            if ((TEITaskMgrConts.MSG_TYPE.MSG_RESPONSE_BC.getValue() == tmpMsg.mheader.msgType || TEITaskMgrConts.MSG_TYPE.MSG_RESPONSE_NBC.getValue() == tmpMsg.mheader.msgType || TEITaskMgrConts.MSG_TYPE.MSG_DISPFAIL_RSP.getValue() == tmpMsg.mheader.msgType) && (cmdCode != 0 && tmpMsg.mheader.cmdCode == cmdCode || 0 == cmdCode) && (0 != msgSn && TESystypes.imapMsgGetSn(tmpMsg) == msgSn || 0 == msgSn)) {
                if (retCode == null || retCode.length <= 0) {
                    return false;
                }
                retCode[0] = tmpMsg.mheader.errCode;
                if (TEITaskMgrConts.MSG_TYPE.MSG_DISPFAIL_RSP.getValue() == tmpMsg.mheader.msgType && (3 == retCode[0] || 4 == retCode[0]) || 1 == retCode[0] || 5 == retCode[0]) {
                    String str = TEStringUtils.snprintf(1024, "iMapTask::iMapSynRecvBySn get message failure, iMAP message ErrCode = %d", retCode[0]);
                    TELogFactory.getNormalLogger().error(str);
                    break;
                }
                cmdMsg[0] = tmpMsg;
                recvResult = true;
                this.setMsgTimeFlag(TESystypes.imapGetMsgArriveTime(cmdMsg[0]));
                break;
            }
            long enTimeout = System.currentTimeMillis() + 5000L;
            if (-1 != tempQueue.enqueueHead(mb[0], enTimeout)) continue;
            TELogFactory.getNormalLogger().info("iMapTask::iMapSynRecvBySn pTempQueue->enqueue_head fail, this msg discard!\n");
        }
        while (!tempQueue.realQueue.isEmpty()) {
            long deTimeout = System.currentTimeMillis() + 5000L;
            tempQueue.dequeue(mb, deTimeout);
            if (-1 != this.msgQueue.enqueueHead(mb[0], deTimeout)) continue;
            TELogFactory.getNormalLogger().info("iMapTask::iMapSynRecvBySn m_pMsgQueue->enqueue_head fail, this msg discard!\n");
        }
        if (recvResult) {
            TELogFactory.getNormalLogger().info("iMapTask::iMapSynRecvBySn synrecv success!\n");
        } else {
            this.setMsgTimeFlag(0L);
        }
        return recvResult;
    }

    public void imapCmdSendNBC(int recvProcID, int recvDeskID, int recvProcHandle, int cmdCode, byte[] cmdMsgData, int cmdMsgLen, int timeOut, TETaskTimeOutCBFP timeOutProc, int protocolVersion) {
        if (cmdMsgLen < 0) {
            TELogFactory.getNormalLogger().error("iMapTask::iMapCmdSendNBC iCmdMsgLen < 0.");
            return;
        }
        if (timeOut < 0) {
            TELogFactory.getNormalLogger().error("iMapTask::iMapCmdSendNBC iTimeOut < 0.");
            return;
        }
        MSGPacketExt msg = null;
        MSGHead header = new MSGHead();
        header.msgType = (byte)TEITaskMgrConts.MSG_TYPE.MSG_REQUEST_NBC.getValue();
        header.receiverProcID = (char)recvProcID;
        header.receiverDeskID = (char)recvDeskID;
        header.receiverProcHandle = (char)recvProcHandle;
        header.cmdCode = cmdCode;
        if (null != cmdMsgData) {
            msg = new MSGPacketExt(header, cmdMsgData, cmdMsgLen);
            this.fillCmdMsgHead(msg);
            header.protocolVer = (byte)protocolVersion;
        }
        if (!TEAppMgr.instance().sendOneMsg_i(msg)) {
            TELogFactory.getNormalLogger().error("iMapTask::iMapCmdSendNBC send msg fail.\n\n");
        } else {
            this.setTaskTimeOut(timeOut, timeOutProc);
        }
    }

    public void imapCmdSendBC(int recvProcID, int cmdCode, byte[] cmdMsgData, int cmdMsgLen, int timeOut, TETaskTimeOutCBFP timeOutProc, int protocolVersion) {
        this.imapCmdSendNBC(recvProcID, 0, 0, cmdCode, cmdMsgData, cmdMsgLen, timeOut, timeOutProc, protocolVersion);
    }

    public void imapCmdSendRespNBC(int recvProcID, int recvDeskID, int recvProcHandle, int cmdCode, int recvCmdHandle, byte[] cmdMsgData, int cmdMsgLen, int protocolVersion) {
        if (cmdMsgLen < 0) {
            TELogFactory.getNormalLogger().error("iMapTask::iMapCmdSendRespNBC iCmdMsgLen < 0.");
            return;
        }
        MSGPacketExt msg = null;
        MSGHead head = new MSGHead();
        head.msgType = (byte)TEITaskMgrConts.MSG_TYPE.MSG_RESPONSE_NBC.getValue();
        head.receiverProcID = (char)recvProcID;
        head.receiverDeskID = (char)recvDeskID;
        head.receiverProcHandle = (char)recvProcHandle;
        head.cmdCode = cmdCode;
        head.cmdHandle = (char)recvCmdHandle;
        if (null != cmdMsgData) {
            msg = new MSGPacketExt(head, cmdMsgData, cmdMsgLen);
            this.fillCmdMsgHead(msg);
            head.protocolVer = (byte)protocolVersion;
        }
        if (!TEAppMgr.instance().sendOneMsg_i(msg)) {
            TELogFactory.getNormalLogger().error("iMapTask::iMapCmdSendRespNBC send msg fail.\n\n");
        }
    }

    public void imapCmdSendRespBC(int recvProcID, int cmdCode, int recvCmdHandle, byte[] cmdMsgData, int cmdMsgLen, int protocolVersion) {
        this.imapCmdSendRespNBC(recvProcID, 0, 0, cmdCode, recvCmdHandle, cmdMsgData, cmdMsgLen, protocolVersion);
    }

    public void imapCmdSendFPToDP(int recvProcID, int cmdCode, byte[] cmdMsgData, int cmdMsgLen, int timeOut, TETaskTimeOutCBFP timeOutProc, int protocolVersion) {
        this.imapCmdSendNBC(recvProcID, 0, 0, cmdCode, cmdMsgData, cmdMsgLen, timeOut, timeOutProc, protocolVersion);
    }

    public void imapCmdRespNBCAndWaitResp(int recvProcID, int recvDeskID, int recvProcHandle, int recvCmdHandle, int cmdCode, byte[] cmdMsgData, int cmdMsgLen, int timeOut, TETaskTimeOutCBFP timeOutProc, int protocolVersion) {
        if (cmdMsgLen < 0) {
            TELogFactory.getNormalLogger().error("iMapTask::iMapCmdRespNBCAndWaitResp iCmdMsgLen < 0.");
            return;
        }
        if (timeOut < 0) {
            TELogFactory.getNormalLogger().error("iMapTask::iMapCmdRespNBCAndWaitResp iTimeOut < 0.");
            return;
        }
        MSGPacketExt msg = null;
        MSGHead head = new MSGHead();
        head.msgType = (byte)TEITaskMgrConts.MSG_TYPE.MSG_RESPONSE_NBC.getValue();
        head.receiverProcID = (char)recvProcID;
        head.cmdCode = cmdCode;
        head.cmdHandle = (char)recvCmdHandle;
        if (null != cmdMsgData) {
            msg = new MSGPacketExt(head, cmdMsgData, cmdMsgLen);
            this.fillCmdMsgHead(msg);
            head.protocolVer = (byte)protocolVersion;
        }
        if (!TEAppMgr.instance().sendOneMsg_i(msg)) {
            TELogFactory.getNormalLogger().error("iMapTask::iMapCmdRespNBCAndWaitResp send msg fail.\n\n");
        } else {
            this.setTaskTimeOut(timeOut, timeOutProc);
        }
    }

    public boolean imapOutSynSendMsg(MSGPacketExt inMsg, MSGPacketExt[] outMsg, int timeOut) {
        int[] retCode = new int[]{0};
        return this.imapOutSynSendMsg(inMsg, outMsg, timeOut, retCode);
    }

    public boolean imapOutSynSendMsg(MSGPacketExt inMsg, MSGPacketExt[] outMsg, int timeOut, int[] retCode) {
        if (null == inMsg) {
            TELogFactory.getNormalLogger().error("iMapTask::iMapOutSynSendMsg fail, input para pInMsg=NULL\n");
            retCode[0] = 1;
            return false;
        }
        if (!TEAppMgr.instance().imapOutSendMsg(inMsg, inMsg.mheader.receiverModule)) {
            return false;
        }
        return this.imapSynRecv(outMsg, timeOut, retCode, 0, 0);
    }

    public int getTaskID() {
        return this.taskID;
    }

    public void setTaskID(String taskID) {
        this.taskName = taskID;
    }

    public long getMsgTimeFlag() {
        this.mutexMsgArriveTime.lock();
        long time = this.msgArriveTime;
        this.mutexMsgArriveTime.unlock();
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int allocMsgSn() {
        this.syncMsgSnSetMutex.lock();
        try {
            if (this.syncMsgSnSet.size() >= 65535) {
                TELogFactory.getNormalLogger().error("iMapTask::AllocMsgSn m_SyncMsgSnSet is full.");
                int n = 0;
                return n;
            }
            int tmp = this.curSyncMsgSn;
            do {
                if (0 != ++tmp) continue;
                tmp = 1;
            } while (this.syncMsgSnSet.contains(tmp));
            this.curSyncMsgSn = tmp;
            this.syncMsgSnSet.add(this.curSyncMsgSn);
            int n = this.curSyncMsgSn;
            return n;
        }
        finally {
            this.syncMsgSnSetMutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeMsgSn(int msgSN) {
        this.syncMsgSnSetMutex.lock();
        try {
            if (this.syncMsgSnSet.contains(msgSN)) {
                this.syncMsgSnSet.remove(msgSN);
            } else {
                TELogFactory.getNormalLogger().error(String.format("iMapTask::RevokeMsgSn not found %d in m_SyncMsgSnSet", msgSN));
            }
        }
        finally {
            this.syncMsgSnSetMutex.unlock();
        }
    }

    public boolean enqueueHead(MSGPacketExt msg) {
        if (null == msg) {
            return false;
        }
        TEMessageBlock mb = new TEMessageBlock(msg);
        long timeout = System.currentTimeMillis() + 5000L;
        if (-1 == this.msgQueue.enqueueHead(mb, timeout)) {
            TELogFactory.getNormalLogger().error(String.format("iMapTask::EnqueueHead enqueue_head failure.", new Object[0]));
            return false;
        }
        return true;
    }

    public boolean imapSynRecvEx(MSGPacketExt[] cmdMsg, int timeOut) {
        if (timeOut < 0) {
            return false;
        }
        this.imapSetTaskStateInterior(TEITaskMgrConts.TASK_EXEC_STAT.TASK_STATE_EXEC);
        TEMessageQueue tempQueue = new TEMessageQueue();
        tempQueue.setHighWaterMark(102400000);
        tempQueue.setLowWaterMark(102400000);
        long timeout = System.currentTimeMillis() + (long)(timeOut * 1000);
        MSGPacketExt tmpMsg = null;
        TEMessageBlock[] mb = new TEMessageBlock[1];
        boolean recvResult = false;
        while (true) {
            if (-1 == this.msgQueue.dequeueHead(mb, timeout)) {
                TELogFactory.getNormalLogger().error("iMapTask::iMapSynRecvEx synrecv Timeout Exit!\n");
                break;
            }
            tmpMsg = mb[0].getBase();
            if (TEITaskMgrConts.MSG_TYPE.MSG_RESPONSE_BC.getValue() == tmpMsg.mheader.msgType || TEITaskMgrConts.MSG_TYPE.MSG_RESPONSE_NBC.getValue() == tmpMsg.mheader.msgType || TEITaskMgrConts.MSG_TYPE.MSG_DISPFAIL_RSP.getValue() == tmpMsg.mheader.msgType) {
                cmdMsg[0] = tmpMsg;
                recvResult = true;
                this.setMsgTimeFlag(TESystypes.imapGetMsgArriveTime(cmdMsg[0]));
                break;
            }
            long enheadTimeout = System.currentTimeMillis() + 5000L;
            if (-1 != tempQueue.enqueueHead(mb[0], enheadTimeout)) continue;
            TELogFactory.getNormalLogger().error("iMapTask::iMapSynRecvEx pTempQueue->enqueue_head fail, this msg discard!\n");
        }
        while (!tempQueue.realQueue.isEmpty()) {
            tempQueue.dequeueHead(mb, 0L);
            long deheadTimeout = System.currentTimeMillis() + 5000L;
            if (-1 != this.msgQueue.enqueueHead(mb[0], deheadTimeout)) continue;
            TELogFactory.getNormalLogger().error("iMapTask::iMapSynRecvEx m_pMsgQueue->enqueue_head fail, this msg discard!\n");
        }
        if (recvResult) {
            TELogFactory.getNormalLogger().info("iMapTask::iMapSynRecvEx synrecv success!\n");
        } else {
            this.setMsgTimeFlag(0L);
        }
        return recvResult;
    }

    public boolean imapCmdSynSendCBEx(MSGPacketExt inMsg, MSGPacketExt[] outMsg, int timeOut) {
        if (null == inMsg) {
            TELogFactory.getNormalLogger().error("iMapTask::iMapCmdSynSendCBEx pInMsg is null.");
            return false;
        }
        if (timeOut <= 0) {
            TELogFactory.getNormalLogger().error("iMapTask::iMapCmdSynSendCBEx TimeOut <=0.");
            return false;
        }
        int msgSn = this.allocMsgSn();
        if (0 == msgSn) {
            TELogFactory.getNormalLogger().error("iMapTask::iMapCmdSynSendCBEx AllocMsgSn return 0.");
            return false;
        }
        TESystypes.imapMsgSetSn(inMsg, msgSn);
        int cmdCode = inMsg.mheader.cmdCode;
        if (!TEAppMgr.instance().sendOneMsg_i(inMsg)) {
            TELogFactory.getNormalLogger().error("iMapTask::iMapCmdSynSendCBEx send msg fail.\n\n");
            this.revokeMsgSn(msgSn);
            return false;
        }
        int[] retCode = new int[1];
        boolean synRecvResult = this.imapSynRecvBySn(cmdCode, outMsg, msgSn, timeOut, retCode);
        this.revokeMsgSn(msgSn);
        return synRecvResult;
    }

    public abstract void initTaskCmdReqProcess(MSGPacketExt var1);

    public void imapTaskCmdResp(int respType, MSGPacketExt cmdMsg) {
    }

    public abstract void imapTaskTimeInterval(int var1);

    public abstract void imapTaskCmdRecv(MSGPacketExt var1);

    protected TETimer findTimerByID_i(int scheDuleID) {
        TETimer timer2 = null;
        for (TETimer timer2 : this.timers) {
            if (timer2 == null || timer2.scheduleID != scheDuleID) continue;
            return timer2;
        }
        return null;
    }

    protected boolean setTaskState_i(TEITaskMgrConts.TASK_EXEC_STAT state) {
        if (TEITaskMgrConts.TASK_EXEC_STAT.TASK_STATE_WANTEXIT == state || TEITaskMgrConts.TASK_EXEC_STAT.TASK_STATE_TIMEEXIT == state) {
            this.finished = true;
        } else if (TEITaskMgrConts.TASK_EXEC_STAT.TASK_STATE_IDLE == state || TEITaskMgrConts.TASK_EXEC_STAT.TASK_STATE_EXEC == state) {
            this.taskState = state;
        }
        return true;
    }

    protected TEITaskMgrConts.TASK_EXEC_STAT getTaskState_i() {
        return this.taskState;
    }

    protected TETimer findTimerByType_i(TEITaskMgrConts.TIMER_TYPE type) {
        TETimer timer2 = null;
        for (TETimer timer2 : this.timers) {
            if (timer2 == null || timer2.type != type) continue;
            return timer2;
        }
        return null;
    }

    protected int imapMsgGetSn_i(MSGPacketExt msg) {
        if (null == msg) {
            TELogFactory.getNormalLogger().error("iMapMsgGetSn_i pMsg is null");
            return 0;
        }
        int sn = 0;
        for (int i = 0; i < 2; ++i) {
            sn |= msg.mheader.reserved[i] << i;
        }
        return sn;
    }

    protected void imapMsgSetSn_i(MSGPacketExt msg, int msgSn) {
        if (null == msg) {
            TELogFactory.getNormalLogger().error("iMapMsgSetSn_i pMsg is null");
            return;
        }
        for (int i = 0; i < 4; ++i) {
            msg.mheader.reserved[i] = (byte)(msgSn >> i);
        }
    }

    public MSGPacketExt getCurReqMsg() {
        return null;
    }

    public TETaskContext getContext() {
        return this.context;
    }

    public void setContext(TETaskContext context) {
        this.context = context;
    }
}

