/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.taskmgr;

import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.HashMap;
import java.util.Map;

public class TESystypes {
    public static Map<MSGPacketExt, Long> mapMsgArriveTime = new HashMap<MSGPacketExt, Long>();
    public static Object mutexMsgArriveTimeMap = new Object();
    public static final int MAX_ARRIVETIMEMAP_SIZE = 65535;
    public static final int IMAP_MSG_MODULE_LEN = 2;
    public static boolean mapCounterEnable;
    protected static boolean systemExited;
    protected static int maxiMAPMsgLen;

    private TESystypes() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long imapGetMsgArriveTime(MSGPacketExt msg) {
        Long time;
        if (null == msg) {
            TELogFactory.getNormalLogger().info("iMapGetMsgArriveTime fail, input para pMsg=NULL\n");
            return 0L;
        }
        Object object = mutexMsgArriveTimeMap;
        synchronized (object) {
            time = mapMsgArriveTime.get(msg);
            if (time == null) {
                String str = TEStringUtils.snprintf(256, "msg CmdCode=%d,CmdHandle=%d can not find in g_mapMsgArriveTime 2!\n", msg.mheader.cmdCode, msg.mheader.cmdHandle);
                TELogFactory.getNormalLogger().error(str);
                time = 0L;
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void imapRegArriveMsgTime(MSGPacketExt msg) {
        Object object = mutexMsgArriveTimeMap;
        synchronized (object) {
            if (mapMsgArriveTime.size() > 65535) {
                String str = String.format("iMapRegArriveMsgTime map size[%d] is too large, not add to map. CmdCode=%d,CmdHandle=%d ", mapMsgArriveTime.size(), msg.mheader.cmdCode, (int)msg.mheader.cmdHandle);
                TELogFactory.getNormalLogger().info(str);
            } else {
                mapMsgArriveTime.put(msg, System.currentTimeMillis());
            }
        }
    }

    public static boolean imapIsExit() {
        return systemExited;
    }

    public static void setSystemExited(boolean systemExited) {
        TESystypes.systemExited = systemExited;
    }

    public static int imapGetMsgMaxLen() {
        return maxiMAPMsgLen;
    }

    public static void imapMsgSetSn(MSGPacketExt msg, int msgSn) {
        if (null == msg) {
            TELogFactory.getCommuLogger().error("iMapMsgSetSn pMsg is null");
            return;
        }
        byte[] sn = IOStreamConvertor.unsignedShort2Bytes(msgSn);
        msg.mheader.reserved[0] = sn[0];
        msg.mheader.reserved[1] = sn[1];
    }

    public static int imapMsgGetSn(MSGPacketExt msg) {
        if (null == msg) {
            TELogFactory.getCommuLogger().error("iMapMsgGetSn pMsg is null");
            return 0;
        }
        return IOStreamConvertor.readUnsignedShort(msg.mheader.reserved, 0);
    }

    static {
        maxiMAPMsgLen = 65535;
    }
}

