/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.taskmgr;

import com.huawei.nglct.core.taskmgr.TEMessageBlock;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TEMessageQueue {
    protected int highWaterMark;
    protected int lowWaterMark;
    protected BlockingQueue<TEMessageBlock> realQueue = new ArrayBlockingQueue<TEMessageBlock>(1000, true);
    protected Lock realQueueMutex = new ReentrantLock(true);

    public Queue<TEMessageBlock> getContents() {
        return this.realQueue;
    }

    public int dequeue(TEMessageBlock[] mb, long timeout) {
        return this.dequeueHead(mb, timeout);
    }

    public int dequeueHead(TEMessageBlock[] mb, long timeout) {
        int size = 0;
        try {
            if (!this.realQueueMutex.tryLock(timeout, TimeUnit.SECONDS)) {
                return -1;
            }
            mb[0] = this.realQueue.poll(timeout, TimeUnit.SECONDS);
            size = this.realQueue.size();
            this.realQueueMutex.unlock();
        }
        catch (InterruptedException e) {
            this.realQueueMutex.unlock();
            return -1;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int enqueueHead(TEMessageBlock mb, long timeOut) {
        try {
            int size;
            if (this.realQueueMutex.tryLock(timeOut, TimeUnit.SECONDS)) {
                this.realQueueMutex.lock();
                ((List)((Object)this.realQueue)).add(0, mb);
            }
            int n = size = this.realQueue.size();
            return n;
        }
        catch (InterruptedException e) {
            int n = -1;
            return n;
        }
        finally {
            this.realQueueMutex.unlock();
        }
    }

    public int enqueue(TEMessageBlock mb, long timeOut) {
        return this.enqueue_tail(mb, timeOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int enqueue_tail(TEMessageBlock mb, long timeOut) {
        try {
            if (this.realQueueMutex.tryLock(timeOut, TimeUnit.SECONDS)) {
                if (this.realQueue.offer(mb, timeOut, TimeUnit.SECONDS)) {
                    int n = this.realQueue.size();
                    return n;
                }
                int n = -1;
                return n;
            }
            int n = -1;
            return n;
        }
        catch (InterruptedException e) {
            int n = -1;
            return n;
        }
        finally {
            this.realQueueMutex.unlock();
        }
    }

    public int getHighWaterMark() {
        return this.highWaterMark;
    }

    public void setHighWaterMark(int highWaterMark) {
        this.highWaterMark = highWaterMark;
    }

    public int getLowWaterMark() {
        return this.lowWaterMark;
    }

    public void setLowWaterMark(int lowWaterMark) {
        this.lowWaterMark = lowWaterMark;
    }

    public void deactivate() {
    }
}

