/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.taskmgr;

import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.core.mdp.TECommUtil;
import com.huawei.nglct.core.startup.SystemConfiguration;
import com.huawei.nglct.core.taskmgr.TEAppMgr;
import com.huawei.nglct.core.taskmgr.TEITaskMgrConts;
import com.huawei.nglct.core.taskmgr.TETask;
import com.huawei.nglct.core.taskmgr.TETaskCreator;
import com.huawei.nglct.core.taskmgr.TETaskHandler;
import com.huawei.nglct.core.taskmgr.TETaskMgr;
import com.huawei.nglct.core.taskmgr.TETaskTimeOutCBFP;
import com.huawei.nglct.util.string.TEStringUtils;
import net.commustru.fstru.FStruct;

public class TEGnlTask
extends TETask {
    protected MSGPacketExt reqMsg;

    public TEGnlTask(TETaskMgr mgr, String taskName) {
        super(mgr, taskName);
    }

    @Override
    public void imapTaskCmdRecv(MSGPacketExt cmdMsg) {
        if (null == cmdMsg) {
            TELogFactory.getNormalLogger().error("iMapGnlTask::iMapTaskCmdRecv(CmdMSG* CmdMsg), input para CmdMsg=null\n");
            return;
        }
        if (49153 == cmdMsg.mheader.cmdCode) {
            TEAppMgr.instance().procInFuncMutex.readLock().lock();
            if (TEAppMgr.instance().procInFunc != null) {
                TEAppMgr.instance().procInFunc.onMessage(cmdMsg);
            }
            TEAppMgr.instance().procInFuncMutex.readLock().unlock();
            this.imapSetTaskState(TEITaskMgrConts.TASK_EXEC_STAT.TASK_STATE_WANTEXIT);
            return;
        }
        if (49154 == cmdMsg.mheader.cmdCode) {
            TEAppMgr.instance().procBtwFuncMutex.readLock().lock();
            if (TEAppMgr.instance().procBtwFunc != null) {
                TEAppMgr.instance().procBtwFunc.onMessage(cmdMsg);
            }
            TEAppMgr.instance().procBtwFuncMutex.readLock().unlock();
            this.imapSetTaskState(TEITaskMgrConts.TASK_EXEC_STAT.TASK_STATE_WANTEXIT);
            return;
        }
        this.reqMsg = cmdMsg;
        this.handleReqMsgContent(this.reqMsg);
        this.imapSetTaskState(TEITaskMgrConts.TASK_EXEC_STAT.TASK_STATE_WANTEXIT);
    }

    @Override
    public void imapTaskCmdResp(int respType, MSGPacketExt cmdMsg) {
        if (30 == this.taskID) {
            this.imapSetTaskState(TEITaskMgrConts.TASK_EXEC_STAT.TASK_STATE_WAITNEXT);
            if (0 != respType || cmdMsg == null) {
                return;
            }
            if (49153 == cmdMsg.mheader.cmdCode) {
                TEAppMgr.instance.procInFuncMutex.readLock().lock();
                if (TEAppMgr.instance().procInFunc != null) {
                    TEAppMgr.instance().procInFunc.onMessage(cmdMsg);
                }
                TEAppMgr.instance.procInFuncMutex.readLock().unlock();
                this.imapSetTaskState(TEITaskMgrConts.TASK_EXEC_STAT.TASK_STATE_WAITNEXT);
                return;
            }
            if (49154 == cmdMsg.mheader.cmdCode) {
                TEAppMgr.instance().procBtwFuncMutex.readLock().lock();
                if (TEAppMgr.instance().procBtwFunc != null) {
                    TEAppMgr.instance().procBtwFunc.onMessage(cmdMsg);
                }
                TEAppMgr.instance().procBtwFuncMutex.readLock().unlock();
                this.imapSetTaskState(TEITaskMgrConts.TASK_EXEC_STAT.TASK_STATE_WAITNEXT);
                return;
            }
            super.imapTaskCmdResp(respType, cmdMsg);
        } else {
            super.imapTaskCmdResp(respType, cmdMsg);
        }
    }

    @Override
    public void imapTaskTimeInterval(int timerId) {
    }

    @Override
    public void initTaskCmdReqProcess(MSGPacketExt initCmdReqMsg) {
    }

    @Override
    public MSGPacketExt getCurReqMsg() {
        return this.reqMsg;
    }

    public void handleReqMsgContent(MSGPacketExt data) {
        TETaskHandler[] handler = new TETaskHandler[1];
        FStruct req = null;
        FStruct[] rsp = new FStruct[1];
        int BUFFER_LEN = 256;
        if (TETaskCreator.instance().getTaskHandler(this.taskMgrInst.taskMgrID, this.reqMsg.mheader.cmdCode, handler)) {
            if (null != handler[0].createReq) {
                req = handler[0].createReq;
                if (null == req) {
                    String str = TEStringUtils.snprintf(BUFFER_LEN, "CmdCode %d: New Request Asn failed!\n", this.reqMsg.mheader.cmdCode);
                    TELogFactory.getNormalLogger().error(str);
                    this.doCleanWork(handler[0], null, rsp[0]);
                    return;
                }
                if (data.getData() == null) {
                    TELogFactory.getNormalLogger().error("iMapGnlTask::HandleReqMsgContent, input para pContent=null\n");
                    return;
                }
                if (!TECommUtil.getASNData(data, req)) {
                    String str = TEStringUtils.snprintf(BUFFER_LEN, "CmdCode %d: Asn Decode failed!\n", this.reqMsg.mheader.cmdCode);
                    TELogFactory.getNormalLogger().error(str);
                    this.doCleanWork(handler[0], req, rsp[0]);
                    return;
                }
            }
            if (null != handler[0].msgHandler) {
                rsp[0] = handler[0].msgHandler.onRequest(this, req);
                if (null == rsp[0]) {
                    String str = TEStringUtils.snprintf(BUFFER_LEN, "CmdCode %d: User defined MsgHandler [%s] returned NULL!\n", this.reqMsg.mheader.cmdCode, handler[0].msgHandler.getClass().getName());
                    TELogFactory.getNormalLogger().error(str);
                }
            } else if (null != handler[0].extMsgHandler) {
                if (null != handler[0].createRsp) {
                    rsp[0] = handler[0].createRsp;
                    if (null == rsp[0]) {
                        String str = TEStringUtils.snprintf(BUFFER_LEN, "CmdCode %d: New Response Asn failed!\n", this.reqMsg.mheader.cmdCode);
                        TELogFactory.getNormalLogger().error(str);
                        this.doCleanWork(handler[0], req, rsp[0]);
                        return;
                    }
                }
                handler[0].extMsgHandler.handleMessage(req, rsp, this);
                if (null == rsp[0]) {
                    String str = TEStringUtils.snprintf(BUFFER_LEN, "CmdCode %d: User defined ExtMsgHandler %s returned NULL!\n", this.reqMsg.mheader.cmdCode, handler[0].extMsgHandler.getClass().getName());
                    TELogFactory.getNormalLogger().info(str);
                }
            } else {
                String str = TEStringUtils.snprintf(BUFFER_LEN, "CmdCode %d: Handle NOT Asn1 Message!\n", this.reqMsg.mheader.cmdCode);
                TELogFactory.getNormalLogger().info(str);
                this.handleNoAsn1Msg(this.reqMsg);
            }
        } else {
            String str = TEStringUtils.snprintf(BUFFER_LEN, "CmdCode %d: iMapGnlTask GetHandle Failed!\n", this.reqMsg.mheader.cmdCode);
            TELogFactory.getNormalLogger().info(str);
        }
        this.doCleanWork(handler[0], req, rsp[0]);
    }

    public void handleNoAsn1Msg(MSGPacketExt data) {
    }

    protected void doCleanWork(TETaskHandler handler, FStruct req, FStruct rsp) {
        if (handler.extMsgHandler == null || handler.createRsp != null) {
            TEGnlTask.asnSendAnsFrameCB(rsp, this.reqMsg);
        }
        this.reqMsg = null;
    }

    protected static int asnSendAnsFrameCB(FStruct rsp, MSGPacketExt reqMsg) {
        if (null == reqMsg) {
            TELogFactory.getNormalLogger().info("iMapGnlTask::AsnSendAnsFrameCB, input para pReqMsg=null\n");
            return -1;
        }
        return TEGnlTask.asnSendAnsFrameCB(rsp, reqMsg, reqMsg.mheader.protocolVer);
    }

    protected static int asnSendAnsFrameCB(FStruct rsp, MSGPacketExt reqMsg, int protocolVer) {
        TEASN1CommMgr.sendMessage(rsp, TEASN1CommMgr.CreateMsgHead(reqMsg), reqMsg.mheader.cmdCode);
        return 0;
    }

    public void asnSendNBC(int recvProcID, int recvDeskID, int recvProcHandle, int recvModule, int cmdCode, FStruct req, int timeOut, TETaskTimeOutCBFP timeOutProc, int protocolVersion) {
        byte[] buffer = null;
        if (null != req) {
            buffer = TECommUtil.encode(req);
            if (buffer == null) {
                return;
            }
            if (buffer.length > TEAppMgr.maxiMAPMsgLen) {
                TELogFactory.getNormalLogger().error(String.format("Error: Request message too long! CmdCode = 0x%x\n", cmdCode));
                return;
            }
        }
        MSGPacketExt msg = new MSGPacketExt();
        msg.mheader.protocolVer = (byte)protocolVersion;
        msg.mheader.senderProcIP = 0;
        msg.mheader.senderDeskID = (char)TEAppMgr.appInstDeskID;
        msg.mheader.receiverDeskID = (char)recvDeskID;
        msg.mheader.senderProcHandle = SystemConfiguration.getProcHandler();
        msg.mheader.receiverProcHandle = (char)recvProcHandle;
        msg.mheader.senderProcID = SystemConfiguration.getProcID();
        msg.mheader.receiverProcID = (char)recvProcID;
        msg.mheader.cmdCode = cmdCode;
        msg.mheader.msgType = (byte)TEITaskMgrConts.MSG_TYPE.MSG_REQUEST_NBC.getValue();
        msg.mheader.cmdHandle = '\u0000';
        msg.mheader.senderCmdHandle = (char)this.taskMgrInst.allocReqID(this);
        msg.mheader.senderModule = (byte)this.taskMgrInst.taskMgrID;
        msg.mheader.receiverModule = (byte)recvModule;
        if (null != buffer) {
            msg.dataLength = buffer.length + 2;
        }
        this.imapCmdSendFrameCB(msg, timeOut, timeOutProc);
    }

    public void asnSendBC(int recvProcID, int recvModule, int cmdCode, FStruct req, int timeOut, TETaskTimeOutCBFP timeOutProc, int protocolVersion) {
        byte[] buffer = TECommUtil.encode(req);
        if (buffer == null) {
            return;
        }
        MSGPacketExt msg = new MSGPacketExt();
        msg.mheader.protocolVer = (byte)protocolVersion;
        msg.mheader.senderProcIP = 0;
        msg.mheader.senderDeskID = (char)TEAppMgr.appInstDeskID;
        msg.mheader.receiverDeskID = '\u0000';
        msg.mheader.senderProcHandle = SystemConfiguration.getProcHandler();
        msg.mheader.receiverProcHandle = '\u0000';
        msg.mheader.senderProcID = SystemConfiguration.getProcID();
        msg.mheader.receiverProcID = (char)recvProcID;
        msg.mheader.cmdCode = cmdCode;
        msg.mheader.msgType = (byte)TEITaskMgrConts.MSG_TYPE.MSG_REQUEST_BC.getValue();
        msg.mheader.cmdHandle = '\u0000';
        msg.mheader.senderCmdHandle = (char)this.taskMgrInst.allocReqID(this);
        msg.mheader.senderModule = (byte)this.taskMgrInst.taskMgrID;
        msg.mheader.receiverModule = (byte)recvModule;
        msg.dataLength = buffer.length + 2;
        this.imapCmdSendFrameCB(msg, timeOut, timeOutProc);
    }

    public boolean ssnSynSendCB(MSGHead msgHead, FStruct inAsn, FStruct outAsn, int timeOut) {
        if (null == msgHead || null == inAsn || null == outAsn) {
            TELogFactory.getNormalLogger().error("iMapGnlTask::AsnSynSendCB, input para pMsgHead=null or pInAsn=null or pOutAsn=null\n");
            return false;
        }
        byte[] buffer = TECommUtil.encode(inAsn);
        boolean ret = false;
        if (buffer != null) {
            if (buffer.length > TEAppMgr.maxiMAPMsgLen - 43 - 2) {
                return false;
            }
            msgHead.senderModule = (byte)this.taskMgrInst.taskMgrID;
            if (10 == msgHead.protocolVer) {
                MSGPacketExt msg = this.createMsg(msgHead, buffer);
                MSGPacketExt[] rspMsg = new MSGPacketExt[1];
                if (msg != null && this.imapCmdSynSendCB(msg, rspMsg, timeOut)) {
                    ret = TECommUtil.getASNData(rspMsg[0], outAsn);
                }
            } else if (11 == msgHead.protocolVer) {
                MSGPacketExt msg = this.createMsg(msgHead, buffer);
                MSGPacketExt[] rspMsg = new MSGPacketExt[1];
                if (msg != null && this.imapCmdSynSendCB(msg, rspMsg, timeOut)) {
                    ret = TECommUtil.getASNData(rspMsg[0], outAsn);
                }
            }
        }
        return ret;
    }

    public boolean asnSynRecv(FStruct asn, int timeOut) {
        if (null == asn) {
            TELogFactory.getNormalLogger().error("iMapGnlTask::AsnSynRecv, input para pAsn=null\n");
            return false;
        }
        MSGPacketExt[] cmdMsg = new MSGPacketExt[1];
        boolean ret = false;
        if (this.imapSynRecv(cmdMsg, timeOut, null, 0, 0)) {
            switch (cmdMsg[0].mheader.protocolVer) {
                case 10: {
                    ret = TECommUtil.getASNData(cmdMsg[0], asn);
                    break;
                }
                case 11: {
                    ret = TECommUtil.getASNData(cmdMsg[0], asn);
                    break;
                }
                default: {
                    ret = false;
                }
            }
        }
        return ret;
    }

    public MSGPacketExt createMsg(MSGHead msgHead, byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            TELogFactory.getNormalLogger().info("CmdMSG* CreateMsg() nBufLength is 0!\n");
        }
        if (null == msgHead) {
            TELogFactory.getNormalLogger().error("CmdMSG* CreateMsg() pMsgHead is NULL!\n");
            return null;
        }
        MSGPacketExt msg = new MSGPacketExt(msgHead, buffer);
        msg.dataLength = buffer.length + 2;
        msg.mheader.protocolVer = (byte)10;
        msg.mheader.senderDeskID = (char)TEAppMgr.appInstDeskID;
        msg.mheader.senderProcHandle = SystemConfiguration.getProcHandler();
        msg.mheader.senderProcID = SystemConfiguration.getProcID();
        return msg;
    }
}

