/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.taskmgr;

import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.consts.system.TESystemVariable;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.core.startup.SystemConfiguration;
import com.huawei.nglct.core.taskmgr.TEAppHandler;
import com.huawei.nglct.core.taskmgr.TEEventMsgHanler;
import com.huawei.nglct.core.taskmgr.TEHandleMsgBefDisp;
import com.huawei.nglct.core.taskmgr.TEITaskMgrConts;
import com.huawei.nglct.core.taskmgr.TEMdpConnMon;
import com.huawei.nglct.core.taskmgr.TEMessageBlock;
import com.huawei.nglct.core.taskmgr.TEMsgMonTask;
import com.huawei.nglct.core.taskmgr.TEReactor;
import com.huawei.nglct.core.taskmgr.TESSLMgr;
import com.huawei.nglct.core.taskmgr.TESysTask;
import com.huawei.nglct.core.taskmgr.TESystypes;
import com.huawei.nglct.core.taskmgr.TETask;
import com.huawei.nglct.core.taskmgr.TETaskCreater;
import com.huawei.nglct.core.taskmgr.TETaskMgr;
import com.huawei.nglct.core.taskmgr.TagMdpAddrInfo;
import com.huawei.nglct.util.string.TEResourceBundle;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TEAppMgr {
    public static String imapCommSubModule = "TMGR";
    public static boolean receiveSIGINT;
    public static int appInstDeskID;
    public static int appInstProcID;
    public static int appInstProcHandle;
    public static int maxiMAPMsgLen;
    public static final int IPADDRSTRING_LEN = 16;
    public static boolean appEventLoopRun;
    public TEReactor reactor;
    private String m_pConfigDir;
    private Object[] mdpAddr = new Object[2];
    private boolean m_bIsInitSucceed;
    protected static TEAppMgr instance;
    protected ReadWriteLock procInFuncMutex = new ReentrantReadWriteLock();
    protected TEEventMsgHanler procInFunc;
    protected TESysTask sysTask;
    protected TEAppHandler handler;
    protected String configDir;
    protected List<TETaskMgr> taskMgrs = new ArrayList<TETaskMgr>();
    protected Lock taskMgrsMutex = new ReentrantLock();
    protected String mdpIP;
    protected int timerID;
    protected String configItemName;
    protected long[] ularyCounters = new long[129];
    protected Lock mutexCounters = new ReentrantLock(true);
    protected StringBuffer initMsgBuf;
    protected boolean permitMultiProcess;
    protected TEMsgMonTask msgMonTask;
    protected Lock mutexMsgMonTask = new ReentrantLock(true);
    protected TEMdpConnMon mdpConnMon;
    protected Lock mutexMdpConnMon = new ReentrantLock(true);
    protected TEHandleMsgBefDisp funHandleMsgBefDisp;
    protected ReadWriteLock funHandleMsgBefDispMutex = new ReentrantReadWriteLock();
    protected boolean isInitSucceed;
    protected TEEventMsgHanler procBtwFunc;
    protected ReadWriteLock procBtwFuncMutex = new ReentrantReadWriteLock();
    protected TETaskCreater procInFactoryFunc;
    protected ReadWriteLock procInFactoryFuncMutex = new ReentrantReadWriteLock();
    protected TETaskCreater procBtwFactoryFunc;
    protected ReadWriteLock procBtwFactoryFuncMutex = new ReentrantReadWriteLock();

    private TEAppMgr() {
        try {
            this.reactor = new TEReactor(1);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("IMapAppMgr::IMapAppMgr(), failed to new Reactor");
        }
        try {
            this.sysTask = new TESysTask(this);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("IMapAppMgr::IMapAppMgr(), failed to new IMapSysTask");
        }
        this.handler = new TEAppHandler(this, null, false);
    }

    private TEAppMgr(TEAppMgr other) {
    }

    public static synchronized TEAppMgr instance() {
        if (instance == null) {
            instance = new TEAppMgr();
        }
        return instance;
    }

    public static void destroy() {
        if (receiveSIGINT) {
            TELogFactory.getNormalLogger().info("Receive SIGINT signal.\n");
        }
        instance.exitThreads();
        instance = null;
    }

    public void release() {
        this.configItemName = null;
        this.reactor.end_reactor_event_loop();
        if (this.handler != null) {
            this.reactor.cancel_timer(this.timerID);
            this.handler.release();
        }
        this.sysTask.release();
        Iterator<TETaskMgr> taskMgrIt = this.taskMgrs.iterator();
        TETaskMgr taskMgr = null;
        while (taskMgrIt.hasNext()) {
            taskMgr = taskMgrIt.next();
            if (taskMgr == null) continue;
            taskMgr.release();
        }
        this.taskMgrs.clear();
        this.reactor.release();
        TESSLMgr.destroy();
    }

    public boolean initProcessEnv(int usId, String logCfgItemName, boolean allowMultiProcess, int handle, TagMdpAddrInfo mdpAddrInfo) {
        this.configItemName = null == logCfgItemName || "".equals(logCfgItemName) ? "iMapLog" : logCfgItemName;
        if (null == this.reactor) {
            TELogFactory.getNormalLogger().error("IMapAppMgr.reactor is NULL");
            return false;
        }
        if (null == this.sysTask) {
            TELogFactory.getNormalLogger().error("IMapAppMgr.sysTask is NULL");
            return false;
        }
        int MIN_STATIC_PROC_HANDLE = 1;
        int MAX_STATIC_PROC_HANDLE = 10000;
        if (!TEAppMgr.setAppInstProcHandle(handle, MIN_STATIC_PROC_HANDLE, MAX_STATIC_PROC_HANDLE)) {
            return false;
        }
        TESystemVariable.setG_AppInstProcID(usId);
        this.permitMultiProcess = allowMultiProcess;
        String pBuf = System.getenv("IMAP");
        if (null == pBuf) {
            TELogFactory.getNormalLogger().error("Get envionment variable IMAP fail!");
            return false;
        }
        this.m_pConfigDir = pBuf = pBuf.trim();
        String striMapdotCfg = this.m_pConfigDir + "/imap.cfg";
        String striMapsecdotCfg = this.m_pConfigDir + "/imapsec.cfg";
        TESystemVariable.setG_iMapCfgFileName(striMapdotCfg);
        TEAppMgr.setSystemVariable(striMapdotCfg);
        String sResult = TEResourceBundle.getString(striMapdotCfg, "MDPAddress");
        if (null == sResult) {
            return false;
        }
        boolean bSSLMode = false;
        boolean bNMSSSLMode = false;
        int iResult = TEResourceBundle.getInt(striMapsecdotCfg, "SSLMode");
        if (-1 != iResult && 0 != iResult) {
            bNMSSSLMode = true;
            if (!this.handler.isLocalIP(sResult)) {
                bSSLMode = true;
            }
        }
        if (!this.loadIpAddrFromCfg(bSSLMode, this.mdpAddr)) {
            return false;
        }
        if (null != mdpAddrInfo) {
            this.mdpAddr[0] = mdpAddrInfo.strMDPIP;
            this.mdpAddr[1] = mdpAddrInfo.port;
            if (mdpAddrInfo.sslConnect) {
                bNMSSSLMode = false;
                bSSLMode = true;
            } else {
                bNMSSSLMode = true;
                bSSLMode = false;
            }
        }
        if (!TESSLMgr.instance().init(bNMSSSLMode, bSSLMode)) {
            return false;
        }
        this.handler = new TEAppHandler(this, this.mdpAddr, bSSLMode);
        SystemConfiguration.setProcID((char)usId);
        SystemConfiguration.setProcHandler((char)handle);
        SystemConfiguration.setCommObjectInfo(this.mdpAddr);
        TEASN1CommMgr.initCommService();
        this.m_bIsInitSucceed = true;
        return true;
    }

    private static boolean setAppInstProcHandle(int handle, int MIN_STATIC_PROC_HANDLE, int MAX_STATIC_PROC_HANDLE) {
        if (MIN_STATIC_PROC_HANDLE <= handle && MAX_STATIC_PROC_HANDLE >= handle) {
            appInstProcHandle = handle;
        } else if (0 != handle) {
            TELogFactory.getNormalLogger().error("Input ProcHandle is invalid;");
            return false;
        }
        return true;
    }

    private static void setSystemVariable(String striMapdotCfg) {
        int nTemp;
        float pResult;
        int iResult = TEResourceBundle.getInt(striMapdotCfg, "EnableAutoTaskThread");
        if (-1 != iResult) {
            boolean bl = TESystemVariable.g_bEnableAutoTaskThread = iResult > 0;
        }
        if (-1 != (iResult = TEResourceBundle.getInt(striMapdotCfg, "iMaxIncThrNum"))) {
            TESystemVariable.g_iMaxIncThrNum = iResult;
        }
        if (-1 != (iResult = TEResourceBundle.getInt(striMapdotCfg, "iMaxDecThrNum"))) {
            TESystemVariable.g_iMaxDecThrNum = iResult;
        }
        if (-1.0f != (pResult = TEResourceBundle.getFloat(striMapdotCfg, "fThrWaitVThrTotalOnInc"))) {
            TESystemVariable.g_fThrWaitVThrTotalOnInc = pResult;
        }
        if (-1.0f != (pResult = TEResourceBundle.getFloat(striMapdotCfg, "fTskReadyVThrTotalOnInc"))) {
            TESystemVariable.g_fTskReadyVThrTotalOnInc = pResult;
        }
        if (-1.0f != (pResult = TEResourceBundle.getFloat(striMapdotCfg, "fThrWaitVThrTotalOnDec"))) {
            TESystemVariable.g_fThrWaitVThrTotalOnDec = pResult;
        }
        if (-1.0f != (pResult = TEResourceBundle.getFloat(striMapdotCfg, "fTskReadyVThrTotalOnDec"))) {
            TESystemVariable.g_fTskReadyVThrTotalOnDec = pResult;
        }
        if (-1 != (nTemp = TEResourceBundle.getInt(striMapdotCfg, "iMapCounterEnable"))) {
            TESystemVariable.g_biMapCounterEnable = nTemp > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tmInsertTaskMgr(TETaskMgr taskMgr, boolean runTaskmgr) {
        if (null == taskMgr) {
            return;
        }
        if (runTaskmgr) {
            taskMgr.open();
        }
        this.taskMgrsMutex.lock();
        try {
            this.taskMgrs.add(taskMgr);
        }
        finally {
            this.taskMgrsMutex.unlock();
        }
    }

    public void tmDynInsertTaskMgr(TETaskMgr taskMgr) {
        this.tmInsertTaskMgr(taskMgr, false);
    }

    public boolean imapOutSendMsg(MSGPacketExt msg, int taskMgrID) {
        if (null == msg) {
            TELogFactory.getNormalLogger().error("iMapAppMgr::iMapOutSendMsg pMsg is null.");
            return false;
        }
        return this.sendOneMsgInside_i(msg, taskMgrID);
    }

    public boolean sendMSG(MSGPacketExt cmdMsg) {
        if (null == cmdMsg) {
            TELogFactory.getNormalLogger().info("iMapAppMgr::SendMSG pCmdMsg is null.");
            return false;
        }
        return this.sendOneMsg_i(cmdMsg);
    }

    public boolean imapSendSynMsgToMDP(MSGPacketExt sendMsg, MSGPacketExt respMsg, int totalTimeOut) {
        return false;
    }

    public boolean sendExitMsgToMDP() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.taskMgrsMutex.lock();
        try {
            TETaskMgr taskMgr2 = null;
            for (TETaskMgr taskMgr2 : this.taskMgrs) {
                if (taskMgr2 == null || taskMgr2.isOpen) continue;
                taskMgr2.open();
            }
        }
        finally {
            this.taskMgrsMutex.unlock();
        }
    }

    public void exitThreads() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TETaskMgr findTaskMgrByID(int taskMgrID) {
        this.taskMgrsMutex.lock();
        try {
            TETaskMgr taskMgr2 = null;
            for (TETaskMgr taskMgr2 : this.taskMgrs) {
                if (null == taskMgr2 || taskMgrID != taskMgr2.taskMgrID) continue;
                TETaskMgr tETaskMgr = taskMgr2;
                return tETaskMgr;
            }
        }
        finally {
            this.taskMgrsMutex.unlock();
        }
        return null;
    }

    public void releaseAllThread() {
        Iterator<TETaskMgr> it = this.taskMgrs.iterator();
        TETaskMgr taskMgr = null;
        while (it.hasNext()) {
            taskMgr = it.next();
            if (null == taskMgr) continue;
            taskMgr.releaseWaitingThread(taskMgr.threadNum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCounter(int counterID, long changeVal) {
        if (!TESystypes.mapCounterEnable) {
            return;
        }
        if (counterID < 0 || counterID > 128 || 0L == changeVal) {
            return;
        }
        this.mutexCounters.lock();
        try {
            if (changeVal < 0L && -changeVal >= this.ularyCounters[counterID]) {
                this.ularyCounters[counterID] = 0L;
            } else {
                int n = counterID;
                this.ularyCounters[n] = this.ularyCounters[n] + changeVal;
            }
        }
        finally {
            this.mutexCounters.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCounter(int counterID, long value) {
        if (!TESystypes.mapCounterEnable) {
            return;
        }
        if (counterID < 0 || counterID > 128) {
            return;
        }
        this.mutexCounters.lock();
        try {
            this.ularyCounters[counterID] = value;
        }
        finally {
            this.mutexCounters.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCounterValue(int counterID, boolean reset) {
        long ret = 0L;
        if (!TESystypes.mapCounterEnable) {
            return 0L;
        }
        if (counterID < 0 || counterID > 128) {
            return 0L;
        }
        this.mutexCounters.lock();
        try {
            ret = this.ularyCounters[counterID];
            if (reset) {
                this.ularyCounters[counterID] = 0L;
            }
        }
        finally {
            this.mutexCounters.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TETask getCurrentTask() {
        this.taskMgrsMutex.lock();
        try {
            for (TETaskMgr taskMgr : this.taskMgrs) {
                TETask task;
                if (null == taskMgr || null == (task = taskMgr.getCurrentTask())) continue;
                TETask tETask = task;
                return tETask;
            }
        }
        finally {
            this.taskMgrsMutex.unlock();
        }
        return null;
    }

    public boolean isMultiprocess() {
        return this.permitMultiProcess;
    }

    public boolean isConnectedMdp() {
        return true;
    }

    public boolean startMsgMonitor(TEMsgMonTask task) {
        return false;
    }

    public TEMsgMonTask stopMsgMontor() {
        return null;
    }

    public boolean startMdpConnMonitor(TEMdpConnMon mon) {
        return false;
    }

    public void stopMdpConnMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setPreHandleMsgFunc(TEHandleMsgBefDisp func) {
        this.funHandleMsgBefDispMutex.writeLock().lock();
        try {
            this.funHandleMsgBefDisp = func;
        }
        finally {
            this.funHandleMsgBefDispMutex.writeLock().unlock();
        }
        return 0;
    }

    public TEHandleMsgBefDisp getPreHandleMsgFunc() {
        TEHandleMsgBefDisp befDisp = null;
        this.funHandleMsgBefDispMutex.readLock().lock();
        befDisp = this.funHandleMsgBefDisp;
        this.funHandleMsgBefDispMutex.readLock().unlock();
        return befDisp;
    }

    public boolean isInit() {
        return this.m_bIsInitSucceed;
    }

    public boolean sendOneMsg_i(MSGPacketExt cmdMsg) {
        if (null == cmdMsg) {
            TELogFactory.getNormalLogger().error("iMapAppMgr::SendOneMsg_i pCmdMsg is null.");
            return false;
        }
        if (TESystypes.imapIsExit()) {
            return false;
        }
        if (43 + cmdMsg.dataLength > TESystypes.imapGetMsgMaxLen()) {
            TELogFactory.getNormalLogger().error("iMapTask::SendOneMsg_i message length is more than max length.");
            return false;
        }
        if (SystemConfiguration.getProcID() == cmdMsg.mheader.receiverProcID && SystemConfiguration.getProcHandler() == cmdMsg.mheader.receiverProcHandle && SystemConfiguration.getProcHandler() != '\u0000' && TEITaskMgrConts.MSG_TYPE.MSG_REQUEST_BC.getValue() != cmdMsg.mheader.msgType && TEITaskMgrConts.MSG_TYPE.MSG_RESPONSE_BC.getValue() != cmdMsg.mheader.msgType) {
            return this.sendOneMsgInside_i(cmdMsg, cmdMsg.mheader.receiverModule);
        }
        if (!this.isConnectedMdp()) {
            TELogFactory.getNormalLogger().info("iMapTask::SendOneMsg_i send msg fail, IsConnectedMdp return false.");
            this.handleSendMsgFail(cmdMsg, 5);
            return false;
        }
        TEMessageBlock mb = new TEMessageBlock(cmdMsg);
        long timeout = System.currentTimeMillis() + 5000L;
        int ret = 0;
        if (null != this.sysTask) {
            ret = this.sysTask.putq(mb, timeout);
        }
        if (-1 == ret) {
            TELogFactory.getNormalLogger().error(String.format("iMapAppMgr::SendOneMsg_i, Enqueue msg in iMapSysTask fail. msg CmdCode=%d discard", cmdMsg.mheader.cmdCode));
            return false;
        }
        return true;
    }

    private void notifyMsgMonTask(MSGPacketExt msg, boolean isNetSerial) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int regEventMsgHandler(int type, TEEventMsgHanler func) {
        if (null == func) {
            TELogFactory.getNormalLogger().error("iMapAppMgr::RegEventMsgHandler pFunc is null.");
            return 1;
        }
        if (0 == type) {
            this.procInFuncMutex.writeLock().lock();
            try {
                this.procInFunc = func;
            }
            finally {
                this.procInFuncMutex.writeLock().unlock();
            }
            TELogFactory.getNormalLogger().info("iMapAppMgr::RegEventMsgHandler set m_pProcInFunc=0x." + func.getClass().getName());
            return 0;
        }
        if (1 == type) {
            this.procBtwFuncMutex.writeLock().lock();
            try {
                this.procBtwFunc = func;
            }
            finally {
                this.procBtwFuncMutex.writeLock().unlock();
            }
            TELogFactory.getNormalLogger().info("iMapAppMgr::RegEventMsgHandler set m_pProcBtwFunc=0x." + func.getClass().getName());
            return 0;
        }
        TELogFactory.getNormalLogger().error("iMapAppMgr::RegEventMsgHandler iType is error.");
        return 1;
    }

    private boolean sendOneMsgInside_i(MSGPacketExt msg, int taskmgrID) {
        if (TESystypes.imapIsExit()) {
            return false;
        }
        this.notifyMsgMonTask(msg, false);
        TETaskMgr taskMgr = this.findTaskMgrByID(taskmgrID);
        if (null != taskMgr) {
            int ret = taskMgr.dispatch(msg);
            if (0 > ret) {
                String str = TEStringUtils.snprintf(1024, "iMapAppMgr::SendOneMsgInside_i taskmgr dispatch msg fail. CmdCode=%d, TaskmgrID=%d ,msg discard.", msg.mheader.cmdCode, taskmgrID);
                TELogFactory.getNormalLogger().error(str);
                return false;
            }
            return true;
        }
        String str = TEStringUtils.snprintf(1024, "iMapAppMgr::SendOneMsgInside_i, get taskmgr fail. CmdCode = %d, TaskmgrID=%d, msg discard.", msg.mheader.cmdCode, taskmgrID);
        TELogFactory.getNormalLogger().error(str);
        return false;
    }

    private int handleSendMsgFail(MSGPacketExt reqMsg, int errCode) {
        return 0;
    }

    private boolean loadIpAddrFromCfg(boolean bCurProcCommMode, Object[] mdpAddr) {
        String pIPAddr = TEResourceBundle.getString(TESystemVariable.iMapGetCfgFileName(), "MDPAddress");
        if (null == pIPAddr) {
            return false;
        }
        if (pIPAddr.length() >= 16) {
            return false;
        }
        this.mdpIP = pIPAddr;
        int pPort = 0;
        if (bCurProcCommMode ? -1 == (pPort = TEResourceBundle.getInt(TESystemVariable.iMapGetCfgFileName(), "MDPSSLPort")) : -1 == (pPort = TEResourceBundle.getInt(TESystemVariable.iMapGetCfgFileName(), "MDPPort"))) {
            return false;
        }
        mdpAddr[0] = pIPAddr;
        mdpAddr[1] = pPort;
        return true;
    }

    static {
        maxiMAPMsgLen = 65535;
        appEventLoopRun = false;
    }
}

