/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.taskmgr;

import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.core.mdp.TENoticeReceiver;
import com.huawei.nglct.core.startup.SystemConfiguration;
import com.huawei.nglct.core.taskmgr.TEAppMgr;
import com.huawei.nglct.core.taskmgr.TEITaskMgrConts;
import com.huawei.nglct.core.taskmgr.TESystypes;
import com.huawei.nglct.core.taskmgr.TETaskMgr;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnNullReq;
import com.huawei.nglct.util.string.TEStringUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import net.commustru.fstru.FStruct;

public class TEAppHandler
extends TENoticeReceiver {
    protected TEAppMgr appMgr;

    TEAppHandler(TEAppMgr appMgr, Object[] addr, boolean sslMode) {
        this.appMgr = appMgr;
    }

    public void release() {
    }

    public boolean getConnCloseFlag() {
        return true;
    }

    @Override
    public byte handleNotice(int cmdCode, MSGPacketExt msg) {
        TESystypes.imapRegArriveMsgTime(msg);
        return (byte)this.handle_input(cmdCode, msg);
    }

    public int handle_input(int cmdCode, MSGPacketExt msg) {
        return this.processFrame(cmdCode, msg);
    }

    protected int processFrame(int cmdCode, MSGPacketExt msg) {
        int dispResult;
        if (TEITaskMgrConts.MSG_TYPE.MSG_EXIT.getValue() == msg.mheader.msgType) {
            TELogFactory.getNormalLogger().info(String.format("Receive EXIT MSG. SIP=%08x,CMD=%u,SPID=%d,SPH=%d,SCM=%d\n", msg.mheader.senderProcID, msg.mheader.cmdCode, (int)msg.mheader.senderProcID, (int)msg.mheader.senderProcHandle, Character.valueOf(msg.mheader.senderCmdHandle)));
            TESystypes.setSystemExited(true);
            this.handle_signal(2);
            return 0;
        }
        if (TEITaskMgrConts.MSG_TYPE.MSG_SEND_ANSWERFRAME.getValue() == msg.mheader.msgType) {
            return 0;
        }
        if (TEITaskMgrConts.MSG_TYPE.MSG_GET_SVR_STATE.getValue() == msg.mheader.msgType) {
            MSGHead msgHead = new MSGHead();
            msgHead.protocolVer = msg.mheader.protocolVer;
            msgHead.senderProcIP = 0;
            msgHead.senderDeskID = (char)TEAppMgr.appInstDeskID;
            msgHead.receiverDeskID = msg.mheader.senderDeskID;
            msgHead.senderProcHandle = SystemConfiguration.getProcHandler();
            msgHead.receiverProcHandle = msg.mheader.senderProcHandle;
            msgHead.senderProcID = SystemConfiguration.getProcID();
            msgHead.receiverProcID = msg.mheader.senderProcID;
            msgHead.cmdCode = msg.mheader.cmdCode;
            msgHead.msgType = (byte)TEITaskMgrConts.MSG_TYPE.MSG_RESPONSE_BC.getValue();
            msgHead.senderCmdHandle = '\u0000';
            msgHead.cmdHandle = msg.mheader.senderCmdHandle;
            msgHead.senderModule = 0;
            msgHead.receiverModule = msg.mheader.senderModule;
            TEASN1CommMgr.sendMessage((FStruct)new AsnNullReq(), msgHead, msg.mheader.cmdCode);
            return 0;
        }
        if (0 != msg.mheader.protocolVer && 10 != msg.mheader.protocolVer && 11 != msg.mheader.protocolVer) {
            TELogFactory.getNormalLogger().error("Protocol version error!");
            return -1;
        }
        this.appMgr.funHandleMsgBefDispMutex.readLock().lock();
        if (null != this.appMgr.funHandleMsgBefDisp && 0 == (dispResult = this.appMgr.funHandleMsgBefDisp.beforeDispatch(msg))) {
            TELogFactory.getAsn1Logger().info(String.format("Not need dispatch,SPID=%d,CMD=%d", Character.valueOf(msg.mheader.senderProcID), msg.mheader.cmdCode));
            this.appMgr.funHandleMsgBefDispMutex.readLock().unlock();
            return 0;
        }
        this.appMgr.funHandleMsgBefDispMutex.readLock().unlock();
        byte mgrID = msg.mheader.receiverModule;
        TETaskMgr taskMgr = this.appMgr.findTaskMgrByID(mgrID);
        if (null != taskMgr) {
            int ret = taskMgr.dispatch(msg);
            if (0 > ret) {
                if (-1 == this.sendDispatchFailMsg(msg)) {
                    TELogFactory.getCommuLogger().error("iMapAppHandler::ProcessFrame invoke SendDispatchFailMsg return TMGR_FAIL");
                }
                String desc = TEStringUtils.strncpy(String.format("ProcessFrame, CMD=%d, TaskmgrID=%d, TaskID=%d, Disptch fail!\n", msg.mheader.cmdCode, mgrID, Character.valueOf(msg.mheader.cmdHandle)), 1024);
                TELogFactory.getCommuLogger().debug(desc);
            }
        } else {
            if (-1 == this.sendDispatchFailMsg(msg)) {
                TELogFactory.getCommuLogger().error("iMapAppHandler::ProcessFrame invoke SendDispatchFailMsg return TMGR_FAIL");
            }
            String desc = TEStringUtils.strncpy(String.format("ProcessFrame, CMD=%d, TaskmgrID=%d, not found taskmgr!\n", msg.mheader.cmdCode, mgrID), 255);
            TELogFactory.getCommuLogger().error(desc);
        }
        return 0;
    }

    protected int handle_signal(int signum) {
        switch (signum) {
            case 2: {
                TESystypes.setSystemExited(true);
                TEAppMgr.receiveSIGINT = true;
                break;
            }
        }
        return 0;
    }

    public boolean isLocalIP(String pStrAddr) {
        if (null == pStrAddr || "".equals(pStrAddr)) {
            TELogFactory.getNormalLogger().info("IMapAppHandler.isLocalIP:Input param is null!");
            return false;
        }
        if (pStrAddr.length() >= "127.0.0.1".length() && pStrAddr.startsWith("127.0.0")) {
            return true;
        }
        String strAddr = pStrAddr;
        int index = strAddr.indexOf(":");
        if (index > 0) {
            strAddr = strAddr.substring(0, index);
        }
        String szIPAddr = "";
        String szHostName = "";
        try {
            InetAddress addr2 = null;
            szHostName = InetAddress.getLocalHost().getHostName();
            InetAddress[] addresses = InetAddress.getAllByName(szHostName);
            if (null != addresses) {
                for (InetAddress addr2 : addresses) {
                    szIPAddr = addr2.getHostAddress();
                    if (szIPAddr.length() != strAddr.length() || !szIPAddr.equals(strAddr)) continue;
                    return true;
                }
            }
        }
        catch (UnknownHostException e) {
            TELogFactory.getNormalLogger().error("IMapAppHandler.isLocalIP:Get host info failed! Please check your system.");
        }
        return false;
    }

    protected int sendDispatchFailMsg(MSGPacketExt reqMsg) {
        if (TEITaskMgrConts.MSG_TYPE.MSG_REQUEST_BC.getValue() != reqMsg.mheader.msgType && TEITaskMgrConts.MSG_TYPE.MSG_RESPONSE_BC.getValue() != reqMsg.mheader.msgType && TEITaskMgrConts.MSG_TYPE.MSG_REQUEST_NBC.getValue() != reqMsg.mheader.msgType && TEITaskMgrConts.MSG_TYPE.MSG_RESPONSE_NBC.getValue() != reqMsg.mheader.msgType) {
            return 0;
        }
        MSGPacketExt rspMsg = new MSGPacketExt();
        rspMsg.mheader.protocolVer = reqMsg.mheader.protocolVer;
        rspMsg.mheader.senderProcIP = 0;
        rspMsg.mheader.senderDeskID = (char)TEAppMgr.appInstDeskID;
        rspMsg.mheader.receiverDeskID = reqMsg.mheader.senderDeskID;
        rspMsg.mheader.senderProcHandle = SystemConfiguration.getProcHandler();
        rspMsg.mheader.receiverProcHandle = reqMsg.mheader.senderProcHandle;
        rspMsg.mheader.senderProcID = SystemConfiguration.getProcID();
        rspMsg.mheader.receiverProcID = reqMsg.mheader.senderProcID;
        rspMsg.mheader.cmdCode = reqMsg.mheader.cmdCode;
        rspMsg.mheader.msgType = (byte)TEITaskMgrConts.MSG_TYPE.MSG_DISPFAIL_RSP.getValue();
        rspMsg.mheader.senderCmdHandle = '\u0000';
        rspMsg.mheader.cmdHandle = reqMsg.mheader.senderCmdHandle;
        rspMsg.mheader.senderModule = 0;
        rspMsg.mheader.receiverModule = reqMsg.mheader.senderModule;
        rspMsg.mheader.errCode = (char)4;
        TESystypes.imapMsgSetSn(rspMsg, TESystypes.imapMsgGetSn(reqMsg));
        TEASN1CommMgr.sendMessage((FStruct)new AsnNullReq(), rspMsg.mheader, rspMsg.mheader.cmdCode);
        return 0;
    }
}

