/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.startup;

import com.huawei.nglct.core.startup.TEWNEMgrJniLogFactory;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import org.slf4j.Logger;

public final class TEWNEMgrJniDllLoader {
    private static Logger embededWnemgrlog = TEWNEMgrJniLogFactory.getLogger(TEWNEMgrJniDllLoader.class.getName());
    private static final String NULL = "null";
    private static final String EMPTYSTRING = "";
    private static volatile boolean loaded = false;
    private static final String JNI_DLLNAME_KEY = "cnemgr.version.name";

    private TEWNEMgrJniDllLoader() {
    }

    public static synchronized void loadWNEMgrDll() {
        if (loaded) {
            embededWnemgrlog.info("***************** already loaded, return *****************");
            return;
        }
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            embededWnemgrlog.info("***************** NOT IN INTEGRATED MODE, RETURN ******************");
            return;
        }
        embededWnemgrlog.info("***************** begin to load dll *****************");
        String dllName = System.getProperty(JNI_DLLNAME_KEY);
        embededWnemgrlog.info("dll name ->" + dllName);
        if (TEWNEMgrJniDllLoader.isValidDllName(dllName)) {
            loaded = true;
            try {
                System.loadLibrary(dllName);
            }
            catch (Throwable e) {
                embededWnemgrlog.info(EMPTYSTRING, e);
                embededWnemgrlog.info("***************** FAILED to load dll *****************");
                loaded = false;
                return;
            }
            embededWnemgrlog.info("***************** succeeded to load dll *****************");
        } else {
            embededWnemgrlog.info("********************* ERROR, invalid DLL name ->" + dllName);
        }
    }

    private static boolean isValidDllName(String dllName) {
        String newDllName;
        if (null == dllName) {
            dllName = EMPTYSTRING;
        }
        return !EMPTYSTRING.equals(newDllName = dllName.trim()) && !NULL.equals(newDllName);
    }
}

