/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.startup;

import com.huawei.nglct.consts.system.TESystemVariable;
import com.huawei.nglct.util.string.TEResourceBundle;

public class TEDefaultDBServer {
    public static final int RWDB_AL_ODBC = 1;
    public static final int RWDB_AL_INFORMIX = 2;
    public static final int RWDB_AL_MSSQL = 3;
    public static final int RWDB_AL_DB2 = 4;
    public static final int RWDB_AL_ORACLE = 5;
    public static final int RWDB_AL_ORACLE8 = 6;
    public static final int RWDB_AL_SYBASECT = 7;
    public static final int RWDB_AL_ORACLE9 = 8;
    public static final int RWDB_AL_UNUSED = 9;
    public static final int RWDB_AL_MEMORIEDDB = 10;
    private int m_DBMSType;
    private String m_AccessLib;
    private String m_ServerName;
    private String m_LoginUser;
    private String m_LoginPassword;
    private static TEDefaultDBServer m_instance = null;

    private TEDefaultDBServer() {
        this.init();
    }

    public static synchronized TEDefaultDBServer getInstance() {
        if (null == m_instance) {
            m_instance = new TEDefaultDBServer();
        }
        return m_instance;
    }

    private boolean init() {
        String pCfgFilePath = TESystemVariable.iMapGetCfgFileName();
        if (null == pCfgFilePath || "".equals(pCfgFilePath)) {
            return false;
        }
        int dbmsType = TEResourceBundle.getInt(pCfgFilePath, "SSDatabaseType");
        if (-1 == dbmsType) {
            return false;
        }
        if (dbmsType == 0) {
            this.m_DBMSType = 7;
        } else if (dbmsType == 1) {
            this.m_DBMSType = 3;
        } else if (dbmsType == 2) {
            this.m_DBMSType = 5;
        }
        String strValue = TEResourceBundle.getString(pCfgFilePath, "DBtools");
        if (null == strValue) {
            return false;
        }
        this.m_AccessLib = strValue;
        strValue = TEResourceBundle.getString(pCfgFilePath, "SSServerName");
        if (null == strValue) {
            return false;
        }
        this.m_ServerName = strValue;
        strValue = TEResourceBundle.getString(pCfgFilePath, "SSUserName");
        if (null == strValue) {
            return false;
        }
        this.m_LoginUser = strValue;
        strValue = TEResourceBundle.getString(pCfgFilePath, "SSPasswd");
        return null != strValue;
    }

    public int getDBMSType() {
        return this.m_DBMSType;
    }

    public String getAccessLib() {
        return this.m_AccessLib;
    }

    public String getServerName() {
        return this.m_ServerName;
    }

    public String getLoginUser() {
        return this.m_LoginUser;
    }

    public String getLoginPassword() {
        return this.m_LoginPassword;
    }
}

