/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.reliableevent;

import com.huawei.communicate.util.asn.AsnCoder;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.event.Event;
import com.huawei.nglct.core.reliableevent.TEICreateTaskFunc;
import com.huawei.nglct.core.reliableevent.TEIEventStateListener;
import com.huawei.nglct.core.reliableevent.TEReliableEventHandler;
import com.huawei.nglct.core.reliableevent.TEReliableEventJniParaReq;
import com.huawei.nglct.core.reliableevent.TEReliableEventJniParaRsp;
import com.huawei.nglct.core.reliableevent.TEReliableEventJniUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class TEReliableEventMgr {
    private static TEReliableEventMgr instance = new TEReliableEventMgr();
    private Map<Integer, List<TEReliableEventHandler>> eventHandlerTrack = new HashMap<Integer, List<TEReliableEventHandler>>();

    private TEReliableEventMgr() {
    }

    public static synchronized TEReliableEventMgr getInstance() {
        if (null == instance) {
            instance = new TEReliableEventMgr();
        }
        return instance;
    }

    public void registerEventState(TEIEventStateListener lst) {
    }

    public void unRegisterEventState(TEIEventStateListener lst) {
    }

    public int send(int eventID, FStruct pEventContext) {
        return this.send(eventID, 0, pEventContext);
    }

    public int send(int eventID, int neID, FStruct pEventContext) {
        int cmd = 2256897;
        int tunnel = 0;
        return this.send(eventID, neID, pEventContext, tunnel, cmd);
    }

    public int send(int eventID, int neID, FStruct pEventContext, int cmd) {
        int tunnel = 0;
        return this.send(eventID, neID, pEventContext, tunnel, cmd);
    }

    public int send(int eventID, int neID, FStruct eventContext, int tunnelID, int cmd) {
        if (null == eventContext) {
            return -1;
        }
        return this.sendImpl(eventID, eventContext, tunnelID, cmd);
    }

    private int sendImpl(int eventID, FStruct pEventContext, int tunnelID, int cmd) {
        TEReliableEventJniParaReq request = new TEReliableEventJniParaReq();
        request.eventId = eventID;
        request.cParam = 0;
        TEReliableEventJniParaRsp response = new TEReliableEventJniParaRsp();
        try {
            request.data = AsnCoder.serialize((FStruct)pEventContext);
        }
        catch (FStruException e) {
            TELogFactory.getNormalLogger().error("TEReliableEventMgr.sendImpl() fail!", (Throwable)e);
        }
        TEReliableEventJniUtil.sendEventMsgEx(request, response);
        return response.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean subscibeEvent(TEReliableEventHandler handler, int eventId) {
        Integer key = eventId;
        Map<Integer, List<TEReliableEventHandler>> map = this.eventHandlerTrack;
        synchronized (map) {
            List<TEReliableEventHandler> eventHandlers = this.eventHandlerTrack.get(key);
            if (eventHandlers == null) {
                eventHandlers = new ArrayList<TEReliableEventHandler>();
                this.eventHandlerTrack.put(key, eventHandlers);
            }
            eventHandlers.add(handler);
        }
        return true;
    }

    public int init(TEICreateTaskFunc taskCreater, boolean autoSync, int syncTaskMgr, int syncTime) {
        return 0;
    }

    public void onReceiveEvent(TEReliableEventJniParaReq request, TEReliableEventJniParaRsp response) {
        int ret;
        if (null == response) {
            response = new TEReliableEventJniParaRsp();
        }
        response.result = -1;
        if (null == request) {
            return;
        }
        int eventID = request.eventId;
        byte[] eventContext = request.data;
        Event event = new Event(eventID, request.cParam, eventContext);
        List<TEReliableEventHandler> handlerList = this.getEventHandler(eventID);
        response.result = ret = this.handleEvent(handlerList, event);
    }

    private int handleEvent(List<TEReliableEventHandler> handlerList, Event event) {
        if (null == handlerList || 0 == handlerList.size() || null == event) {
            return -1;
        }
        for (TEReliableEventHandler handle : handlerList) {
            handle.handleEvent(event);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TEReliableEventHandler> getEventHandler(int eventID) {
        Map<Integer, List<TEReliableEventHandler>> map = this.eventHandlerTrack;
        synchronized (map) {
            if (null == this.eventHandlerTrack || this.eventHandlerTrack.isEmpty()) {
                return null;
            }
            return this.eventHandlerTrack.get(eventID);
        }
    }
}

