/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.reliableevent;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.mdp.TECommUtil;
import com.huawei.nglct.core.reliableevent.EventTarget;
import com.huawei.nglct.core.reliableevent.TEReliableEvent;
import com.huawei.nglct.core.startup.SystemConfiguration;
import com.huawei.nglct.db.TECommonDaoService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEReliableDBRW_Proxy {
    private int MAX_BLOB_SIZE = 1212416;
    protected Map<Integer, List<EventTarget>> reliableEventSubMap = new HashMap<Integer, List<EventTarget>>();
    private static TEReliableDBRW_Proxy instance = new TEReliableDBRW_Proxy();

    public static TEReliableDBRW_Proxy getInstance() {
        return instance;
    }

    private void releaseConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.commit();
                conn.close();
            }
            catch (SQLException e) {
                TELogFactory.getNormalLogger().error("TEReliableDBRW_Proxy.releaseConnection() fail!", (Throwable)e);
            }
        }
    }

    public Connection getMCDBConnection() {
        Connection connection = TECommonDaoService.getMCDBConn();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSubscribEvents() {
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = this.getMCDBConnection();
            String querySql = "SELECT * FROM MCDB..tbl_SubscribEvent";
            pstmt = conn.prepareStatement(querySql);
            ResultSet rs = pstmt.executeQuery();
            int tmpEventID = 0;
            EventTarget tmpEventTag = null;
            while (rs.next()) {
                tmpEventID = rs.getInt(1);
                tmpEventTag = new EventTarget();
                tmpEventTag.m_RecvProcID = rs.getInt(2);
                tmpEventTag.m_RecvProcHandle = rs.getInt(3);
                tmpEventTag.m_RecvTaskMgrID = rs.getInt(4);
                List<EventTarget> listrs = this.reliableEventSubMap.get(tmpEventID);
                if (listrs == null) {
                    listrs = new ArrayList<EventTarget>(2);
                    this.reliableEventSubMap.put(tmpEventID, listrs);
                }
                listrs.add(tmpEventTag);
            }
        }
        catch (SQLException e) {
            TELogFactory.getNormalLogger().error("TEReliableDBRW_Proxy.getSubscribEvents() fail!", (Throwable)e);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    TELogFactory.getNormalLogger().error("TEReliableDBRW_Proxy close statement fail!", (Throwable)e);
                }
            }
            this.releaseConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getEvents(Set setBlockTunnelID) {
        ArrayList<TEReliableEvent> events = new ArrayList<TEReliableEvent>();
        CallableStatement cstmt = null;
        Connection conn = this.getMCDBConnection();
        String procname = "MCDB..t2ksp_GetEvents(?,?,?,?)";
        try {
            cstmt = conn.prepareCall(procname);
            cstmt.setInt(1, (int)SystemConfiguration.getProcID());
            cstmt.setInt(2, (int)SystemConfiguration.getProcHandler());
            cstmt.setInt(3, 0);
            cstmt.setInt(4, 0);
            ResultSet result = cstmt.executeQuery();
            int lastsn = 0;
            while (result.next()) {
                Blob blob;
                int serial = result.getInt("Serial");
                int packetno = result.getInt("PacketNO");
                int iTmpTunnelID = result.getInt("TunnelID");
                if (setBlockTunnelID.contains(iTmpTunnelID) && serial != lastsn) {
                    events.add(new TEReliableEvent());
                    lastsn = serial;
                }
                TEReliableEvent tmpEvent = (TEReliableEvent)events.get(events.size() - 1);
                if (packetno < 2) {
                    tmpEvent.eventID = result.getInt("");
                    tmpEvent.m_ProcID = result.getInt("");
                    tmpEvent.m_ProcHandle = result.getInt("");
                    blob = result.getBlob("");
                    TECommUtil.decode(blob.getBytes(0L, (int)blob.length()), tmpEvent.eventContext);
                    tmpEvent.m_TryCount = result.getInt("");
                    tmpEvent.eventState = result.getInt("");
                    continue;
                }
                blob = result.getBlob("");
                byte[] eventByte = TECommUtil.encode(tmpEvent.eventContext);
                byte[] context = new byte[eventByte.length + (int)blob.length()];
                System.arraycopy(eventByte, 0, context, 0, eventByte.length);
                System.arraycopy(blob.getBytes(0L, (int)blob.length()), 0, context, eventByte.length, (int)blob.length());
                TECommUtil.decode(context, tmpEvent.eventContext);
            }
            ArrayList<TEReliableEvent> serial = events;
            return serial;
        }
        catch (SQLException e) {
            TELogFactory.getNormalLogger().error("TEReliableDBRW_Proxy.getEvents() fail!", (Throwable)e);
            List list = null;
            return list;
        }
        finally {
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                TELogFactory.getNormalLogger().error("TEReliableDBRW_Proxy.getEvents() fail!", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receiveEvent(TEReliableEvent event, int result) {
        CallableStatement cstmt = null;
        Connection conn = this.getMCDBConnection();
        String procname = "MCDB.t2ksp_RecvEvent(?,?,?,?,?)";
        try {
            cstmt = conn.prepareCall(procname);
            cstmt.setInt(1, event.m_Serial);
            cstmt.setInt(2, event.m_ProcID);
            cstmt.setInt(3, event.m_ProcHandle);
            cstmt.setInt(4, result);
            cstmt.setInt(5, 0);
            boolean status = cstmt.execute();
            if (!status) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            TELogFactory.getNormalLogger().error("TEReliableDBRW_Proxy.receiveEvent() fail!", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                TELogFactory.getNormalLogger().error("TEReliableDBRW_Proxy.receiveEvent() fail!", (Throwable)e);
            }
        }
    }

    public Map<Integer, List<EventTarget>> getSubcribeEventMap() {
        this.reliableEventSubMap.clear();
        this.getSubscribEvents();
        return this.reliableEventSubMap;
    }

    public int send(TEReliableEvent event) {
        byte[] eventByte = TECommUtil.encode(event.eventContext);
        if (eventByte.length > this.MAX_BLOB_SIZE) {
            return this.sendEventMultiPacket(event);
        }
        return this.sendEventSinglePacket(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendEventMultiPacket(TEReliableEvent event) {
        byte[] eventByte = TECommUtil.encode(event.eventContext);
        int pos = 0;
        int length = eventByte.length;
        int serial = -1;
        int packetNo = 0;
        while (pos < eventByte.length) {
            int packetLen = length - pos;
            if (packetLen > this.MAX_BLOB_SIZE) {
                packetLen = this.MAX_BLOB_SIZE;
            }
            Connection conn = null;
            boolean bGetSerial = false;
            try {
                conn = this.getMCDBConnection();
                conn.setCatalog("MCDB");
                String sql = "Insert into tbl_EventBuffer(EventID,SenderProcID,SenderProcHandle,EventContext,EventState,PacketNO,TunnelID";
                if (bGetSerial) {
                    sql = sql + ", FirstPacketSN";
                }
                sql = sql + ") ";
                sql = sql + " VALUES(?,?,?,?,?,?,?";
                if (bGetSerial) {
                    sql = sql + ",?";
                }
                sql = sql + ") ";
                pos += packetLen;
                PreparedStatement pstmt = conn.prepareStatement(sql);
                pstmt.setInt(1, event.eventID);
                pstmt.setInt(2, event.senderProcID);
                pstmt.setInt(3, event.senderProcHandle);
                ByteArrayInputStream is = new ByteArrayInputStream(eventByte);
                pstmt.setBinaryStream(4, (InputStream)is, eventByte.length);
                pstmt.setInt(5, 0);
                pstmt.setInt(6, packetNo);
                pstmt.setInt(7, 0);
                pstmt.setInt(8, serial);
                pstmt.executeUpdate();
                ResultSet rs = pstmt.getResultSet();
                if (rs != null && rs.next()) {
                    serial = rs.getInt(1);
                    bGetSerial = true;
                    rs.close();
                }
                pstmt.close();
            }
            catch (SQLException e) {
                TELogFactory.getNormalLogger().error("TEReliableDBRW_Proxy.sendEventMultiPacket() fail!", (Throwable)e);
            }
            finally {
                this.releaseConnection(conn);
            }
        }
        return serial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendEventSinglePacket(TEReliableEvent event) {
        Connection conn = null;
        int serail = -1;
        try {
            byte[] eventByte = TECommUtil.encode(event.eventContext);
            conn = this.getMCDBConnection();
            conn.setCatalog("MCDB");
            String sql = "INSERT INTO tbl_EventBuffer(EventID,SenderProcID,SenderProcHandle,EventContext,EventState,TunnelID) VALUES(?,?,?,?,?,?)";
            PreparedStatement pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, event.eventID);
            pstmt.setInt(2, event.senderProcID);
            pstmt.setInt(3, event.senderProcHandle);
            ByteArrayInputStream is = new ByteArrayInputStream(eventByte);
            pstmt.setBinaryStream(4, (InputStream)is, eventByte.length);
            pstmt.setInt(5, event.eventState);
            pstmt.setInt(6, 0);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            if (rs != null && rs.next()) {
                serail = rs.getInt(1);
                rs.close();
            }
            pstmt.close();
            this.releaseConnection(conn);
        }
        catch (SQLException e) {
            try {
                TELogFactory.getNormalLogger().error("TEReliableDBRW_Proxy.sendEventSinglePacket() fail!", (Throwable)e);
                this.releaseConnection(conn);
            }
            catch (Throwable throwable) {
                this.releaseConnection(conn);
                throw throwable;
            }
        }
        return serail;
    }
}

