/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.neproxy;

import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.ProxyUtil;
import com.huawei.nglct.core.neproxy.JNIProcInfo;
import com.huawei.nglct.core.neproxy.TEProcID;
import com.huawei.nglct.core.startup.TEWNEMgrJniDllLoader;
import com.huawei.nglct.core.startup.TEWNEMgrJniLogFactory;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

abstract class TEIProxyAdapter {
    private static Logger log = TEWNEMgrJniLogFactory.getLogger(TEIProxyAdapter.class.getName());
    private static TEIProxyAdapter instance = null;

    public static TEIProxyAdapter getProxyInstance() {
        return instance;
    }

    protected TEIProxyAdapter() {
    }

    public abstract int getProcessInfoFromNEID(int var1, ProcessInfo var2);

    public abstract int getAllProcesses(List<ProcessInfo> var1);

    public abstract int getAllProcesses(char var1, List<ProcessInfo> var2);

    private static native int getAllNEMgr(List<JNIProcInfo> var0);

    private static native int getAllNEMgrByProcID(char var0, List<JNIProcInfo> var1);

    private static native int getDevOwner(int var0, JNIProcInfo var1);

    static {
        instance = TESysManagerBean.getInstance().isIntegratedStatus() ? new TEJniProxyImpl() : new UFlightProxyImpl();
        TEWNEMgrJniDllLoader.loadWNEMgrDll();
    }

    private static class TEJniProxyImpl
    extends TEIProxyAdapter {
        private TEJniProxyImpl() {
        }

        @Override
        public int getAllProcesses(List<ProcessInfo> pes) {
            int result = -1;
            if (null != pes) {
                ArrayList allp = new ArrayList();
                try {
                    result = TEIProxyAdapter.getAllNEMgr(allp);
                }
                catch (Throwable e) {
                    log.info("", e);
                }
                if (0 == result) {
                    for (JNIProcInfo jpi : allp) {
                        TEProcID pid = new TEProcID(jpi.procID, jpi.procHandler);
                        pes.add(pid);
                    }
                }
            }
            return result;
        }

        @Override
        public int getAllProcesses(char procID, List<ProcessInfo> pes) {
            int result = -1;
            if (null != pes) {
                ArrayList allp = new ArrayList();
                try {
                    result = TEIProxyAdapter.getAllNEMgrByProcID(procID, allp);
                }
                catch (Throwable e) {
                    log.info("", e);
                }
                if (0 == result) {
                    for (JNIProcInfo jpi : allp) {
                        TEProcID pid = new TEProcID(jpi.procID, jpi.procHandler);
                        pes.add(pid);
                    }
                }
            }
            return result;
        }

        @Override
        public int getProcessInfoFromNEID(int neID, ProcessInfo pinf) {
            int result = -1;
            JNIProcInfo jpi = new JNIProcInfo();
            try {
                result = TEIProxyAdapter.getDevOwner(neID, jpi);
            }
            catch (Throwable e) {
                log.info("", e);
            }
            if (0 == result) {
                pinf.setProcID(jpi.procID);
                pinf.setProcHandle(jpi.procHandler);
            }
            return result;
        }
    }

    private static class UFlightProxyImpl
    extends TEIProxyAdapter {
        private UFlightProxyImpl() {
        }

        @Override
        public int getAllProcesses(List<ProcessInfo> pes) {
            return ProxyUtil.queryAllEMProcess((int)0, pes);
        }

        @Override
        public int getAllProcesses(char procID, List<ProcessInfo> pes) {
            return ProxyUtil.queryAllEMProcess((char)procID, pes);
        }

        @Override
        public int getProcessInfoFromNEID(int neID, ProcessInfo pinf) {
            return ProxyUtil.queryNeOwnerProcess((int)neID, (ProcessInfo)pinf);
        }
    }
}

