/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.necoordinator;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.necoordinator.SPHelper;
import com.huawei.nglct.core.necoordinator.SPParameter;
import com.huawei.nglct.core.necoordinator.TENESP;
import com.huawei.nglct.core.necoordinator.TENESPRegInfo;
import com.huawei.nglct.db.CommonDaoService;
import gnu.trove.TIntObjectHashMap;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class TENESPTransaction {
    private final int INVALID_SP_NO = -1;
    public static final int SERIAL = 1;
    public static final int PARALLEL = 2;
    public static final String p_AllocDevID = "p_AllocDevID";
    public static final String p_VerifyDevID = "p_VerifyDevID";
    public static final String p_HasNEExisted = "p_HasNEExisted";
    public static final String p_GetNumOfNE = "p_GetNumOfNE";
    public static final String p_GetLicenseNumOfNE = "p_GetLicenseNumOfNE";
    public static final String p_CheckGne = "p_CheckGne";
    public static final String p_IsNENameOccupied = "p_IsNENameOccupied";
    public static final String p_VerifyPhyID = "p_VerifyPhyID";
    public static final String p_GetDevIDByPhyID = "p_GetDevIDByPhyID";
    public static final String p_GetPhyIDByDevID = "p_GetPhyIDByDevID";
    public static final String p_GetGneDetail = "p_GetGneDetail";
    public static final String p_AllocTL1PhyID = "p_AllocTL1PhyID";
    public static final String p_CheckGneProtocol = "p_CheckGneProtocol";
    public static final String p_GetNeidByAddr = "p_GetNeidByAddr";
    private ArrayList<TENESP> al_NESPs = new ArrayList();
    private ArrayList<TENESPRegInfo> al_NERegInfos = new ArrayList();
    private ArrayList<TIntObjectHashMap<Object>> al_LastExecResult = new ArrayList();
    private Connection conn = null;
    private TRANSTATE state = TRANSTATE.INIT;
    private int connIsolationType;
    private int m_FinishedNESPCount = 0;
    private final String STR_SQL_SELECT_RESULT_TABLE = "select spName, userSPNo, result from #SumNESPResult";
    private final String STR_SQL_CREATE_RESULT_TABLE = "create table #SumNESPResult (spName varchar(128) not null, userSPNo int not null, result int, primary key(spName, userSPNo))\n ";
    private final String STR_SQL_SELECT_NESP_REG_INFO = "select cNeMgrSvrProcType, cNeMgrSvrProcHandle, cDbName, cNeSPName, cDbServerName from MCDB..tbl_RegNESP";
    private final String STR_SQL_DROP_RESULT_TABLE = "if object_id('tempdb..#SumNESPResult') is not null\n drop table #SumNESPResult";
    private final String STR_SQL_DELETE_RESULT_TABLE = "delete #SumNESPResult ";

    public TENESPTransaction() {
        this(1);
    }

    public TENESPTransaction(int _isolationLevel) {
    }

    public void addNESP(String spName) {
        this.addNESP(spName, -1);
    }

    public void addNESP(String spName, int spNo) {
        TENESP tempSp = new TENESP(spName, spNo);
        for (TENESP sp : this.al_NESPs) {
            if (!sp.equals(tempSp)) continue;
            return;
        }
        this.al_NESPs.add(tempSp);
    }

    public void addNESP(String spName, ArrayList<SPParameter> paras) {
        this.addNESP(spName, -1, paras);
    }

    public void addNESP(String spName, int spNo, ArrayList<SPParameter> paras) {
        TENESP tempSp = new TENESP(spName, spNo, paras);
        for (TENESP sp : this.al_NESPs) {
            if (!sp.equals(tempSp)) continue;
            return;
        }
        this.al_NESPs.add(tempSp);
    }

    private int getNESPRegInfo() {
        int ret = 0;
        if (!this.al_NERegInfos.isEmpty()) {
            return ret;
        }
        try {
            Statement stmt = this.conn.createStatement();
            ResultSet rs = stmt.executeQuery("select cNeMgrSvrProcType, cNeMgrSvrProcHandle, cDbName, cNeSPName, cDbServerName from MCDB..tbl_RegNESP");
            while (rs.next()) {
                TENESPRegInfo tempSp = new TENESPRegInfo();
                tempSp.m_ProcType = rs.getInt("cNeMgrSvrProcType");
                tempSp.m_ProcHandle = rs.getInt("cNeMgrSvrProcHandle");
                tempSp.m_DBName = rs.getString("cDbName");
                tempSp.m_SPName = rs.getString("cNeSPName");
                tempSp.m_ServerName = rs.getString("cDbServerName");
                this.al_NERegInfos.add(tempSp);
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENESPTransaction.getNESPRegInfo() fail!", (Throwable)e);
            ret = 2;
        }
        return ret;
    }

    private int prepareConnection() {
        int ret = 0;
        this.conn = CommonDaoService.conntection();
        if (this.getNESPRegInfo() != 0) {
            return 2;
        }
        try {
            Statement stmt = this.conn.createStatement();
            stmt.execute("create table #SumNESPResult (spName varchar(128) not null, userSPNo int not null, result int, primary key(spName, userSPNo))\n ");
            this.connIsolationType = this.conn.getTransactionIsolation();
            if (this.connIsolationType != 2) {
                this.conn.setTransactionIsolation(2);
            }
            stmt.close();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENESPTransaction.prepareConnection() fail!", (Throwable)e);
            ret = 2;
        }
        return ret;
    }

    public void pauseTran() {
        try {
            if (null != this.conn && TRANSTATE.INIT != this.state) {
                Statement stmt = this.conn.createStatement();
                stmt.execute("delete #SumNESPResult ");
                this.conn.commit();
                this.conn.setAutoCommit(true);
                this.state = TRANSTATE.PAUSE;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENESPTransaction.pauseTran() fail!", (Throwable)e);
        }
        this.m_FinishedNESPCount = 0;
        this.al_NESPs.clear();
    }

    public int continueTran() {
        return this.continueTran(60);
    }

    public int continueTran(int timeout) {
        int ret = 0;
        try {
            if (this.state == TRANSTATE.PAUSE) {
                this.conn.setAutoCommit(false);
                this.state = TRANSTATE.BEGIN;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENESPTransaction.continueTran() fail!", (Throwable)e);
            return 2;
        }
        if (this.state == TRANSTATE.BEGIN) {
            ret = this.getLock(timeout);
            if (0 != ret) {
                return ret;
            }
            this.state = TRANSTATE.LOCKED;
        }
        if (this.state != TRANSTATE.LOCKED) {
            ret = 2;
        }
        return ret;
    }

    public void destroy() {
        try {
            if (null != this.conn) {
                if (TRANSTATE.LOCKED == this.state && !this.al_NESPs.isEmpty()) {
                    this.sendCreateDevMsg();
                }
                Statement stmt = this.conn.createStatement();
                stmt.execute("if object_id('tempdb..#SumNESPResult') is not null\n drop table #SumNESPResult");
                if (TRANSTATE.INIT != this.state) {
                    this.conn.commit();
                    this.conn.setAutoCommit(true);
                }
                this.conn.setTransactionIsolation(this.connIsolationType);
                stmt.close();
                this.conn.close();
            }
        }
        catch (Exception e) {
            try {
                this.conn.rollback();
            }
            catch (SQLException e1) {
                TELogFactory.getNormalLogger().error("TENESPTransaction.destroy() fail!", (Throwable)e1);
            }
            TELogFactory.getNormalLogger().error("TENESPTransaction.destroy() fail!", (Throwable)e);
        }
    }

    public ArrayList<TIntObjectHashMap<Object>> getLastExecResult() {
        return this.al_LastExecResult;
    }

    private void getResultFromDB() {
        try {
            Statement stmt = this.conn.createStatement();
            ResultSet rs = stmt.executeQuery("select spName, userSPNo, result from #SumNESPResult");
            while (rs.next()) {
                String db_spName = rs.getString("spName");
                int db_userSPNo = rs.getInt("userSPNo");
                for (TENESP sp : this.al_NESPs) {
                    if (!sp.spName.equalsIgnoreCase(db_spName) || sp.userSPNo != db_userSPNo) continue;
                    sp.result = rs.getInt("result");
                }
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENESPTransaction.getResultFromDB() fail!", (Throwable)e);
        }
    }

    public int resultOf(String spName) {
        return this.resultOf(spName, -1);
    }

    public int resultOf(String spName, int spNo) {
        TENESP tempSp = new TENESP(spName, spNo);
        for (TENESP sp : this.al_NESPs) {
            if (!sp.equals(tempSp)) continue;
            return sp.result;
        }
        return 0;
    }

    private int getLock(int timeout) {
        int ret = 0;
        return ret;
    }

    public int exec() {
        return this.exec(60);
    }

    public int exec(int timeout) {
        int ret = 0;
        if (null == this.conn && 0 != (ret = this.prepareConnection())) {
            return ret;
        }
        Statement stmt = null;
        Statement cstmt = null;
        try {
            if (this.state == TRANSTATE.INIT) {
                this.conn.setAutoCommit(false);
                this.state = TRANSTATE.BEGIN;
            }
            if (TRANSTATE.BEGIN == this.state) {
                ret = this.getLock(timeout);
                if (0 != ret) {
                    return ret;
                }
                this.state = TRANSTATE.LOCKED;
            }
            if (TRANSTATE.LOCKED != this.state) {
                return 2;
            }
            stmt = this.conn.createStatement();
            this.al_LastExecResult.clear();
            int nsize = this.al_NESPs.size();
            for (int n = this.m_FinishedNESPCount; n < nsize; ++n) {
                TENESP sp = this.al_NESPs.get(n);
                StringBuffer osSQL = new StringBuffer();
                osSQL.append(" insert into #SumNESPResult values ('");
                osSQL.append(sp.spName);
                osSQL.append("', ");
                osSQL.append(sp.userSPNo);
                osSQL.append(", 0)");
                stmt.executeUpdate(osSQL.toString());
                for (TENESPRegInfo nespRegInfo : this.al_NERegInfos) {
                    int i;
                    if (!sp.spName.equalsIgnoreCase(nespRegInfo.m_SPName)) continue;
                    osSQL = new StringBuffer();
                    osSQL.append("{? = call ");
                    osSQL.append(nespRegInfo.m_DBName);
                    osSQL.append(".dbo.");
                    osSQL.append(sp.spName);
                    int size = sp.paras.size();
                    for (i = 0; i < size; ++i) {
                        if (i == 0) {
                            osSQL.append('(');
                        }
                        osSQL.append('?');
                        if (i != size - 1) {
                            osSQL.append(',');
                            continue;
                        }
                        osSQL.append(')');
                    }
                    osSQL.append('}');
                    cstmt = this.conn.prepareCall(osSQL.toString());
                    cstmt.registerOutParameter(1, 4);
                    size = sp.paras.size();
                    for (i = 0; i < size; ++i) {
                        SPHelper.convertParameter((CallableStatement)cstmt, i + 2, sp.paras.get(i));
                    }
                    cstmt.execute();
                    ResultSet rs = null;
                    int updateCount = -1;
                    do {
                        if ((updateCount = cstmt.getUpdateCount()) != -1) {
                            cstmt.getMoreResults();
                            continue;
                        }
                        rs = cstmt.getResultSet();
                        if (rs == null) continue;
                        int colCount = rs.getMetaData().getColumnCount();
                        TIntObjectHashMap execResult = new TIntObjectHashMap();
                        while (rs.next()) {
                            for (int i2 = 1; i2 <= colCount; ++i2) {
                                execResult.put(i2, rs.getObject(i2));
                            }
                        }
                        this.al_LastExecResult.add((TIntObjectHashMap<Object>)execResult);
                        cstmt.getMoreResults();
                    } while (updateCount != -1 || rs != null);
                    int tempret = cstmt.getInt(1);
                    int size2 = sp.paras.size();
                    for (int i3 = 0; i3 < size2; ++i3) {
                        SPHelper.fillOutputParameter((CallableStatement)cstmt, i3 + 2, sp.paras.get(i3));
                    }
                    osSQL = new StringBuffer();
                    osSQL.append(" update #SumNESPResult set result = result + ");
                    osSQL.append(tempret);
                    osSQL.append(" where spName='");
                    osSQL.append(sp.spName);
                    osSQL.append("' and userSPNo=");
                    osSQL.append(sp.userSPNo);
                    stmt.executeUpdate(osSQL.toString());
                }
            }
            stmt.close();
            if (null != cstmt) {
                cstmt.close();
            }
            this.m_FinishedNESPCount = this.al_NESPs.size();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENESPTransaction.exec() fail!", (Throwable)e);
            return 2;
        }
        this.getResultFromDB();
        return 0;
    }

    private void sendCreateDevMsg() {
    }

    public static void main(String[] args) {
        try {
            TENESPTransaction test = new TENESPTransaction();
            ArrayList<SPParameter> spParameters = new ArrayList<SPParameter>();
            SPParameter para = new SPParameter(12, "1234");
            spParameters.add(para);
            test.addNESP(p_HasNEExisted, (ArrayList)spParameters.clone());
            test.addNESP(p_AllocDevID);
            test.exec();
            test.destroy();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENESPTransaction.main() fail!", (Throwable)e);
        }
    }

    private static enum TRANSTATE {
        INIT,
        BEGIN,
        LOCKED,
        PAUSE;

    }
}

