/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.necoordinator;

import com.huawei.nglct.core.necoordinator.SPParameter;
import com.huawei.nglct.core.necoordinator.TEAppNESPEx;
import gnu.trove.TIntIntHashMap;
import java.util.ArrayList;
import java.util.List;

public class TENEIDCacheMgr {
    private static TENEIDCacheMgr _instance = null;
    private TIntIntHashMap m_mapPhyIDToDevID = new TIntIntHashMap();
    private TIntIntHashMap m_mapDevIDToPhyID = new TIntIntHashMap();

    private TENEIDCacheMgr() {
    }

    public static synchronized TENEIDCacheMgr getInstance() {
        if (null == _instance) {
            _instance = new TENEIDCacheMgr();
        }
        return _instance;
    }

    public int getPhyID(int devID) {
        if (this.m_mapDevIDToPhyID.contains(devID)) {
            return this.m_mapDevIDToPhyID.get(devID);
        }
        TEAppNESPEx appNesp = new TEAppNESPEx("p_GetPhyIDByDevID");
        appNesp.addParameter(new SPParameter(4, devID));
        int phyID = 0;
        if (0 != appNesp.exec()) {
            phyID = appNesp.getLastTotalResult();
            this.insert(devID, phyID);
        }
        return phyID;
    }

    public int getDevID(int phyID) {
        if (this.m_mapPhyIDToDevID.containsKey(phyID)) {
            return this.m_mapPhyIDToDevID.get(phyID);
        }
        TEAppNESPEx appNesp = new TEAppNESPEx("p_GetDevIDByPhyID");
        appNesp.addParameter(new SPParameter(4, phyID));
        int devID = 0;
        if (0 != appNesp.exec()) {
            devID = appNesp.getLastTotalResult();
            this.insert(devID, phyID);
        }
        return devID;
    }

    public synchronized void insert(int devID, int phyID) {
        if (0 == devID || 0 == phyID) {
            return;
        }
        this.m_mapDevIDToPhyID.put(devID, phyID);
        this.m_mapPhyIDToDevID.put(phyID, devID);
    }

    public synchronized void remove(int devID) {
        int phyID = 0;
        if (this.m_mapDevIDToPhyID.containsKey(devID)) {
            phyID = this.m_mapDevIDToPhyID.get(devID);
            this.m_mapDevIDToPhyID.remove(devID);
        }
        if (this.m_mapPhyIDToDevID.containsKey(phyID)) {
            this.m_mapPhyIDToDevID.remove(phyID);
        }
    }

    public List getDevIDList() {
        int[] devids = this.m_mapPhyIDToDevID.getValues();
        ArrayList<Integer> devidList = new ArrayList<Integer>();
        for (int i = 0; i < devids.length; ++i) {
            devidList.add(devids[i]);
        }
        return devidList;
    }

    public synchronized boolean changePhyID(int oldID, int newID) {
        if (oldID == 0 || newID == 0) {
            return false;
        }
        int tmpdevID = 0;
        if (!this.m_mapPhyIDToDevID.containsKey(oldID)) {
            return false;
        }
        tmpdevID = this.m_mapPhyIDToDevID.get(oldID);
        this.m_mapPhyIDToDevID.remove(oldID);
        this.m_mapPhyIDToDevID.put(newID, tmpdevID);
        if (!this.m_mapDevIDToPhyID.contains(tmpdevID)) {
            return false;
        }
        this.m_mapDevIDToPhyID.put(tmpdevID, newID);
        return true;
    }

    public static void main(String[] args) {
        TENEIDCacheMgr.getInstance().getDevID(34);
        TENEIDCacheMgr.getInstance().getDevIDList();
    }
}

