/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.mdp;

import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.core.neproxy.TEProcID;
import com.huawei.nglct.core.neproxy.TEProxyUtil;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.commustru.fstru.FStruct;

public class TEFInterfaceUtils {
    private static final int INVALID_VLANID = 65535;

    private TEFInterfaceUtils() {
    }

    public static int getProcID(int neid, TEProcID procID) {
        ProcessInfo processInfo = new ProcessInfo();
        int result = TEProxyUtil.getProcessInfoFromNEID(neid, processInfo);
        if (result == 0) {
            procID.setProcHandle(processInfo.getProcHandle().charValue());
            procID.setProcID(processInfo.getProcID().charValue());
        }
        return result;
    }

    public static int sendCommand(String ipAddress, int neid, FStruct req, FStruct rsp, int command) {
        TEProcID procID = new TEProcID();
        int result = TEFInterfaceUtils.getProcID(neid, procID);
        if (result == 0) {
            TELogFactory.getInterfaceLogger().debug(TEAsn1Util.getAsn1String(req));
            if (ipAddress != null && !ipAddress.isEmpty()) {
                int ip = IPAddressUtil.convertIPStrToInt(ipAddress);
                TEASN1CommMgr.sendCommand(ip, procID, req, rsp, command, 90);
            } else {
                result = TEASN1CommMgr.sendCommand(procID, req, rsp, command);
            }
            TELogFactory.getInterfaceLogger().debug(TEAsn1Util.getAsn1String(rsp));
        }
        return result;
    }

    public static String convertBigInt2Str(BigInteger bigInt) {
        return null == bigInt ? "" : bigInt.toString();
    }

    public static BigInteger convertParam2BigInt(String param) {
        BigInteger result = null;
        result = !"".equals(param) ? BigInteger.valueOf(Long.valueOf(param)) : BigInteger.valueOf(-1L);
        return result;
    }

    public static BigInteger convertParam2BigInt(Param param) {
        BigInteger result = null;
        result = null != param && !"".equals(param.getValue()) ? BigInteger.valueOf(Long.valueOf(param.getValue())) : BigInteger.valueOf(-1L);
        return result;
    }

    public static BigInteger convertPortParam2BigInt(Param param) {
        BigInteger result = null;
        if (null != param && !"".equals(param.getValue())) {
            int portid = TEConfigurationDataMgr.getAbsolutPort(16, Integer.parseInt(param.getValue()));
            result = BigInteger.valueOf(portid);
        } else {
            result = BigInteger.valueOf(-1L);
        }
        return result;
    }

    public static String getNodeName(int neid, int slotid, int portid) {
        String nodeName = String.valueOf(slotid);
        nodeName = nodeName + "-" + TEConfigurationDataMgr.getInstance().getBoardName(neid, slotid);
        nodeName = nodeName + "-" + TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, TEConfigurationDataMgr.getPortRelativeID(portid));
        return nodeName;
    }

    public static RowErrors convertRowErrors(int neid, int iErrorCode) {
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        String errorCode = String.valueOf(iErrorCode);
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot(Integer.parseInt(errorCode)));
        rowError.setErrorMessage(errorMessage);
        errorparam = new Param("neid", String.valueOf(neid));
        rowError.addParam(errorparam);
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        if (null != ne) {
            errorparam = new Param("nename", ne.getNEName());
            rowError.addParam(errorparam);
        }
        return rowError;
    }

    public static BussinessParams convertErrorBussiness(int neid, int iErrorCode) {
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        rowparams.addRowErrors(TEFInterfaceUtils.convertRowErrors(neid, iErrorCode));
        bussiness.addRowParams(rowparams);
        return bussiness;
    }

    public static BussinessParams convertErrorBussiness(int neid, int iErrorCode, List<String[]> param) {
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        RowErrors rowerror = TEFInterfaceUtils.convertRowErrors(neid, iErrorCode);
        int len = param.size();
        for (int i = 0; i < len; ++i) {
            String[] pTemp = param.get(i);
            if (pTemp.length < 2) continue;
            rowerror.addParam(new Param(pTemp[0], pTemp[1]));
        }
        rowparams.addRowErrors(rowerror);
        bussiness.addRowParams(rowparams);
        return bussiness;
    }

    public static RowErrors convertRowErrors(int neid, int slotid, int portid, int iErrorCode) {
        RowErrors rowError = TEFInterfaceUtils.convertRowErrors(neid, iErrorCode);
        Param errorparam = new Param("slotid", String.valueOf(TEBoardUtil.getSlotIDFromSlot(neid, slotid)));
        rowError.addParam(errorparam);
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        errorparam = new Param("boardtype", String.valueOf(boardtype));
        rowError.addParam(errorparam);
        errorparam = new Param("boardname", TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype));
        rowError.addParam(errorparam);
        errorparam = new Param("portname", TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardtype, portid));
        rowError.addParam(errorparam);
        errorparam = new Param("port", String.valueOf(portid));
        rowError.addParam(errorparam);
        return rowError;
    }

    public static String convertVLAN2Str(List<BigInteger> vlanlist) {
        String vlan = "";
        int vlanid = 0;
        if (!vlanlist.isEmpty() && vlanlist.size() == 1) {
            vlanid = vlanlist.get(0).intValue();
            if (vlanid != 65535) {
                vlan = String.valueOf(vlanid);
            }
            return vlan;
        }
        Collections.sort(vlanlist);
        ArrayList allList = new ArrayList();
        ArrayList<Integer> dstlist = new ArrayList<Integer>();
        int size = vlanlist.size();
        for (int i = 0; i < size; ++i) {
            int pathNum = vlanlist.get(i).intValue();
            if (dstlist.isEmpty() || (Integer)dstlist.get(dstlist.size() - 1) + 1 == pathNum) {
                dstlist.add(pathNum);
            } else {
                allList.add(dstlist);
                dstlist = new ArrayList<Integer>();
                dstlist.add(pathNum);
            }
            if (i != size - 1) continue;
            allList.add(dstlist);
        }
        StringBuilder strBuilder = new StringBuilder();
        int size2 = allList.size();
        for (int i = 0; i < size2; ++i) {
            dstlist = (ArrayList<Integer>)allList.get(i);
            if (dstlist.size() == 1) {
                strBuilder.append(",");
                strBuilder.append(dstlist.get(0));
                continue;
            }
            strBuilder.append(",");
            strBuilder.append(dstlist.get(0));
            strBuilder.append("-");
            strBuilder.append(dstlist.get(dstlist.size() - 1));
        }
        String strResult = strBuilder.toString();
        if (strResult.length() > 0) {
            strResult = strResult.substring(1, strResult.length());
        }
        return strResult;
    }
}

