/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.event;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.communication.DebugTracer;
import com.huawei.nglct.core.event.TEEventKey;
import com.huawei.nglct.core.event.TEEventListener;
import com.huawei.nglct.core.event.TEEventParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEEventMgr {
    private Map<TEEventKey, List<TEEventListener>> listeners = new HashMap<TEEventKey, List<TEEventListener>>();
    private static TEEventMgr instance;
    private volatile boolean shouldRun;
    private List<TEEventParam> events = new ArrayList<TEEventParam>();
    private static long TIMEOUT_60;

    private TEEventMgr() {
    }

    public static synchronized TEEventMgr instance() {
        if (instance == null) {
            instance = new TEEventMgr();
            instance.startDispatcher();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeEvent(TEEventKey key, TEEventListener listener) {
        if (key == null || listener == null) {
            return;
        }
        Map<TEEventKey, List<TEEventListener>> map = this.listeners;
        synchronized (map) {
            List<TEEventListener> subLiters = this.listeners.get(key);
            if (subLiters == null) {
                subLiters = new ArrayList<TEEventListener>();
                this.listeners.put(key, subLiters);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postEvent(TEEventParam param) {
        List<TEEventParam> list = this.events;
        synchronized (list) {
            param.block = false;
            this.events.add(param);
            this.events.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(TEEventParam param) {
        Object object = this.events;
        synchronized (object) {
            param.block = true;
            this.events.add(param);
            this.events.notifyAll();
        }
        object = param;
        synchronized (object) {
            try {
                param.wait(TIMEOUT_60);
            }
            catch (InterruptedException e) {
                TELogFactory.getNormalLogger().error("TEEventMgr.sendEvent() fail!", (Throwable)e);
            }
        }
    }

    public void directEvent(TEEventParam param) {
        TEEventKey key = new TEEventKey(param.eventID, param.equipID);
        List<TEEventListener> subLiters = this.listeners.get(key);
        if (subLiters.size() > 0) {
            int size = subLiters.size();
            for (int i = 0; i < size; ++i) {
                subLiters.get(i).onEventNotified(param);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDispatcher() {
        List<TEEventParam> list = this.events;
        synchronized (list) {
            this.shouldRun = false;
        }
    }

    private void startDispatcher() {
        this.shouldRun = true;
        new TEEventDispatcher().start();
    }

    static {
        TIMEOUT_60 = 60000L;
    }

    protected class TEEventDispatcher
    extends Thread {
        protected TEEventDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (TEEventMgr.this.shouldRun) {
                TEEventParam event = null;
                List list = TEEventMgr.this.events;
                synchronized (list) {
                    if (TEEventMgr.this.events.size() == 0) {
                        try {
                            TEEventMgr.this.events.wait();
                        }
                        catch (InterruptedException e) {
                            DebugTracer.trace("The TEEventMgr dispatcher thread was interrupted.");
                            DebugTracer.trace(e);
                        }
                    } else {
                        event = (TEEventParam)TEEventMgr.this.events.remove(0);
                    }
                }
                if (event == null) continue;
                TEEventKey key = new TEEventKey(event.eventID, event.equipID);
                List subLiters = (List)TEEventMgr.this.listeners.get(key);
                if (subLiters != null && subLiters.size() > 0) {
                    int size = subLiters.size();
                    for (int i = 0; i < size; ++i) {
                        ((TEEventListener)subLiters.get(i)).onEventNotified(event);
                    }
                }
                if (!event.block) continue;
                TEEventParam tEEventParam = event;
                synchronized (tEEventParam) {
                    event.notifyAll();
                }
            }
        }
    }
}

