/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.event;

import com.huawei.commextend.eventmgr.EventTask;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.util.asn.AsnCoder;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.event.EventSubscibe;
import com.huawei.nglct.core.event.TEEventDescription;
import com.huawei.nglct.core.event.TEEventExJniParaReq;
import com.huawei.nglct.core.event.TEEventExJniParaRsp;
import com.huawei.nglct.core.event.TEEventExJniUtil;
import com.huawei.nglct.db.TECommonDaoService;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEEventHandlerEx {
    static final int EMGR_OK = 0;
    static final int EMGR_FAIL = -1;
    static final int NUM_NEG_ONE = -1;
    static final int NUM_ZER0 = 0;
    static final int NUM_ONE = 1;
    static final int NUM_UC_MAX = 255;
    static final int NUM_US_MAX = 65535;
    static final int EVENT_TIMEOUT = 30;
    static final int LOW_PRIORITY_EVENT_PROCESS_TASK_ID = 30;
    static final int WAIT_HANDLE_RESULT = 1;
    static final int NOWAIT_HANDLE_RESULT = 0;
    private List<EventSubscibe> m_SubscibeInfoList = new ArrayList<EventSubscibe>();
    private Object m_SubscibeRwMutex = new Object();
    private Logger log = TELogFactory.getNormalLogger();
    private static final int PARAM_NUM = 1;
    private Map<Integer, TEEventDescription> cmdTaskDesMap = new Hashtable<Integer, TEEventDescription>();
    private static TEEventHandlerEx m_instance = new TEEventHandlerEx();

    private TEEventHandlerEx() {
    }

    public static TEEventHandlerEx instance() {
        return m_instance;
    }

    public int init() {
        return this.getDBData();
    }

    public int reload() {
        return this.getDBData();
    }

    private int getDBData() {
        Connection connection = TECommonDaoService.getDBConn("MCDB");
        if (null == connection) {
            this.log.info("W-NEMGR -- TECommonDaoService connection is null! Connect failed!!");
            return -1;
        }
        String strSql = "select iEventID, iProcID, iProcHandle, iHandlerID, iModule, iPriority from MCDB..tbl_EventSubscibe";
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            if (null == statement) {
                this.log.info("W-NEMGR -- The ResultSet is null! Got ResultSet failed!!");
                return -1;
            }
            resultSet = statement.executeQuery(strSql);
            this.initSubscribeInfoList(resultSet);
            connection.commit();
            statement.close();
            resultSet.close();
            connection.close();
        }
        catch (SQLException e) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e1) {
                    TELogFactory.getNormalLogger().error("TEEventHandlerEx.getDBData() fail!", (Throwable)e);
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e1) {
                    TELogFactory.getNormalLogger().error("TEEventHandlerEx.getDBData() fail!", (Throwable)e1);
                }
            }
            try {
                connection.close();
            }
            catch (SQLException e1) {
                TELogFactory.getNormalLogger().error("TEEventHandlerEx.getDBData() fail!", (Throwable)e1);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSubscribeInfoList(ResultSet resultSet) {
        Object object = this.m_SubscibeRwMutex;
        synchronized (object) {
            if (null == this.m_SubscibeInfoList) {
                this.m_SubscibeInfoList = new ArrayList<EventSubscibe>();
            }
            this.m_SubscibeInfoList.clear();
            try {
                while (resultSet.next()) {
                    EventSubscibe oOneRecord = new EventSubscibe();
                    oOneRecord.m_EventID = resultSet.getBigDecimal("m_EventID").intValue();
                    oOneRecord.m_ProcID = resultSet.getInt("m_ProcID");
                    oOneRecord.m_ProcHandle = resultSet.getInt("m_ProcHandle");
                    oOneRecord.m_HandlerID = resultSet.getBigDecimal("m_HandlerID").intValue();
                    oOneRecord.m_Module = resultSet.getInt("m_Module");
                    oOneRecord.m_Priority = resultSet.getInt("m_Priority");
                    if (oOneRecord.m_EventID > 0 && oOneRecord.m_HandlerID > 0 && oOneRecord.m_ProcID >= 1 && oOneRecord.m_ProcHandle >= -1 && oOneRecord.m_ProcHandle <= 65535 && oOneRecord.m_Priority <= 1) {
                        this.m_SubscibeInfoList.add(oOneRecord);
                        this.log.debug("insert record success. " + oOneRecord);
                        continue;
                    }
                    this.log.error("discard record. " + oOneRecord);
                }
            }
            catch (SQLException e) {
                TELogFactory.getNormalLogger().error("TEEventHandlerEx.initSubscribeInfoList() fail!", (Throwable)e);
            }
            this.log.debug("TEEventMgrEx.getDBData get subsrcibe information success from db.");
        }
    }

    public int sendEvent(int eventId, int cParam, FStruct pParam) {
        if (null == pParam) {
            this.log.error("TEEventMgrEx.sendEvent pParam is null.");
            return -1;
        }
        int iResult = this.sendEventMsg(eventId, cParam, pParam, 1);
        this.log.debug("TEEventMgrEx.sendEvent send success " + iResult + " msg.");
        return 0;
    }

    public int postEvent(int eventId, int cParam, FStruct pParam) {
        if (null == pParam) {
            this.log.error("TEEventMgrEx.postEvent event is null.");
            return -1;
        }
        int iResult = this.sendEventMsg(eventId, cParam, pParam, 0);
        this.log.info("TEEventMgrEx.postEvent send success " + iResult + " msg.");
        return 0;
    }

    int sendEventMsg(int eventId, int cParam, FStruct pParam, int usWaitMark) {
        int iSendCount = 0;
        if (null == pParam) {
            this.log.error("The pParam is null.");
            return iSendCount;
        }
        byte[] tmpData = null;
        try {
            tmpData = AsnCoder.serialize((FStruct)pParam);
        }
        catch (FStruException e) {
            TELogFactory.getNormalLogger().error("TEEventHandlerEx.sendEventMsg() fail!", (Throwable)e);
        }
        if (null == tmpData) {
            this.log.error("The AsnCoder result is null.");
            return iSendCount;
        }
        TEEventExJniParaReq request = new TEEventExJniParaReq();
        request.eventId = eventId;
        request.cParam = cParam;
        request.data = tmpData;
        request.usWaitMark = usWaitMark;
        TEEventExJniParaRsp response = new TEEventExJniParaRsp();
        TEEventExJniUtil.sendEventMsgEx(request, response);
        if (1 == usWaitMark) {
            this.log.info("W-NEMGR ex event send result is : " + response.result);
        }
        return ++iSendCount;
    }

    public int registerEvent(Class taskClass) {
        boolean isDoTaskMethod = false;
        Method[] method = taskClass.getMethods();
        Class<?> reqClass = null;
        for (int i = 0; i < method.length; ++i) {
            isDoTaskMethod = method[i].isAnnotationPresent(EventTask.class);
            if (!isDoTaskMethod) continue;
            EventTask eventTask = method[i].getAnnotation(EventTask.class);
            int eventID = eventTask.eventID();
            int handleID = eventTask.handlerID();
            try {
                if (!this.isValidateMethod(method[i])) continue;
                Class<?>[] paramTypes = method[i].getParameterTypes();
                reqClass = paramTypes[0];
                TEEventDescription eventDesObj = new TEEventDescription(taskClass, eventID, handleID, reqClass, method[i]);
                this.cmdTaskDesMap.put(eventID, eventDesObj);
                continue;
            }
            catch (Exception e) {
                this.log.error("Register task (" + eventTask.toString() + ") fail!", (Throwable)e);
            }
        }
        return 0;
    }

    private boolean isValidateMethod(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        switch (paramTypes.length) {
            case 1: {
                if (!FStruct.class.isAssignableFrom(paramTypes[0])) {
                    this.log.info("Task Method Paramter Types Error, method:" + method.toString());
                    return false;
                }
                return true;
            }
        }
        this.log.info("Task Method Paramter Types Error, method:" + method.toString());
        return false;
    }

    public void receiveEvent(int eventID, MSGPacketExt eventMsg) {
        TEEventDescription eventDes = this.cmdTaskDesMap.get(eventID);
        if (null != eventDes) {
            try {
                FStruct eventASN = (FStruct)eventDes.getReq().newInstance();
                AsnCoder.deserialize((byte[])eventMsg.getData(), (FStruct)eventASN);
                Object handleClass = eventDes.getEventClass().newInstance();
                Method handleMethod = eventDes.geteventMethod();
                handleMethod.invoke(handleClass, eventASN);
            }
            catch (Exception e) {
                this.log.error("Task Method Paramter Types Error, method:" + e);
            }
        } else {
            this.log.debug("Event not register! eventID = " + eventID);
        }
    }
}

