/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.communication;

import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.multipkg.IPkgSplitter;
import com.huawei.communicate.multipkg.MultiPkgRequest;
import com.huawei.communicate.util.asn.AsnCoder;
import com.huawei.communicate.util.storage.SuperMap;
import com.huawei.nglct.core.communication.TEJniMultiPkgUtil;
import com.huawei.nglct.core.neproxy.TEProxyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TEJniPkgSplitter
implements IPkgSplitter {
    private static final String STARDAND_NEID = "neID";
    private List neObjList;
    private String neIDName = "neID";
    private int cmdStrategy;
    private static Logger logger = LoggerFactory.getLogger(TEJniPkgSplitter.class);
    private int index = 0;
    private static final String POINT = ".";
    protected MSGHead msgHead;
    protected Object locateInfo;

    public void setLocateInfo(Object locateInfo) {
        this.locateInfo = locateInfo;
    }

    public void setMSGHead(MSGHead msgHead) {
        this.msgHead = msgHead;
    }

    public TEJniPkgSplitter(FStruct request, List neObjList, String neIDName, int cmdStrategy) {
        if (null != neIDName) {
            this.neIDName = neIDName;
        }
        this.cmdStrategy = cmdStrategy;
        this.neObjList = neObjList;
    }

    public List<MultiPkgRequest> getSubRequestlst(FStruct request) {
        if (null == this.neObjList) {
            logger.error("The request isn't a valid neCommand with class = " + request.getClass().getName());
            return null;
        }
        List<MultiPkgRequest> subReqList = null;
        if (this.neObjList.isEmpty()) {
            logger.info("The size of the objList is 0, send the request to all the ems with procID->!" + this.msgHead.receiverProcID);
            subReqList = this.getALLReqList(this.msgHead, request);
        } else {
            subReqList = 1 == this.neObjList.size() ? this.getOneReq(request) : this.dealWithMultiNEReq(this.msgHead.cmdCode, request);
        }
        return subReqList;
    }

    private List<MultiPkgRequest> getOneReq(FStruct request) {
        ArrayList<MultiPkgRequest> subReqList = new ArrayList<MultiPkgRequest>();
        Object operNE = this.neObjList.get(0);
        int neID = this.getNEID(operNE);
        int result = TEJniMultiPkgUtil.addSubRequest(this.msgHead.cmdCode, neID, request, subReqList);
        if (0 != result) {
            logger.error("query EM process failed, cmdCode = " + this.msgHead.cmdCode + " neID = " + neID);
            return null;
        }
        return subReqList;
    }

    private List<MultiPkgRequest> getALLReqList(MSGHead msgHead, FStruct request) {
        ArrayList<MultiPkgRequest> subReqList = new ArrayList<MultiPkgRequest>();
        if ('\u0000' != msgHead.receiverProcID) {
            ProcessInfo procInfo = new ProcessInfo(Character.valueOf(msgHead.receiverProcID), Character.valueOf(msgHead.receiverProcHandle));
            TEJniMultiPkgUtil.addSubRequest(procInfo, request, subReqList);
        } else {
            ArrayList<ProcessInfo> processes = new ArrayList<ProcessInfo>();
            TEProxyUtil.getAllProcesses(processes);
            TEJniMultiPkgUtil.addSubRequest(processes, request, subReqList);
        }
        return subReqList;
    }

    private List<MultiPkgRequest> dealWithMultiNEReq(int cmdcode, FStruct request) {
        List<MultiPkgRequest> subReqList = null;
        switch (this.cmdStrategy) {
            case 1: 
            case 2: {
                subReqList = this.getParallelReqlst(request);
                break;
            }
            case 0: {
                subReqList = this.getOrderReqlst(cmdcode, request);
                break;
            }
        }
        return subReqList;
    }

    private List<MultiPkgRequest> getParallelReqlst(FStruct request) {
        ArrayList<MultiPkgRequest> subReqList = null;
        SuperMap<ProcessInfo, Object> proInfoMap = this.getProcInfoMap();
        if (null == proInfoMap) {
            logger.error("getParallelReqlst() failed when getProcInfoMap()");
            return null;
        }
        subReqList = new ArrayList<MultiPkgRequest>(proInfoMap.size());
        Set keySet = proInfoMap.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            this.neObjList.clear();
            ProcessInfo processInfo = (ProcessInfo)iter.next();
            List neIDLst = proInfoMap.getValuesByKey((Object)processInfo);
            MultiPkgRequest subReq = new MultiPkgRequest();
            subReq.setProcessInfo(processInfo);
            for (int i = 0; i < neIDLst.size(); ++i) {
                Object objNE = neIDLst.get(i);
                this.neObjList.add(objNE);
                subReq.addNEID(this.getNEID(objNE));
            }
            subReq.setAsnReq(AsnCoder.asnClone((FStruct)request));
            subReqList.add(subReq);
        }
        return subReqList;
    }

    private List cloneNeObjList() {
        if (this.neObjList instanceof Vector) {
            return (List)((Vector)this.neObjList).clone();
        }
        if (this.neObjList instanceof ArrayList) {
            return (List)((ArrayList)this.neObjList).clone();
        }
        if (this.neObjList instanceof LinkedList) {
            return (List)((LinkedList)this.neObjList).clone();
        }
        throw new IllegalArgumentException("neObjList has a not supported type");
    }

    private List<MultiPkgRequest> getOrderReqlst(int cmdCode, FStruct request) {
        ArrayList<MultiPkgRequest> subReqList = new ArrayList<MultiPkgRequest>();
        List neObjListExt = this.cloneNeObjList();
        Counter counter = new Counter();
        ProcessInfo cProcInfo = null;
        ArrayList tmplst = new ArrayList(10);
        int n = neObjListExt.size();
        for (int i = 0; i < n; ++i) {
            ProcessInfo processInfo;
            Object opNE = neObjListExt.get(i);
            int neID = this.getNEID(opNE);
            int result = TEProxyUtil.getProcessInfoFromNEID(neID, processInfo = new ProcessInfo());
            if (0 != result) continue;
            if (null != cProcInfo && !cProcInfo.equals((Object)processInfo)) {
                this.neObjList.clear();
                processInfo.setReserved((byte)counter.counter(cProcInfo));
                this.neObjList.addAll(tmplst);
                TEJniMultiPkgUtil.addSubRequest(cProcInfo, request, subReqList);
                tmplst.clear();
                this.neObjList.clear();
            }
            tmplst.add(opNE);
            cProcInfo = processInfo;
        }
        if (!tmplst.isEmpty()) {
            this.neObjList.clear();
            cProcInfo.setReserved((byte)counter.counter(cProcInfo));
            this.neObjList.addAll(tmplst);
            TEJniMultiPkgUtil.addSubRequest(cProcInfo, request, subReqList);
            tmplst.clear();
            this.neObjList.clear();
        }
        return subReqList;
    }

    private SuperMap<ProcessInfo, Object> getProcInfoMap() {
        SuperMap proInfoMap = new SuperMap();
        int n = this.neObjList.size();
        for (int i = 0; i < n; ++i) {
            ProcessInfo pinf;
            Object opNE = this.neObjList.get(i);
            int neID = this.getNEID(opNE);
            int result = TEProxyUtil.getProcessInfoFromNEID(neID, pinf = new ProcessInfo());
            if (0 != result) {
                return null;
            }
            proInfoMap.put((Object)pinf, opNE);
        }
        return proInfoMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNEID(Object operationObj) {
        String tempNeID = this.neIDName;
        int neID = -1;
        if (operationObj instanceof Number) {
            neID = ((Number)operationObj).intValue();
        } else if (operationObj instanceof FStruct) {
            FStruct req = (FStruct)operationObj;
            try {
                String[] array;
                int start = tempNeID.indexOf(POINT);
                if (-1 != start && 0 != (array = tempNeID.split("\\.")).length && this.index < array.length) {
                    tempNeID = array[this.index];
                    ++this.index;
                }
                Object neIDObj = req.getClass().getField(tempNeID).get(req);
                neID = this.getNEID(neIDObj);
            }
            catch (Exception e) {
                logger.error("getNEID failed, req = " + req, (Throwable)e);
            }
            finally {
                this.index = 0;
            }
        }
        return neID;
    }

    class Counter {
        private Map<Object, Integer> counters = new HashMap<Object, Integer>();

        Counter() {
        }

        public int counter(Object obj) {
            int curCunter = 0;
            if (this.counters.containsKey(obj)) {
                int conter = this.counters.get(obj);
                this.counters.put(obj, ++conter);
            } else {
                this.counters.put(obj, curCunter++);
            }
            return curCunter;
        }
    }
}

