/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.communication;

import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGListener;
import com.huawei.communicate.core.MSGSyncReceiver;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.multipkg.AbstractMultiPkgCommHandle;
import com.huawei.communicate.multipkg.AbstractMultiPkgReceiver;
import com.huawei.communicate.multipkg.IPkgSplitter;
import com.huawei.communicate.multipkg.MultiPkgRequest;
import com.huawei.communicate.proxy.IProxyService;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.util.asn.AsnCoder;
import com.huawei.communicate.util.receive.ILiteReceiver;
import com.huawei.communicate.util.receive.IReceiverReference;
import com.huawei.nglct.core.communication.TEJniCommService;
import com.huawei.nglct.core.communication.TEJniMultiPkgCommHandleFactory;
import com.huawei.nglct.core.communication.TEJniMultiPkgUtil;
import com.huawei.nglct.core.communication.TEJniPkgSplitter;
import com.huawei.nglct.core.neproxy.TEProxyUtil;
import com.huawei.nglct.core.startup.TEWNEMgrJniLogFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

class TEJniNEProxyService
implements IProxyService {
    private TEJniCommService commService = TEJniCommService.getInstance();
    private static Logger logger = TEWNEMgrJniLogFactory.getLogger(TEJniNEProxyService.class.getName());

    TEJniNEProxyService() {
    }

    public int getTimeOut() {
        return 90;
    }

    public int sendMessage(int cmdCode, int neID, FStruct request, FStruct response, int timeOut) {
        return this.commService.sendSingleNEMessage_SYNC(cmdCode, neID, request, response, timeOut);
    }

    public int sendMessage(int cmdCode, int neID, FStruct request, FStruct response) {
        return this.sendMessage(cmdCode, neID, request, response, this.getTimeOut());
    }

    public int sendAsyncMessage(int cmdCode, int neID, FStruct request, MSGListener listener, int timeOut) {
        return this.commService.sendSingleNEMessage_ASYNC(cmdCode, neID, request, listener, timeOut);
    }

    public int sendAsyncMessage(int cmdCode, int neID, FStruct request, MSGListener listener) {
        return this.sendAsyncMessage(cmdCode, neID, request, listener, this.getTimeOut());
    }

    public AbstractMultiPkgCommHandle getAsyncCommHandle(int cmdCode, int neID, FStruct request, AbstractMultiPkgReceiver receiver) {
        ProcessInfo processInfo = new ProcessInfo();
        int result = TEProxyUtil.getProcessInfoFromNEID(neID, processInfo);
        if (0 != result) {
            return null;
        }
        ArrayList<MultiPkgRequest> subReqList = new ArrayList<MultiPkgRequest>(1);
        TEJniMultiPkgUtil.addSubRequest(processInfo, neID, request, subReqList);
        MSGHead head = MSGHeadBuilder.buildMSGHead((int)cmdCode, (ProcessInfo)processInfo);
        return TEJniMultiPkgCommHandleFactory.getCommHandle(this.commService, head, subReqList, receiver, 1, 0);
    }

    public AbstractMultiPkgCommHandle getAsyncCommHandle(int cmdCode, FStruct request, AbstractMultiPkgReceiver receiver, IPkgSplitter splitter, int cmdStrategy) {
        MSGHead head = new MSGHead();
        head.msgType = (byte)6;
        head.cmdCode = cmdCode;
        splitter.setMSGHead(head);
        List subReqList = splitter.getSubRequestlst(request);
        if (null == subReqList) {
            return null;
        }
        return TEJniMultiPkgCommHandleFactory.getCommHandle(this.commService, head, subReqList, receiver, 1, cmdStrategy);
    }

    public AbstractMultiPkgCommHandle getAsyncCommHandle(int cmdCode, FStruct request, AbstractMultiPkgReceiver receiver, List neObjList, String neIDName, int cmdStrategy) {
        TEJniPkgSplitter splitter = new TEJniPkgSplitter(request, neObjList, neIDName, cmdStrategy);
        return this.getAsyncCommHandle(cmdCode, request, receiver, splitter, cmdStrategy);
    }

    public AbstractMultiPkgCommHandle getCommHandle(int cmdCode, int neID, FStruct request, AbstractMultiPkgReceiver receiver) {
        AbstractMultiPkgCommHandle commHandle = this.getAsyncCommHandle(cmdCode, neID, request, receiver);
        if (null != commHandle) {
            commHandle.setWaitStrategy(0);
        }
        return commHandle;
    }

    public AbstractMultiPkgCommHandle getCommHandle(int cmdCode, FStruct request, AbstractMultiPkgReceiver receiver, List neObjList, String neIDName, int cmdStrategy) {
        AbstractMultiPkgCommHandle commHandle = this.getAsyncCommHandle(cmdCode, request, receiver, neObjList, neIDName, cmdStrategy);
        if (null != commHandle) {
            commHandle.setWaitStrategy(0);
        }
        return commHandle;
    }

    public AbstractMultiPkgCommHandle getCommHandle(int cmdCode, FStruct request, AbstractMultiPkgReceiver receiver, IPkgSplitter splitter, int cmdStrategy) {
        AbstractMultiPkgCommHandle commHandle = this.getAsyncCommHandle(cmdCode, request, receiver, splitter, cmdStrategy);
        if (null != commHandle) {
            commHandle.setWaitStrategy(0);
        }
        return commHandle;
    }

    public int sendMessage(MSGHead msgHead, FStruct request, MSGSyncReceiver recv, int timeOut) {
        return this.commService.sendMessage_SYNC(msgHead, request, recv, timeOut);
    }

    public int sendMessage(MSGHead msgHead, FStruct request, MSGListener recv, int timeOut) {
        return this.commService.sendMessage_SYNC(msgHead, request, recv, timeOut);
    }

    public int sendMessage(MSGHead msgHead, FStruct request, MSGSyncReceiver recv) {
        return this.sendMessage(msgHead, request, recv, this.getTimeOut());
    }

    public int sendMessage(MSGHead msgHead, FStruct request, MSGListener recv) {
        return this.sendMessage(msgHead, request, recv, this.getTimeOut());
    }

    public int sendMessage(MSGHead msgHead, FStruct request, FStruct response, int timeOut) {
        return this.commService.sendMessage_SYNC(msgHead, request, response, timeOut);
    }

    public int sendMessage(MSGHead msgHead, FStruct request, FStruct response) {
        return this.sendMessage(msgHead, request, response, this.getTimeOut());
    }

    public int sendMessage(int cmdCode, FStruct request, FStruct response, int timeOut) {
        return -1;
    }

    public int sendMessage(int cmdCode, FStruct request, FStruct response) {
        return -1;
    }

    public int sendAsyncMessage(MSGHead msgHead, FStruct request, MSGListener listener, int timeOut) {
        return this.commService.sendMessage_ASYNC(msgHead, request, listener, timeOut);
    }

    public int sendAsyncMessage(MSGHead msgHead, FStruct request, MSGListener listener) {
        return this.sendAsyncMessage(msgHead, request, listener, this.getTimeOut());
    }

    public int sendAsyncMessage(int cmdCode, FStruct request, MSGListener listener, int timeOut) {
        return -1;
    }

    public int sendAsyncMessage(int cmdCode, FStruct request, MSGListener listener) {
        return -1;
    }

    public int sendBroadcastMessage(int cmdCode, FStruct request, int timeOut) {
        return this.sendBroadcastMessage2AllProcess(cmdCode, request, timeOut);
    }

    public int sendBroadcastMessage2AllProcess(int cmdCode, FStruct request, int timeOut) {
        ArrayList<ProcessInfo> processes = new ArrayList<ProcessInfo>();
        TEProxyUtil.getAllProcesses(processes);
        if (processes.isEmpty()) {
            return -1;
        }
        return this.sendBroadcastMessage(cmdCode, processes, request, timeOut);
    }

    protected int sendBroadcastMessage(int cmdCode, List<ProcessInfo> processes, FStruct request, int timeOut) {
        if (processes.isEmpty()) {
            logger.info("TEJniNEProxyService---no EM Process support, CmdCode = " + cmdCode);
            return -2;
        }
        Iterator<ProcessInfo> iter = processes.iterator();
        int result = -1;
        while (iter.hasNext()) {
            ProcessInfo procInfo = iter.next();
            MSGHead head = MSGHeadBuilder.buildMSGHead((int)cmdCode, (ProcessInfo)procInfo);
            head.msgType = 1;
            int errorCode = this.sendAsyncMessage(head, AsnCoder.asnClone((FStruct)request), null, timeOut);
            if (0 != errorCode) continue;
            result = errorCode;
        }
        return result;
    }

    public int sendBroadcastMessage(MSGHead msgHead, FStruct request, int timeOut) {
        logger.info("TEJniNEProxyService---sendBroadcastMessage, msgHead = " + msgHead);
        if ('\u0000' != msgHead.receiverProcID) {
            return this.sendAsyncMessage(msgHead, request, null, timeOut);
        }
        return this.sendBroadcastMessage2AllProcess(msgHead.cmdCode, request, timeOut);
    }

    public int sendBroadcastMessage(MSGHead msgHead, FStruct request) {
        return this.sendBroadcastMessage(msgHead, request, this.getTimeOut());
    }

    public int sendBroadcastMessage(int cmdCode, FStruct request) {
        return this.sendBroadcastMessage2AllProcess(cmdCode, request, this.getTimeOut());
    }

    public IReceiverReference addMessageListener(int cmdCode, ILiteReceiver receiver) {
        this.commService.regNtfReceiver(cmdCode, receiver);
        return null;
    }

    public AbstractMultiPkgCommHandle getAsyncCommHandle(MSGHead msgHead, FStruct request, AbstractMultiPkgReceiver receiver) {
        logger.info("TEJniNEProxyService---getAsyncCommHandle, msgHead = " + msgHead);
        ArrayList<ProcessInfo> processes = new ArrayList<ProcessInfo>();
        if (msgHead.receiverProcID == '3' || msgHead.receiverProcID == '4' || msgHead.receiverProcID == '8' || msgHead.receiverProcID == '3' || msgHead.receiverProcID == '7' || msgHead.receiverProcID == '5' || msgHead.receiverProcID == '9' || msgHead.receiverProcID == '\u00b2' || msgHead.receiverProcID == ':' || msgHead.receiverProcID == ';') {
            processes.add(new ProcessInfo(Character.valueOf(msgHead.receiverProcID), Character.valueOf(msgHead.receiverProcHandle)));
        } else if ('\u0000' != msgHead.receiverProcID) {
            if ('\u0000' != msgHead.receiverProcHandle) {
                processes.add(new ProcessInfo(Character.valueOf(msgHead.receiverProcID), Character.valueOf(msgHead.receiverProcHandle)));
            } else {
                TEProxyUtil.getAllProcesses(msgHead.receiverProcID, processes);
            }
        } else {
            TEProxyUtil.getAllProcesses(processes);
        }
        if (processes.isEmpty()) {
            return null;
        }
        ArrayList<MultiPkgRequest> subReqList = new ArrayList<MultiPkgRequest>(processes.size());
        TEJniMultiPkgUtil.addSubRequest(processes, request, subReqList);
        return TEJniMultiPkgCommHandleFactory.getCommHandle(this.commService, msgHead, subReqList, receiver, 1, 2);
    }

    public AbstractMultiPkgCommHandle getCommHandle(MSGHead msgHead, FStruct request, AbstractMultiPkgReceiver receiver) {
        AbstractMultiPkgCommHandle commHandle = this.getAsyncCommHandle(msgHead, request, receiver);
        if (null != commHandle) {
            commHandle.setWaitStrategy(0);
        }
        return commHandle;
    }

    public int sendResponseMessage(MSGHead msgHead, FStruct reponse, int timeOut) {
        return this.sendAsyncMessage(msgHead, reponse, null, timeOut);
    }

    public int sendResponseMessage(MSGHead msgHead, FStruct reponse) {
        return this.sendResponseMessage(msgHead, reponse, this.getTimeOut());
    }
}

