/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.communication;

import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGListener;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.multipkg.AbstractMultiPkgReceiver;
import com.huawei.communicate.multipkg.MultiPkgRequest;
import com.huawei.communicate.proxy.ICommServiceAdapter;
import com.huawei.nglct.core.communication.TEJniMultiPkgCommHandle;
import com.huawei.uflight.threadpool.ThreadPool;
import java.util.List;

class TEJniMultiPkgOrderCommHandle
extends TEJniMultiPkgCommHandle {
    public TEJniMultiPkgOrderCommHandle(ICommServiceAdapter commService, MSGHead msgHead, List subReqList, AbstractMultiPkgReceiver receiver, int waitStrategy) {
        super(commService, msgHead, subReqList, receiver, waitStrategy);
    }

    @Override
    public void sendRequest(final int timeout) {
        ThreadPool threadPool = ThreadPool.getInstance();
        threadPool.execute(new Runnable(){

            @Override
            public void run() {
                int takenTime = 0;
                for (int i = 0; i < TEJniMultiPkgOrderCommHandle.this.subReqCount; ++i) {
                    MultiPkgRequest subReq = (MultiPkgRequest)TEJniMultiPkgOrderCommHandle.this.subReqList.get(i);
                    ProcessInfo processInfo = subReq.getProcessInfo();
                    TEJniMultiPkgOrderCommHandle.this.msgHead.receiverProcID = processInfo.getProcID().charValue();
                    TEJniMultiPkgOrderCommHandle.this.msgHead.receiverProcHandle = processInfo.getProcHandle().charValue();
                    if (timeout - takenTime > 0) {
                        long startTime = System.currentTimeMillis();
                        TEJniMultiPkgOrderCommHandle.this.sendARequest(subReq, timeout - takenTime);
                        long endTime = System.currentTimeMillis();
                        takenTime += (int)((endTime - startTime) / 1000L);
                        continue;
                    }
                    TEJniMultiPkgOrderCommHandle.this.handleToApplication(processInfo, null, -1);
                }
            }
        });
    }

    private void sendARequest(MultiPkgRequest subReq, int timeout) {
        final ProcessInfo processInfo = subReq.getProcessInfo();
        if (!processInfo.isValid()) {
            this.handleToApplication(processInfo, null, 3);
            return;
        }
        MSGListener asyncMultiRec = new MSGListener(){

            public boolean receiveMessage(MSGPacketExt msg) {
                return TEJniMultiPkgOrderCommHandle.this.handleToApplication(processInfo, msg, 0);
            }

            public void timeout(int cmdCode, Character cmdHandle) {
                TEJniMultiPkgOrderCommHandle.this.handleToApplication(processInfo, null, -1);
            }
        };
        boolean isNECmd = !subReq.getNEIDList().isEmpty();
        int result = -1;
        if (isNECmd) {
            int neID = (Integer)subReq.getNEIDList().get(0);
            int cmdCode = this.msgHead.cmdCode;
            result = this.commService.sendSingleNEMessage_SYNC(cmdCode, neID, subReq.getASN1Req(), asyncMultiRec, timeout);
        } else {
            result = this.commService.sendMessage_SYNC(this.msgHead, subReq.getASN1Req(), asyncMultiRec, timeout);
        }
        if (0 != result) {
            this.handleToApplication(processInfo, null, result);
        }
    }
}

