/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.communication;

import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.multipkg.AbstractMultiPkgCommHandle;
import com.huawei.communicate.multipkg.AbstractMultiPkgReceiver;
import com.huawei.communicate.multipkg.MultiPkgRequest;
import com.huawei.communicate.proxy.ICommServiceAdapter;
import com.huawei.communicate.util.asn.AsnCoder;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.communication.TEJniCommService;
import com.huawei.nglct.core.communication.TEJniMultiPkgDataPacket;
import com.huawei.nglct.core.mdp.TEAbstractMultiPkgReceiver;
import com.huawei.uflight.threadpool.ThreadPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.commustru.fstru.FStruct;

abstract class TEJniMultiPkgCommHandle
extends AbstractMultiPkgCommHandle {
    protected static final long ONE_SECOND = 1000L;
    protected TEJniCommService commService = null;
    public static final int SYNCHRONIZED = 0;
    public static final int ASYNCHRONIZED = 1;
    protected List<MultiPkgRequest> subReqList = null;
    protected int subReqCount = 0;
    private int finishedReqCount = 0;
    protected List<TEJniMultiPkgDataPacket> rsps = null;
    private Vector<Counter> counters = null;
    private ProcessInfo currProcessInfo = null;
    private MSGHead currMSGHead = null;
    protected MSGHead msgHead = null;
    protected TEAbstractMultiPkgReceiver receiver = null;
    private List<Integer> currOperIDList = null;
    private int currCmd = -1;
    private int currDealCount = -1;
    private int waitStrategy = -1;
    private int rspStrategy = -1;
    protected int sendType = 0;
    private int timeout = 9;
    private char cmdHandle = '\u0000';

    public TEJniMultiPkgCommHandle(ICommServiceAdapter csa, MSGHead mHead, List subReqs, AbstractMultiPkgReceiver recver, int waitStrategy) {
        super(csa, mHead, subReqs, recver, waitStrategy);
        this.commService = (TEJniCommService)csa;
        this.subReqList = subReqs;
        this.subReqCount = subReqs.size();
        this.receiver = (TEAbstractMultiPkgReceiver)recver;
        this.receiver.setCommHandle(this);
        this.rsps = new ArrayList<TEJniMultiPkgDataPacket>();
        this.currCmd = mHead.cmdCode;
        this.setWaitStrategy(waitStrategy);
        this.setRspStrategy(this.rspStrategy);
        this.msgHead = mHead;
        this.initCounter();
    }

    private void initCounter() {
        this.counters = new Vector(this.subReqCount);
        for (int i = 0; i < this.subReqCount; ++i) {
            MultiPkgRequest subReq = this.subReqList.get(i);
            Counter counter = new Counter(subReq.getProcessInfo());
            this.counters.add(counter);
        }
    }

    public void setSendType(int sendType) {
        this.sendType = sendType;
    }

    public void send() {
        this.send(this.timeout);
    }

    public void send(int timeout) {
        int commTimeout = timeout;
        if (this.subReqCount <= 0) {
            this.callMessageReceived();
            return;
        }
        char newHandle = this.getCmdHandle();
        if ('\u0000' != newHandle) {
            this.msgHead.cmdHandle = newHandle;
        }
        if (0 != this.sendType) {
            this.msgHead.msgType = (byte)this.sendType;
        }
        this.sendRequest(commTimeout);
        if (0 == this.getWaitStrategy()) {
            this.syncWait(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncWait(int timeout) {
        Vector<Counter> vector = this.counters;
        synchronized (vector) {
            if (this.finishedReqCount != this.subReqCount) {
                try {
                    this.counters.wait((long)timeout * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized boolean hasNextRsp() {
        return this.hasReqUnfinished() || !this.rsps.isEmpty();
    }

    public HashMap<Integer, List<Integer>> getNEIDListMap() {
        HashMap<Integer, List<Integer>> neIDListMap = new HashMap<Integer, List<Integer>>(this.subReqCount);
        for (int i = 0; i < this.subReqCount; ++i) {
            MultiPkgRequest subReq = this.subReqList.get(i);
            if (null == subReq) continue;
            ProcessInfo processInfo = subReq.getProcessInfo();
            int key = (processInfo.getProcID().charValue() << 16) + processInfo.getProcHandle().charValue();
            neIDListMap.put(key, subReq.getNEIDList());
        }
        return neIDListMap;
    }

    public HashMap<MSGHead, Float> getSubTaskWeightMap() {
        HashMap<MSGHead, Float> weightMap = new HashMap<MSGHead, Float>(this.subReqCount);
        boolean isNullNEReq = this.isNullNEReq();
        int totalNECount = isNullNEReq ? 0 : this.getTotalNECount();
        for (int i = 0; i < this.subReqCount; ++i) {
            MultiPkgRequest subReq = this.subReqList.get(i);
            if (null == subReq) continue;
            ProcessInfo processInfo = subReq.getProcessInfo();
            MSGHead msgHead = new MSGHead();
            msgHead.receiverProcID = processInfo.getProcID().charValue();
            msgHead.receiverProcHandle = processInfo.getProcHandle().charValue();
            msgHead.receiverModule = processInfo.getReserved();
            float weight = isNullNEReq ? 1.0f / (float)this.subReqCount : (float)subReq.getNEIDList().size() / (float)totalNECount;
            weightMap.put(msgHead, Float.valueOf(weight));
        }
        return weightMap;
    }

    public int getCurrCount() {
        return this.currDealCount;
    }

    public synchronized int getCurrCmdCode() {
        return this.currCmd;
    }

    public MSGHead getCurrMSGHead() {
        return this.currMSGHead;
    }

    public char getCmdHandle() {
        return this.cmdHandle;
    }

    public void setCmdHandle(char cmdHandle) {
        this.cmdHandle = cmdHandle;
    }

    public List<Integer> getCurrOpIDList() {
        return this.currOperIDList;
    }

    public ProcessInfo getCurrProcessInfo() {
        return this.currProcessInfo;
    }

    public int getCurrProcID() {
        return (this.currProcessInfo.getProcID().charValue() << 16) + this.currProcessInfo.getProcHandle().charValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrRsp(FStruct rsp) {
        List<TEJniMultiPkgDataPacket> list = this.rsps;
        synchronized (list) {
            while (this.rsps.isEmpty()) {
                this.waitForReceiveResponse();
            }
            TEJniMultiPkgDataPacket multiPkgData = this.rsps.remove(0);
            ProcessInfo processInfo = multiPkgData.getProcessInfo();
            this.count(processInfo);
            this.recordCurrOperIDList(processInfo);
            this.currMSGHead = multiPkgData.getMSGHead();
            if (this.rsps.isEmpty() && !this.hasReqUnfinished()) {
                this.callMessageReceived();
            }
            return TEJniMultiPkgCommHandle.getASNData(multiPkgData, rsp);
        }
    }

    private void waitForReceiveResponse() {
        if (this.hasReqUnfinished()) {
            try {
                this.rsps.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void count(ProcessInfo processInfo) {
        if (null != this.counters) {
            this.currProcessInfo = processInfo;
            for (int i = 0; i < this.subReqCount; ++i) {
                Counter counter = this.counters.get(i);
                if (!this.currProcessInfo.equals((Object)counter.getProcessInfo())) continue;
                counter.addDealCounter();
                this.currDealCount = counter.getDealCounter();
                break;
            }
        }
    }

    private void recordCurrOperIDList(ProcessInfo processInfo) {
        for (int i = 0; i < this.subReqCount; ++i) {
            MultiPkgRequest subReq = this.subReqList.get(i);
            if (!processInfo.equals((Object)subReq.getProcessInfo())) continue;
            this.currOperIDList = subReq.getNEIDList();
            break;
        }
    }

    public void setWaitStrategy(int waitStrategy) {
        this.waitStrategy = waitStrategy;
    }

    public int getWaitStrategy() {
        return this.waitStrategy;
    }

    public void setRspStrategy(int rspStrategy) {
        this.rspStrategy = rspStrategy;
    }

    public int getRspStrategy() {
        return this.rspStrategy;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    private boolean isNullNEReq() {
        MultiPkgRequest teReq = this.subReqList.get(0);
        return teReq.getNEIDList().isEmpty();
    }

    private int getTotalNECount() {
        int totalNECount = 0;
        for (int i = 0; i < this.subReqCount; ++i) {
            MultiPkgRequest subReq = this.subReqList.get(i);
            if (null == subReq) continue;
            totalNECount += subReq.getNEIDList().size();
        }
        return totalNECount;
    }

    private boolean hasReqUnfinished() {
        return this.finishedReqCount < this.subReqCount;
    }

    protected void setRequestFinish(ProcessInfo processInfo) {
        for (int i = 0; i < this.subReqCount; ++i) {
            MultiPkgRequest subReq = this.subReqList.get(i);
            if (!processInfo.equals((Object)subReq.getProcessInfo()) || subReq.isFinish()) continue;
            subReq.setFinish(true);
            ++this.finishedReqCount;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveRsp(ProcessInfo processInfo, MSGPacketExt data, int result) {
        List<TEJniMultiPkgDataPacket> list = this.rsps;
        synchronized (list) {
            TEJniMultiPkgDataPacket multiPkgData = new TEJniMultiPkgDataPacket();
            multiPkgData.setProcessInfo(processInfo);
            multiPkgData.setResult(result);
            multiPkgData.setData(data);
            this.rsps.add(multiPkgData);
            this.rsps.notifyAll();
        }
    }

    protected synchronized boolean handleToApplication(ProcessInfo processInfo, MSGPacketExt data, int result) {
        if (null != data) {
            this.currCmd = data.mheader.cmdCode;
        }
        this.receiveRsp(processInfo, data, result);
        boolean hasFinishRec = true;
        try {
            hasFinishRec = this.receiver.checkDataIntegrity();
        }
        catch (Exception ex) {
            TELogFactory.getE2ELogger().error(ex.getMessage());
        }
        if (hasFinishRec) {
            this.setRequestFinish(processInfo);
            if (!this.hasNextRsp()) {
                this.callMessageReceived();
            }
            return true;
        }
        return false;
    }

    private void callMessageReceived() {
        ThreadPool threadPool = ThreadPool.getInstance();
        threadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (null != TEJniMultiPkgCommHandle.this.receiver) {
                        TEJniMultiPkgCommHandle.this.receiver.messageReceived();
                    }
                }
                catch (Exception ex) {
                    TELogFactory.getE2ELogger().error(ex.getMessage());
                }
                Vector vector = TEJniMultiPkgCommHandle.this.counters;
                synchronized (vector) {
                    TEJniMultiPkgCommHandle.this.counters.notifyAll();
                }
            }
        });
    }

    protected void exceptionHandleToApplication(final ProcessInfo processInfo, final int reason) {
        ThreadPool threadPool = ThreadPool.getInstance();
        threadPool.execute(new Runnable(){

            @Override
            public void run() {
                TEJniMultiPkgCommHandle.this.handleToApplication(processInfo, null, reason);
            }
        });
    }

    public static final int getASNData(TEJniMultiPkgDataPacket dataPackage, FStruct asnData) {
        if (0 != dataPackage.getResult()) {
            return dataPackage.getResult();
        }
        boolean result = AsnCoder.deserialize((byte[])dataPackage.getData(), (FStruct)asnData);
        if (!result) {
            dataPackage.setResult(-2);
        }
        return dataPackage.getResult();
    }

    public abstract void sendRequest(int var1);

    private static class Counter {
        private ProcessInfo procID = null;
        private int dealCount = 0;

        Counter(ProcessInfo procID) {
            this.procID = procID;
        }

        void addDealCounter() {
            ++this.dealCount;
        }

        int getDealCounter() {
            return this.dealCount;
        }

        ProcessInfo getProcessInfo() {
            return this.procID;
        }
    }
}

