/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.communication;

import com.huawei.communicate.core.AppAidedMsgReceiver;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGListener;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.multipkg.AbstractMultiPkgReceiver;
import com.huawei.communicate.multipkg.MultiPkgRequest;
import com.huawei.communicate.proxy.ICommServiceAdapter;
import com.huawei.nglct.core.communication.TEJniMultiPkgCommHandle;
import java.util.List;

class TEJniMultiPkgCollateralCommHandle
extends TEJniMultiPkgCommHandle {
    AppAidedMsgReceiver[] receiverArray = null;

    protected TEJniMultiPkgCollateralCommHandle(ICommServiceAdapter commService, MSGHead msgHead, List<MultiPkgRequest> subReqList, AbstractMultiPkgReceiver receiver, int waitStrategy) {
        super(commService, msgHead, subReqList, receiver, waitStrategy);
        this.initReceiver();
    }

    private void initReceiver() {
        this.receiverArray = new MultiMsgSyncReceiver[this.subReqList.size()];
        int len = this.subReqList.size();
        for (int i = 0; i < len; ++i) {
            ProcessInfo processInfo = ((MultiPkgRequest)this.subReqList.get(i)).getProcessInfo();
            this.receiverArray[i] = new MultiMsgSyncReceiver(processInfo);
        }
    }

    @Override
    public void sendRequest(int timeout) {
        for (int i = 0; i < this.subReqCount; ++i) {
            MultiPkgRequest subReq = (MultiPkgRequest)this.subReqList.get(i);
            ProcessInfo processInfo = subReq.getProcessInfo();
            this.msgHead.receiverProcID = processInfo.getProcID().charValue();
            this.msgHead.receiverProcHandle = processInfo.getProcHandle().charValue();
            this.msgHead.senderCmdHandle = '\u0000';
            if (!processInfo.isValid()) {
                this.handleToApplication(processInfo, null, 3);
                continue;
            }
            if (this.receiver == null) {
                this.sendNoResponseMessage(subReq, processInfo, timeout);
                continue;
            }
            this.sendResponseMessage(subReq, processInfo, this.receiverArray[i], timeout);
        }
    }

    private void sendNoResponseMessage(MultiPkgRequest subReq, ProcessInfo processInfo, int timeout) {
        int result = this.commService.sendMessage_ASYNC(this.msgHead, subReq.getASN1Req(), null, timeout);
        if (0 != result) {
            this.exceptionHandleToApplication(processInfo, result);
        }
    }

    private void sendResponseMessage(MultiPkgRequest subReq, ProcessInfo processInfo, AppAidedMsgReceiver asyncMultiRec, int timeout) {
        int result = this.commService.sendMessage_ASYNC(this.msgHead, subReq.getASN1Req(), (MSGListener)asyncMultiRec, timeout);
        if (0 != result) {
            this.exceptionHandleToApplication(processInfo, result);
        }
    }

    class MultiMsgSyncReceiver
    extends AppAidedMsgReceiver {
        ProcessInfo processInfo = null;

        public MultiMsgSyncReceiver(ProcessInfo process) {
            this.processInfo = process;
        }

        public boolean processMessage(MSGPacketExt msg) {
            return TEJniMultiPkgCollateralCommHandle.this.handleToApplication(this.processInfo, msg, 0);
        }

        public int handleTimeout() {
            TEJniMultiPkgCollateralCommHandle.this.handleToApplication(this.processInfo, null, -1);
            return -1;
        }
    }
}

