/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.communication;

import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGListener;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.util.asn.AsnCoder;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.communication.TEJniCommService;
import com.huawei.nglct.core.communication.TEJniDEObj;
import com.huawei.nglct.core.mdp.TEMultiPkgMsgSyncReceiver;
import com.huawei.nglct.core.startup.TEWNEMgrJniDllLoader;
import com.huawei.nglct.core.startup.TEWNEMgrJniLogFactory;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public final class TEJniCommUtil {
    private static Logger embededWnemgrlog = TEWNEMgrJniLogFactory.getLogger(TEJniCommUtil.class.getName());

    private TEJniCommUtil() {
    }

    public static int requestReceived(TEJniDEObj req, TEJniDEObj rsp) {
        embededWnemgrlog.info("-------- receive request");
        embededWnemgrlog.info("--------" + TEJniCommUtil.printJniDEObj(req));
        if (req.needResponse()) {
            TEJniCommService.getInstance().receiveSyncMessageResponse(req, rsp);
            embededWnemgrlog.info("--------return response");
            embededWnemgrlog.info("--------" + TEJniCommUtil.printJniDEObj(rsp));
        } else {
            TEJniCommService.getInstance().receiveAsyncMessageResponse(req);
        }
        return 0;
    }

    private static String printJniDEObj(TEJniDEObj de) {
        String deStr = null;
        deStr = null == de ? "TEJniDEObj  is NULL" : de.toString();
        return deStr;
    }

    public static int responseReceived(TEJniDEObj rsp) {
        embededWnemgrlog.info("---responseReceived(TEJniDEObj rsp)-----receive response");
        embededWnemgrlog.info("---responseReceived(TEJniDEObj rsp)-----" + TEJniCommUtil.printJniDEObj(rsp));
        TEJniCommService.getInstance().receiveAsyncMessageResponse(rsp);
        return 0;
    }

    static int sendSingleNEMessage_SYNC(int cmdCode, int neID, FStruct request, FStruct response, int timeOut) {
        boolean decodeResult;
        TEJniDEObj req = new TEJniDEObj();
        req.cmdCode = cmdCode;
        req.neID = neID;
        try {
            req.data = AsnCoder.serialize((FStruct)request);
        }
        catch (Throwable e) {
            embededWnemgrlog.info(e.toString(), e);
            return 0;
        }
        req.timeout = timeOut;
        TEJniDEObj rsp = new TEJniDEObj();
        rsp.cmdCode = cmdCode;
        rsp.neID = neID;
        embededWnemgrlog.info("send requese");
        embededWnemgrlog.info(TEJniCommUtil.printJniDEObj(req));
        embededWnemgrlog.info("BEGIN TO CALL JNI METHOD---  sendNEMsgSync(TEJniDEObj req, TEJniDEObj rsp)");
        try {
            TEJniCommUtil.sendNEMsgSync(req, rsp);
        }
        catch (Throwable e) {
            embededWnemgrlog.info(e.toString(), e);
        }
        embededWnemgrlog.info("END TO CALL JNI METHOD---  sendNEMsgSync(TEJniDEObj req, TEJniDEObj rsp)");
        embededWnemgrlog.info("----sendSingleNEMessage_SYNC()----receive response");
        embededWnemgrlog.info("----sendSingleNEMessage_SYNC()----" + TEJniCommUtil.printJniDEObj(rsp));
        int result = rsp.result;
        if (0 == result && !(decodeResult = AsnCoder.deserialize((byte[])rsp.data, (FStruct)response))) {
            embededWnemgrlog.info("decode failed...");
        }
        return 0;
    }

    static int sendSingleNEMessage_ASYNC(char cmdHandle, int cmdCode, int neID, FStruct request, int timeOut) {
        TEJniDEObj req = new TEJniDEObj();
        req.cmdCode = cmdCode;
        req.neID = neID;
        try {
            req.data = AsnCoder.serialize((FStruct)request);
        }
        catch (Throwable e) {
            TELogFactory.getNormalLogger().error("TEJniCommUtil.sendSingleNEMessage_ASYNC() fail!", e);
            return 0;
        }
        req.cmdHandle = cmdHandle;
        req.timeout = timeOut;
        embededWnemgrlog.info("---sendSingleNEMessage_ASYNC()-----send message");
        embededWnemgrlog.info("---sendSingleNEMessage_ASYNC()-----" + TEJniCommUtil.printJniDEObj(req));
        embededWnemgrlog.info("BEGIN TO CALL JNI METHOD---  sendNEMsgAsync(TEJniDEObj req)");
        try {
            int result = TEJniCommUtil.sendNEMsgAsync(req);
            embededWnemgrlog.info("sendNEMsgAsync(TEJniDEObj req)=" + result);
        }
        catch (Throwable e) {
            embededWnemgrlog.info(e.toString(), e);
        }
        embededWnemgrlog.info("END TO CALL JNI METHOD---  sendNEMsgAsync(TEJniDEObj req)=");
        return 0;
    }

    private static native int sendNEMsgAsync(TEJniDEObj var0);

    static int sendMessage_SYNC(MSGHead msgHead, FStruct request, MSGListener recv, int timeOut) {
        TEJniDEObj req = new TEJniDEObj();
        req.cmdCode = msgHead.cmdCode;
        req.procID = msgHead.receiverProcID;
        req.procHandle = msgHead.receiverProcHandle;
        req.receiverModule = msgHead.receiverModule;
        req.senderProcIP = msgHead.senderProcIP;
        try {
            req.data = AsnCoder.serialize((FStruct)request);
        }
        catch (Throwable e) {
            embededWnemgrlog.info(e.toString(), e);
            return 0;
        }
        req.timeout = timeOut;
        TEJniDEObj rsp = new TEJniDEObj();
        rsp.cmdCode = msgHead.cmdCode;
        embededWnemgrlog.info("--sendMessage_SYNC()------send requese");
        embededWnemgrlog.info("--sendMessage_SYNC()------" + TEJniCommUtil.printJniDEObj(req));
        embededWnemgrlog.info("BEGIN TO CALL JNI METHOD---  sendNoNEMsgSync(TEJniDEObj req, TEJniDEObj rsp)");
        try {
            TEJniCommUtil.sendNoNEMsgSync(req, rsp);
        }
        catch (Throwable e) {
            embededWnemgrlog.info(e.toString(), e);
        }
        embededWnemgrlog.info("END TO CALL JNI METHOD---  sendNoNEMsgSync(TEJniDEObj req, TEJniDEObj rsp)");
        embededWnemgrlog.info("--sendMessage_SYNC()------receive response");
        embededWnemgrlog.info("--sendMessage_SYNC()------" + TEJniCommUtil.printJniDEObj(rsp));
        int result = rsp.result;
        if (0 == result) {
            MSGHead mh = new MSGHead();
            MSGPacketExt msg = new MSGPacketExt(mh, rsp.data);
            recv.receiveMessage(msg);
        }
        return result;
    }

    static int sendMessage_ASYNC(char chandle, MSGHead msgHead, FStruct request, int timeOut) {
        TEJniDEObj req = new TEJniDEObj();
        req.cmdCode = msgHead.cmdCode;
        req.procID = msgHead.receiverProcID;
        req.procHandle = msgHead.receiverProcHandle;
        req.receiverModule = msgHead.receiverModule;
        req.senderProcIP = msgHead.senderProcIP;
        try {
            req.data = AsnCoder.serialize((FStruct)request);
        }
        catch (Throwable e) {
            embededWnemgrlog.info(e.toString(), e);
            return 0;
        }
        req.timeout = timeOut;
        req.cmdHandle = chandle;
        embededWnemgrlog.info("--sendMessage_ASYNC()------send message");
        embededWnemgrlog.info("--sendMessage_ASYNC()------" + TEJniCommUtil.printJniDEObj(req));
        embededWnemgrlog.info("BEGIN TO CALL JNI METHOD---  snedNoNEMsgAsync(TEJniDEObj req)");
        int result = -1;
        try {
            result = TEJniCommUtil.snedNoNEMsgAsync(req);
        }
        catch (Throwable e) {
            embededWnemgrlog.info(e.toString(), e);
        }
        embededWnemgrlog.info("END TO CALL JNI METHOD---  snedNoNEMsgAsync(TEJniDEObj req)");
        return result;
    }

    private static synchronized native int snedNoNEMsgAsync(TEJniDEObj var0);

    static int sendSingleNEMessage_SYNC(int cmdCode, int neID, FStruct asn1Req, MSGListener asyncMultiRec, int timeout) {
        TEJniDEObj req = new TEJniDEObj();
        req.cmdCode = cmdCode;
        req.neID = neID;
        try {
            req.data = AsnCoder.serialize((FStruct)asn1Req);
        }
        catch (Throwable e) {
            embededWnemgrlog.info(e.toString(), e);
            return 0;
        }
        req.timeout = timeout;
        TEJniDEObj rsp = new TEJniDEObj();
        rsp.cmdCode = cmdCode;
        rsp.neID = neID;
        embededWnemgrlog.info("--sendSingleNEMessage_SYNC()------send requese");
        embededWnemgrlog.info("--sendSingleNEMessage_SYNC()------" + TEJniCommUtil.printJniDEObj(req));
        embededWnemgrlog.info("BEGIN TO CALL JNI METHOD---  sendNEMsgSync(TEJniDEObj req, TEJniDEObj rsp)");
        try {
            TEJniCommUtil.sendNEMsgSync(req, rsp);
        }
        catch (Throwable e) {
            embededWnemgrlog.info(e.toString(), e);
        }
        embededWnemgrlog.info("END TO CALL JNI METHOD---  sendNEMsgSync(TEJniDEObj req, TEJniDEObj rsp)");
        embededWnemgrlog.info("--sendSingleNEMessage_SYNC()------receive response");
        embededWnemgrlog.info("--sendSingleNEMessage_SYNC()------" + TEJniCommUtil.printJniDEObj(rsp));
        int result = rsp.result;
        if (0 == result) {
            MSGHead msgHead = new MSGHead();
            MSGPacketExt msg = new MSGPacketExt(msgHead, rsp.data);
            asyncMultiRec.receiveMessage(msg);
        }
        return result;
    }

    private static native int sendNEMsgSync(TEJniDEObj var0, TEJniDEObj var1);

    static int sendMessage_SYNC(MSGHead msgHead, FStruct request, FStruct response, int timeOut) {
        boolean decodeResult;
        TEJniDEObj req = new TEJniDEObj();
        req.cmdCode = msgHead.cmdCode;
        req.procID = msgHead.receiverProcID;
        req.procHandle = msgHead.receiverProcHandle;
        req.receiverModule = msgHead.receiverModule;
        req.senderProcIP = msgHead.senderProcIP;
        try {
            req.data = AsnCoder.serialize((FStruct)request);
        }
        catch (Throwable e) {
            embededWnemgrlog.info(e.toString(), e);
            return 1145;
        }
        req.timeout = timeOut;
        TEJniDEObj rsp = new TEJniDEObj();
        rsp.cmdCode = msgHead.cmdCode;
        embededWnemgrlog.info("--sendMessage_SYNC()------send requese");
        embededWnemgrlog.info("--sendMessage_SYNC()------" + TEJniCommUtil.printJniDEObj(req));
        embededWnemgrlog.info("BEGIN TO CALL JNI METHOD---  sendNoNEMsgSync(TEJniDEObj req, TEJniDEObj rsp)");
        try {
            TEJniCommUtil.sendNoNEMsgSync(req, rsp);
        }
        catch (Throwable e) {
            embededWnemgrlog.info(e.toString(), e);
        }
        embededWnemgrlog.info("END TO CALL JNI METHOD---  sendNoNEMsgSync(TEJniDEObj req, TEJniDEObj rsp)");
        embededWnemgrlog.info("--sendMessage_SYNC()------receive response");
        embededWnemgrlog.info("--sendMessage_SYNC()------" + TEJniCommUtil.printJniDEObj(rsp));
        int result = rsp.result;
        if (0 == result && !(decodeResult = AsnCoder.deserialize((byte[])rsp.data, (FStruct)response))) {
            embededWnemgrlog.info("decode failed...");
        }
        return result;
    }

    private static native int sendNoNEMsgSync(TEJniDEObj var0, TEJniDEObj var1);

    static int sendMessageMultiRsp_SYNC(MSGHead msgHead, FStruct request, TEMultiPkgMsgSyncReceiver syncMultiRec, int timeOut, int reqType) {
        TEJniDEObj req = new TEJniDEObj();
        req.cmdCode = msgHead.cmdCode;
        req.cmdHandle = msgHead.cmdHandle;
        req.procID = msgHead.receiverProcID;
        req.procHandle = msgHead.receiverProcHandle;
        req.receiverModule = msgHead.receiverModule;
        req.senderProcIP = msgHead.senderProcIP;
        try {
            req.data = AsnCoder.serialize((FStruct)request);
        }
        catch (Throwable e) {
            embededWnemgrlog.info(e.toString(), e);
            return 0;
        }
        req.timeout = timeOut;
        TEJniDEObj rsp = new TEJniDEObj();
        rsp.cmdCode = msgHead.cmdCode;
        embededWnemgrlog.info("--sendMessageMultiRsp_SYNC()------send requese");
        embededWnemgrlog.info("--sendMessageMultiRsp_SYNC()------" + TEJniCommUtil.printJniDEObj(req));
        embededWnemgrlog.info("BEGIN TO CALL JNI METHOD---  sendMultiRspNoNEMsgSync(TEJniDEObj req, TEJniDEObj rsp)");
        try {
            TEJniCommUtil.sendMultiRspNoNEMsgSync(req, rsp, reqType);
        }
        catch (Throwable e) {
            embededWnemgrlog.info(e.toString(), e);
        }
        embededWnemgrlog.info("END TO CALL JNI METHOD---  sendMultiRspNoNEMsgSync(TEJniDEObj req, TEJniDEObj rsp)");
        embededWnemgrlog.info("--sendMessageMultiRsp_SYNC()------receive response");
        embededWnemgrlog.info("--sendMessageMultiRsp_SYNC()------" + TEJniCommUtil.printJniDEObj(rsp));
        int result = rsp.result;
        if (0 == result) {
            MSGHead mh = new MSGHead();
            MSGPacketExt msg = new MSGPacketExt(mh, rsp.data);
            syncMultiRec.receiveMessage(msg);
            if (syncMultiRec.hasNextRsp()) {
                TEJniCommUtil.sendMessageMultiRsp_SYNC(msgHead, request, syncMultiRec, timeOut, 2);
            } else {
                TEJniCommUtil.sendMultiRspNoNEMsgSync(req, rsp, 3);
            }
        }
        return result;
    }

    private static native int sendMultiRspNoNEMsgSync(TEJniDEObj var0, TEJniDEObj var1, int var2);

    static {
        TEWNEMgrJniDllLoader.loadWNEMgrDll();
    }
}

