/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.core.communication;

import com.huawei.communicate.core.AppAidedMsgSyncReceiver;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGListener;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.MSGSyncReceiver;
import com.huawei.communicate.proxy.ICommServiceAdapter;
import com.huawei.communicate.util.asn.AsnCoder;
import com.huawei.communicate.util.receive.ILiteReceiver;
import com.huawei.communicate.util.receive.IReceiverReference;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.communication.TEJniCommUtil;
import com.huawei.nglct.core.communication.TEJniDEObj;
import com.huawei.nglct.core.mdp.TEMultiPkgMsgSyncReceiver;
import com.huawei.nglct.core.startup.TEWNEMgrJniLogFactory;
import com.huawei.nglct.core.taskmgr.TEWNEMgrTaskDispatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public final class TEJniCommService
implements ICommServiceAdapter {
    private static TEJniCommService instance = new TEJniCommService();
    private static final char MIN_CMDHANDLE = '\u0001';
    private static final char MAX_CMDHANDLE = '\ufffa';
    private char cmdHandle = '\u0001';
    private DataAccepter dataAccepter = new DataAccepter();
    private MsgDispatcher dispatcher = new MsgDispatcher(this, this.dataAccepter);
    private static Logger embededWnemgrLogger = TEWNEMgrJniLogFactory.getLogger(TEJniCommService.class.getName());

    public synchronized char getCmdHandle() {
        if ('\ufffa' == this.cmdHandle) {
            this.cmdHandle = (char)(this.cmdHandle - 65530);
        }
        this.cmdHandle = (char)(this.cmdHandle + '\u0001');
        return this.cmdHandle;
    }

    private TEJniCommService() {
        this.dispatcher.start();
    }

    public static TEJniCommService getInstance() {
        return instance;
    }

    public void unregNtfReceiver(int cmdCode, ILiteReceiver receiver) {
        this.dispatcher.removeMessageListener(cmdCode, receiver);
    }

    public void unregNtfReceiver(int cmdCode) {
        this.dispatcher.removeMessageListener(cmdCode);
    }

    public void regNtfReceiver(int cmdCode, ILiteReceiver receiver) {
        this.dispatcher.addMessageListener(cmdCode, receiver);
    }

    public int receiveAsyncMessageResponse(TEJniDEObj msg) {
        MSGHead mhead = this.newMsgHead(msg);
        mhead.msgType = (byte)msg.msgType;
        MSGPacketExt msgpacketext = new MSGPacketExt(mhead, msg.data);
        this.dataAccepter.sendToDispatch(msgpacketext);
        return 0;
    }

    private MSGHead newMsgHead(TEJniDEObj msg) {
        MSGHead mhead = new MSGHead();
        mhead.cmdCode = msg.cmdCode;
        mhead.cmdHandle = msg.cmdHandle;
        mhead.senderProcIP = (int)msg.senderProcIP;
        return mhead;
    }

    public void receiveSyncMessageResponse(TEJniDEObj req, TEJniDEObj rsp) {
        MSGHead mh = this.newMsgHead(req);
        MSGPacketExt msg = new MSGPacketExt(mh, req.data);
        FStruct asnrsp = TEWNEMgrTaskDispatcher.getInstance().receiveMessage(msg);
        rsp.result = 1;
        if (null != asnrsp) {
            try {
                rsp.result = 0;
                rsp.data = AsnCoder.serialize((FStruct)asnrsp);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEJniCommService.receiveSyncMessageResponse() fail!", (Throwable)e);
                embededWnemgrLogger.info("", (Throwable)e);
            }
        }
    }

    public void ntfMsgRecieved(int cmdCode, byte[] hd, byte[] data) {
        MSGPacketExt msg = new MSGPacketExt(new MSGHead(), data);
        this.dataAccepter.sendToDispatch(msg);
    }

    public int sendMessage(MSGHead msgHead, FStruct request, MSGSyncReceiver recv, int timeOut) {
        return -1;
    }

    public IReceiverReference addMessageListener(int cmdCode, ILiteReceiver receiver) {
        return null;
    }

    public int getDefaultTimeOut() {
        return 0;
    }

    public int sendAsyncMessage(MSGHead head, FStruct data, MSGListener listener) {
        return 0;
    }

    public int sendMessage(MSGHead head, FStruct data, MSGSyncReceiver recv) {
        return 0;
    }

    public int sendMessage(MSGHead msgHead, FStruct request, AppAidedMsgSyncReceiver receiver, int timeOut) {
        return 0;
    }

    public int sendAsyncMessage(MSGHead msghead, FStruct req, MSGListener msglistener, int timeOut) {
        return -1;
    }

    public int sendSingleNEMessage_SYNC(int cmdCode, int neID, FStruct request, FStruct response, int timeOut) {
        return TEJniCommUtil.sendSingleNEMessage_SYNC(cmdCode, neID, request, response, timeOut);
    }

    public int sendSingleNEMessage_ASYNC(int cmdCode, int neID, FStruct request, MSGListener listener, int timeOut) {
        int result = 0;
        char chandle = this.getCmdHandle();
        Character ch = Character.valueOf(chandle);
        if (null != listener) {
            this.dispatcher.addMessageReceiver(ch, listener, cmdCode, timeOut);
        }
        result = TEJniCommUtil.sendSingleNEMessage_ASYNC(chandle, cmdCode, neID, request, timeOut);
        return result;
    }

    public int sendMessage_SYNC(MSGHead msgHead, FStruct request, MSGSyncReceiver recv, int timeOut) {
        int result = TEJniCommUtil.sendMessage_SYNC(msgHead, request, (MSGListener)recv, timeOut);
        return result;
    }

    public int sendMessageMultiRsp_SYNC(MSGHead msgHead, FStruct request, TEMultiPkgMsgSyncReceiver recv, int timeOut) {
        int result = TEJniCommUtil.sendMessageMultiRsp_SYNC(msgHead, request, recv, timeOut, 1);
        return result;
    }

    public int sendMessage_SYNC(MSGHead msgHead, FStruct asn1Req, MSGListener asyncMultiRec, int timeout) {
        return TEJniCommUtil.sendMessage_SYNC(msgHead, asn1Req, asyncMultiRec, timeout);
    }

    public int sendMessage_ASYNC(MSGHead msgHead, FStruct request, MSGListener listener, int timeOut) {
        int result = 0;
        char chandle = this.getCmdHandle();
        Character ch = Character.valueOf(chandle);
        msgHead.senderCmdHandle = chandle;
        if (null != listener) {
            this.dispatcher.addMessageReceiver(ch, listener, msgHead.cmdCode, timeOut);
        }
        result = TEJniCommUtil.sendMessage_ASYNC(chandle, msgHead, request, timeOut);
        return result;
    }

    public int sendMessage_SYNC(MSGHead msgHead, FStruct request, FStruct response, int timeOut) {
        return TEJniCommUtil.sendMessage_SYNC(msgHead, request, response, timeOut);
    }

    public int sendSingleNEMessage_SYNC(int cmdCode, int neID, FStruct asn1Req, MSGListener asyncMultiRec, int timeout) {
        return TEJniCommUtil.sendSingleNEMessage_SYNC(cmdCode, neID, asn1Req, asyncMultiRec, timeout);
    }

    static final class CommTimeoutChecker
    extends Thread {
        private static final int REMOVE_ITEM_FAILED = -1;
        private static final int CHECK_INTERVAL = 1000;
        private static final int ONE_SECOND = 1000;
        private MsgDispatcher dispatcher = null;
        private volatile boolean running = true;
        private HashMap itemMap = new HashMap();

        CommTimeoutChecker(MsgDispatcher disp) {
            this.dispatcher = disp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addItem(Character cmdHandle, int cmdCode, int timeout) {
            if (this.itemMap == null) {
                return;
            }
            CheckItem item = new CheckItem();
            item.cmdHandle = cmdHandle;
            item.cmdCode = cmdCode;
            item.timeout = timeout;
            HashMap hashMap = this.itemMap;
            synchronized (hashMap) {
                this.itemMap.put(cmdHandle, item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int removeItem(Character cmdHandle) {
            if (this.itemMap == null) {
                return -1;
            }
            CheckItem item = null;
            HashMap hashMap = this.itemMap;
            synchronized (hashMap) {
                item = (CheckItem)this.itemMap.remove(cmdHandle);
            }
            if (item == null) {
                return -1;
            }
            return item.timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void refreshTimeoutValue(int newValue, Character cmdHandle) {
            if (this.itemMap == null) {
                return;
            }
            CheckItem item = null;
            HashMap hashMap = this.itemMap;
            synchronized (hashMap) {
                item = (CheckItem)this.itemMap.get(cmdHandle);
            }
            if (item != null && newValue > 0) {
                item.timeout = newValue * 1000;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (this.running) {
                    Object object = this;
                    synchronized (object) {
                        this.wait(1000L);
                    }
                    object = this.itemMap;
                    synchronized (object) {
                        if (!this.itemMap.isEmpty()) {
                            Iterator list = this.itemMap.values().iterator();
                            CheckItem item = null;
                            boolean isTimeout = false;
                            while (list.hasNext()) {
                                item = (CheckItem)list.next();
                                ++item.count;
                                if (item.count * 1000 < item.timeout + 1000) continue;
                                isTimeout = this.dispatcher.checkTimeout(item.cmdHandle);
                                if (isTimeout) {
                                    this.dispatcher.timeout(item.cmdCode, item.cmdHandle);
                                    list.remove();
                                    continue;
                                }
                                item.count = 0;
                            }
                        }
                    }
                }
            }
            catch (InterruptedException ex) {
                TELogFactory.getNormalLogger().error("TEJniCommService.run() fail!", (Throwable)ex);
                embededWnemgrLogger.info("", (Throwable)ex);
            }
            this.dispatcher = null;
            this.itemMap.clear();
        }

        public void close() {
            this.running = false;
            this.interrupt();
        }
    }

    private static class CheckItem {
        Character cmdHandle;
        int cmdCode;
        int timeout;
        int count = 0;

        private CheckItem() {
        }
    }

    static final class MsgDispatcher
    extends Thread {
        private volatile boolean running = true;
        private TEJniCommService m_Handle = null;
        private DataAccepter accepter = null;
        private CommTimeoutChecker checker = null;
        private Map<Integer, Vector<ILiteReceiver>> ntflistenTable = new Hashtable<Integer, Vector<ILiteReceiver>>();
        private Map<Character, MSGListener> rspReceivers = new Hashtable<Character, MSGListener>();

        MsgDispatcher(TEJniCommService handle, DataAccepter accepter) {
            this.m_Handle = handle;
            this.accepter = accepter;
            this.checker = new CommTimeoutChecker(this);
            this.checker.start();
        }

        public void addMessageReceiver(Character handleChar, MSGListener listener, int cmdCode, int times) {
            this.rspReceivers.put(handleChar, listener);
            if (times >= 60) {
                this.checker.addItem(handleChar, cmdCode, times);
            } else {
                this.checker.addItem(handleChar, cmdCode, 90);
            }
        }

        public void addMessageListener(int cmdCode, ILiteReceiver listener) {
            Vector<Object> listeners = this.ntflistenTable.get(cmdCode);
            if (listeners == null) {
                listeners = new Vector();
                listeners.addElement(listener);
                this.ntflistenTable.put(cmdCode, listeners);
            } else if (!listeners.contains(listener)) {
                listeners.addElement(listener);
            }
        }

        public void removeMessageListener(int cmdCode, ILiteReceiver listener) {
            Vector<ILiteReceiver> listeners = this.ntflistenTable.get(cmdCode);
            if (null != listeners) {
                listeners.removeElement(listener);
                if (listeners.isEmpty()) {
                    this.ntflistenTable.remove(cmdCode);
                }
            }
        }

        public void removeMessageListener(int cmdCode) {
            Vector<ILiteReceiver> listeners = this.ntflistenTable.get(cmdCode);
            if (listeners != null) {
                listeners.removeAllElements();
                this.ntflistenTable.remove(cmdCode);
            }
        }

        public void removeReceiver(Character ch) {
            this.rspReceivers.remove(ch);
        }

        void removeReceiver(MSGListener listener) {
            if (listener == null) {
                return;
            }
            Set<Map.Entry<Character, MSGListener>> eset = this.rspReceivers.entrySet();
            for (Map.Entry<Character, MSGListener> ent : eset) {
                MSGListener tlis = ent.getValue();
                Character ch = ent.getKey();
                if (!tlis.equals(listener)) continue;
                this.removeReceiver(ch);
                this.removeTimeoutItem(ch);
            }
        }

        public void cancelReceivers() {
            Set<Map.Entry<Character, MSGListener>> eset = this.rspReceivers.entrySet();
            for (Map.Entry<Character, MSGListener> ent : eset) {
                Character ch = ent.getKey();
                this.removeReceiver(ch);
            }
            if (null != this.m_Handle) {
                this.rspReceivers.clear();
            }
        }

        void removeTimeoutItem(Character cmdHandle) {
            this.checker.removeItem(cmdHandle);
        }

        void refreshTimeoutValue(int newValue, Character cmdHandle) {
            this.checker.refreshTimeoutValue(newValue, cmdHandle);
        }

        boolean checkTimeout(Character cmdHandle) {
            return true;
        }

        @Override
        public void run() {
            while (this.running) {
                MSGPacketExt msg = this.accepter.getMessage();
                if (msg == null) continue;
                switch (msg.mheader.msgType) {
                    case 1: 
                    case 6: 
                    case 9: 
                    case 21: {
                        this.dispatchNtfMsg(msg);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 7: 
                    case 17: 
                    case 27: 
                    case 28: {
                        this.dispatchRspMsg(msg);
                        break;
                    }
                    case 5: {
                        break;
                    }
                }
            }
            this.m_Handle = null;
            this.accepter = null;
            this.checker = null;
        }

        private void dispatchNtfMsg(MSGPacketExt msg) {
            Integer code = msg.mheader.cmdCode;
            Vector<ILiteReceiver> listeners = this.ntflistenTable.get(code);
            if (listeners != null) {
                try {
                    ILiteReceiver[] rcverArray = new ILiteReceiver[listeners.size()];
                    listeners.toArray(rcverArray);
                    for (int i = 0; i < rcverArray.length; ++i) {
                        MSGListener listener = (MSGListener)rcverArray[i];
                        listener.receiveMessage(msg);
                    }
                }
                catch (Exception ex) {
                    embededWnemgrLogger.info("", (Throwable)ex);
                }
            }
        }

        private void dispatchRspMsg(MSGPacketExt packet) {
            char handle = packet.mheader.cmdHandle;
            Character handleObj = Character.valueOf(handle);
            MSGListener recv = this.rspReceivers.get(handleObj);
            if (recv != null && recv.receiveMessage(packet)) {
                this.removeReceiver(handleObj);
                this.checker.removeItem(handleObj);
            }
        }

        void timeout(int cmdCode, Character cmdHandle) {
            MSGListener receiver = null;
            receiver = this.rspReceivers.remove(cmdHandle);
            if (receiver != null) {
                receiver.timeout(cmdCode, cmdHandle);
            }
        }

        public void cancelListeners() {
            this.ntflistenTable.clear();
        }

        public void close() {
            this.running = false;
            if (this.checker != null) {
                this.checker.close();
            }
            this.cancelReceivers();
            this.cancelListeners();
        }
    }

    static final class DataAccepter {
        private List<MSGPacketExt> recvBuffer = new ArrayList<MSGPacketExt>();

        DataAccepter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendToDispatch(MSGPacketExt packet) {
            List<MSGPacketExt> list = this.recvBuffer;
            synchronized (list) {
                this.recvBuffer.add(packet);
                this.recvBuffer.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            List<MSGPacketExt> list = this.recvBuffer;
            synchronized (list) {
                this.recvBuffer.clear();
                this.recvBuffer.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MSGPacketExt getMessage() {
            MSGPacketExt result = null;
            if (null != this.recvBuffer) {
                try {
                    List<MSGPacketExt> list = this.recvBuffer;
                    synchronized (list) {
                        while (this.recvBuffer.isEmpty()) {
                            this.recvBuffer.wait(100L);
                        }
                        if (!this.recvBuffer.isEmpty()) {
                            result = this.recvBuffer.remove(0);
                        }
                    }
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().error("TEJniCommService.getMessage() fail!", (Throwable)e);
                    result = null;
                    embededWnemgrLogger.info("", (Throwable)e);
                }
            }
            return result;
        }
    }
}

