/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.common.mibsdef;

import com.huawei.nglct.common.mibsdef.Devinfo;
import com.huawei.nglct.common.mibsdef.Index;
import com.huawei.nglct.common.mibsdef.Leaf;
import com.huawei.nglct.common.mibsdef.Rowstatus;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public abstract class MibTableType
implements Serializable {
    private static final long serialVersionUID = -5136471995930907502L;
    private String _name;
    private ArrayList _indexList = new ArrayList();
    private ArrayList _leafList = new ArrayList();
    private ArrayList _rowstatusList = new ArrayList();
    private ArrayList _devinfoList = new ArrayList();

    public void addDevinfo(Devinfo vDevinfo) throws IndexOutOfBoundsException {
        this._devinfoList.add(vDevinfo);
    }

    public void addDevinfo(int index, Devinfo vDevinfo) throws IndexOutOfBoundsException {
        this._devinfoList.add(index, vDevinfo);
    }

    public void addIndex(Index vIndex) throws IndexOutOfBoundsException {
        this._indexList.add(vIndex);
    }

    public void addIndex(int index, Index vIndex) throws IndexOutOfBoundsException {
        this._indexList.add(index, vIndex);
    }

    public void addLeaf(Leaf vLeaf) throws IndexOutOfBoundsException {
        this._leafList.add(vLeaf);
    }

    public void addLeaf(int index, Leaf vLeaf) throws IndexOutOfBoundsException {
        this._leafList.add(index, vLeaf);
    }

    public void addRowstatus(Rowstatus vRowstatus) throws IndexOutOfBoundsException {
        this._rowstatusList.add(vRowstatus);
    }

    public void addRowstatus(int index, Rowstatus vRowstatus) throws IndexOutOfBoundsException {
        this._rowstatusList.add(index, vRowstatus);
    }

    public void clearDevinfo() {
        this._devinfoList.clear();
    }

    public void clearIndex() {
        this._indexList.clear();
    }

    public void clearLeaf() {
        this._leafList.clear();
    }

    public void clearRowstatus() {
        this._rowstatusList.clear();
    }

    public Enumeration enumerateDevinfo() {
        return new IteratorEnumeration(this._devinfoList.iterator());
    }

    public Enumeration enumerateIndex() {
        return new IteratorEnumeration(this._indexList.iterator());
    }

    public Enumeration enumerateLeaf() {
        return new IteratorEnumeration(this._leafList.iterator());
    }

    public Enumeration enumerateRowstatus() {
        return new IteratorEnumeration(this._rowstatusList.iterator());
    }

    public Devinfo getDevinfo(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._devinfoList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Devinfo)this._devinfoList.get(index);
    }

    public Devinfo[] getDevinfo() {
        int size = this._devinfoList.size();
        Devinfo[] mArray = new Devinfo[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Devinfo)this._devinfoList.get(index);
        }
        return mArray;
    }

    public int getDevinfoCount() {
        return this._devinfoList.size();
    }

    public Index getIndex(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._indexList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Index)this._indexList.get(index);
    }

    public Index[] getIndex() {
        int size = this._indexList.size();
        Index[] mArray = new Index[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Index)this._indexList.get(index);
        }
        return mArray;
    }

    public int getIndexCount() {
        return this._indexList.size();
    }

    public Leaf getLeaf(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._leafList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Leaf)this._leafList.get(index);
    }

    public Leaf[] getLeaf() {
        int size = this._leafList.size();
        Leaf[] mArray = new Leaf[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Leaf)this._leafList.get(index);
        }
        return mArray;
    }

    public int getLeafCount() {
        return this._leafList.size();
    }

    public String getName() {
        return this._name;
    }

    public Rowstatus getRowstatus(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._rowstatusList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Rowstatus)this._rowstatusList.get(index);
    }

    public Rowstatus[] getRowstatus() {
        int size = this._rowstatusList.size();
        Rowstatus[] mArray = new Rowstatus[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Rowstatus)this._rowstatusList.get(index);
        }
        return mArray;
    }

    public int getRowstatusCount() {
        return this._rowstatusList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public abstract void marshal(Writer var1) throws MarshalException, ValidationException;

    public abstract void marshal(ContentHandler var1) throws IOException, MarshalException, ValidationException;

    public boolean removeDevinfo(Devinfo vDevinfo) {
        boolean removed = this._devinfoList.remove(vDevinfo);
        return removed;
    }

    public boolean removeIndex(Index vIndex) {
        boolean removed = this._indexList.remove(vIndex);
        return removed;
    }

    public boolean removeLeaf(Leaf vLeaf) {
        boolean removed = this._leafList.remove(vLeaf);
        return removed;
    }

    public boolean removeRowstatus(Rowstatus vRowstatus) {
        boolean removed = this._rowstatusList.remove(vRowstatus);
        return removed;
    }

    public void setDevinfo(int index, Devinfo vDevinfo) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._devinfoList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._devinfoList.set(index, vDevinfo);
    }

    public void setDevinfo(Devinfo[] devinfoArray) {
        this._devinfoList.clear();
        for (int i = 0; i < devinfoArray.length; ++i) {
            this._devinfoList.add(devinfoArray[i]);
        }
    }

    public void setIndex(int index, Index vIndex) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._indexList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._indexList.set(index, vIndex);
    }

    public void setIndex(Index[] indexArray) {
        this._indexList.clear();
        for (int i = 0; i < indexArray.length; ++i) {
            this._indexList.add(indexArray[i]);
        }
    }

    public void setLeaf(int index, Leaf vLeaf) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._leafList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._leafList.set(index, vLeaf);
    }

    public void setLeaf(Leaf[] leafArray) {
        this._leafList.clear();
        for (int i = 0; i < leafArray.length; ++i) {
            this._leafList.add(leafArray[i]);
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setRowstatus(int index, Rowstatus vRowstatus) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._rowstatusList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._rowstatusList.set(index, vRowstatus);
    }

    public void setRowstatus(Rowstatus[] rowstatusArray) {
        this._rowstatusList.clear();
        for (int i = 0; i < rowstatusArray.length; ++i) {
            this._rowstatusList.add(rowstatusArray[i]);
        }
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

