/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.common.mibsdef;

import com.huawei.nglct.common.mibsdef.MibTable;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public abstract class MibObjectsType
implements Serializable {
    private static final long serialVersionUID = 5196035920949927079L;
    private String _moduleName;
    private ArrayList _mibTableList = new ArrayList();

    public void addMibTable(MibTable vMibTable) throws IndexOutOfBoundsException {
        this._mibTableList.add(vMibTable);
    }

    public void addMibTable(int index, MibTable vMibTable) throws IndexOutOfBoundsException {
        this._mibTableList.add(index, vMibTable);
    }

    public void clearMibTable() {
        this._mibTableList.clear();
    }

    public Enumeration enumerateMibTable() {
        return new IteratorEnumeration(this._mibTableList.iterator());
    }

    public MibTable getMibTable(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._mibTableList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (MibTable)this._mibTableList.get(index);
    }

    public MibTable[] getMibTable() {
        int size = this._mibTableList.size();
        MibTable[] mArray = new MibTable[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (MibTable)this._mibTableList.get(index);
        }
        return mArray;
    }

    public int getMibTableCount() {
        return this._mibTableList.size();
    }

    public String getModuleName() {
        return this._moduleName;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public abstract void marshal(Writer var1) throws MarshalException, ValidationException;

    public abstract void marshal(ContentHandler var1) throws IOException, MarshalException, ValidationException;

    public boolean removeMibTable(MibTable vMibTable) {
        boolean removed = this._mibTableList.remove(vMibTable);
        return removed;
    }

    public void setMibTable(int index, MibTable vMibTable) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._mibTableList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._mibTableList.set(index, vMibTable);
    }

    public void setMibTable(MibTable[] mibTableArray) {
        this._mibTableList.clear();
        for (int i = 0; i < mibTableArray.length; ++i) {
            this._mibTableList.add(mibTableArray[i]);
        }
    }

    public void setModuleName(String moduleName) {
        this._moduleName = moduleName;
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

