/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.common.functions;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public final class TECheckInputParam {
    private TECheckInputParam() {
    }

    public static boolean isInputParamValid(SubFunc subfunc, Datainterface inputData, int neid) {
        return TECheckInputParam.isInputParamValid(subfunc, inputData, neid, null);
    }

    public static boolean isInputParamValid(SubFunc subfunc, Datainterface inputData, int neid, ArrayList operationNameList) {
        Operation operation = null;
        RowParams rowparams = null;
        Input input = null;
        if (null == inputData) {
            return true;
        }
        BussinessParams businessparams = inputData.getBussinessParams();
        if (null == businessparams) {
            return true;
        }
        ArrayList<String> qxList = operationNameList;
        if (null == qxList) {
            qxList = new ArrayList<String>();
            int len = subfunc.getQxMappingCount();
            for (int i = 0; i < len; ++i) {
                qxList.add(subfunc.getQxMapping(i).getContent());
            }
        }
        if (qxList.isEmpty()) {
            return true;
        }
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            int size = qxList.size();
            for (int i = 0; i < size; ++i) {
                operation = TECreateObjectFactory.getOperation(neid, (String)qxList.get(i));
                if (null == operation) continue;
                input = operation.getInput();
                if (null == input || 0 == input.getPartCount()) {
                    return true;
                }
                int partlen = input.getPartCount();
                for (int partIndex = 0; partIndex < partlen; ++partIndex) {
                    Part part = input.getPart(partIndex);
                    if (TECheckInputParam.isPartValid(part, rowparams)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isPartValid(Part part, RowParams rowparams) {
        String partType = part.getType();
        int partLength = part.getLength();
        if (null == rowparams || 0 == rowparams.getParamCount()) {
            return true;
        }
        Param rowparam = rowparams.getParam(part.getName());
        if (rowparam == null || rowparam.getIsPassword()) {
            return true;
        }
        String paramValue = rowparam.getValue();
        if (null == partType || partType.isEmpty()) {
            return true;
        }
        if ("undefined".equalsIgnoreCase(paramValue) || "null".equalsIgnoreCase(paramValue) || "-".equals(paramValue) || "/".equals(paramValue)) {
            return true;
        }
        if ("int".equalsIgnoreCase(partType)) {
            return TECheckInputParam.checkInt(paramValue);
        }
        if ("long".equalsIgnoreCase(partType)) {
            String partName = part.getName().toUpperCase();
            if (partName.indexOf("IP") > -1 && IPAddressUtil.isValidIP(paramValue)) {
                paramValue = String.valueOf(IPAddressUtil.convertIPStrToLong(paramValue));
            }
            return TECheckInputParam.checkLong(paramValue);
        }
        if ("byte".equalsIgnoreCase(partType)) {
            return TECheckInputParam.checkByte(paramValue);
        }
        if ("string".equalsIgnoreCase(partType)) {
            return TECheckInputParam.checkString(paramValue, partLength);
        }
        if ("var".equalsIgnoreCase(partType)) {
            return TECheckInputParam.checkVar(paramValue, partLength * 2);
        }
        if ("prototype".equalsIgnoreCase(partType)) {
            return true;
        }
        return true;
    }

    public static boolean checkInt(String paramValue) {
        return TEStringUtils.isNumeric(paramValue);
    }

    public static boolean checkLong(String paramValue) {
        return TEStringUtils.isNumeric(paramValue);
    }

    public static boolean checkIP(String paramValue) {
        return IPAddressUtil.isValidIP(paramValue);
    }

    public static boolean checkByte(String paramValue) {
        return TEStringUtils.isNumber(paramValue);
    }

    public static boolean checkString(String paramValue, int partLength) {
        if (0 >= partLength) {
            return true;
        }
        if (null == paramValue) {
            return true;
        }
        return paramValue.length() <= partLength;
    }

    public static boolean checkVar(String paramValue, int partLength) {
        if (0 >= partLength) {
            return true;
        }
        if (null == paramValue) {
            return true;
        }
        return paramValue.length() <= partLength;
    }

    public static boolean checkPrototype(String paramValue, int partLength) {
        if (0 >= partLength) {
            return true;
        }
        if (null == paramValue) {
            return true;
        }
        if (paramValue.length() > partLength) {
            return false;
        }
        return TEStringUtils.isHexString(paramValue);
    }
}

