/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.common.functions;

import com.huawei.nglct.common.functions.Function;
import com.huawei.nglct.common.functions.SubFunc;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class Functions
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5090735790073023430L;
    private ArrayList _functionList = new ArrayList();

    public void addFunction(Function vFunction) throws IndexOutOfBoundsException {
        this._functionList.add(vFunction);
    }

    public void addFunction(int index, Function vFunction) throws IndexOutOfBoundsException {
        this._functionList.add(index, vFunction);
    }

    public void clearFunction() {
        this._functionList.clear();
    }

    public Enumeration enumerateFunction() {
        return new IteratorEnumeration(this._functionList.iterator());
    }

    public Function getFunction(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._functionList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Function)this._functionList.get(index);
    }

    public Function[] getFunction() {
        int size = this._functionList.size();
        Function[] mArray = new Function[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Function)this._functionList.get(index);
        }
        return mArray;
    }

    public int getFunctionCount() {
        return this._functionList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeFunction(Function vFunction) {
        boolean removed = this._functionList.remove(vFunction);
        return removed;
    }

    public void setFunction(int index, Function vFunction) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._functionList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._functionList.set(index, vFunction);
    }

    public void setFunction(Function[] functionArray) {
        this._functionList.clear();
        for (int i = 0; i < functionArray.length; ++i) {
            this._functionList.add(functionArray[i]);
        }
    }

    public static Functions unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Functions)Unmarshaller.unmarshal(Functions.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }

    public SubFunc getSubFunc(int sfid) {
        Function function = null;
        SubFunc subFunc = null;
        for (int i = this.getFunction().length - 1; i >= 0; --i) {
            function = this.getFunction(i);
            for (int j = function.getSubFunc().length - 1; j >= 0; --j) {
                subFunc = function.getSubFunc(j);
                if (subFunc.getCode() != sfid) continue;
                return subFunc;
            }
        }
        return null;
    }

    public Object clone() {
        Functions cloneFuncs = null;
        try {
            cloneFuncs = (Functions)super.clone();
            cloneFuncs._functionList = new ArrayList();
            int len = this._functionList.size();
            for (int i = 0; i < len; ++i) {
                cloneFuncs.addFunction((Function)this.getFunction(i).clone());
            }
        }
        catch (Exception e) {
            throw new InternalError();
        }
        return cloneFuncs;
    }
}

