/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.common.datamodel;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.datamodel.Attribute;
import com.huawei.nglct.common.datamodel.ConvertAttriList;
import com.huawei.nglct.common.datamodel.DataModel;
import com.huawei.nglct.common.datamodel.TEDataModelDescriptor;
import com.huawei.nglct.common.datamodel.TEDataModelIF;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.beanplugin.TESubFuncInfo;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;

public class TEDataModelConverterForQX {
    public static List<TEDataModelIF> dataModelCreateFromOper(int neid, SubFunc subFunc, List<Operation> operationList, List<Integer> filterErrorCodeList) {
        ArrayList<TEDataModelIF> dataModelList = new ArrayList<TEDataModelIF>();
        if (null == subFunc) {
            return dataModelList;
        }
        if (null == operationList || operationList.isEmpty()) {
            return dataModelList;
        }
        DataModel dataModel = TESubFuncInfo.createDataModelDescriptor(subFunc);
        if (null == dataModel) {
            return dataModelList;
        }
        List<Operation> saveDBOperList = TEDataModelDescriptor.filteOperationList(dataModel, operationList);
        List<TEDataModelIF> tempDataModelList = TEDataModelConverterForQX.createDataModel(neid, subFunc, dataModel, saveDBOperList, filterErrorCodeList);
        if (null != tempDataModelList && !tempDataModelList.isEmpty()) {
            dataModelList.addAll(tempDataModelList);
        }
        return dataModelList;
    }

    private static ArrayList joinOperation(int neid, SubFunc subFunc, DataModel dataModel, List<Operation> operationList, List<Integer> filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList<Integer>();
        }
        ArrayList<RowErrors> errorDataList = new ArrayList<RowErrors>();
        ArrayList operationObject = TEDataConverter.getOperationObject(subFunc);
        ArrayList operObjPart = null;
        ArrayList tmpoperObjPart = null;
        Operation descOperation = null;
        Operation operation = null;
        Operation tmpOperation = null;
        Output curOutput = null;
        Output tmpOutput = null;
        int len = 0;
        int faultCode = 0;
        if (null == operationList || !operationList.isEmpty()) {
            return errorDataList;
        }
        len = operationList.size();
        if (null != operationObject && !operationObject.isEmpty()) {
            for (int i = 0; i < len; ++i) {
                operation = operationList.get(i);
                TEDataConverter.copyInDataToOutData(operation);
                int ouputlen = operation.getOutputCount();
                for (int outputIndex = 0; outputIndex < ouputlen; ++outputIndex) {
                    curOutput = operation.getOutput(outputIndex);
                    faultCode = Integer.parseInt(curOutput.getFault(0).getCode());
                    if (filterErrorCodeList.contains(faultCode)) continue;
                    if (0 != faultCode && !filterErrorCodeList.contains(faultCode)) {
                        errorDataList.add(TEDataConverter.handleErrorData(neid, subFunc, operation.getInput(), curOutput));
                    }
                    operObjPart = TEDataConverter.getOperObjData(operationObject, operation.getInput(), curOutput);
                    for (int j = i + 1; j < len; ++j) {
                        tmpOperation = operationList.get(j);
                        TEDataConverter.copyInDataToOutData(tmpOperation);
                        for (int tmpOutputIndex = tmpOperation.getOutputCount() - 1; tmpOutputIndex >= 0; --tmpOutputIndex) {
                            tmpOutput = tmpOperation.getOutput(tmpOutputIndex);
                            tmpoperObjPart = TEDataConverter.getOperObjData(operationObject, tmpOperation.getInput(), tmpOutput);
                            if (!TEDataConverter.compareOperObj(operObjPart, tmpoperObjPart)) continue;
                            TEDataConverter.joinOperationPart(neid, subFunc, curOutput, tmpOutput, tmpOperation.getInput(), errorDataList, (ArrayList)filterErrorCodeList);
                            tmpOperation.removeOutput(tmpOutput);
                        }
                        if (0 != tmpOperation.getOutputCount()) continue;
                        operationList.remove(tmpOperation);
                        --len;
                        --j;
                    }
                }
            }
        } else {
            descOperation = operationList.get(0);
            for (int output = 0; output < descOperation.getOutputCount(); ++output) {
                Output desOutput = descOperation.getOutput(output);
                faultCode = Integer.parseInt(desOutput.getFault(0).getCode());
                if (0 == faultCode || filterErrorCodeList.contains(faultCode)) continue;
                errorDataList.add(TEDataConverter.handleErrorData(neid, subFunc, descOperation.getInput(), desOutput));
            }
            for (int i = operationList.size() - 1; i > 0; --i) {
                tmpOperation = operationList.get(i);
                TEDataConverter.joinOperationOutput(neid, subFunc, descOperation, tmpOperation, errorDataList, (ArrayList)filterErrorCodeList);
                operationList.remove(tmpOperation);
            }
        }
        return errorDataList;
    }

    private static List<TEDataModelIF> createDataModel(int neid, SubFunc subFunc, DataModel dataModel, List<Operation> operationList, List<Integer> filterErrorCodeList) {
        ArrayList<TEDataModelIF> dataModelList = new ArrayList<TEDataModelIF>();
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList<Integer>();
        }
        ArrayList errorData = TEDataModelConverterForQX.joinOperation(neid, subFunc, dataModel, operationList, filterErrorCodeList);
        Operation operation = null;
        if (null == operationList || !operationList.isEmpty()) {
            return null;
        }
        RowParams rowparams = null;
        Input input = null;
        Output output = null;
        boolean succ = false;
        boolean fault = false;
        boolean row_succ = false;
        boolean verify_succ = true;
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        int len = operationList.size();
        block2: for (int i = 0; i < len; ++i) {
            operation = operationList.get(i);
            TEDataConverter.handleSpecialStr(operation);
            input = operation.getInput();
            if (operation.getOutputCount() == 0) {
                succ = true;
            }
            int size = operation.getOutputCount();
            for (int row = 0; row < size; ++row) {
                output = operation.getOutput(row);
                rowparams = new RowParams();
                row_succ = TEDataConverter.handleRowError(output, (ArrayList)filterErrorCodeList);
                if (row_succ) {
                    succ = true;
                    boolean flag = false;
                    int errorSize = output.getFaultCount();
                    for (int a = 0; a < errorSize; ++a) {
                        if (filterErrorCodeList.contains(Integer.valueOf(output.getFault(a).getCode()))) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue block2;
                    TEDataConverter.handleRowData(neid, subFunc, rowparams, input, output);
                    flag = false;
                } else if (1 == operation.getOutputCount()) {
                    boolean hasDefault = true;
                    int count = operation.getOutput(0).getPartCount();
                    for (int index = 0; index < count; ++index) {
                        if (operation.getOutput(0).getPart(index).hasDefault()) continue;
                        hasDefault = false;
                        break;
                    }
                    if (hasDefault) {
                        TEDataConverter.handleRowData(neid, subFunc, rowparams, input, output);
                    }
                }
                if (0 != rowparams.getParamCount()) {
                    outputData.getBussinessParams().addRowParams(rowparams);
                    String dataModelClassName = dataModel.getDataModelClass().getName();
                    try {
                        TEDataModelIF dataModelIF = (TEDataModelIF)Class.forName(dataModelClassName).newInstance();
                        dataModelIF.getClass().getFields();
                        ConvertAttriList attrList = dataModel.getConvertAttriList();
                        ArrayList<String> attrNameList = new ArrayList<String>();
                        int attrSize = attrList.getAttributeCount();
                        for (int attrIndex = 0; attrIndex < attrSize; ++attrIndex) {
                            Attribute attribute = attrList.getAttribute(attrIndex);
                            String attrName = attribute.getName();
                            attrNameList.add(attrName);
                        }
                    }
                    catch (Exception e) {
                        TELogFactory.getNormalLogger().info("", (Throwable)e);
                    }
                }
                row_succ = false;
            }
        }
        if (null != errorData && !errorData.isEmpty()) {
            fault = true;
            rowparams = new RowParams();
            RowErrors rErrors = null;
            int size = errorData.size();
            for (int i = 0; i < size; ++i) {
                rErrors = (RowErrors)errorData.get(i);
                rowparams.addRowErrors(rErrors);
                if (!rErrors.getErrorMessage().getErrorcode().equals("42293")) continue;
                verify_succ = false;
            }
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (succ && !fault) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 0));
        } else if (!succ && fault || !verify_succ) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 1));
        }
        return dataModelList;
    }

    public static boolean dataModelUpdateFromOper(int neid, SubFunc subFunc, List<Operation> operationList, TEDataModelIF dataModel) {
        return true;
    }

    public void convertToDatainterface() {
    }
}

